<?php
/**
 * The template for displaying product widget entries
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-widget-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see     http://docs.woothemes.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.5.5
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

global $product;

if ( ! is_a( $product, 'WC_Product' ) ) {
    return;
}

$product_title = $product->get_title();
$product_link = get_permalink( $product->get_id() );

?>

<li>
    <?php do_action( 'woocommerce_widget_product_item_start', $args ); ?>
    
    <a href="<?php echo esc_url( $product_link ); ?>" title="<?php echo esc_attr( $product_title ); ?>" class="product-list-image">
        <?php echo $product->get_image(); // PHPCS:Ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
    </a>

    <div class="product-item-right">

        <p class="product-title"><a href="<?php echo esc_url( $product_link ); ?>" title="<?php echo esc_attr( $product_title ); ?>"><?php echo wp_kses_post( $product_title ); ?></a></p>

        <?php if ( ! empty( $show_rating ) ) : ?>
            <?php echo wp_kses_post( wc_get_rating_html( $product->get_average_rating() ) ); // PHPCS:Ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
        <?php endif; ?>

        <div class="price">
            <?php echo $product->get_price_html(); // PHPCS:Ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
        </div>
        
    </div>
    
    <?php do_action( 'woocommerce_widget_product_item_end', $args ); ?>
</li>