<?php
/**
 * Elementor Vehicle Seller Contact template.
 *
 * @package car-dealer-helper
 */

if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
	?>
	<div class="alert alert-danger" role="alert" style="margin: 0;">
		<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
		<p><?php esc_html_e( 'This elementor widget will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
	</div>
	<?php
	return;
}

if ( class_exists( 'CDHL_CPT_Template' ) ) {
	$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
} else {
	$post_id = get_the_ID();
}

if ( ! isset( $settings['contact_form'] ) || ( isset( $settings['contact_form'] ) && empty( $settings['contact_form'] ) ) ) {
	return;
}

$post_author_id  = get_post_field( 'post_author', $post_id );
$post_author     = get_user_by( 'id', $post_author_id );
$user_type       = cdfs_get_usertype( $post_author );
$show_title      = ( isset( $settings['show_title'] ) ) ? $settings['show_title'] : 'no';
$show_title      = filter_var( $show_title, FILTER_VALIDATE_BOOLEAN );
$usertype_labels = $this->usertype_labels();
$dealer_title    = ( isset( $settings['dealer_title'] ) && ! empty( $settings['dealer_title'] ) ) ? $settings['dealer_title'] : $usertype_labels['dealer'];
$user_title      = ( isset( $settings['user_title'] ) && ! empty( $settings['user_title'] ) ) ? $settings['user_title'] : $usertype_labels['user'];
$widget_title    = ( 'dealer' === $user_type ) ? $dealer_title : $user_title;

$this->add_render_attribute( 'cd_vehicle_seller_contact', 'id', 'cd-vehicle-seller-contact-form-' . $this->get_id() );
$this->add_render_attribute( 'cd_vehicle_seller_contact', 'class', 'cd-vehicle-seller-contact-form' );
$this->add_render_attribute( 'cd_vehicle_seller_contact', 'class', 'cd-vehicle-seller-contact-form-style-default' );
?>
<div <?php $this->print_render_attribute_string( 'cd_vehicle_seller_contact' ); ?>>
	<?php
	global $cdfs_seller_form, $cdfs_seller_form_fields;

	$cdfs_seller_form        = true;
	$cdfs_seller_form_fields = array(
		'cdfs_seller_form'           => 'yes',
		'cdfs_seller_form_user_id'   => $post_author_id,
		'cdfs_seller_form_user_type' => $user_type,
	);

	if ( $show_title ) {
		?>
		<h3 class="vehicle-seller-contact-title"><?php echo esc_html( $widget_title ); ?></h3>
		<?php
	}

	echo do_shortcode( '[contact-form-7 id="' . $settings['contact_form'] . '"]' );

	$cdfs_seller_form        = false;
	$cdfs_seller_form_fields = array();
	?>
</div>
