<?php
/**
 * Elementor Vehicle Title template.
 *
 * @package car-dealer-helper
 */

global $car_dealer_options;

if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
	?>
	<div class="alert alert-danger" role="alert" style="margin: 0;">
		<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
		<p><?php esc_html_e( 'This elementor widget will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
	</div>
	<?php
	return;
}

$this->add_render_attribute( 'cd_vehicle_share', 'id', 'cd_vehicle_share-' . $this->get_id() );
$this->add_render_attribute( 'cd_vehicle_share', 'class', 'cd-share-button cd-vehicle-share ' . $settings['share_type'] );
$this->add_render_attribute( 'cd_vehicle_share', 'class', 'text-' . $settings['tax_label_alignment'] );

if ( class_exists( 'CDHL_CPT_Template' ) ) {
	$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
} else {
	$post_id = get_the_ID();
}
?>
<div <?php $this->print_render_attribute_string( 'cd_vehicle_share' ); ?>>
	<?php
	$facebook_share  = isset( $car_dealer_options['facebook_share'] ) ? $car_dealer_options['facebook_share'] : '';
	$twitter_share   = isset( $car_dealer_options['twitter_share'] ) ? $car_dealer_options['twitter_share'] : '';
	$linkedin_share  = isset( $car_dealer_options['linkedin_share'] ) ? $car_dealer_options['linkedin_share'] : '';
	$pinterest_share = isset( $car_dealer_options['pinterest_share'] ) ? $car_dealer_options['pinterest_share'] : '';
	$whatsapp_share  = isset( $car_dealer_options['whatsapp_share'] ) ? $car_dealer_options['whatsapp_share'] : '';

	if ( $facebook_share || $twitter_share || $linkedin_share || $pinterest_share || $whatsapp_share ) {
		?>
		<div class="details-social details-weight share">
			<?php
			if ( isset( $settings['title'] ) && $settings['title'] ) {
				?>
				<h6 class="uppercase"><?php echo esc_html( $settings['title'] ); ?></h6>
				<?php
			}
			?>
			<ul class="single-share-box mk-box-to-trigger">
				<?php
				if ( $facebook_share ) {
					?>
					<li>
						<a href="#" data-title="<?php echo esc_attr( get_the_title() ); ?>" data-url="<?php echo esc_url( get_permalink( $post_id ) ); ?>" class="facebook-share"><i class="fab fa-facebook-f"></i></a>
					</li>
					<?php
				}
				if ( $twitter_share ) {
					?>
					<li>
						<a href="#"  data-title="<?php echo esc_attr( get_the_title() ); ?>" data-url="<?php echo esc_url( get_permalink( $post_id ) ); ?>" class="twitter-share"><i class="fab fa-twitter"></i></a>
					</li>
					<?php
				}
				if ( $linkedin_share ) {
					?>
					<li>
						<a href="#" data-title="<?php echo esc_attr( get_the_title() ); ?>" data-url="<?php echo esc_url( get_permalink( $post_id ) ); ?>" class="linkedin-share"><i class="fab fa-linkedin-in"></i></a>
					</li>
					<?php
				}
				if ( $pinterest_share ) {
					?>
					<li>
						<a href="#" data-title="<?php echo esc_attr( get_the_title( $post_id ) ); ?>" data-url="<?php echo esc_url( get_permalink( $post_id ) ); ?>" data-image="<?php echo esc_url( cardealer_get_single_image_url( 'car_catalog_image', $post_id ) ); ?>" class="pinterest-share"><i class="fab fa-pinterest"></i></a>
					</li>
					<?php
				}
				if ( $whatsapp_share ) {
					?>
					<li><a href="#" data-url="<?php echo esc_url( get_permalink( $post_id ) ); ?>"  class="whatsapp-share"><i class="fab fa-whatsapp"></i></a></li>
					<?php
				}
				?>
			</ul>
		</div><!--.share-->
		<?php
	}
	?>
</div>
