<?php
/**
 * Elementor Vehicle Compare template.
 *
 * @package car-dealer-helper
 */

if ( ! is_user_logged_in() ) {
	return;
}

if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
	?>
	<div class="alert alert-danger" role="alert" style="margin: 0;">
		<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
		<p><?php esc_html_e( 'This elementor widget will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
	</div>
	<?php
	return;
}

$this->add_render_attribute( 'cd_vehicle_wishlist', 'id', 'cd_vehicle_wishlist-' . $this->get_id() );
$this->add_render_attribute( 'cd_vehicle_wishlist', 'class', 'cd-wishlist-button cd-vehicle-wishlist ' . $settings['wishlist_button_type'] );

if ( class_exists( 'CDHL_CPT_Template' ) ) {
	$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
} else {
	$post_id = get_the_ID();
}

$title          = isset( $settings['title'] ) ? $settings['title'] : '';
$cdfs_wishlist  = new CDFS_Wishlist();
$wishlist_class = 'pgs_wishlist';

if ( $cdfs_wishlist->is_car_in_wishlist( $post_id ) ) {
	$wishlist_class .= ' added-wishlist';
}
?>
<div <?php $this->print_render_attribute_string( 'cd_vehicle_wishlist' ); ?>>
	<a href="javascript:void(0)" title="<?php echo esc_attr( get_the_title( $post_id ) ); ?>" data-id="<?php echo esc_attr( $post_id ); ?>" class="<?php echo esc_attr( $wishlist_class ); ?>">
		<i class="far fa-heart"></i> <?php echo esc_html( $title ); ?>
	</a>
</div>
