<?php
/**
 * Car financial form
 *
 * @author  TeamWP @Potenza Global Solutions
 * @package car-dealer-helper
 */
$year         = cardealer_get_field_label_with_tax_key( 'car_year' );
$make         = cardealer_get_field_label_with_tax_key( 'car_make' );
$model        = cardealer_get_field_label_with_tax_key( 'car_model' );
$trim         = cardealer_get_field_label_with_tax_key( 'car_trim' );
$vin_number   = cardealer_get_field_label_with_tax_key( 'car_vin_number' );
$stock_number = cardealer_get_field_label_with_tax_key( 'car_stock_number' );

if ( function_exists( 'acf_add_local_field_group' ) ) :
	acf_add_local_field_group(
		/**
		 * Filters the arguments of the financial form field group.
		 *
		 * @since 1.0
		 * @param array    $args    Arguments of the financial form field group.
		 * @visible        true
		 */
		apply_filters(
			'cardealer_acf_financial_form',
			array(
				'key'                   => 'group_58db4171103b4',
				'title'                 => esc_html__( 'Financial form', 'cardealer-helper' ),
				'fields'                => array(
					array(
						'key'               => 'field_58db4a30643a9',
						'label'             => esc_html__( 'Financial Information', 'cardealer-helper' ),
						'name'              => '',
						'type'              => 'tab',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'placement'         => 'top',
						'endpoint'          => 0,
					),
					array(
						'key'               => 'field_58db41886437b',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_first_name', esc_html__( 'First Name', 'cardealer-helper' ) ),
						'name'              => 'first_name',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-first_name',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db43006437d',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_middle_initial', esc_html__( 'Middle Initial', 'cardealer-helper' ) ),
						'name'              => 'middle_initial',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-middle_initial',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db42f26437c',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_last_name', esc_html__( 'Last Name', 'cardealer-helper' ) ),
						'name'              => 'last_name',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-last_name',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db430f6437e',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_street_address', esc_html__( 'Street Address', 'cardealer-helper' ) ),
						'name'              => 'street_address',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-street_address',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db432a6437f',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_city', esc_html__( 'City', 'cardealer-helper' ) ),
						'name'              => 'city',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-city',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db433264380',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_state', esc_html__( 'State', 'cardealer-helper' ) ),
						'name'              => 'state',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-state',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db434264381',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_zip', esc_html__( 'Zip', 'cardealer-helper' ) ),
						'name'              => 'zip',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-zip',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db434b64382',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_preferred_email_address', esc_html__( 'Preferred Email Address', 'cardealer-helper' ) ),
						'name'              => 'preferred_email_address',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-preferred_email_address',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db435464383',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_daytime_phone_number', esc_html__( 'Daytime Phone Number', 'cardealer-helper' ) ),
						'name'              => 'daytime_phone_number',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-daytime_phone_number',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db436164384',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_mobile', esc_html__( 'Mobile', 'cardealer-helper' ) ),
						'name'              => 'mobile_phone_number',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-mobile_phone_number',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db436e64385',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_date_of_birth', esc_html__( 'Date of Birth', 'cardealer-helper' ) ),
						'name'              => 'date_of_birth',
						'type'              => 'text',
						'instructions'      => esc_html__( 'Date Format: mm-dd-yyyy', 'cardealer-helper' ),
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-date_of_birth',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db438564387',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_ssn', esc_html__( 'Social Security Number (SSN)', 'cardealer-helper' ) ),
						'name'              => 'ssn',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-ssn',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db438c64388',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_employer_name', esc_html__( 'Employer Name', 'cardealer-helper' ) ),
						'name'              => 'employer_name',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-employer_name',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db43aa6438a',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_employer_phone', esc_html__( 'Employer Phone', 'cardealer-helper' ) ),
						'name'              => 'employer_phone',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-employer_phone',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db43b46438b',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_job_title', esc_html__( 'Job Title', 'cardealer-helper' ) ),
						'name'              => 'job_title',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-job_title',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db437964386',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_living_arrangements', esc_html__( 'Living Arrangements', 'cardealer-helper' ) ),
						'name'              => 'living_arrangements',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-living_arrangements',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db439864389',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_monthly_rent_mortgage_payment', esc_html__( 'Monthly Rent/Mortgage Payment', 'cardealer-helper' ) ),
						'name'              => 'monthly_rent_payment',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-monthly_rent_payment',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db43bd6438c',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_length_of_time_at_current_address', esc_html__( 'Length of Time at Current Address', 'cardealer-helper' ) ),
						'name'              => 'len_time_at_curr_addr',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-len_time_at_curr_addr',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db43da6438d',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_length_of_employment', esc_html__( 'Length of Employment', 'cardealer-helper' ) ),
						'name'              => 'len_of_employment',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-len_of_employment',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db43f66438e',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_annual_income', esc_html__( 'Annual Income', 'cardealer-helper' ) ),
						'name'              => 'annual_income',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-annual_income',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58dcdfd1c4955',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_other_income_amount_monthly', esc_html__( 'Other Income Amount (Monthly)', 'cardealer-helper' ) ),
						'name'              => 'other_income_amt',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-other_income_amt',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58dce013c4956',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_other_income_source', esc_html__( 'Other Income (Source)', 'cardealer-helper' ) ),
						'name'              => 'other_income_source',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-other_income_source',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58dce02bc4957',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_include_additional_info2', esc_html__( 'Additional Information', 'cardealer-helper' ) ),
						'name'              => 'additional_info',
						'type'              => 'textarea',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-additional_info',
							'id'    => '',
						),
						'default_value'     => '',
						'new_lines'         => 'wpautop',
						'maxlength'         => '',
						'placeholder'       => '',
						'rows'              => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db44006438f',
						'label'             => esc_html__( 'Joint Application', 'cardealer-helper' ),
						'name'              => 'joint_application',
						'type'              => 'true_false',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_application',
							'id'    => '',
						),
						'default_value'     => 0,
						'message'           => '',
						'ui'                => 0,
						'ui_on_text'        => '',
						'ui_off_text'       => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_607836a733cb2',
						'label'             => esc_html__( 'Joint Application', 'cardealer-helper' ),
						'name'              => '',
						'type'              => 'tab',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'placement'         => 'top',
						'endpoint'          => 0,
					),
					array(
						'key'               => 'field_58db454164391',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_first_name', esc_html__( 'First Name', 'cardealer-helper' ) ),
						'name'              => 'joint_first_name',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_first_name',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db466e64392',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_middle_initial', esc_html__( 'Middle Initial', 'cardealer-helper' ) ),
						'name'              => 'joint_middle_name',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_middle_name',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db469364393',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_last_name', esc_html__( 'Last Name', 'cardealer-helper' ) ),
						'name'              => 'joint_last_name',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_last_name',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db46a664394',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_relationship_to_applicant', esc_html__( 'Relationship to Applicant', 'cardealer-helper' ) ),
						'name'              => 'joint_relationship_to_applicant',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_relationship_to_applicant',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db46c664395',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_street_address', esc_html__( 'Street Address', 'cardealer-helper' ) ),
						'name'              => 'joint_street_address',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_street_address',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db46dc64396',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_city', esc_html__( 'City', 'cardealer-helper' ) ),
						'name'              => 'joint_city',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_city',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db46f264397',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_state', esc_html__( 'State', 'cardealer-helper' ) ),
						'name'              => 'joint_state',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_state',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db471964398',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_zip', esc_html__( 'Zip', 'cardealer-helper' ) ),
						'name'              => 'joint_zip',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_zip',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db472464399',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_preferred_email_address', esc_html__( 'Preferred Email Address', 'cardealer-helper' ) ),
						'name'              => 'joint_preferred_email_address',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_preferred_email_address',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db475c6439a',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_daytime_phone_number', esc_html__( 'Daytime Phone Number', 'cardealer-helper' ) ),
						'name'              => 'joint_day_time_phone_no',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_day_time_phone_no',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db47c86439b',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_mobile', esc_html__( 'Mobile', 'cardealer-helper' ) ),
						'name'              => 'joint_mobile_phone_number',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_mobile_phone_number',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db48406439c',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_date_of_birth', esc_html__( 'Date of Birth', 'cardealer-helper' ) ),
						'name'              => 'joint_date_of_birth',
						'type'              => 'text',
						'instructions'      => esc_html__( 'Date Format: mm-dd-yyyy', 'cardealer-helper' ),
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_date_of_birth',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db48a26439e',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_ssn', esc_html__( 'Social Security Number (SSN)', 'cardealer-helper' ) ),
						'name'              => 'joint_ssn',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_ssn',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db48b56439f',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_employer_name', esc_html__( 'Employer Name', 'cardealer-helper' ) ),
						'name'              => 'joint_employer_name',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_employer_name',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db490f643a1',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_employer_phone', esc_html__( 'Employer Phone', 'cardealer-helper' ) ),
						'name'              => 'joint_employer_phone',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_employer_phone',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db491c643a2',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_job_title', esc_html__( 'Job Title', 'cardealer-helper' ) ),
						'name'              => 'joint_job_title',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_job_title',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db48906439d',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_living_arrangements', esc_html__( 'Living Arrangements', 'cardealer-helper' ) ),
						'name'              => 'joint_living_arrangements',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_living_arrangements',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db48ca643a0',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_monthly_rent_mortgage_payment', esc_html__( 'Monthly Rent/Mortgage Payment', 'cardealer-helper' ) ),
						'name'              => 'joint_monthly_rent_payment',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_monthly_rent_payment',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db4936643a3',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_length_of_time_at_current_address', esc_html__( 'Length of Time at Current Address', 'cardealer-helper' ) ),
						'name'              => 'joint_len_time_at_curr_addr',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_len_time_at_curr_addr',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58dbb156c4324',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_length_of_employment', esc_html__( 'Length of Employment', 'cardealer-helper' ) ),
						'name'              => 'joint_len_of_employment',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_len_of_employment',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db497d643a5',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_annual_income', esc_html__( 'Annual Income', 'cardealer-helper' ) ),
						'name'              => 'joint_annual_income',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_annual_income',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db4993643a6',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_other_income_amount_monthly', esc_html__( 'Other Income Amount (Monthly)', 'cardealer-helper' ) ),
						'name'              => 'joint_other_income_amt',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_other_income_amt',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db49b2643a7',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_other_income_source', esc_html__( 'Other Income (Source)', 'cardealer-helper' ) ),
						'name'              => 'joint_other_income',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_other_income',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_58db49cf643a8',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_include_additional_info2', esc_html__( 'Additional Information', 'cardealer-helper' ) ),
						'name'              => 'joint_additional_info',
						'type'              => 'textarea',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'field_58db44006438f',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-joint_additional_info',
							'id'    => '',
						),
						'default_value'     => '',
						'new_lines'         => 'wpautop',
						'maxlength'         => '',
						'placeholder'       => '',
						'rows'              => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_591ecc6a33a93',
						'label'             => esc_html__( 'Vehicle Information', 'cardealer-helper' ),
						'name'              => '',
						'type'              => 'tab',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name- acf_field_name- acf_field_name-',
							'id'    => '',
						),
						'placement'         => 'top',
						'endpoint'          => 0,
					),
					array(
						'key'               => 'field_591ecca733a94',
						'label'             => $year,
						'name'              => 'car_year_inq',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-car_year_inq',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_591eccb033a95',
						'label'             => $make,
						'name'              => 'car_make_inq',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-car_make_inq',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_591eccb733a96',
						'label'             => $model,
						'name'              => 'car_model_inq',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-car_model_inq',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_591eccbe33a97',
						'label'             => $trim,
						'name'              => 'car_trim_inq',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-car_trim_inq',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_591eccc433a98',
						'label'             => $vin_number,
						'name'              => 'vin_number',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-vin_number',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_591ecccc33a99',
						'label'             => $stock_number,
						'name'              => 'stock_number',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-stock_number',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_591eccd233a9a',
						'label'             => esc_html__( 'Regular Price', 'cardealer-helper' ),
						'name'              => 'regular_price',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-regular_price',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_591eccda33a9b',
						'label'             => esc_html__( 'Sale Price', 'cardealer-helper' ),
						'name'              => 'sale_price',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-sale_price',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
						'readonly'          => 1,
					),
				),
				'location'              => array(
					array(
						array(
							'param'    => 'post_type',
							'operator' => '==',
							'value'    => 'financial_inquiry',
						),
					),
				),
				'menu_order'            => 0,
				'position'              => 'normal',
				'style'                 => 'default',
				'label_placement'       => 'left',
				'instruction_placement' => 'field',
				'hide_on_screen'        => '',
				'active'                => 1,
				'description'           => '',
				'menu_item_level'       => 'all',
			)
		)
	);

endif;
