<?php
/**
 * Elementor Vehicle Financing Calculator class.
 *
 * @package cardealer-helper/elementor
 * @since   5.0.0
 */

namespace Cdhl_Elementor\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

use Cdhl_Elementor\Widget_Controller\Widget_Controller;
use Cdhl_Elementor\Group_Controls;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor banner widget.
 *
 * Elementor widget that displays an banner.
 *
 * @since 5.0.0
 */
class Financing_Calculator extends Widget_Controller {

	/**
	 * Widget slug
	 *
	 * @var string
	 */
	protected $widget_slug = 'financing-calculator';

	/**
	 * Widget icon
	 *
	 * @var string
	 */
	protected $widget_icon = 'cdhl-widget-icon';

	/**
	 * Widget keywords
	 *
	 * @var array
	 */
	protected $keywords = array( 'cars', 'vehicle', 'detail', 'single', 'financing', 'calculator' );

	/**
	 * Retrieve the widget title.
	 *
	 * @since 5.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Financing Calculator', 'cardealer-helper' );
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 5.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'section_content_general',
			array(
				'label' => esc_html__( 'General', 'cardealer-helper' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'cardealer-helper' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Financing Calculator', 'cardealer-helper' ),
				'description' => esc_html__( 'Enter title here.', 'cardealer-helper' ),
			]
		);

		$this->add_control(
			'description',
			[
				'label'       => esc_html__( 'Description', 'cardealer-helper' ),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter description here', 'cardealer-helper' ),
			]
		);

		$this->add_control(
			'rate',
			[
				'label' => esc_html__( 'Rate (%)', 'cardealer-helper' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => 12,
			]
		);

		$this->add_control(
			'loan_amount_label',
			[
				'label'       => esc_html__( 'Loan Amount Field Label', 'cardealer-helper' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Loan Amount', 'cardealer-helper' ),
			]
		);

		$this->add_control(
			'down_payment_label',
			[
				'label'       => esc_html__( 'Down Payment Field Label', 'cardealer-helper' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Down Payment', 'cardealer-helper' ),
			]
		);

		$this->add_control(
			'interest_rate_label',
			[
				'label'       => esc_html__( 'Interest Rate Field Label', 'cardealer-helper' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Interest Rate (%)', 'cardealer-helper' ),
			]
		);

		$this->add_control(
			'loan_period_label',
			[
				'label'       => esc_html__( 'Loan Period Label', 'cardealer-helper' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Period (Month)', 'cardealer-helper' ),
			]
		);

		$this->add_control(
			'button_text',
			[
				'label'       => esc_html__( 'Estimate Payment Button Label', 'cardealer-helper' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Estimate Payment', 'cardealer-helper' ),
			]
		);

		$this->end_controls_section();
	}
}
