<?php
/**
 * Elementor Vehicle Attributes  class.
 *
 * @package cardealer-helper/elementor
 * @since   5.0.0
 */

namespace Cdhl_Elementor\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

use Cdhl_Elementor\Widget_Controller\Widget_Controller;
use Cdhl_Elementor\Group_Controls;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor banner widget.
 *
 * Elementor widget that displays an banner.
 *
 * @since 5.0.0
 */
class Vehicle_Attributes extends Widget_Controller {

	/**
	 * Widget slug
	 *
	 * @var string
	 */
	protected $widget_slug = 'vehicle-attributes';

	/**
	 * Widget icon
	 *
	 * @var string
	 */
	protected $widget_icon = 'cdhl-widget-icon';

	/**
	 * Widget keywords
	 *
	 * @var array
	 */
	protected $keywords = array( 'cars', 'vehicle', 'detail', 'single', 'attributes' );

	/**
	 * Retrieve the widget title.
	 *
	 * @since 5.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Vehicle Attributes', 'cardealer-helper' );
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 5.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( CDHL_ELEMENTOR_VEHIVLE_SINGLE_CAT );
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 5.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'section_content_general',
			array(
				'label' => esc_html__( 'General', 'cardealer-helper' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'important_note_content',
			[
				'label'           => esc_html__( 'Important Note', 'cardealer-helper' ),
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => '<div style="margin-top: 15px;color: #f00;font-size: 13px;">'
					. wp_kses( __( 'You can manage the attribute list using the theme option in <strong>Theme options > Inventory Settings > Detail Page > Detail Attributes</strong>.', 'cardealer-helper' ), array( 'strong' => array() ) )
					. '</div>',
				'content_classes' => 'cardealer-elementor-note',
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'cardealer-helper' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Description', 'cardealer-helper' ),
				'description' => esc_html__( 'Enter title here.', 'cardealer-helper' ),
			]
		);

		$this->add_control(
			'style',
			[
				'label'       => esc_html__( 'Style', 'cardealer-helper' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 'style-1',
				'description' => esc_html__( 'Select style from given dropdown.', 'cardealer-helper' ),
				'options'     => [
					'style-1' => esc_html__( 'Style 1', 'cardealer-helper' ),
					'style-2' => esc_html__( 'Style 2', 'cardealer-helper' ),
				],
			]
		);

		$this->add_control(
			'attribute_layout',
			[
				'label'       => esc_html__( 'Vertical/Horizontal', 'cardealer-helper' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 'vertical',
				'description' => esc_html__( 'Select attribute layout from given dropdown.', 'cardealer-helper' ),
				'options'     => [
					'vertical'   => esc_html__( 'Vertical', 'cardealer-helper' ),
					'horizontal' => esc_html__( 'Horizontal', 'cardealer-helper' ),
				],
			]
		);

		$this->add_control(
			'no_of_column',
			[
				'label'       => esc_html__( 'Number Of Columns', 'cardealer-helper' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 'vertical',
				'description' => esc_html__( 'Select number of columns from given dropdown.', 'cardealer-helper' ),
				'options'     => [
					'2' => '2',
					'3' => '3',
				],
				'condition' => [
					'attribute_layout' => 'horizontal',
				],
			]
		);

		$this->end_controls_section();
	}
}
