<?php
/**
 * CarDealer Vehicle Attributes Shortcode
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package car-dealer-helper
 */

add_shortcode( 'cd_vehicle_attributes', 'cdhl_vehicle_attributes_shortcode' );

/**
 * Shortcode HTML.
 *
 * @param array $atts .
 */
function cdhl_vehicle_attributes_shortcode( $atts ) {
	$atts = shortcode_atts(
		array(
			'element_id'       => uniqid( 'cd_vehicle_attributes' ),
			'attribute_layout' => 'vertical',
			'title'            => esc_html__( 'Description', 'cardealer-helper' ),
			'style'            => 'style-1',
			'no_of_column'     => '2',
			'css'              => '',
		),
		$atts
	);

	if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
		?>
		<div class="alert alert-danger" role="alert" style="margin: 0;">
			<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
			<p><?php esc_html_e( 'This shortcode will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
		</div>
		<?php
		return;
	}

	if ( class_exists( 'CDHL_CPT_Template' ) ) {
		$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
	} else {
		$post_id = get_the_ID();
	}

	$wrapper_class = 'cd-vehicle-attributes' . vc_shortcode_custom_css_class( $atts['css'], ' ' );	
	$wrapper_class .= ' layout-' . $atts['attribute_layout'];
	$wrapper_class .= ' ' . $atts['style'];
	if ( 'horizontal' === $atts['attribute_layout'] ) {
		if ( isset( $atts['no_of_column'] ) && $atts['no_of_column'] ) {
			$wrapper_class .= ' column-' . $atts['no_of_column'];
		}
	}

	ob_start();
	?>
	<div id="<?php echo esc_attr( $atts['element_id'] ); ?>" class="<?php echo esc_attr( $wrapper_class ); ?>">
		<?php
		if ( $atts['title'] ) {
			?>
			<h6 class="vehicle-element-title"><?php echo esc_html( $atts['title'] ); ?></h6>
			<?php
		}
		cardealer_get_cars_attributes( $post_id );
		?>
	</div>
	<?php
	return ob_get_clean();
}

/**
 * Shortcode mapping.
 *
 * @return void
 */
function cdhl_vehicle_attributes_shortcode_vc_map() {

	$params = array(
		array(
			'type'        => 'cd_html',
			'param_name'  => 'important_note_content',
			'html'        => '<div style="margin-top: 15px;color: #f00;font-size: 16px;">'
				. wp_kses( __( '<strong>Important Note</strong>: You can manage the attribute list using the theme option in <strong>Theme options > Inventory Settings > Detail Page > Detail Attributes</strong>.', 'cardealer-helper' ), array( 'strong' => array() ) )
				. '</div>',
		),
		array(
			'type'        => 'textfield',
			'heading'     => esc_html__( 'Title', 'cardealer-helper' ),
			'description' => esc_html__( 'Enter title here', 'cardealer-helper' ),
			'param_name'  => 'title',
			'value'       => esc_html__( 'Description', 'cardealer-helper' ),
		),
		array(
			'type'        => 'dropdown',
			'heading'     => esc_html__( 'Style', 'cardealer-helper' ),
			'param_name'  => 'style',
			'value'       => array(
				esc_html__( 'Style 1', 'cardealer-helper' ) => 'style-1',
				esc_html__( 'Style 2', 'cardealer-helper' ) => 'style-2',
			),
			'description' => esc_html__( 'Select style from given dropdown.', 'cardealer-helper' ),
		),
		array(
			'type'        => 'dropdown',
			'heading'     => esc_html__( 'Vertical/Horizontal', 'cardealer-helper' ),
			'param_name'  => 'attribute_layout',
			'value'       => array(
				esc_html__( 'Vertical', 'cardealer-helper' ) => 'vertical',
				esc_html__( 'Horizontal', 'cardealer-helper' ) => 'horizontal',
			),
			'description' => esc_html__( 'Select attribute layout from given dropdown.', 'cardealer-helper' ),
		),
		array(
			'type'        => 'dropdown',
			'heading'     => esc_html__( 'Number Of Columns', 'cardealer-helper' ),
			'param_name'  => 'no_of_column',
			'value'       => array(
				'2' => '2',
				'3' => '3',
			),
			'dependency'  => array(
				'element' => 'attribute_layout',
				'value'   => array( 'horizontal' ),
			),
			'description' => esc_html__( 'Select number of columns from given dropdown.', 'cardealer-helper' ),
		),
		array(
			'type'       => 'css_editor',
			'heading'    => esc_html__( 'CSS box', 'cardealer-helper' ),
			'param_name' => 'css',
			'group'      => esc_html__( 'Design Options', 'cardealer-helper' ),
		),
	);

	if ( function_exists( 'vc_map' ) ) {
		vc_map(
			array(
				'name'                    => esc_html__( 'Vehicle Attributes', 'cardealer-helper' ),
				'description'             => esc_html__( 'Vehicle Attributes', 'cardealer-helper' ),
				'base'                    => 'cd_vehicle_attributes',
				'class'                   => 'cardealer_helper_element_wrapper',
				'controls'                => 'full',
				'icon'                    => cardealer_vc_shortcode_icon( 'cd_vehicle_attributes' ),
				'category'                => esc_html__( 'Potenza Vehicle Detail', 'cardealer-helper' ),
				'show_settings_on_create' => true,
				'params'                  => $params,
			)
		);
	}
}
add_action( 'vc_before_init', 'cdhl_vehicle_attributes_shortcode_vc_map' );
