<?php
/**
 * CarDealer Vehicle Seller Contact Form Shortcode
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package car-dealer-helper
 */

add_shortcode( 'cd_vehicle_seller_contact', 'cdhl_vehicle_seller_contact_shortcode' );

/**
 * Shortcode HTML.
 *
 * @param array $atts .
 */
function cdhl_vehicle_seller_contact_shortcode( $atts ) {
	$atts = shortcode_atts(
		array(
			'element_id'   => uniqid( 'cd-vehicle-seller-contact-' ),
			'contact_form' => '',
			'show_title'   => '',
			'dealer_title' => '',
			'user_title'   => '',
			'css'          => '',
		),
		$atts
	);

	if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
		?>
		<div class="alert alert-danger" role="alert" style="margin: 0;">
			<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
			<p><?php esc_html_e( 'This shortcode will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
		</div>
		<?php
		return;
	}

	if ( class_exists( 'CDHL_CPT_Template' ) ) {
		$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
	} else {
		$post_id = get_the_ID();
	}

	if ( ! isset( $atts['contact_form'] ) || ( isset( $atts['contact_form'] ) && empty( $atts['contact_form'] ) ) ) {
		return;
	}

	$usertypes       = function_exists( 'cdfs_get_usertypes' ) ? cdfs_get_usertypes() : array();
	$usertype_labels = array();
	foreach ( $usertypes as $usertype => $usertype_data ) {
		$usertype_label = ( isset( $usertype_data['label'] ) && ! empty( $usertype_data['label'] ) ) ? $usertype_data['label'] : $usertype_data['label_original'];
		$usertype_labels[ $usertype ] = sprintf(
			esc_html__( 'Contact %s', 'cardealer-helper' ),
			$usertype_label
		);
	}

	$post_author_id = get_post_field( 'post_author', $post_id );
	$post_author    = get_user_by( 'id', $post_author_id );
	$user_type      = cdfs_get_usertype( $post_author );
	$show_title     = filter_var( $atts['show_title'], FILTER_VALIDATE_BOOLEAN );
	$dealer_title   = ( isset( $atts['dealer_title'] ) && ! empty( $atts['dealer_title'] ) ) ? $atts['dealer_title'] : $usertype_labels['dealer'];
	$user_title     = ( isset( $atts['user_title'] ) && ! empty( $atts['user_title'] ) ) ? $atts['user_title'] : $usertype_labels['user'];
	$widget_title   = ( 'dealer' === $user_type ) ? $dealer_title : $user_title;

	// contact_form
	ob_start();

	global $cdfs_seller_form, $cdfs_seller_form_fields;

	$cdfs_seller_form        = true;
	$cdfs_seller_form_fields = array(
		'cdfs_seller_form'           => 'yes',
		'cdfs_seller_form_user_id'   => $post_author_id,
		'cdfs_seller_form_user_type' => $user_type,
	);

	$wrapper_class = array(
		'cd-vehicle-seller-contact-form',
		'cd-vehicle-seller-contact-form-style-default',
		vc_shortcode_custom_css_class( $atts['css'], ' ' ),
	);
	?>
	<div id="<?php echo esc_attr( $atts['element_id'] ); ?>" class="<?php cdhl_class_builder( $wrapper_class ); ?>">
		<?php
		if ( $show_title ) {
			?>
			<h3 class="vehicle-seller-contact-title"><?php echo esc_html( $widget_title ); ?></h3>
			<?php
		}
		echo do_shortcode( '[contact-form-7 id="' . $atts['contact_form'] . '"]' );
		?>
	</div>
	<?php

	$cdfs_seller_form        = false;
	$cdfs_seller_form_fields = array();

	return ob_get_clean();
}

/**
 * Shortcode mapping.
 *
 * @return void
 */
function cdhl_vehicle_seller_contact_shortcode_vc_map() {
	if ( function_exists( 'vc_map' ) ) {

		$usertypes       = function_exists( 'cdfs_get_usertypes' ) ? cdfs_get_usertypes() : array();
		$usertype_labels = array();
		foreach ( $usertypes as $usertype => $usertype_data ) {
			$usertype_label = ( isset( $usertype_data['label'] ) && ! empty( $usertype_data['label'] ) ) ? $usertype_data['label'] : $usertype_data['label_original'];
			$usertype_labels[ $usertype ] = sprintf(
				esc_html__( 'Contact %s', 'cardealer-helper' ),
				$usertype_label
			);
		}

		$params = array(
			array(
				'param_name'  => 'contact_form',
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Contact Form', 'cardealer-helper' ),
				'description' => esc_html__( 'Please select contact form.', 'cardealer-helper' ),
				'value'       => array_flip( cdhl_get_cf7_options() ),
				'save_always' => true,
			),
			array(
				'param_name'  => 'show_title',
				'type'        => 'checkbox',
				'heading'     => esc_html__( 'Show Title', 'cardealer-helper' ),
				'value'       => array(
					esc_html__( 'Yes', 'cardealer-helper' ) => 'yes',
				),
				'std'         => '',
				'save_always' => true,
			),
			array(
				'param_name'  => 'dealer_title',
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Dealer Title', 'cardealer-helper' ),
				'description' => esc_html__( 'Enter the title to display for users with the "Car Dealer" role.', 'cardealer-helper' ),
				'value'       => $usertype_labels['dealer'],
				'save_always' => true,
				'dependency'  => array(
					'element'   => 'show_title',
					'not_empty' => true,
				),
			),
			array(
				'param_name'  => 'user_title',
				'type'        => 'textfield',
				'heading'     => esc_html__( 'User Title', 'cardealer-helper' ),
				'description' => esc_html__( 'Enter the title to display for users other than the "Car Dealer" role.', 'cardealer-helper' ),
				'value'       => $usertype_labels['user'],
				'save_always' => true,
				'dependency'  => array(
					'element'   => 'show_title',
					'not_empty' => true,
				),
			),
			array(
				'type'       => 'css_editor',
				'heading'    => esc_html__( 'CSS box', 'cardealer-helper' ),
				'param_name' => 'css',
				'group'      => esc_html__( 'Design Options', 'cardealer-helper' ),
			),
		);

		vc_map(
			array(
				'name'                    => esc_html__( 'Vehicle Seller Contact', 'cardealer-helper' ),
				'description'             => '',
				'base'                    => 'cd_vehicle_seller_contact',
				'class'                   => 'cardealer_helper_element_wrapper',
				'controls'                => 'full',
				'icon'                    => cardealer_vc_shortcode_icon( 'cd_vehicle_seller_contact' ),
				'category'                => esc_html__( 'Potenza Vehicle Detail', 'cardealer-helper' ),
				'show_settings_on_create' => true,
				'params'                  => $params,
			)
		);
	}
}
add_action( 'vc_before_init', 'cdhl_vehicle_seller_contact_shortcode_vc_map' );
