<?php
/**
 * CarDealer Vehicle Short Description Shortcode
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package car-dealer-helper
 */

add_shortcode( 'cd_vehicle_short_description', 'cdhl_vehicle_short_description_shortcode' );

/**
 * Shortcode HTML.
 *
 * @param array $atts .
 */
function cdhl_vehicle_short_description_shortcode( $atts ) {
	$atts = shortcode_atts(
		array(
			'element_id' => uniqid( 'cd_vehicle_short_description' ),
			'css'        => '',
		),
		$atts
	);

	if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
		?>
		<div class="alert alert-danger" role="alert" style="margin: 0;">
			<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
			<p><?php esc_html_e( 'This shortcode will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
		</div>
		<?php
		return;
	}

	if ( class_exists( 'CDHL_CPT_Template' ) ) {
		$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
	} else {
		$post_id = get_the_ID();
	}

	$wrapper_class = 'cd-vehicle-short-description' . vc_shortcode_custom_css_class( $atts['css'], ' ' );
	ob_start();
	?>
	<div id="<?php echo esc_attr( $atts['element_id'] ); ?>" class="<?php echo esc_attr( $wrapper_class ); ?>">
		<?php echo get_the_excerpt( $post_id ); ?>
	</div>
	<?php
	return ob_get_clean();
}

/**
 * Shortcode mapping.
 *
 * @return void
 */
function cdhl_vehicle_short_description_shortcode_vc_map() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map(
			array(
				'name'                    => esc_html__( 'Vehicle Short Description', 'cardealer-helper' ),
				'description'             => esc_html__( 'Vehicle Short Description', 'cardealer-helper' ),
				'base'                    => 'cd_vehicle_short_description',
				'class'                   => 'cardealer_helper_element_wrapper',
				'controls'                => 'full',
				'icon'                    => cardealer_vc_shortcode_icon( 'cd_vehicle_short_description' ),
				'category'                => esc_html__( 'Potenza Vehicle Detail', 'cardealer-helper' ),
				'show_settings_on_create' => true,
				'params'                  => array(
					array(
						'type'       => 'css_editor',
						'heading'    => esc_html__( 'CSS box', 'cardealer-helper' ),
						'param_name' => 'css',
						'group'      => esc_html__( 'Design Options', 'cardealer-helper' ),
					),
				),
			)
		);
	}
}
add_action( 'vc_before_init', 'cdhl_vehicle_short_description_shortcode_vc_map' );
