<?php
/**
 * CarDealer Vehicle Tabs Shortcode
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package car-dealer-helper
 */

add_shortcode( 'cd_vehicle_tabs', 'cdhl_vehicle_tabs_shortcode' );

/**
 * Shortcode HTML.
 *
 * @param array $atts .
 */
function cdhl_vehicle_tabs_shortcode( $atts ) {
	$atts = shortcode_atts(
		array(
			'element_id'   => uniqid( 'cd_vehicle_tabs' ),
			'vehicle_tabs' => '',
			'css'          => '',
		),
		$atts
	);

	if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
		?>
		<div class="alert alert-danger" role="alert" style="margin: 0;">
			<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
			<p><?php esc_html_e( 'This shortcode will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
		</div>
		<?php
		return;
	}

	$wrapper_class = 'cardealer-vehicle-tabs' . vc_shortcode_custom_css_class( $atts['css'], ' ' );
	$tabs_items    = vc_param_group_parse_atts( $atts['vehicle_tabs'] );

	if ( ! is_array( $tabs_items ) || empty( $tabs_items ) || ( ( 1 === (int) count( $tabs_items ) ) && empty( $tabs_items[0] ) ) ) {
		return;
	}

	global $cardealer_pagebuilder_vehicle_tabs;

	$cardealer_pagebuilder_vehicle_tabs = true;
	$tab_contents                       = array();
	$vehicle_tabs                       = apply_filters( 'cardealer_vehicle_tabs', array() );
	$widget_id                          = uniqid();
	ob_start();
	?>
	<div id="<?php echo esc_attr( $atts['element_id'] ); ?>" class="<?php echo esc_attr( $wrapper_class ); ?>">
		<div class="vehicle-tabs-tabcordion">
			<ul class="vehicle-tabs-tabcordion-tabs nav nav-tabs">
				<?php
				$tab_sr = 0;
				foreach ( $tabs_items as $tab_index => $tab_data ) {

					$tab_title   = isset( $tab_data['title'] ) ? $tab_data['title'] : '';
					$tab_content = isset( $tab_data['content'] ) ? $tab_data['content'] : '';
					$tab_type    = isset( $tab_data['tab_type'] ) ? $tab_data['tab_type'] : '';

					// Icon
					$icon        = '';
					$icon_type   = isset( $tab_data['icon_type'] ) ? $tab_data['icon_type'] : '';

					if ( $icon_type ) {
						vc_icon_element_fonts_enqueue( $icon_type );
						$icon = $tab_data[ 'icon_' . $icon_type ];
					}

					if ( empty( $tab_title ) && 'custom' !== $tab_type && isset( $vehicle_tabs[ $tab_type ] ) ) {
						$tab_title = $vehicle_tabs[ $tab_type ]['title'];
					}

					if ( empty( $tab_title ) || ( 'custom' !== $tab_type && ! isset( $vehicle_tabs[ $tab_type ] ) ) || ( 'custom' === $tab_type && empty( $tab_content ) ) ) {
						continue;
					}

					$tab_sr++;
					$tab_data['tab_title'] = $tab_title;
					$tab_contents[]        = $tab_data;

					$tab_li_id     = 'tabcordion-tab-' . $widget_id . $tab_sr;
					$tab_li_class  = array(
						'tabcordion-tab',
						'tabcordion-tab-' . $tab_data['tab_type'],
					);
					$tab_link_href = '#tabcordion-tab-content-' . $widget_id . $tab_sr;

					if ( 1 === $tab_sr ) {
						$tab_li_class[] = 'active';
					}
					?>
					<li id="<?php echo esc_attr( $tab_li_id ); ?>" class="<?php cdhl_class_builder( $tab_li_class ); ?>">
						<a href="<?php echo esc_url( $tab_link_href ); ?>" data-toggle="tab">
							<?php
							if ( $icon ) {
								?>
								<i class="<?php echo esc_attr( $icon ); ?>"></i>
								<?php
							}
							echo esc_html( $tab_title );
							?>
						</a>
					</li>
					<?php
				}
				?>
			</ul>
			<div class="vehicle-tabs-tabcordion-contents tab-content">
				<?php
				$tab_sr = 0;
				foreach ( $tab_contents as $tab_index => $tab_data ) {
					$tab_sr++;

					$tab_content = isset( $tab_data['content'] ) ? $tab_data['content'] : '';
					$tab_type    = isset( $tab_data['tab_type'] ) ? $tab_data['tab_type'] : '';

					// Icon
					$icon        = '';
					$icon_type   = isset( $tab_data['icon_type'] ) ? $tab_data['icon_type'] : '';

					if ( $icon_type ) {
						vc_icon_element_fonts_enqueue( $icon_type );
						$icon = $tab_data[ 'icon_' . $icon_type ];
					}

					$tab_content_class = array(
						'tabcordion-tab-content',
						'tabcordion-tab-content-' . $widget_id,
						'tab-pane'
					);

					$tabcordion_collapse_link_class = array(
						'tabcordion-collapse'
					);

					$tabcordion_collapse_content_class = array(
						'tabcordion-collapse-content',
						'panel-collapse',
						'collapse',
					);

					if ( 1 === $tab_sr ) {
						$tab_content_class[] = 'active';
						$tabcordion_collapse_content_class[] = 'in';
					} else {
						$tabcordion_collapse_link_class[] = 'collapsed';
					}
					?>
					<div id="tabcordion-tab-content-<?php echo esc_attr( $widget_id.$tab_sr ); ?>" class="<?php cdhl_class_builder( $tab_content_class ); ?>">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 class="panel-title">
									<a class="<?php cdhl_class_builder( $tabcordion_collapse_link_class ); ?>" data-toggle="collapse" data-parent=".tabcordion-tab-content-<?php echo esc_attr( $widget_id ); ?>" href="#tabcordion-collapse-content-<?php echo esc_attr( "$widget_id-$tab_sr" ); ?>">
										<?php
										if ( $icon ) {
											?>
											<i class="<?php echo esc_attr( $icon ); ?>"></i>
											<?php
										}
										echo esc_html( $tab_data['tab_title'] );
										?>
									</a>
								</h4>
							</div>
							<div id="tabcordion-collapse-content-<?php echo esc_attr( "$widget_id-$tab_sr" ); ?>" class="<?php cdhl_class_builder( $tabcordion_collapse_content_class ); ?>">
								<div class="panel-body">
									<?php
									if ( 'custom' === $tab_type ) {
										echo do_shortcode( $tab_content );
									} else {
										if ( is_singular( 'cardealer_template' ) ) {
											echo esc_html__( 'The content will appear on the vehicle detail page.', 'cardealer-helper' );
										} else {
											if ( isset( $vehicle_tabs[ $tab_type ]['callback'] ) && is_callable( $vehicle_tabs[ $tab_type ]['callback'] ) ) {
												call_user_func( $vehicle_tabs[ $tab_type ]['callback'], $tab_type, $tab_data );
											}
										}
									}
									?>
								</div>
							</div>
						</div>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
	return ob_get_clean();
}

/**
 * Shortcode mapping.
 *
 * @return void
 */
function cdhl_vehicle_tabs_shortcode_vc_map() {
	if ( function_exists( 'vc_map' ) ) {

		$vehicle_tabs = apply_filters( 'cardealer_vehicle_tabs_option', array() );
		$vehicle_tabs = array_merge(
			$vehicle_tabs,
			array(
				'custom' => 'Custom',
			)
		);

		$vehicle_tabs = array_map( 'htmlspecialchars_decode', $vehicle_tabs );

		$params = array(
			array(
				'type'       => 'param_group',
				'param_name' => 'vehicle_tabs',
				'group'      => esc_html__( 'Tabs', 'cardealer-helper' ),
				'params'     => array(
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Tab', 'cardealer-helper' ),
						'param_name'  => 'tab_type',
						'value'       => array_flip( $vehicle_tabs ),
						'description' => esc_html__( 'The built-in tabs depend on the content so that they will appear according to the data.', 'cardealer-helper' ),
						'admin_label' => true,
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Title', 'cardealer-helper' ),
						'description' => esc_html__( 'Enter title here', 'cardealer-helper' ),
						'param_name'  => 'title',
						'admin_label' => true,
					),
					array(
						'type'        => 'textarea',
						'heading'     => esc_html__( 'Content', 'cardealer-helper' ),
						'param_name'  => 'content',
						'dependency'  => array(
							'element' => 'tab_type',
							'value'   => 'custom',
						),
						'description' => esc_html__( 'If a custom tab is missing a title or content, the tab will not display on the front.', 'cardealer-helper' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Icon library', 'cardealer-helper' ),
						'value'       => array(
							esc_html__( 'None', 'cardealer-helper' ) => '',
							esc_html__( 'Font Awesome', 'cardealer-helper' ) => 'fontawesome',
							esc_html__( 'Open Iconic', 'cardealer-helper' ) => 'openiconic',
							esc_html__( 'Typicons', 'cardealer-helper' )   => 'typicons',
							esc_html__( 'Entypo', 'cardealer-helper' )     => 'entypo',
							esc_html__( 'Linecons', 'cardealer-helper' )   => 'linecons',
							esc_html__( 'Mono Social', 'cardealer-helper' ) => 'monosocial',
							esc_html__( 'Flat Icons', 'cardealer-helper' ) => 'flaticon',
						),
						'param_name'  => 'icon_type',
						'description' => esc_html__( 'Select icon library.', 'cardealer-helper' ),
					),
					array(
						'type'        => 'iconpicker',
						'heading'     => esc_html__( 'Icon', 'cardealer-helper' ),
						'param_name'  => 'icon_fontawesome',
						'value'       => 'fas fa-info-circle',
						'settings'    => array(
							'emptyIcon'    => false,
							'iconsPerPage' => 100,
						),
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'fontawesome',
						),
						'description' => esc_html__( 'Select icon from library.', 'cardealer-helper' ),
					),
					array(
						'type'        => 'iconpicker',
						'heading'     => esc_html__( 'Icon', 'cardealer-helper' ),
						'param_name'  => 'icon_openiconic',
						'value'       => 'vc-oi vc-oi-dial',
						'settings'    => array(
							'emptyIcon'    => false,
							'type'         => 'openiconic',
							'iconsPerPage' => 100,
						),
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'openiconic',
						),
						'description' => esc_html__( 'Select icon from library.', 'cardealer-helper' ),
					),
					array(
						'type'        => 'iconpicker',
						'heading'     => esc_html__( 'Icon', 'cardealer-helper' ),
						'param_name'  => 'icon_typicons',
						'value'       => 'typcn typcn-adjust-brightness',
						'settings'    => array(
							'emptyIcon'    => false,
							'type'         => 'typicons',
							'iconsPerPage' => 100,
						),
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'typicons',
						),
						'description' => esc_html__( 'Select icon from library.', 'cardealer-helper' ),
					),
					array(
						'type'       => 'iconpicker',
						'heading'    => esc_html__( 'Icon', 'cardealer-helper' ),
						'param_name' => 'icon_entypo',
						'value'      => 'entypo-icon entypo-icon-note',
						'settings'   => array(
							'emptyIcon'    => false,
							'type'         => 'entypo',
							'iconsPerPage' => 100,
						),
						'dependency' => array(
							'element' => 'icon_type',
							'value'   => 'entypo',
						),
						'description' => esc_html__( 'Select icon from library.', 'cardealer-helper' ),
					),
					array(
						'type'        => 'iconpicker',
						'heading'     => esc_html__( 'Icon', 'cardealer-helper' ),
						'param_name'  => 'icon_linecons',
						'value'       => 'vc_li vc_li-heart',
						'settings'    => array(
							'emptyIcon'    => false,
							'type'         => 'linecons',
							'iconsPerPage' => 100,
						),
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'linecons',
						),
						'description' => esc_html__( 'Select icon from library.', 'cardealer-helper' ),
					),
					array(
						'type'        => 'iconpicker',
						'heading'     => esc_html__( 'Icon', 'cardealer-helper' ),
						'param_name'  => 'icon_monosocial',
						'value'       => 'vc-mono vc-mono-fivehundredpx',
						'settings'    => array(
							'emptyIcon'    => false,
							'type'         => 'monosocial',
							'iconsPerPage' => 100,
						),
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'monosocial',
						),
						'description' => esc_html__( 'Select icon from library.', 'cardealer-helper' ),
					),
					array(
						'type'        => 'iconpicker',
						'heading'     => esc_html__( 'Icon', 'cardealer-helper' ),
						'param_name'  => 'icon_flaticon',
						'value'       => 'glyph-icon flaticon-air-conditioning',
						'settings'    => array(
							'emptyIcon'    => false,
							'type'         => 'flaticon',
							'iconsPerPage' => 100,
						),
						'dependency'  => array(
							'element' => 'icon_type',
							'value'   => 'flaticon',
						),
						'description' => esc_html__( 'Select icon from library.', 'cardealer-helper' ),
					),
				),
				'value' => rawurlencode( wp_json_encode( array(
					array(
						'tab_type'         => 'overview',
						'icon_type'        => 'fontawesome',
						'icon_fontawesome' => 'fas fa-sliders-h',
					),
					array(
						'tab_type'         => 'features',
						'icon_type'        => 'fontawesome',
						'icon_fontawesome' => 'fas fa-list',
					),
					array(
						'tab_type'         => 'technical',
						'icon_type'        => 'fontawesome',
						'icon_fontawesome' => 'fas fa-cogs',
					),
					array(
						'tab_type'         => 'general_info',
						'icon_type'        => 'fontawesome',
						'icon_fontawesome' => 'fas fa-info-circle',
					),
					array(
						'tab_type'         => 'location',
						'icon_type'        => 'fontawesome',
						'icon_fontawesome' => 'fas fa-map-marker-alt',
					)
				) ) ),
			),
			array(
				'type'       => 'css_editor',
				'heading'    => esc_html__( 'CSS box', 'cardealer-helper' ),
				'param_name' => 'css',
				'group'      => esc_html__( 'Design Options', 'cardealer-helper' ),
			),
		);
		vc_map(
			array(
				'name'                    => esc_html__( 'Vehicle Tabs', 'cardealer-helper' ),
				'description'             => esc_html__( 'Vehicle Tabs', 'cardealer-helper' ),
				'base'                    => 'cd_vehicle_tabs',
				'class'                   => 'cardealer_helper_element_wrapper',
				'controls'                => 'full',
				'icon'                    => cardealer_vc_shortcode_icon( 'cd_vehicle_tabs' ),
				'category'                => esc_html__( 'Potenza Vehicle Detail', 'cardealer-helper' ),
				'show_settings_on_create' => true,
				'params'                  => $params,
			)
		);
	}
}
add_action( 'vc_before_init', 'cdhl_vehicle_tabs_shortcode_vc_map' );
