<?php
/**
 * Adds Vehicle Make Widget.
 *
 * @package car-dealer-helper/widgets
 * @version 1.9.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * CDHL_Widget_Vehicle_Make_Logos class.
 *
 * @extends CDHL_Widget
 */
class CDFS_Widget_Vehicle_Seller_Contact extends CDHL_Widget {

	/**
	 * Register widget with WordPress.
	 */
	public function __construct() {
		$this->widget_id          = 'vehicle-seller-contact';
		$this->widget_name        = esc_html__( 'CDFS - Vehicle Seller Contact', 'cardealer-helper' );
		$this->widget_description = esc_html__( 'Display vehicle seller contact form.', 'cardealer-helper' );
		$this->widget_cssclass    = 'widget-cdfs-vehicle-seller-contact';
		$usertype_labels          = $this->usertype_labels();

		$this->settings           = array(
			'widget_notice' => array(
				'type'        => 'notice',
				'notice_type' => 'info',
				'label'       => esc_html__( 'Widget Notice', 'cardealer-helper' ),
				'message'     => esc_html__( 'This widget will display only on the vehicle details post (post type: cars).', 'cardealer-helper' ),
			),
			'show_title' => array(
				'type'        => 'checkbox',
				'std'         => 0,
				'label'       => esc_html__( 'Show Title', 'cardealer-helper' ),
			),
			'dealer_title'      => array(
				'type'  => 'text',
				'label' => esc_html__( 'Dealer Title', 'cardealer-helper' ),
				'std'   => isset( $usertype_labels['dealer'] ) ? $usertype_labels['dealer'] : '',
				'desc'  => esc_html__( 'Enter the widget title to display for users with the "Car Dealer" role.', 'cardealer-helper' ),
			),
			'user_title'      => array(
				'type'  => 'text',
				'label' => esc_html__( 'User Title', 'cardealer-helper' ),
				'std'   => isset( $usertype_labels['user'] ) ? $usertype_labels['user'] : '',
				'desc'  => esc_html__( 'Enter the widget title to display for users other than the "Car Dealer" role.', 'cardealer-helper' ),
			),
			'contact_form'  => array(
				'type'        => 'select',
				'std'         => 'name',
				'label'       => esc_html__( 'Contact Form', 'cardealer-helper' ),
				'options'     => cdhl_get_cf7_options(),
			),
		);

		parent::__construct();
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {

		if ( ! is_singular( 'cars' ) ) {
			return;
		}

		if ( ! isset( $instance['contact_form'] ) || ( isset( $instance['contact_form'] ) && empty( $instance['contact_form'] ) ) ) {
			return;
		}

		$post_id         = get_the_ID();
		$post_author_id  = get_post_field( 'post_author', $post_id );
		$post_author     = get_user_by( 'id', $post_author_id );
		$user_type       = cdfs_get_usertype( $post_author );
		$show_title      = ( isset( $instance['show_title'] ) ) ? $instance['show_title'] : 'no';
		$show_title      = filter_var( $show_title, FILTER_VALIDATE_BOOLEAN );
		$usertype_labels = $this->usertype_labels();
		$dealer_title    = ( isset( $instance['dealer_title'] ) && ! empty( $instance['dealer_title'] ) ) ? $instance['dealer_title'] : $usertype_labels['dealer'];
		$user_title      = ( isset( $instance['user_title'] ) && ! empty( $instance['user_title'] ) ) ? $instance['user_title'] : $usertype_labels['user'];
		$widget_title    = ( 'dealer' === $user_type ) ? $dealer_title : $user_title;

		echo $args['before_widget']; // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotE

		global $cdfs_seller_form, $cdfs_seller_form_fields;

		$cdfs_seller_form        = true;
		$cdfs_seller_form_fields = array(
			'cdfs_seller_form'           => 'yes',
			'cdfs_seller_form_user_id'   => $post_author_id,
			'cdfs_seller_form_user_type' => $user_type,
		);

		$wrapper_class = array(
			'cd-vehicle-seller-contact-form',
			'cd-vehicle-seller-contact-form-style-default',
		);
		?>
		<div id="<?php echo esc_attr( uniqid( 'cd-vehicle-seller-contact-' ) ); ?>" class="<?php cdhl_class_builder( $wrapper_class ); ?>">
			<?php
			if ( $show_title ) {
				?>
				<h3 class="vehicle-seller-contact-title"><?php echo esc_html( $widget_title ); ?></h3>
				<?php
			}
			?>
			<?php echo do_shortcode( '[contact-form-7 id="' . $instance['contact_form'] . '"]' ); ?>
		</div>
		<?php

		$cdfs_seller_form        = false;
		$cdfs_seller_form_fields = array();

		echo $args['after_widget']; // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotE
	}

	private function usertype_labels() {
		$usertypes       = function_exists( 'cdfs_get_usertypes' ) ? cdfs_get_usertypes() : array();
		$usertype_labels = array();
		foreach ( $usertypes as $usertype => $usertype_data ) {
			$usertype_label = ( isset( $usertype_data['label'] ) && ! empty( $usertype_data['label'] ) ) ? $usertype_data['label'] : $usertype_data['label_original'];
			$usertype_labels[ $usertype ] = sprintf(
				esc_html__( 'Contact %s', 'cardealer-helper' ),
				$usertype_label
			);
		}
		return $usertype_labels;
	}
}
