<?php
/**
 * Elementor Vehicle Title template.
 *
 * @package car-dealer-helper
 */

$this->add_render_attribute( 'cd_financing_calculator', 'id', 'cd_vehicle_title-' . $this->get_id() );
$this->add_render_attribute( 'cd_vehicle_title', 'class', 'cd-financing-calculator' );

$loan_amount_label   = ( isset( $settings['loan_amount_label'] ) && $settings['loan_amount_label'] ) ? $settings['loan_amount_label'] : esc_html__( 'Loan Amount', 'cardealer-helper' );
$down_payment_label  = ( isset( $settings['down_payment_label'] ) && $settings['down_payment_label'] ) ? $settings['down_payment_label'] : esc_html__( 'Down Payment', 'cardealer-helper' );
$interest_rate_label = ( isset( $settings['interest_rate_label'] ) && $settings['interest_rate_label'] ) ? $settings['interest_rate_label'] : esc_html__( 'Interest Rate (%)', 'cardealer-helper' );
$loan_period_label   = ( isset( $settings['loan_period_label'] ) && $settings['loan_period_label'] ) ? $settings['loan_period_label'] : esc_html__( 'Period (Month)', 'cardealer-helper' );
$button_text         = ( isset( $settings['button_text'] ) && $settings['button_text'] ) ? $settings['button_text'] : esc_html__( 'Estimate Payment', 'cardealer-helper' );
$description         = ( isset( $settings['description'] ) ) ? $settings['description'] : '';
$title               = ( isset( $settings['title'] ) ) ? $settings['title'] : '';
$rate                = ( isset( $settings['rate'] ) ) ? $settings['rate'] : '';

wp_enqueue_script( 'cardealer-financing-calculator' );
?>
<div <?php $this->print_render_attribute_string( 'cd_financing_calculator' ); ?>>
	<div class="news-letter">
		<?php		
		if ( $title ) {
			$this->add_render_attribute( 'cd_element_title', 'class', 'vehicle-element-title' );
			?>
			<h6 <?php $this->print_render_attribute_string( 'cd_element_title' ); ?>>
				<?php echo esc_html( $title ); ?>
			</h6>
			<?php
		}

		if ( $description ) {
			echo '<p>' . esc_html( $description ) . '</p>';
		}
		?>
		<form class="financing-calculator" id="<?php echo esc_attr( $this->get_id() ); ?>">
			<div class="form-group">
				<label><?php echo esc_html( $loan_amount_label ); ?>*</label>
				<input type="text" name="loan_amount" id="loan-amount-<?php echo esc_attr( $this->get_id() ); ?>" value="" class="form-control"/>
			</div>
			<div class="form-group">
				<label><?php echo esc_html( $down_payment_label ); ?>*</label>
				<input type="text" name="down_payment" id="down-payment-<?php echo esc_attr( $this->get_id() ); ?>" class="form-control"/>
			</div>
			<div class="form-group">
				<label><?php echo esc_html( $interest_rate_label ); ?>*</label>
				<input type="text" name="interest_rate" id="interest-rate-<?php echo esc_attr( $this->get_id() ); ?>" class="form-control" value="<?php echo esc_attr( $rate ); ?>"/>
			</div>
			<div class="form-group">
				<label><?php echo esc_html( $loan_period_label ); ?>*</label>
				<input type="text" name="period" id="period-<?php echo esc_attr( $this->get_id() ); ?>" class="form-control" />
			</div>
			<div class="form-group">
				<label><?php esc_html_e( 'Payment', 'cardealer-helper' ); ?></label>
				<div class="cal_text payment-box">
					<div id="txtPayment-<?php echo esc_attr( $this->get_id() ); ?>"></div>
				</div>
			</div>
			<div class="form-group">
				<a class="button red do_calculator" href="javascript:void(0);" data-form-id="<?php echo esc_attr( $this->get_id() ); ?>"><?php echo esc_html( $button_text ); ?></a>
				<a class="button red do_calculator_clear" href="javascript:void(0);" data-form-id="<?php echo esc_attr( $this->get_id() ); ?>"><?php echo esc_html__( 'clear', 'cardealer-helper' ); ?></a>
			</div>
		</form>
	</div>
</div>
