<?php
/**
 * Elementor Vehicle Button template.
 *
 * @package car-dealer-helper
 */

if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
	?>
	<div class="alert alert-danger" role="alert" style="margin: 0;">
		<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
		<p><?php esc_html_e( 'This elementor widget will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
	</div>
	<?php
	return;
}

$show_buttons = ( isset( $settings['show_buttons'] ) && is_array( $settings['show_buttons'] ) && ! empty( $settings['show_buttons'] ) ) ? $settings['show_buttons'] : array();
$style        = ( isset( $settings['style'] ) && ! empty( $settings['style'] ) ) ? $settings['style'] : 'style-1';
$alignment    = ( isset( $settings['alignment'] ) && ! empty( $settings['alignment'] ) ) ? $settings['alignment'] : 'inline';
$color        = ( isset( $settings['color'] ) && ! empty( $settings['color'] ) ) ? $settings['color'] : 'default';
$button_type  = ( isset( $settings['button_type'] ) && ! empty( $settings['button_type'] ) ) ? $settings['button_type'] : 'default';

$this->add_render_attribute( 'cd_vehicle_buttons', 'id', 'cd_vehicle_buttons-' . $this->get_id() );
$this->add_render_attribute( 'cd_vehicle_buttons', 'class', 'cd-vehicle-buttons' );
$this->add_render_attribute( 'cd_vehicle_buttons', 'class', 'cd-vehicle-buttons-' . $style );

if ( 'style-1' === $style ) {
	$this->add_render_attribute( 'cd_vehicle_buttons', 'class', 'cd-vehicle-buttons-alignment-' . $alignment  );
	$this->add_render_attribute( 'cd_vehicle_buttons', 'class', 'cd-vehicle-buttons-color-' . $color  );
} elseif( 'style-2' === $style ) {
	$this->add_render_attribute( 'cd_vehicle_buttons', 'class', 'cd-vehicle-buttons-type-' . $button_type  );
}
?>
<div <?php $this->print_render_attribute_string( 'cd_vehicle_buttons' ); ?>>
	<?php cardealer_display_vehicle_buttons( $show_buttons ); ?>
</div>
