<?php
/**
 * Elementor Vehicle Title template.
 *
 * @package car-dealer-helper
 */

if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
	?>
	<div class="alert alert-danger" role="alert" style="margin: 0;">
		<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
		<p><?php esc_html_e( 'This elementor widget will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
	</div>
	<?php
	return;
}

$atts = array(
	'image_size'   => ( isset( $settings['image_size'] ) && ! empty( $settings['image_size'] ) ) ? $settings['image_size'] : 'car_single_slider',
	'video_button' => ( isset( $settings['video_button'] ) && ! empty( $settings['video_button'] ) ) ? filter_var( $settings['video_button'], FILTER_VALIDATE_BOOLEAN ) : false,
	'sold_badge'   => ( isset( $settings['sold_badge'] ) && ! empty( $settings['sold_badge'] ) ) ? filter_var( $settings['sold_badge'], FILTER_VALIDATE_BOOLEAN ) : false,
	'no_margin'    => ( isset( $settings['no_margin'] ) && ! empty( $settings['no_margin'] ) ) ? filter_var( $settings['no_margin'], FILTER_VALIDATE_BOOLEAN ) : false,
);

if ( class_exists( 'CDHL_CPT_Template' ) ) {
	$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
} else {
	$post_id = get_the_ID();
}

$this->add_render_attribute( 'cd_vehicle_gallery', 'id', 'cd_vehicle_gallery-' . $this->get_id() );
$this->add_render_attribute( 'cd_vehicle_gallery', 'class', 'vehicle-gallery' );

if ( isset( $atts['no_margin'] ) && true === (bool) $atts['no_margin'] ) {
	$this->add_render_attribute( 'cd_vehicle_gallery', 'class', 'no-margin' );
}
?>
<div <?php $this->print_render_attribute_string( 'cd_vehicle_gallery' ); ?>>
		<div class="slider-slick">
			<?php
			if ( function_exists( 'get_field' ) ) {
				?>
				<div class="cars-image-gallery my-gallery">
					<?php
					do_action( 'before_image_gallery_slider', $post_id );
					if ( isset( $atts['sold_badge'] ) && true === (bool) $atts['sold_badge'] ) {
						echo cardealer_vehicle_sold_label( $post_id );
					}
					?>
					<div class="slider slider-for detail-big-car-gallery">
						<?php
						$i      = 0;
						$images = get_field( 'car_images', $post_id );
						if ( ! empty( $images ) ) {
							foreach ( $images as $image ) {
								$image_url    = isset( $image['url'] ) ? $image['url'] : '';
								$image_width  = isset( $image['width'] ) ? $image['width'] : '';
								$image_height = isset( $image['height'] ) ? $image['height'] : '';
								$imag_alt     = ( isset( $image['alt'] ) && $image['alt'] ) ? $image['alt'] : get_the_title();
								?>
								<figure>
									<img src="<?php echo esc_url( $image['sizes'][$atts['image_size']] ); ?>" class="img-responsive ps-car-listing" id="pscar-<?php echo esc_attr( $i++ ); ?>" alt="<?php echo esc_attr( $imag_alt ); ?>"  data-src="<?php echo esc_url( $image_url ); ?>" data-width="<?php echo esc_attr( $image_width ); ?>" data-height="<?php echo esc_attr( $image_height ); ?>"/>
								</figure>
								<?php
							}
						} else {
							echo wp_kses_post( cardealer_get_cars_image( 'large', $post_id ) );
						}
						?>
					</div>
					<?php
					if ( isset( $atts['video_button'] ) && true === (bool) $atts['video_button'] ) {
						echo cardealer_vehicle_image_gallery_video_button( $post_id );
					}
					?>
				</div>
				<div class="slider slider-nav">
					<?php
					$images = get_field( 'car_images', $post_id );
					if ( $images ) {
						?>
						<?php
						foreach ( $images as $image ) {
							$imag_alt = ( '' !== $image['alt'] ) ? $image['alt'] : get_the_title();
							?>
							<img class="img-responsive" src="<?php echo esc_url( $image['sizes']['car_thumbnail'] ); ?>" alt="<?php echo esc_attr( $imag_alt ); ?>">
							<?php
						}
					}
					?>
				</div>
				<?php
			}
			?>
		</div>
	</div>
