<?php
/**
 * Elementor Vehicle Tabs template.
 *
 * @package car-dealer-helper
 */

if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
	?>
	<div class="alert alert-danger" role="alert" style="margin: 0;">
		<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
		<p><?php esc_html_e( 'This elementor widget will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
	</div>
	<?php
	return;
}

$widget_id    = $this->get_id_int();
$settings     = $this->get_settings_for_display();
$tabs         = $this->get_settings_for_display( 'tabs' );
$tab_contents = array();

global $cardealer_pagebuilder_vehicle_tabs;
$cardealer_pagebuilder_vehicle_tabs = true;

$vehicle_tabs = apply_filters( 'cardealer_vehicle_tabs', array() );

$this->add_render_attribute(
	'cardealer_vehicle_tabs',
	array(
		'id'    => "cardealer-vehicle-tabs-$widget_id",
		'class' => 'cardealer-vehicle-tabs xyz',
	)
);
?>
<div <?php $this->print_render_attribute_string( 'cardealer_vehicle_tabs' ); ?>>
	<div class="vehicle-tabs-tabcordion">
		<ul class="vehicle-tabs-tabcordion-tabs nav nav-tabs">
			<?php
			$tab_sr = 0;
			foreach ( $tabs as $tab_index => $tab_data ) {

				$tab_title   = ( isset( $tab_data['tab_title'] ) && $tab_data['tab_title'] ) ? trim( $tab_data['tab_title'] ) : '';
				$tab_content = ( isset( $tab_data['tab_content'] ) && $tab_data['tab_content'] ) ? trim( $tab_data['tab_content'] ) : '';

				if ( empty( $tab_title ) && 'custom' !== $tab_data['selected_tab'] && isset( $vehicle_tabs[ $tab_data['selected_tab'] ] ) ) {
					$tab_title = $vehicle_tabs[ $tab_data['selected_tab'] ]['title'];
				}

				if (
					( ! \Elementor\Plugin::$instance->editor->is_edit_mode() )
					&& ( empty( $tab_title ) || ( 'custom' !== $tab_data['selected_tab'] && ! isset( $vehicle_tabs[ $tab_data['selected_tab'] ] ) ) || ( 'custom' === $tab_data['selected_tab'] && empty( $tab_content ) ) )
				) {
					continue;
				}

				$tab_sr++;
				$tab_data['tab_title'] = $tab_title;
				$tab_contents[]        = $tab_data;

				$tab_li_id     = 'tabcordion-tab-' . $widget_id . $tab_sr;
				$tab_li_class  = array(
					'tabcordion-tab',
					'tabcordion-tab-' . $tab_data['selected_tab'],
				);
				$tab_link_href = '#tabcordion-tab-content-' . $widget_id . $tab_sr;

				if ( 1 === $tab_sr ) {
					$tab_li_class[] = 'active';
				}
				?>
				<li id="<?php echo esc_attr( $tab_li_id ); ?>" class="<?php cdhl_class_builder( $tab_li_class ); ?>">
					<a href="<?php echo esc_url( $tab_link_href ); ?>" data-toggle="tab">
						<?php
						if ( ! empty( $tab_data['tab_icon']['value'] ) ) {
							?>
							<span <?php $this->print_render_attribute_string( 'icon-align' ); ?>>&nbsp;<?php \Elementor\Icons_Manager::render_icon( $tab_data['tab_icon'], [ 'aria-hidden' => 'true' ] ); ?></span>
							<?php
						}
						echo esc_html( $tab_title );
						?>
					</a>
				</li>
				<?php
			}
			?>
		</ul>
		<div class="vehicle-tabs-tabcordion-contents tab-content">
			<?php
			$tab_sr = 0;
			foreach ( $tab_contents as $tab_index => $tab_data ) {
				$tab_sr++;

				$tab_content = isset( $tab_data['tab_content'] ) ? $tab_data['tab_content'] : '';
				$tab_type    = isset( $tab_data['selected_tab'] ) ? $tab_data['selected_tab'] : '';

				$tab_content_class = array(
					'tabcordion-tab-content',
					'tabcordion-tab-content-' . $widget_id,
					'tab-pane'
				);

				$tabcordion_collapse_link_class = array(
					'tabcordion-collapse'
				);

				$tabcordion_collapse_content_class = array(
					'tabcordion-collapse-content',
					'panel-collapse',
					'collapse',
				);

				if ( 1 === $tab_sr ) {
					$tab_content_class[] = 'active';
					$tabcordion_collapse_content_class[] = 'in';
				} else {
					$tabcordion_collapse_link_class[] = 'collapsed';
				}
				?>
				<div id="tabcordion-tab-content-<?php echo esc_attr( $widget_id.$tab_sr ); ?>" class="<?php cdhl_class_builder( $tab_content_class ); ?>">
					<div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<a class="<?php cdhl_class_builder( $tabcordion_collapse_link_class ); ?>" data-toggle="collapse" data-parent=".tabcordion-tab-content-<?php echo esc_attr( $widget_id ); ?>" href="#tabcordion-collapse-content-<?php echo esc_attr( "$widget_id-$tab_sr" ); ?>">
									<?php
									if ( ! empty( $tab_data['tab_icon']['value'] ) ) {
										?>
										<span <?php $this->print_render_attribute_string( 'icon-align' ); ?>>&nbsp;<?php \Elementor\Icons_Manager::render_icon( $tab_data['tab_icon'], [ 'aria-hidden' => 'true' ] ); ?></span>
										<?php
									}
									echo esc_html( $tab_data['tab_title'] );
									?>
								</a>
							</h4>
						</div>
						<div id="tabcordion-collapse-content-<?php echo esc_attr( "$widget_id-$tab_sr" ); ?>" class="<?php cdhl_class_builder( $tabcordion_collapse_content_class ); ?>">
							<div class="panel-body">
								<?php
								if ( 'custom' === $tab_type ) {
									$this->print_text_editor( $tab_content );
								} else {
									if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
										echo esc_html__( 'The content will appear on the vehicle detail page.', 'cardealer-helper' );
									} else {
										if ( isset( $vehicle_tabs[ $tab_type ]['callback'] ) && is_callable( $vehicle_tabs[ $tab_type ]['callback'] ) ) {
											call_user_func( $vehicle_tabs[ $tab_type ]['callback'], $tab_type, $tab_data );
										}
									}
								}
								?>
							</div>
						</div>
					</div>
				</div>
				<?php
			}
			?>
		</div>
	</div>
</div>
