<?php
/**
 * Car team details
 *
 * @author  TeamWP @Potenza Global Solutions
 * @package car-dealer-helper
 */

if ( function_exists( 'acf_add_local_field_group' ) ) :

	acf_add_local_field_group(
		/**
		 * Filters the arguments of the team details field group.
		 *
		 * @since 1.0
		 * @param array    $args    Arguments of the team details field group.
		 * @visible        true
		 */
		apply_filters(
			'cardealer_acf_team_details',
			array(
				'key'                   => 'group_575eac21bbfd0',
				'title'                 => esc_html__( 'Team Details', 'cardealer-helper' ),
				'fields'                => array(
					array(
						'key'               => 'field_575eac8624994',
						'label'             => esc_html__( 'General Details', 'cardealer-helper' ),
						'name'              => '',
						'type'              => 'tab',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name- acf_field_name- acf_field_name-',
							'id'    => '',
						),
						'placement'         => 'top',
						'endpoint'          => 0,
					),
					array(
						'key'               => 'field_575eac3024992',
						'label'             => esc_html__( 'Designation', 'cardealer-helper' ),
						'name'              => 'designation',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-designation acf_field_name-designation acf_field_name-designation',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
						'readonly'          => 0,
						'disabled'          => 0,
					),
					array(
						'key'               => 'field_575eac3e24993',
						'label'             => esc_html__( 'Social Profiles', 'cardealer-helper' ),
						'name'              => '',
						'type'              => 'tab',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name- acf_field_name- acf_field_name-',
							'id'    => '',
						),
						'placement'         => 'top',
						'endpoint'          => 0,
					),
					array(
						'key'               => 'field_575eac9a24995',
						'label'             => esc_html__( 'Facebook', 'cardealer-helper' ),
						'name'              => 'facebook',
						'type'              => 'url',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-facebook acf_field_name-facebook acf_field_name-facebook',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
					),
					array(
						'key'               => 'field_575eacbb24996',
						'label'             => esc_html__( 'Twitter', 'cardealer-helper' ),
						'name'              => 'twitter',
						'type'              => 'url',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-twitter acf_field_name-twitter acf_field_name-twitter',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
					),
					array(
						'key'               => 'field_d82ba802d5c311e88eff6f6e6c696e65',
						'label'             => esc_html__( 'Dribble', 'cardealer-helper' ),
						'name'              => 'dribbble',
						'type'              => 'url',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-dribbble acf_field_name-dribbble acf_field_name-dribbble',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
					),
					array(
						'key'               => 'field_d82baa78d5c311e8a8036f6e6c696e65',
						'label'             => esc_html__( 'Vimeo', 'cardealer-helper' ),
						'name'              => 'vimeo',
						'type'              => 'url',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-vimeo acf_field_name-vimeo acf_field_name-vimeo',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
					),
					array(
						'key'               => 'field_d82bab22d5c311e88b8b6f6e6c696e65',
						'label'             => esc_html__( 'Pinterest', 'cardealer-helper' ),
						'name'              => 'pinterest',
						'type'              => 'url',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-pinterest acf_field_name-pinterest acf_field_name-pinterest',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
					),
					array(
						'key'               => 'field_575eacf32499a',
						'label'             => esc_html__( 'Behance', 'cardealer-helper' ),
						'name'              => 'behance',
						'type'              => 'url',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-behance acf_field_name-behance acf_field_name-behance',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
					),
					array(
						'key'               => 'field_d82bac58d5c311e89e006f6e6c696e65',
						'label'             => esc_html__( 'Linkedin', 'cardealer-helper' ),
						'name'              => 'linkedin',
						'type'              => 'url',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-linkedin acf_field_name-linkedin acf_field_name-linkedin',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
					),
					array(
						'key'               => 'field_38ef2b58d5c611e8a7d06f6e6c696e65',
						'label'             => esc_html__( 'Skills', 'cardealer-helper' ),
						'name'              => '',
						'type'              => 'tab',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-',
							'id'    => '',
						),
						'placement'         => 'top',
						'endpoint'          => 0,
					),
					array(
						'key'               => 'field_38ef2de2d5c611e882746f6e6c696e65',
						'label'             => esc_html__( 'Skills Title', 'cardealer-helper' ),
						'name'              => 'skills_title',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-skills_title',
							'id'    => '',
						),
						'default_value'     => esc_html__( 'Powerful Skills', 'cardealer-helper' ),
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
					),
					array(
						'key'               => 'field_38ef2e8cd5c611e89c4d6f6e6c696e65',
						'label'             => esc_html__( 'Skills', 'cardealer-helper' ),
						'name'              => 'skills',
						'type'              => 'repeater',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-skills',
							'id'    => '',
						),
						'collapsed'         => 'field_38ef2f22d5c611e890066f6e6c696e65',
						'min'               => 0,
						'max'               => 0,
						'layout'            => 'table',
						'button_label'      => esc_html__( 'Add Skill', 'cardealer-helper' ),
						'sub_fields'        => array(
							array(
								'key'               => 'field_38ef2f22d5c611e890066f6e6c696e65',
								'label'             => esc_html__( 'Skill', 'cardealer-helper' ),
								'name'              => 'skill',
								'type'              => 'text',
								'instructions'      => '',
								'required'          => 0,
								'conditional_logic' => 0,
								'wrapper'           => array(
									'width' => '',
									'class' => 'acf_field_name-skill',
									'id'    => '',
								),
								'default_value'     => '',
								'placeholder'       => '',
								'prepend'           => '',
								'append'            => '',
								'maxlength'         => '',
								'readonly'          => 0,
								'disabled'          => 0,
							),
							array(
								'key'               => 'field_38ef2fb8d5c611e8a7d76f6e6c696e65',
								'label'             => esc_html__( 'Percent', 'cardealer-helper' ),
								'name'              => 'percent',
								'type'              => 'number',
								'instructions'      => '',
								'required'          => 0,
								'conditional_logic' => 0,
								'wrapper'           => array(
									'width' => '',
									'class' => 'acf_field_name-percent',
									'id'    => '',
								),
								'default_value'     => '',
								'placeholder'       => '',
								'prepend'           => '',
								'append'            => '%',
								'min'               => 1,
								'max'               => 100,
								'step'              => 1,
								'readonly'          => 0,
								'disabled'          => 0,
							),
						),
					),
					array(
						'key'               => 'field_a2a440f189234021bd95c60a063bb0fc',
						'label'             => esc_html__( 'Expertise', 'cardealer-helper' ),
						'name'              => '',
						'type'              => 'tab',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-',
							'id'    => '',
						),
						'placement'         => 'top',
						'endpoint'          => 0,
					),
					array(
						'key'               => 'field_3c0823ed35a54db7e5a352812353f98c',
						'label'             => esc_html__( 'Expertise Title', 'cardealer-helper' ),
						'name'              => 'expertise_title',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-expertise_title',
							'id'    => '',
						),
						'default_value'     => esc_html__( 'Areas of Expertise', 'cardealer-helper' ),
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
					),
					array(
						'key'               => 'field_db5cbe72caee45c1ce108f45286d2b2f',
						'label'             => esc_html__( 'Expertises', 'cardealer-helper' ),
						'name'              => 'expertises',
						'type'              => 'repeater',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-expertises',
							'id'    => '',
						),
						'collapsed'         => 'field_38ef2f22d5c611e890066f6e6c696e65',
						'min'               => 0,
						'max'               => 0,
						'layout'            => 'table',
						'button_label'      => esc_html__( 'Add Expertise', 'cardealer-helper' ),
						'sub_fields'        => array(
							array(
								'key'               => 'field_4e1396b9c0134be4e80b236c3df6dbfb',
								'label'             => esc_html__( 'Expertise', 'cardealer-helper' ),
								'name'              => 'expertise',
								'type'              => 'text',
								'instructions'      => '',
								'required'          => 0,
								'conditional_logic' => 0,
								'wrapper'           => array(
									'width' => '',
									'class' => 'acf_field_name-expertise',
									'id'    => '',
								),
								'default_value'     => '',
								'placeholder'       => '',
								'prepend'           => '',
								'append'            => '',
								'maxlength'         => '',
							),
						),
					),
				),
				'location'              => array(
					array(
						array(
							'param'    => 'post_type',
							'operator' => '==',
							'value'    => 'teams',
						),
					),
				),
				'menu_order'            => 0,
				'position'              => 'normal',
				'style'                 => 'default',
				'label_placement'       => 'top',
				'instruction_placement' => 'label',
				'hide_on_screen'        => '',
				'active'                => 1,
				'description'           => '',
				'menu_item_level'       => 'all',
				'modified'              => 1475219820,
			)
		)
	);

endif;
