<?php
/**
 * Car Usemeta social profiles
 *
 * @author  TeamWP @Potenza Global Solutions
 * @package car-dealer-helper
 */

if ( function_exists( 'acf_add_local_field_group' ) ) :

	/**
	 * Filters the arguments of social profiles field group.
	 *
	 * @since 1.0
	 * @param array   $args     Array arguments of social profiles field group.
	 * @visible       true
	 */
	$cardealer_acf_usermeta_social_profiles = apply_filters(
		'cardealer_acf_usermeta_social_profiles',
		array(
			'key'                   => 'group_57566c039a64d',
			'title'                 => esc_html__( 'User Meta - Social Profiles', 'cardealer-helper' ),
			'fields'                => array(),
			'location'              => array(
				array(
					array(
						'param'    => 'user_form',
						'operator' => '==',
						'value'    => 'edit',
					),
				),
			),
			'menu_order'            => 0,
			'position'              => 'normal',
			'style'                 => 'default',
			'label_placement'       => 'top',
			'instruction_placement' => 'label',
			'hide_on_screen'        => '',
			'active'                => 1,
			'description'           => '',
			'modified'              => 1465282896,
		)
	);

	if ( ! empty( $cardealer_acf_usermeta_social_profiles['fields'] ) ) {
		acf_add_local_field_group( $cardealer_acf_usermeta_social_profiles );
	}

endif;
