<?php
/**
 * Elementor Vehicle Gallery class.
 *
 * @package cardealer-helper/elementor
 * @since   5.0.0
 */

namespace Cdhl_Elementor\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

use Cdhl_Elementor\Widget_Controller\Widget_Controller;
use Cdhl_Elementor\Group_Controls;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor banner widget.
 *
 * Elementor widget that displays an banner.
 *
 * @since 5.0.0
 */
class Vehicle_Gallery extends Widget_Controller {

	/**
	 * Widget slug
	 *
	 * @var string
	 */
	protected $widget_slug = 'vehicle-gallery';

	/**
	 * Widget icon
	 *
	 * @var string
	 */
	protected $widget_icon = 'cdhl-widget-icon';

	/**
	 * Widget keywords
	 *
	 * @var array
	 */
	protected $keywords = array( 'cars', 'vehicle', 'detail', 'single', 'gallery' );

	/**
	 * Retrieve the widget title.
	 *
	 * @since 5.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Vehicle Gallery', 'cardealer-helper' );
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 5.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( CDHL_ELEMENTOR_VEHIVLE_SINGLE_CAT );
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 5.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'section_content_general',
			array(
				'label' => esc_html__( 'General', 'cardealer-helper' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'video_button',
			array(
				'label'        => esc_html__( 'Display Video Button', 'cardealer-helper' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'description'  => esc_html__( 'Check the checkbox to add video button.', 'cardealer-helper' ),
				'label_on'     => esc_html__( 'Show', 'cardealer-helper' ),
				'label_off'    => esc_html__( 'Hide', 'cardealer-helper' ),
				'return_value' => 'yes',
				'default'      => '',
			)
		);

		$this->add_control(
			'no_margin',
			array(
				'label'        => esc_html__( 'No Margin', 'cardealer-helper' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'description'  => esc_html__( 'Check the checkbox to remove margin between the images.', 'cardealer-helper' ),
				'label_on'     => esc_html__( 'Show', 'cardealer-helper' ),
				'label_off'    => esc_html__( 'Hide', 'cardealer-helper' ),
				'return_value' => 'yes',
				'default'      => '',
			)
		);

		$this->add_control(
			'sold_badge',
			array(
				'label'        => esc_html__( 'Display Sold Badge', 'cardealer-helper' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'description'  => esc_html__( 'Check the checkbox to add sold badge.', 'cardealer-helper' ),
				'label_on'     => esc_html__( 'Show', 'cardealer-helper' ),
				'label_off'    => esc_html__( 'Hide', 'cardealer-helper' ),
				'return_value' => 'yes',
				'default'      => '',
			)
		);

		$this->add_control(
			'image_size',
			array(
				'label'   => esc_html__( 'Image Size', 'cardealer-helper' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'description' => wp_kses(
					sprintf(
						__( 'To know more about image size and add your custom image size, please refer to <a href="%s" target="_blank" rel="noopener">this document</a>.', 'cardealer-helper' ),
						'https://developer.wordpress.org/reference/functions/add_image_size/'
					),
					array(
						'a' => array(
							'href'   => true,
							'target' => true,
							'rel'    => true,
						),
					)
				),
				'options' => cardealer_get_all_registered_image_size_array(),
				'default' => 'car_single_slider',
			)
		);

		$this->end_controls_section();
	}
}
