<?php // phpcs:ignore WordPress.Files.FileName.NotHyphenatedLowercase
/**
 * CarDealer Vehicle Attribute Shortcode
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package car-dealer-helper/functions
 */

add_shortcode( 'cd_vehicle_attribute', 'cdhl_shortcode_vehicle_attribute' );

/**
 * Shortcode HTML.
 *
 * @param array $atts .
 * @param array $content .
 */
function cdhl_shortcode_vehicle_attribute( $atts, $content ) {
	$atts = shortcode_atts(
		array(
			'element_id'     => uniqid( 'cd_vehicle_attribute' ),
			'attribute_slug' => '',
			'fallback_text'  => '',
			'html_tag'       => 'h2',
			'transform'      => 'capitalize',
			'css'            => '',
		),
		$atts
	);

	global $post, $wp_taxonomies;

	$post_id = get_the_ID();
	$value   = '';

	if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
		?>
		<div class="alert alert-danger" role="alert" style="margin: 0;">
			<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
			<p><?php esc_html_e( 'This shortcode will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
		</div>
		<?php
		return;
	}

	if ( empty( $atts['attribute_slug'] ) ) {
		return null;
	}

	if ( ! isset( $wp_taxonomies[ $atts['attribute_slug'] ] ) ) {
		return null;
	}

	if ( ! in_array( 'cars', $wp_taxonomies[ $atts['attribute_slug'] ]->object_type, true ) ) {
		return null;
	}

	if ( CDHL_CPT_Template::CPT === $post->post_type && class_exists( 'CDHL_CPT_Template' ) ) {
		$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
	}

	$terms = wp_get_post_terms( $post_id, $atts['attribute_slug'] );

	if ( ! is_wp_error( $terms ) && ! empty( $terms ) ) {
		$value = $terms[0]->name;
	}

	if ( empty( $value ) ) {
		$value = $atts['fallback_text'];
	}

	$wrapper_class = 'cd-vehicle-attribute' . vc_shortcode_custom_css_class( $atts['css'], ' ' );
	$wrapper_class .= ' text-transform-' . $atts['transform'];

	ob_start();
	?>
	<div id="<?php echo esc_attr( $atts['element_id'] ); ?>" class="<?php echo esc_attr( $wrapper_class ); ?>">
		<<?php echo esc_attr( $atts['html_tag'] ); ?> class="vehicle-attribute"><?php echo wp_kses_post( $value ); ?></<?php echo esc_attr( $atts['html_tag'] ); ?>>
	</div>
	<?php
	return ob_get_clean();
}

/**
 * Shortcode mapping.
 *
 * @return void
 */
function cdhl_vehicle_attribute_shortcode_vc_map() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map(
			array(
				'name'                    => esc_html__( 'Vehicle Attribute', 'cardealer-helper' ),
				'description'             => esc_html__( 'Display single vehicle attribute.', 'cardealer-helper' ),
				'base'                    => 'cd_vehicle_attribute',
				'class'                   => '_helper_element_wrapper',
				'controls'                => 'full',
				'icon'                    => cardealer_vc_shortcode_icon( 'cd_vehicle_attribute' ),
				'category'                => esc_html__( 'Potenza Vehicle Detail', 'cardealer-helper' ),
				'show_settings_on_create' => true,
				'params'                  => array(
					array(
						'param_name'  => 'attribute_slug',
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Taxonomy Key', 'cardealer-helper' ),
						'description' => esc_html__( 'To find the taxonomy key go to Admin Panel > Vehicle Inventory > Add/Edit Attributes and get taxonomy key for the desired attribute.', 'cardealer-helper' )
							. "\r\n" . esc_html__( 'Important Note: The taxonomy key for "Feature & Option" is not allowed.', 'cardealer-helper' ),
					),
					array(
						'param_name'  => 'fallback_text',
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Fallback Text', 'cardealer-helper' ),
						'description' => esc_html__( 'Enter fallback text to show if the value is empty.', 'cardealer-helper' ),
						'value'       => 'N/A',
						'class'       => '',
					),
					array(
						'param_name'  => 'html_tag',
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'HTML Tag', 'cardealer-helper' ),
						'description' => esc_html__( 'HTML tag to be used to wrap the value between.', 'cardealer-helper' ),
						'value'       => array(
							'h1'  => 'h1',
							'h2'  => 'h2',
							'h3'  => 'h3',
							'h4'  => 'h4',
							'h5'  => 'h5',
							'h6'  => 'h6',
							'div' => 'div',
							'span'=> 'span',
							'p'   => 'p',
						),
						'save_always' => true,
					),
					array(
						'param_name'  => 'transform',
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Text Transform', 'cardealer-helper' ),
						'value'       => array(
							esc_html__( 'Capitalize', 'cardealer-helper' ) => 'capitalize',
							esc_html__( 'Uppercase', 'cardealer-helper' )  => 'uppercase',
							esc_html__( 'Lowercase', 'cardealer-helper' )  => 'lowercase',
						),
						'std'         => 'capitalize',
					),
					array(
						'type'       => 'css_editor',
						'heading'    => esc_html__( 'CSS box', 'cardealer-helper' ),
						'param_name' => 'css',
						'group'      => esc_html__( 'Design Options', 'cardealer-helper' ),
					),
				),
			)
		);
	}
}
add_action( 'vc_before_init', 'cdhl_vehicle_attribute_shortcode_vc_map' );
