<?php // phpcs:ignore WordPress.Files.FileName.NotHyphenatedLowercase
/**
 * CarDealer Vehicle Meta Shortcode
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package car-dealer-helper/functions
 */

add_shortcode( 'cd_vehicle_meta', 'cdhl_shortcode_vehicle_meta' );

/**
 * Shortcode HTML.
 *
 * @param array $atts .
 * @param array $content .
 */
function cdhl_shortcode_vehicle_meta( $atts, $content ) {
	$atts = shortcode_atts(
		array(
			'element_id'            => uniqid( 'cd_vehicle_meta' ),
			'vehicle_meta'          => '',
			'vehicle_meta_fallback' => 'N/A',
			'vehicle_meta_tag'      => 'h2',
			'transform'             => 'capitalize',
			'css'                   => '',
		),
		$atts
	);

	extract( $atts );

	if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
		?>
		<div class="alert alert-danger" role="alert" style="margin: 0;">
			<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
			<p><?php esc_html_e( 'This shortcode will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
		</div>
		<?php
		return;
	}

	if ( empty( $atts['vehicle_meta'] ) ) {
		return null;
	}

	if ( class_exists( 'CDHL_CPT_Template' ) ) {
		$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
	} else {
		$post_id = get_the_ID();
	}

	$wrapper_class = 'cd-vehicle-meta' . vc_shortcode_custom_css_class( $atts['css'], ' ' );
	$wrapper_class .= ' text-transform-' . $atts['transform'];

	$vehicle_meta_value = get_post_meta( $post_id, sanitize_key( $atts['vehicle_meta'] ), true );
	if ( ! $vehicle_meta_value ) {
		$vehicle_meta_value = $atts['vehicle_meta_fallback'];
	}
	ob_start();
	?>
	<div id="<?php echo esc_attr( $atts['element_id'] ); ?>" class="<?php echo esc_attr( $wrapper_class ); ?>">
		<<?php echo esc_attr( $atts['vehicle_meta_tag'] ); ?> class="vehicle-meta">
			<?php echo wp_kses_post( $vehicle_meta_value ); ?>
		</<?php echo esc_attr( $atts['vehicle_meta_tag'] ); ?>>
	</div>
	<?php
	return ob_get_clean();
}

/**
 * Shortcode mapping.
 *
 * @return void
 */
function cdhl_vehicle_meta_shortcode_vc_map() {
	if ( function_exists( 'vc_map' ) ) {
		vc_map(
			array(
				'name'                    => esc_html__( 'Vehicle Meta', 'cardealer-helper' ),
				'description'             => esc_html__( 'Vehicle Meta', 'cardealer-helper' ),
				'base'                    => 'cd_vehicle_meta',
				'class'                   => '_helper_element_wrapper',
				'controls'                => 'full',
				'icon'                    => cardealer_vc_shortcode_icon( 'cd_vehicle_meta' ),
				'category'                => esc_html__( 'Potenza Vehicle Detail', 'cardealer-helper' ),
				'show_settings_on_create' => true,
				'params'                  => array(
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Vehicle Meta Key', 'cardealer-helper' ),
						'description' => esc_html__( 'Enter meta key.', 'cardealer-helper' ),
						'param_name'  => 'vehicle_meta',
					),
					array(
						'type'        => 'textfield',
						'class'       => '',
						'heading'     => esc_html__( 'Fallback text', 'cardealer-helper' ),
						'description' => esc_html__( 'Enter fallback text if value is empty.', 'cardealer-helper' ),
						'value'       => 'N/A',
						'param_name'  => 'vehicle_meta_fallback',
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Meta Tag', 'cardealer-helper' ),
						'description' => esc_html__( 'Tag to be used for section title display.', 'cardealer-helper' ),
						'param_name'  => 'vehicle_meta_tag',
						'value'       => array(
							'h2'  => 'h2',
							'h3'  => 'h3',
							'h4'  => 'h4',
							'h5'  => 'h5',
							'h6'  => 'h6',
							'p'   => 'p',
							'div' => 'div',
						),
						'save_always' => true,
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Text transform', 'cardealer-helper' ),
						'value'       => array(
							esc_html__( 'Capitalize', 'cardealer-helper' ) => 'capitalize',
							esc_html__( 'Uppercase', 'cardealer-helper' )  => 'uppercase',
							esc_html__( 'Lowercase', 'cardealer-helper' )  => 'lowercase',
						),
						'std'         => 'capitalize',
						'param_name'  => 'transform',
					),
					array(
						'type'       => 'css_editor',
						'heading'    => esc_html__( 'CSS box', 'cardealer-helper' ),
						'param_name' => 'css',
						'group'      => esc_html__( 'Design Options', 'cardealer-helper' ),
					),
				),
			)
		);
	}
}
add_action( 'vc_before_init', 'cdhl_vehicle_meta_shortcode_vc_map' );
