<?php
/**
 * CarDealer Vehicle Wishlist Button Shortcode
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package car-dealer-helper
 */

add_shortcode( 'cd_vehicle_seller_email', 'cdhl_vehicle_seller_email_shortcode' );

/**
 * Shortcode HTML.
 *
 * @param array $atts .
 */
function cdhl_vehicle_seller_email_shortcode( $atts ) {
	$atts = shortcode_atts(
		array(
			'element_id'           => uniqid( 'cd-vehicle-seller-email-' ),
			'title'                => esc_html__( 'Send Mail', 'cardealer-helper' ),
			'css'                  => '',
		),
		$atts
	);

	if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
		?>
		<div class="alert alert-danger" role="alert" style="margin: 0;">
			<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
			<p><?php esc_html_e( 'This shortcode will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
		</div>
		<?php
		return;
	}

	if ( class_exists( 'CDHL_CPT_Template' ) ) {
		$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
	} else {
		$post_id = get_the_ID();
	}

	$post_author_id = get_post_field( 'post_author', $post_id );

	if ( ! filter_var( get_the_author_meta( 'cdfs_show_email', $post_author_id ), FILTER_VALIDATE_BOOLEAN ) )  {
		return;
	}

	$seller_email = cdfs_get_user_email( $post_author_id );

	if ( ! $seller_email ) {
		return;
	}

	$title     = ( isset( $atts['title'] ) && ! empty( $atts['title'] ) ) ? $atts['title'] : esc_html__( 'Send Mail', 'cardealer-helper' );
	$email_url = "mailto:{$seller_email}";

	$wrapper_class = array(
		'cd-vehicle-seller-email-btn',
		'cd-vehicle-seller-email-btn-style-default',
		vc_shortcode_custom_css_class( $atts['css'], ' ' )
	);
	ob_start();
	?>
	<div id="<?php echo esc_attr( $atts['element_id'] ); ?>" class="<?php cdhl_class_builder( $wrapper_class ); ?>">
		<?php
		echo sprintf(
			'<a class="%s" title="%s" href="%s" target="_blank" rel="noopener"><i class="far fa-envelope"></i> %s</a>',
			'cd-vehicle-seller-email-link',
			esc_attr( $title ),
			esc_attr( $email_url ),
			esc_html( $title )
		);
		?>
	</div>
	<?php
	return ob_get_clean();
}

/**
 * Shortcode mapping.
 *
 * @return void
 */
function cdhl_vehicle_seller_email_shortcode_vc_map() {
	if ( function_exists( 'vc_map' ) ) {
		$params = array(
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Title', 'cardealer-helper' ),
				'description' => esc_html__( 'Enter button title here.', 'cardealer-helper' ),
				'param_name'  => 'title',
				'value'       => esc_html__( 'Send Mail', 'cardealer-helper' ),
				'save_always' => true,
				'admin_label' => true,
			),
			array(
				'type'       => 'css_editor',
				'heading'    => esc_html__( 'CSS box', 'cardealer-helper' ),
				'param_name' => 'css',
				'group'      => esc_html__( 'Design Options', 'cardealer-helper' ),
			),
		);

		vc_map(
			array(
				'name'                    => esc_html__( 'Vehicle Seller Email', 'cardealer-helper' ),
				'description'             => '',
				'base'                    => 'cd_vehicle_seller_email',
				'class'                   => 'cardealer_helper_element_wrapper',
				'controls'                => 'full',
				'icon'                    => cardealer_vc_shortcode_icon( 'cd_vehicle_seller_email' ),
				'category'                => esc_html__( 'Potenza Vehicle Detail', 'cardealer-helper' ),
				'show_settings_on_create' => true,
				'params'                  => $params,
			)
		);
	}
}
add_action( 'vc_before_init', 'cdhl_vehicle_seller_email_shortcode_vc_map' );
