<?php
/**
 * CarDealer Vehicle Wishlist Button Shortcode
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package car-dealer-helper
 */

add_shortcode( 'cd_vehicle_seller_info', 'cdhl_vehicle_seller_info_shortcode' );

/**
 * Shortcode HTML.
 *
 * @param array $atts .
 */
function cdhl_vehicle_seller_info_shortcode( $atts ) {
	$atts = shortcode_atts(
		array(
			'element_id'   => uniqid( 'cd-vehicle-seller-info-' ),
			'show_title'   => '',
			'dealer_title' => esc_html__( 'Dealer Details', 'cardealer-helper' ),
			'user_title'   => esc_html__( 'User Details', 'cardealer-helper' ),
			'show_phone'   => 'yes',
			'css'          => '',
		),
		$atts
	);

	if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
		?>
		<div class="alert alert-danger" role="alert" style="margin: 0;">
			<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
			<p><?php esc_html_e( 'This shortcode will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
		</div>
		<?php
		return;
	}

	if ( class_exists( 'CDHL_CPT_Template' ) ) {
		$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
	} else {
		$post_id = get_the_ID();
	}

	$show_title   = filter_var( $atts['show_title'], FILTER_VALIDATE_BOOLEAN );
	$show_phone   = filter_var( $atts['show_phone'], FILTER_VALIDATE_BOOLEAN );

	$seller_info_args = array(
		'wrapper_id'    => $atts['element_id'],
		'wrapper_class' => array(
			'cd-vehicle-seller-info',
			'cd-vehicle-seller-info-style-default',
			vc_shortcode_custom_css_class( $atts['css'], ' ' ),
		),
		'post_id'       => $post_id,
		'show_title'    => $show_title,
		'show_phone'    => $show_phone,
		'dealer_title'  => $atts['dealer_title'],
		'user_title'    => $atts['user_title'],
	);
	ob_start();
	cdhl_vehicle_seller_info_html( $seller_info_args );
	return ob_get_clean();
}

/**
 * Shortcode mapping.
 *
 * @return void
 */
function cdhl_vehicle_seller_info_shortcode_vc_map() {
	if ( function_exists( 'vc_map' ) ) {
		$params = array(
			array(
				'param_name'  => 'show_title',
				'type'        => 'checkbox',
				'heading'     => esc_html__( 'Show Title', 'cardealer-helper' ),
				'value'       => array(
					esc_html__( 'Yes', 'cardealer-helper' ) => 'yes',
				),
				'std'         => '',
				'save_always' => true,
			),
			array(
				'param_name'  => 'dealer_title',
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Dealer Title', 'cardealer-helper' ),
				'description' => esc_html__( 'Enter the title to display the above seller information for users with the "Car Dealer" role.', 'cardealer-helper' ),
				'value'       => esc_html__( 'Dealer Details', 'cardealer-helper' ),
				'save_always' => true,
				'dependency'  => array(
					'element'   => 'show_title',
					'not_empty' => true,
				),
			),
			array(
				'param_name'  => 'user_title',
				'type'        => 'textfield',
				'heading'     => esc_html__( 'User Title', 'cardealer-helper' ),
				'description' => esc_html__( 'Enter the title to display the above seller information for users other than the "Car Dealer" role.', 'cardealer-helper' ),
				'value'       => esc_html__( 'User Details', 'cardealer-helper' ),
				'save_always' => true,
				'dependency'  => array(
					'element'   => 'show_title',
					'not_empty' => true,
				),
			),
			array(
				'param_name'  => 'show_phone',
				'type'        => 'checkbox',
				'heading'     => esc_html__( 'Show Phone', 'cardealer-helper' ),
				'value'       => array(
					esc_html__( 'Yes', 'cardealer-helper' ) => 'yes',
				),
				'std'         => 'yes',
				'save_always' => true,
			),
			array(
				'type'       => 'css_editor',
				'heading'    => esc_html__( 'CSS box', 'cardealer-helper' ),
				'param_name' => 'css',
				'group'      => esc_html__( 'Design Options', 'cardealer-helper' ),
			),
		);

		vc_map(
			array(
				'name'                    => esc_html__( 'Vehicle Seller Info', 'cardealer-helper' ),
				'description'             => '',
				'base'                    => 'cd_vehicle_seller_info',
				'class'                   => 'cardealer_helper_element_wrapper',
				'controls'                => 'full',
				'icon'                    => cardealer_vc_shortcode_icon( 'cd_vehicle_seller_info' ),
				'category'                => esc_html__( 'Potenza Vehicle Detail', 'cardealer-helper' ),
				'show_settings_on_create' => true,
				'params'                  => $params,
			)
		);
	}
}
add_action( 'vc_before_init', 'cdhl_vehicle_seller_info_shortcode_vc_map' );
