<?php
/**
 * CarDealer Vehicle Share Button Shortcode
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package car-dealer-helper
 */

add_shortcode( 'cd_vehicle_share', 'cdhl_vehicle_share_shortcode' );

/**
 * Shortcode HTML.
 *
 * @param array $atts .
 */
function cdhl_vehicle_share_shortcode( $atts ) {
	global $car_dealer_options;

	$atts = shortcode_atts(
		array(
			'element_id'          => uniqid( 'cd_share_button' ),
			'tax_label_alignment' => 'left',
			'title'               => esc_html__( 'Share', 'cardealer-helper' ),
			'share_type'          => 'default',
			'css'                 => '',
		),
		$atts
	);

	if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
		?>
		<div class="alert alert-danger" role="alert" style="margin: 0;">
			<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
			<p><?php esc_html_e( 'This shortcode will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
		</div>
		<?php
		return;
	}

	if ( class_exists( 'CDHL_CPT_Template' ) ) {
		$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
	} else {
		$post_id = get_the_ID();
	}

	$wrapper_class = 'cd-share-button ' . $atts['share_type'] . vc_shortcode_custom_css_class( $atts['css'], ' ' );
	$wrapper_class .= ' text-' . $atts['tax_label_alignment'];
	ob_start();
	?>
	<div id="<?php echo esc_attr( $atts['element_id'] ); ?>" class="<?php echo esc_attr( $wrapper_class ); ?>">
		<?php
		$facebook_share  = isset( $car_dealer_options['facebook_share'] ) ? $car_dealer_options['facebook_share'] : '';
		$twitter_share   = isset( $car_dealer_options['twitter_share'] ) ? $car_dealer_options['twitter_share'] : '';
		$linkedin_share  = isset( $car_dealer_options['linkedin_share'] ) ? $car_dealer_options['linkedin_share'] : '';
		$pinterest_share = isset( $car_dealer_options['pinterest_share'] ) ? $car_dealer_options['pinterest_share'] : '';
		$whatsapp_share  = isset( $car_dealer_options['whatsapp_share'] ) ? $car_dealer_options['whatsapp_share'] : '';

		if ( $facebook_share || $twitter_share || $linkedin_share || $pinterest_share || $whatsapp_share ) {
			?>
			<div class="details-social details-weight share">
				<?php
				if ( $atts['title'] ) {
					?>
					<h6 class="uppercase"><?php echo esc_html( $atts['title'] ); ?></h6>
					<?php
				}
				?>
				<ul class="single-share-box mk-box-to-trigger">
					<?php
					if ( $facebook_share ) {
						?>
						<li>
							<a href="#" data-title="<?php echo esc_attr( get_the_title( $post_id ) ); ?>" data-url="<?php echo esc_url( get_permalink( $post_id ) ); ?>" class="facebook-share"><i class="fab fa-facebook-f"></i></a>
						</li>
						<?php
					}
					if ( $twitter_share ) {
						?>
						<li>
							<a href="#"  data-title="<?php echo esc_attr( get_the_title( $post_id ) ); ?>" data-url="<?php echo esc_url( get_permalink( $post_id ) ); ?>" class="twitter-share"><i class="fab fa-twitter"></i></a>
						</li>
						<?php
					}
					if ( $linkedin_share ) {
						?>
						<li>
							<a href="#" data-title="<?php echo esc_attr( get_the_title( $post_id ) ); ?>" data-url="<?php echo esc_url( get_permalink( $post_id ) ); ?>" class="linkedin-share"><i class="fab fa-linkedin-in"></i></a>
						</li>
						<?php
					}
					if ( $pinterest_share ) {
						?>
						<li>
							<a href="#" data-title="<?php echo esc_attr( get_the_title( $post_id ) ); ?>" data-url="<?php echo esc_url( get_permalink( $post_id ) ); ?>" data-image="<?php echo esc_url( cardealer_get_single_image_url( 'car_catalog_image', $post_id ) ); ?>" class="pinterest-share"><i class="fab fa-pinterest"></i></a>
						</li>
						<?php
					}
					if ( $whatsapp_share ) {
						?>
						<li><a href="#" data-url="<?php echo esc_url( get_permalink( $post_id ) ); ?>" class="whatsapp-share"><i class="fab fa-whatsapp"></i></a></li>
						<?php
					}
					?>
				</ul>
			</div><!--.share-->
			<?php
		}
		?>
	</div>
	<?php
	return ob_get_clean();
}

/**
 * Shortcode mapping.
 *
 * @return void
 */
function cdhl_vehicle_share_shortcode_vc_map() {
	if ( function_exists( 'vc_map' ) ) {
		$params = array(
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Share Button Type', 'cardealer-helper' ),
				'param_name'  => 'share_type',
				'value'       => array_flip( array(
					'default' => esc_html__( 'Default', 'cardealer-helper' ),
					'rounded' => esc_html__( 'Rounded', 'cardealer-helper' ),
				) ),
				'std'     => 'default',
				'save_always' => true,
				'description' => esc_html__( 'Select button type.', 'cardealer-helper' ),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Title', 'cardealer-helper' ),
				'description' => esc_html__( 'Enter title here', 'cardealer-helper' ),
				'param_name'  => 'title',
				'value'       => esc_html__( 'Share', 'cardealer-helper' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Alignment', 'cardealer-helper' ),
				'param_name'  => 'tax_label_alignment',
				'value'       => array_flip( array(
					'left'  => esc_html__( 'Left', 'cardealer-helper' ),
					'right' => esc_html__( 'Right', 'cardealer-helper' ),
				) ),
				'std'         => 'left',
				'save_always' => true,
				'description' => esc_html__( 'Select alignment.', 'cardealer-helper' ),
			),
			array(
				'type'       => 'css_editor',
				'heading'    => esc_html__( 'CSS box', 'cardealer-helper' ),
				'param_name' => 'css',
				'group'      => esc_html__( 'Design Options', 'cardealer-helper' ),
			),
		);

		vc_map(
			array(
				'name'                    => esc_html__( 'Vehicle Share', 'cardealer-helper' ),
				'description'             => esc_html__( 'Vehicle Share Button', 'cardealer-helper' ),
				'base'                    => 'cd_vehicle_share',
				'class'                   => 'cardealer_helper_element_wrapper',
				'controls'                => 'full',
				'icon'                    => cardealer_vc_shortcode_icon( 'cd_vehicle_share' ),
				'category'                => esc_html__( 'Potenza Vehicle Detail', 'cardealer-helper' ),
				'show_settings_on_create' => true,
				'params'                  => $params,
			)
		);
	}
}
add_action( 'vc_before_init', 'cdhl_vehicle_share_shortcode_vc_map' );
