<?php
/**
 * Adds Vehicle Make Widget.
 *
 * @package car-dealer-helper/widgets
 * @version 1.9.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * CDHL_Widget_Vehicle_Make_Logos class.
 *
 * @extends CDHL_Widget
 */
class CDFS_Widget_Vehicle_Seller_Email extends CDHL_Widget {

	/**
	 * Register widget with WordPress.
	 */
	public function __construct() {
		$this->widget_id          = 'vehicle-seller-email';
		$this->widget_name        = esc_html__( 'CDFS - Vehicle Seller Email', 'cardealer-helper' );
		$this->widget_description = esc_html__( 'Display vehicle seller email button.', 'cardealer-helper' );
		$this->widget_cssclass    = 'widget-cdfs-vehicle-seller-email';
		$this->settings           = array(
			'widget_notice' => array(
				'type'        => 'notice',
				'notice_type' => 'info',
				'label'       => esc_html__( 'Widget Notice', 'cardealer-helper' ),
				'message'     => esc_html__( 'This widget will display only on the vehicle details post (post type: cars).', 'cardealer-helper' ),
			),
			'button_title'      => array(
				'type'  => 'text',
				'label' => esc_html__( 'Button Title', 'cardealer-helper' ),
				'std'   => esc_html__( 'Send Mail', 'cardealer-helper' ),
				'desc'  => esc_html__( 'Enter email button title.', 'cardealer-helper' ),
			),
		);

		parent::__construct();
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {

		if ( ! is_singular( 'cars' ) ) {
			return;
		}

		$post_id = get_the_ID();
		$post_author_id = get_post_field( 'post_author', $post_id );

		if ( ! filter_var( get_the_author_meta( 'cdfs_show_email', $post_author_id ), FILTER_VALIDATE_BOOLEAN ) )  {
			return;
		}

		$seller_email = cdfs_get_user_email( $post_author_id );

		if ( ! $seller_email ) {
			return;
		}

		$title     = ( isset( $instance['button_title'] ) && ! empty( $instance['button_title'] ) ) ? $instance['button_title'] : esc_html__( 'Send Mail', 'cardealer-helper' );
		$email_url = "mailto:{$seller_email}";

		$wrapper_class = array(
			'cd-vehicle-seller-email-btn',
			'cd-vehicle-seller-email-btn-style-default',
		);
		echo $args['before_widget']; // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotE
		?>
		<div id="<?php echo esc_attr( uniqid( 'cd-vehicle-seller-email-' ) ); ?>" class="<?php cdhl_class_builder( $wrapper_class ); ?>">
			<?php
			echo sprintf(
				'<a class="%s" title="%s" href="%s" target="_blank" rel="noopener"><i class="far fa-envelope"></i> %s</a>',
				'cd-vehicle-seller-email-link',
				esc_attr( $title ),
				esc_attr( $email_url ),
				esc_html( $title )
			);
			?>
		</div>
		<?php
		echo $args['after_widget']; // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotE
	}
}
