<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\AuditingTrait;

class AccountUser extends Model {

    /**
     * The database table used by the model.
     * @var string
     */
    use AuditingTrait;
    protected $auditEnabled = true;
    protected $table = 'account_user';
    protected $primaryKey = 'account_id';
    protected $fillable = ['account_id', 'user_id','is_allowed'];
    public $timestamps = false;

    /*
      |--------------------------------------------------------------------------
      | Relationship Methods
      |--------------------------------------------------------------------------
     */

    /**
     * many-to-many relationship method.
     *
     * @return QueryBuilder
     */
    public function users() {
        return $this->belongsToMany('\App\User', 'account_user', 'account_id', 'user_id');
    }

  


}
