<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\AuditingTrait;

class Ads extends Model {

    use AuditingTrait;

    protected $table = 'ads';
    protected $primaryKey = 'ad_id';
    protected $auditEnabled = true;
    public $timestamps = false;

    public function getCreatives() {
        return $this->belongsTo('\App\CreativeGroup', 'creative_ids');
    }

    public function campaign() {
        return $this->belongsTo('\App\Campaigns', 'campaign_id');
    }

    public function publishers() {
        return $this->belongsToMany('App\Publisher', 'ad_publisher', 'ad_id', 'publisher_id');
    }

}
