<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
//use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Http\Controllers\SessionController;
use Validator;
use Cache;
use Illuminate\Support\Facades\Session;
//use App\Account;
//use App\Advertiser;
use Auth;
//use Illuminate\Mail\Mailer;
use Illuminate\Support\Facades\Mail;

class AdvertiserController extends Controller {

    public function __construct() {
        $this->sessionObj = new SessionController();
        //echo "aaaaaa"
    }

    public function advertiserView(Request $request) {
        $validate = $this->sessionObj->validateUser();
        if ($validate['status'] == 'failed')
            return json_encode($validate);

        if (!empty($request->advertiser_id)) {
            $advertisersObj = $this->sessionObj->getUserAccountsAdvts();
            if (!array_key_exists($request->advertiser_id, $advertisersObj)) {
                return json_encode(array("status" => "failed"));
            }
            $advertiserInfo = \App\Advertiser::find($request->advertiser_id);
            if (!$advertiserInfo) {
                return json_encode(array("status" => "failed", 'msg' => 'advertiser not found'));
            }
        }

        //print_r($advertiserInfo->toArray());exit;
        $countries = json_decode($this->getCountries(), true);
        $countryArr = array_column($countries, 'name', 'iso3');
        return View("/advertiserview", ['advertiser_data' => $advertiserInfo->toArray(), 'countries' => $countryArr]);
    }

    public function updateAdvertiserBasicInfo(Request $request) {

        $validate = $this->sessionObj->validateUser();
        if ($validate['status'] == 'failed') {
            return json_encode(array('status' => 'failed', 'msg' => 'Update failed'));
        }
        if (!empty($request->advertiser_id)) {
            $advertiserObj = $this->sessionObj->getUserAccountsAdvts();
            if (!array_key_exists($request->advertiser_id, $advertiserObj)) {
                return json_encode(array('status' => 'success', 'msg' => 'Update failed'));
            }
            $advDetail = \App\Advertiser::find($request->advertiser_id);

            $validator = Validator::make(
                            array(
                        'first_name' => $request->first_name,
                        'last_name' => $request->last_name,
                        'email_address' => $request->email,
                        'contact_phone' => $request->contact_phone,
                            ), array(
                        'first_name' => 'required',
                        'last_name' => 'required',
                        'email_address' => 'required|email',
                        'contact_phone' => 'required|numeric',
                            )
            );

            if ($validator->fails()) {
                return redirect(config('app.local_url') . "admin/advinfo/" . $request->advertiser_id)->withErrors($validator)->with(array(
                            'basicupdatefailed' => true,
                            'first_name' => $request->first_name,
                            'last_name' => $request->last_name,
                            'email' => $request->email,
                            'contact_phone' => $request->contact_phone,
                            'contact_mobile' => $request->contact_mobile,
                            'contact_address' => $request->contact_address,
                            'country' => $request->country,
                            'contact_city' => $request->contact_city,
                            'pin_code' => $request->pin_code,
                            'domain' => $request->domain,
                            'status' => $request->status,
                            'payer_type' => $request->payer_type,
                        ))->withInput();
            }

            if ($advDetail) {
                $updated = array();
                $advertiser_info = $advDetail->contact_name . '[' . $advDetail->contact_email . ']';
                if ($advDetail->contact_name != $request->first_name) {
                    $updated['first_name']['old'] = $advDetail->contact_name;
                    $advDetail->contact_name = $request->first_name;
                    $updated['first_name']['new'] = $advDetail->contact_name;
                }

                if ($advDetail->last_name != $request->last_name) {
                    $updated['last_name']['old'] = $advDetail->last_name;
                    $advDetail->last_name = $request->last_name;
                    $updated['last_name']['new'] = $advDetail->last_name;
                }

                if ($advDetail->contact_email != $request->email) {
                    $updated['email']['old'] = $advDetail->contact_email;
                    $advDetail->contact_email = $request->email;
                    $updated['email']['new'] = $advDetail->contact_email;
                }

                if ($advDetail->contact_phone != $request->contact_phone) {
                    $updated['contact_phone']['old'] = $advDetail->contact_phone;
                    $advDetail->contact_phone = $request->contact_phone;
                    $updated['contact_phone']['new'] = $advDetail->contact_phone;
                }

                if ($advDetail->contact_mobile != $request->contact_mobile) {
                    $updated['contact_mobile']['old'] = $advDetail->contact_mobile;
                    $advDetail->contact_mobile = $request->contact_mobile;
                    $updated['contact_mobile']['new'] = $advDetail->contact_mobile;
                }

                if ($advDetail->contact_address != $request->address) {
                    $updated['contact_mobile']['old'] = $advDetail->contact_address;
                    $advDetail->contact_address = $request->address;
                    $updated['contact_mobile']['new'] = $advDetail->contact_address;
                }

                if ($advDetail->country != $request->country) {
                    $updated['country']['old'] = $advDetail->country;
                    $advDetail->country = $request->country;
                    $updated['country']['new'] = $advDetail->country;
                }
                if ($advDetail->state != $request->state) {
                    $updated['state']['old'] = $advDetail->state;
                    $advDetail->state = $request->state;
                    $updated['state']['new'] = $advDetail->state;
                }

                if ($advDetail->contact_city != $request->contact_city) {
                    $updated['city']['old'] = $advDetail->contact_city;
                    $advDetail->contact_city = $request->contact_city;
                    $updated['city']['new'] = $advDetail->contact_city;
                }

                if ($advDetail->contact_postal_code != $request->pin_code) {
                    $updated['pin_code']['old'] = $advDetail->contact_postal_code;
                    $advDetail->contact_postal_code = $request->pin_code;
                    $updated['pin_code']['new'] = $advDetail->contact_postal_code;
                }

                if ($advDetail->advertiser_domain != $request->domain) {
                    $updated['domain']['old'] = $advDetail->advertiser_domain;
                    $advDetail->advertiser_domain = $request->domain;
                    $updated['domain']['new'] = $advDetail->advertiser_domain;
                }

                if ($advDetail->status != $request->status) {
                    $updated['status']['old'] = $advDetail->status;
                    $advDetail->status = $request->status;
                    $updated['status']['new'] = $advDetail->status;
                }

                if ($advDetail->payer_type != $request->payer_type) {
                    $updated['payer_type']['old'] = $advDetail->payer_type;
                    $advDetail->payer_type = $request->payer_type;
                    $updated['payer_type']['new'] = $advDetail->payer_type;
                }

                $advDetail->save();
                $mail_message = "";
                if (count($updated)) {

                    Mail::send('advertiser_updated_info_mail', ['updated' => $updated, 'advertiser_name' => $advertiser_info], function($message) use($advertiser_info) {

                        $message->from(config('all.noreply_email'), 'Vola.ad')
                                ->to(config('all.admin_email'), 'Admin')
                                ->subject('Advertiser ' . $advertiser_info . ' basic info updated');
                    });
                }
                return redirect(config('app.local_url') . "admin/advinfo/" . $request->advertiser_id)->with("success_basic_updated", "Basic information updated successfully");
                //return json_encode(array('status' => 'success', 'msg' => 'Updated Successfully.'));
            }
        }
    }

    public function updateAdvertiserBillingInfo(Request $request) {
        $validate = $this->sessionObj->validateUser();
        if ($validate['status'] == 'failed') {
            return json_encode(array('status' => 'failed', 'msg' => 'Update failed'));
        }
        if (!empty($request->advertiser_id)) {
            $advertiserObj = $this->sessionObj->getUserAccountsAdvts();
            if (!array_key_exists($request->advertiser_id, $advertiserObj)) {
                return json_encode(array('status' => 'success', 'msg' => 'Update failed'));
            }
            $advDetail = \App\Advertiser::find($request->advertiser_id);

            $validator = Validator::make(
                            array(
                        'first_name' => $request->billing_first_name,
                        'last_name' => $request->billing_last_name,
                        'contact_mobile' => $request->billing_contact_mobile,
                        'address1' => $request->billing_address1,
                        'city' => $request->billing_city,
                        'state' => $request->billing_state,
                        'country' => $request->billing_country,
                        'pin_code' => $request->billing_pin_code,
                            ), array(
                        'first_name' => 'required',
                        'last_name' => 'required',
                        'contact_mobile' => 'required|numeric',
                        'address1' => 'required',
                        'city' => 'required',
                        'state' => 'required',
                        'country' => 'required',
                        'pin_code' => 'required',
                            )
            );

            if ($validator->fails()) {
                return redirect(config('app.local_url') . "admin/advinfo/" . $request->advertiser_id)->withErrors($validator)->with(
                                array('billingupdatefailed' => true,
                                    'billing_first_name' => $request->billing_first_name,
                                    'billing_last_name' => $request->billing_last_name,
                                    'billing_address1' => $request->billing_address1,
                                    'billing_address2' => $request->billing_address2,
                                    'billing_contact_mobile' => $request->billing_contact_mobile,
                                    'billing_city' => $request->billing_city,
                                    'billing_state' => $request->billing_state,
                                    'billing_country' => $request->billing_country,
                                    'billing_pin_code' => $request->billing_pin_code,
                        ))->withInput();
            }

            if ($advDetail) {
                $updated = array();
                $advertiser_info = $advDetail->contact_name . '[' . $advDetail->contact_email . ']';
                if ($advDetail->billing_first_name != $request->billing_first_name) {
                    $updated['billing_first_name']['old'] = $advDetail->billing_first_name;
                    $advDetail->billing_first_name = $request->billing_first_name;
                    $updated['billing_first_name']['new'] = $advDetail->billing_first_name;
                }

                if ($advDetail->billing_last_name != $request->billing_last_name) {
                    $updated['billing_last_name']['old'] = $advDetail->billing_last_name;
                    $advDetail->billing_last_name = $request->billing_last_name;
                    $updated['billing_last_name']['new'] = $advDetail->billing_last_name;
                }

                if ($advDetail->billing_contact_mobile != $request->billing_contact_mobile) {
                    $updated['billing_contact_mobile']['old'] = $advDetail->billing_contact_mobile;
                    $advDetail->billing_contact_mobile = $request->billing_contact_mobile;
                    $updated['billing_contact_mobile']['new'] = $advDetail->billing_contact_mobile;
                }

                if ($advDetail->billing_address1 != $request->billing_address1) {
                    $updated['billing_address1']['old'] = $advDetail->billing_address1;
                    $advDetail->billing_address1 = $request->billing_address1;
                    $updated['billing_address1']['new'] = $advDetail->billing_address1;
                }
                if ($advDetail->billing_address2 != $request->billing_address2) {
                    $updated['billing_address2']['old'] = $advDetail->billing_address2;
                    $advDetail->billing_address2 = $request->billing_address2;
                    $updated['billing_address2']['new'] = $advDetail->billing_address2;
                }

                if ($advDetail->billing_city != $request->billing_city) {
                    $updated['billing_city']['old'] = $advDetail->billing_city;
                    $advDetail->billing_city = $request->billing_city;
                    $updated['billing_city']['new'] = $advDetail->billing_city;
                }

                if ($advDetail->billing_state != $request->billing_state) {
                    $updated['billing_state']['old'] = $advDetail->billing_state;
                    $advDetail->billing_state = $request->billing_state;
                    $updated['billing_state']['new'] = $advDetail->billing_state;
                }

                if ($advDetail->billing_country != $request->billing_country) {
                    $updated['billing_country']['old'] = $advDetail->billing_country;
                    $advDetail->billing_country = $request->billing_country;
                    $updated['billing_country']['new'] = $advDetail->billing_country;
                }


                if ($advDetail->billing_pin_code != $request->billing_pin_code) {
                    $updated['billing_pin_code']['old'] = $advDetail->billing_pin_code;
                    $advDetail->billing_pin_code = $request->billing_pin_code;
                    $updated['billing_pin_code']['new'] = $advDetail->billing_pin_code;
                }

                $advDetail->save();
                $mail_message = "";
                if (count($updated)) {

                    Mail::send('advertiser_updated_info_mail', ['updated' => $updated, 'advertiser_name' => $advertiser_info], function($message) use($advertiser_info) {

                        $message->from(config('all.noreply_email'), 'Vola.ad')
                                ->to(config('all.admin_email'), 'Admin')
                                ->subject('Advertiser ' . $advertiser_info . ' billing info updated');
                    });
                }
                return redirect(config('app.local_url') . "admin/advinfo/" . $request->advertiser_id)->with("success_billing_updated", "Billing information updated successfully");
                //return json_encode(array('status' => 'success', 'msg' => 'Updated Successfully.'));
            }
        }
    }

    public function getCountries() {
        $getAll = Cache::get('countries');
        if (!($getAll)) {
            $getAll = \App\Country::all();
            Cache::store('apc')->put('countries', $getAll, 36000);
        }
        return $getAll->toJson();
    }

}
