<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Validator;
use Auth;
use Hash;
use App\User;
use App\Http\Controllers\PaymentController;
use Illuminate\Support\Facades\Mail; //TBD
use Illuminate\Mail\Mailer; //TBD

class CouponsController extends Controller {

    public function __construct() {
        $this->middleware('auth');
    }
    
    public function redeemCoupons(Request $request){
        
        $request->coupon_code="WED50"; //TBD
        $valid =0;
        $accounts       =   Session::get('sessiondata');
        $country_id     =   Session::get('country_id');
        
        if( $request->coupon_code ){
            
            $couponData = \App\CouponMaster::where('code',trim($request->coupon_code))
               ->where('apply_status', 'AVAILABLE')
               ->take(1)
               ->get();
            
            if( count( $couponData ) > 0 ){
                
                if( $couponData[0]->for_type == "INDIVIDUAL" ){
                    
                    $valid = ($couponData[0]->individual_account_id == $accounts['accounts'][0]['account_id']) ? 1 : 0;
                
                } elseif($couponData[0]->for_type == "OPEN") {
                    
                    $valid = 1;
                }
                
                if( $valid ){
                    
                    $valid =  ( $this->checkCouponApplyType( $couponData[0],$country_id ) ) ? 1 : 0 ;
                
                }
            }
            
            return ($valid) ? json_decode($couponData[0]) : 0;
        }
        
        return $valid;
    }
    
    
    public function checkCouponApplyType( $couponData,$country_id ){
        
        switch ($couponData->apply_type) {
            case "COUNTRY":
                return ($couponData->country_id == $country_id) ? 1 : 0 ;
                break;
            case "DOW":
                return ($couponData->valid_dow == date('D')) ? 1 : 0 ;
                break;
            case "DATE":
                return ($couponData->valid_date == date('Y-m-d')) ? 1 : 0 ;
                break;
            case "TILLDATE":
                return (strtotime($couponData->valid_date) >= strtotime(date('Y-m-d'))) ? 1 : 0 ;
                break;
        }
        
        return 0;

    }
    
    public function afterApplyCallback(Request $request){
        
        if($request->coupon_data){
            
            $data_arr   = json_decode($request->coupon_data);
            
            //insert into coupon history table
            
            $history  = new \App\CouponHistory();
            $history->coupon_id = $data_arr['coupon_id'];
            $history->transaction_id = $data_arr['transaction_id'];
            $history->code = $data_arr['code'];
            $history->applied_on = date('Y-m-d H:i:s');
            $history->applied_account = $data_arr['account_id'];
            $history->credited_value = $data_arr['credited_value'];
            $history->advertiser_id = $this->getAdvertiserId( $data_arr['account_id'] );
            $history->amount_dollar = $data_arr['credited_value'];//usd
            $history->amount_used = 0.0;
            $history->valid_date = $this->getCouponField($data_arr['coupon_id'],'valid_date');
            $history->valid_dow = $this->getCouponField($data_arr['coupon_id'],'valid_dow');
            $history->save();
            
            //add coupon dollar amount to advertiser table
            //############################################
            DB::update('update dl_advertisers set balance_left_dollar = balance_left_dollar+'.trim($data_arr['credited_value']).' where account_id = ? limit 1', [$data_arr['account_id']]);
            
            //update coupon master in case of individual coupon
            //#################################################
            \App\CouponMaster::where('id', $data_arr['coupon_id'])
                ->where('for_type', "INDIVIDUAL")
                ->update(['apply_status' => "APPLIED"]);
            
            return true;
        }
        
        return false;
    }
    
    
    public function getAdvertiserId($account_id){
        
        if($account_id){
            
               $advId = \App\Advertiser::where('account_id',trim($account_id))
               ->take(1)
               ->get();
               
               if(count( $advId ) > 0 ){
                   
                return  $advId[0]->advertiser_id;
               }
        }
        
        return 0;
    }
    
    
    public function getCouponField( $coupon_id, $field ) {
        
        if($coupon_id){
            
            $couponData = \App\CouponMaster::where('id',trim($coupon_id))
               ->take(1)
               ->get();
               
            if( count( $couponData ) > 0 ){
                
                return $couponData[0]->{$field};
            }
        }
        
        return 0;
    }
    
}