<?php

namespace App\Http\Controllers;

use DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;
use App\Account;
use Auth;
use Cache;

class JsonController extends Controller {

    public function __construct() {
        $this->session = SESSION::All();
        if (!isset($this->session['sessiondata']['user_timezone']) && empty($this->session['sessiondata']['user_timezone'])) {
            date_default_timezone_set(date('e'));
        } else {
            date_default_timezone_set($this->session['sessiondata']['user_timezone']);
        }
        // date_default_timezone_set('Pacific/Tongatapu');
        if (Auth::check() && isset($this->session['sessiondata']['accounts'][0]['account_type']) && $this->session['sessiondata']['accounts'][0]['account_type'] == 'ADVERTISER') {
            $this->advertiserdata = Account::find($this->session['sessiondata']['accounts'][0]['account_id'])->advertiser;
            $this->advertiserdata = $this->advertiserdata->toArray();
            $this->currency = !empty($this->advertiserdata['currency']) ? $this->advertiserdata['currency'] : 'USD';
            $this->currencyminarray = config('paymentgateway.currencyminarray');
            $this->currencymin = $this->currencyminarray[$this->currency];
            $this->advertiserdata['currencymin'] = $this->currencymin;
        }
    }

    /*
      get all categories in json format
     *
     */

    public function getCountries() {
        $getAll = Cache::get('countries');
        if (!($getAll)) {
            $getAll = \App\Country::all();
            Cache::put('countries', $getAll, 36000);
        }

        return $getAll->toJson();
    }
    
     public function getCountriesMb() {
        $getAll = Cache::get('countriesmb');
        if (!($getAll)) {
           
            $getAll = \App\Country::groupby('phonecode')->distinct()->orderBy('phonecode', 'asc')->get();
            Cache::put('countriesmb', $getAll, 36000);
        }
        return $getAll->toJson();
    }

    /*
     * get all state
     * 
     */
     public function getState(Request $request) {
          $q = $request->q;
        $pos = strpos($q, ',');
        $qArr = array();
        if ($pos === false) {
            $qArr[] = $q;
        } else {
            $qArr = explode(',', $q);
        }
         $statModel = new \App\StatezipCode;
         $statData = Cache::get('state_' . $q);
         if (!$statData) {
          
         $statData = DB::table('country_region_zip')
         ->select(DB::raw('distinct(region),id,country_iso3,region_iso'))
         ->whereIn('country_iso3',$qArr)
         ->orderBy('region')
         ->orderBy('country_iso3')->get();
         Cache::put('state_' . $q, $statData, 36000);
        }
        $final_array = array();
        if (count($statData) > 0) {
            foreach ($statData as $key => $value) {
        $sb = array();
		$sb['id']=$value->id;
        $sb['region_iso']=$value->region_iso;
		$sb['country_iso3']=$value->country_iso3;
        $sb['region'] = $value->region;
        $final_array[] = $sb;
            }
        }
        return json_encode($final_array);
         
    }
    
    /*
      get all cities in json format
     *  */

    public function getAllCities(Request $request) {
        //$advertisers = DB::table('dl_advertisers')->get();
        // $q = $_GET["q"];
        $q = $request->q;

        $statModel = new \App\Cities;
        $statData = Cache::get('city_' . $q);
        //$statData = $statModel::where('city', 'LIKE', '%'.$q.'%')->get();
        if (!$statData) {
            $statData = $statModel::where('country_iso', '=', $q)->orderBy('city', 'desc')->get();
            Cache::put('city_' . $q, $statData, 36000);
        }
        $final_array = array();
        if (count($statData) > 0) {

            foreach ($statData as $key => $value) {
                $sb = array();
                $sb['id'] = $value->city;
		$sb['city_iso']=$value->city_iso;
		$sb['country_iso3']=$value->country_iso3;
                $sb['name'] = $value->city;
                $final_array[] = $sb;
            }
        }

        return json_encode($final_array);
    }

    /*
      get Selected countries cities  in json format
     *  */

    public function getSelectedCities(Request $request) {
        //$advertisers = DB::table('dl_advertisers')->get();
        // $q = $_GET["q"];

     
        $q = $request->q;
        $pos = strpos($q, ',');
        $qArr = array();
        if ($pos === false) {
            $qArr[] = $q;
        } else {
            $qArr = explode(',', $q);
        }

        // $b = $request->b;
        // $posb = strpos($b, ',');
        // $bArr = array();
        // if($posb === false){
        //     $bArr = 'IN BR';//$b;
        // }else{
        //     $bArr = explode(',', $b);
        // }


        $statModel = new \App\Cities;
        // if(count($bArr)>0)
        // {
        // $statData = $statModel::whereIn('country_iso3', $qArr)->whereIn('city_iso', 'IN BR')->get();
        // }else{
            $statData = $statModel::whereIn('country_iso3', $qArr)->get();
        // }
        //->groupBy('country_iso3')
        //->all();
        $final_array = array();
        if (count($statData) > 0) {

            foreach ($statData as $key => $value) {
                $sb = array();
                $sb['id'] = $value->city;
                $sb['name'] = $value->city;
                $sb['city_iso'] = $value->city_iso;
                $sb['country_iso3'] = $value->country_iso3;
                $final_array[] = $sb;
            }
        }

        return json_encode($final_array);
    }

    public function getSelectedStateCities(Request $request){
          $q = $request->q;
        $pos = strpos($q, ',');
        $qArr = array();
        if ($pos === false) {
            $qArr[] = $q;
        } else {
            $qArr = explode(',', $q);
        }

         $statModel = new \App\StatezipCode;
         $statData = Cache::get('state_' . $q);
         if (!$statData) {
          
         $statData = DB::table('country_region_zip')
         ->select(DB::raw('distinct(region),id,country_iso3,region_iso'))
         ->whereIn('region_iso',$qArr)
         ->orderBy('region')
         ->orderBy('country_iso3')->get();
         Cache::put('state_' . $q, $statData, 36000);
        }
        $final_array = array();
        if (count($statData) > 0) {
            foreach ($statData as $key => $value) {
        $sb = array();
        $sb['id']=$value->id;
        $sb['region_iso']=$value->region_iso;
        $sb['country_iso3']=$value->country_iso3;
        $sb['region'] = $value->region;
        $final_array[] = $sb;
            }
        }
        return json_encode($final_array);

    }


public function getSelectedCityCities(Request $request){
      $q = $request->q;
        $pos = strpos($q, ',');
        $qArr = array();
        if ($pos === false) {
            $qArr[] = $q;
        } else {
            $qArr = explode(',', $q);
        }

        $statModel = new \App\Cities;
        $statData = $statModel::whereIn('city_iso', $qArr)->get();
        $final_array = array();
        if (count($statData) > 0) {

            foreach ($statData as $key => $value) {
                $sb = array();
                $sb['id'] = $value->city;
                $sb['name'] = $value->city;
                $sb['city_iso'] = $value->city_iso;
                $sb['country_iso3'] = $value->country_iso3;
                $final_array[] = $sb;
            }
        }

    

        return json_encode($final_array);


}

    /*
      get all categories in json format
     *  */

    public function getIabCategories() {


        $getAll = Cache::get('iab_categories');
        if (!$getAll) {
            $getAll = \App\CfCategory::all();
            Cache::put('iab_categories', $getAll, 36000);
        }
   
        $final_array = array();
        if (count($getAll) > 0) {

            foreach ($getAll as $key => $value) {

                $value->iab_category_id = ($value->iab_category_id) ? $value->iab_category_id : $value->category_id;
                $value->iab_parent_id = ($value->iab_parent_id) ? $value->iab_parent_id : 0;
                $final_array[$value->iab_parent_id][$value->iab_category_id] = $value->description;
            }
        }
        return json_encode($final_array);
    }

    /*
      get all categories in json format
     *  */

    public function getCategories() {

        //$advertisers = DB::table('dl_advertisers')->get();

        $getAll = Cache::get('adv_categories');
        if (!$getAll) {
            $getAll = \App\AdvCategory::all();
            Cache::put('adv_categories', $getAll, 36000);
        }

        $final_array = array();
        if (count($getAll) > 0) {

            foreach ($getAll as $key => $value) {

                if ($value->type == "B")
                    $final_array[0][$value->parent_id][$value->id] = $value->description;
                else
                    $final_array[1][$value->parent_id][$value->id] = $value->description;
            }
        }
        //echo "<pre>";print_r($final_array);
        return json_encode($final_array);
    }

    /*
      get all devices in json format
     *  */

    public function getDevices(Request $request) {


        if (isset($request->q) && trim($request->q) != '') {
            $q = $request->q;
        } else {
            $q = 'all';
        }
        $pos = strpos($q, ',');
        $qArr = array();
        if ($pos === false) {
            $qArr[] = $q;
        } else {
            $qArr = explode(',', $q);
        }

        $statModel = new \App\Devices;

        if ($q == 'all' || $qArr[0] == 'all') {
            $statData = $statModel::distinct()->select('device_brand')
                    ->orderBy('device_brand', 'asc')
                    ->get();
        } else {

            $statData = $statModel::whereIn('device_type', $qArr)->get();
        }
        $final_array = array();
        $final_array2 = array();
        if (count($statData) > 0) {

            foreach ($statData as $key => $value) {
                $final_array[] = $value->device_brand;
            }
        }

        $final_array2 = array();
        $statDatav = Cache::get('device_brands');
        if (!$statDatav) {
            $statDatav = $statModel::distinct()->select('device_brand')
                    ->orderBy('device_brand', 'asc')
                    ->get();
            Cache::put('device_brands', $statDatav, 36000);
        }

        if (count($statDatav) > 0) {

            foreach ($statDatav as $key => $value) {

                if (in_array(trim($value->device_brand), $final_array)) {
                    $final_array2[$value->device_brand] = 'checked';
                } else {
                    $final_array2[$value->device_brand] = '';
                }
            }
        }
        return json_encode($final_array2);
    }

    /*
      get all os in json format
     *  */

    public function getOs(Request $request) {
        if (isset($request->q) && trim($request->q) != '') {
            $q = $request->q;
        } else {
            $q = 'all';
        }

        $os_list = Cache::get('device_os_list');
          
        if (!$os_list) {
            $os_list = parse_ini_file('target_data/category_os.php', true);
            Cache::put('device_os_list', $os_list, 6000);
        }

        $pos = strpos($q, ',');
        $qArr = array();
        if ($pos === false) {
            $qArr[] = $q;
        } else {
            $qArr = explode(',', $q);
        }
        $final_array = array();
        foreach ($os_list as $device_type => $os) {
            if ($q == 'all' || $qArr[0] == 'all') {
                $final_array = array_merge($final_array, $os);
            } else {
                if (array_key_exists($device_type, $qArr)) {
                    $final_array = array_merge($final_array, $os);
                }
            }
        }


        return json_encode($final_array);
    }

    /*
      get all osv in json format
     *  */

    public function getOsV() {

        //$contents = Storage::disk('local')->get('target_data/device_list.include');
        $contents = file('target_data/osv_list.include');
        //print_r( json_encode($contents) );
        return json_encode($contents);
    }

    

    /*
    get all lanaguage list values

    */

      public function getlanguagelist(Request $request){
        $new_lan = Cache::get('lang_lsit');
        if(!$new_lan){
            $lang_contents = json_decode(file_get_contents("json_data/country-lang.json"), true);
            $new_lan=[];
            foreach ($lang_contents as $key => $value){
            $new_lan[]= $lang_contents[$key]['English'];
            }
             Cache::put('lang_lsit', $new_lan, 36000);
            }
       return json_encode($new_lan);
    }



    /*
      get all browser in json format
     *  */
    public function getBrowser() {

        //$contents = Storage::disk('local')->get('target_data/device_list.include');
        $contents = file('target_data/browser_list.include');
        //print_r( json_encode($contents) );
        return json_encode($contents);
    }

    /*
      get all browser versions in json format
     *  */

    public function getBrowserV() {

        //$contents = Storage::disk('local')->get('target_data/device_list.include');
        $contents = file('target_data/browserv_list.include');
        //print_r( json_encode($contents) );
        return json_encode($contents);
    }

    /*
      get all browser in json format
     *  */

    public function getOperator(Request $request) {
         
        $countrys = $request->q ? $request->q :'';
        
        $country= array();

        if(empty($countrys) || !isset($countrys)) {
            $country[] = 'IND';
        }   else{
            $country = explode(',',$countrys);
             }
              $statModel = new \App\Operator;
             $operators_list = $statModel::distinct()->select('operator_name','country_name_iso3','operator_id')
             ->whereIN('country_name_iso3',$country)
                    ->orderBy('operator_id', 'asc')
                    ->get();

        $selected_operators = array();
        $counter = 0;

        foreach ($operators_list as $ckey => $operators) {
            if (in_array($operators['country_name_iso3'], $country)) {
                    $selected_operators[$counter]['operator_id'] = $operators['operator_id'];
                    $selected_operators[$counter]['operator_name'] = $operators['operator_name'];
                    $selected_operators[$counter]['country_name_iso3'] = $operators['country_name_iso3'];
                    $counter++;
               
            }
        }
        return json_encode($selected_operators);

    }

     public function getOperatorS2S(Request $request) {
         
         $countrys = $request->q ? $request->q :'';
        
        $country= array();

      if(empty($countrys) || !isset($countrys)) {
            $country[] = 'IND';
        }   else{
            $country = explode(',',$countrys);
             }

         // $operators_list = Cache::get('operators_list_s2s');
         //  if(!$operators_list) {
            $statModel = new \App\Operators2s;
             $operators_list = $statModel::distinct()->select('name as operator_name','country_code3 as country_name_iso3','id as operator_id')
             ->whereIn('country_code3',$country)
                    ->orderBy('id', 'asc')
                    ->get();
             //    Cache::put('operators_list_s2s', $operators_list, 36000);
             // }

        $selected_operators = array();
        $counter = 0;

        foreach ($operators_list as $ckey => $operators) {
            if (in_array($operators['country_name_iso3'], $country)) {
                    $selected_operators[$counter]['operator_id'] = $operators['operator_id'];
                    $selected_operators[$counter]['operator_name'] = $operators['operator_name'];
                    $selected_operators[$counter]['country_name_iso3'] = $operators['country_name_iso3'];
                    $counter++;
               
            }
        }
        return json_encode($selected_operators);

    }
    /*
      get ads running info in json format
     * */

    public function getReportInfoAdvertiser(Request $request) {
 if (!isset($this->advertiserdata)) {
            return false;
        }

        if (isset($request->start) && !empty($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->start = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        }

        if (isset($request->end) && !empty($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->end = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        }

        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start:date('Y-m-d');
        $end = ( $request->end ) ? $request->end: date("Y-m-d");
	$campaign = ( $request->Campaign_id ) ? $request->Campaign_id: 0 ;
        //getting the stat records
        if (!isset($request->groupby)) {
            $request->groupby = 1;
        }
        $statModel = new \App\hourlyStat();

        $statData = $statModel->join('dl_campaigns', 'hourly_stat.campaign_id', '=', 'dl_campaigns.campaign_id')
                ->leftJoin('advertiser_webpage', 'advertiser_webpage.page_id', '=', 'hourly_stat.url_id')
                ->where('hourly_stat.advertiser_id', $this->advertiserdata['advertiser_id'])
                ->where('hourly_stat.stat_date', '>=', $start)
                ->where('hourly_stat.stat_date', '<=', $end)
		->where('dl_campaigns.campaign_id', '!=', $campaign);

        if ($request->groupby == 2) {
            $statData = $statData->where('advertiser_webpage.webpage_name', '=', '')
                    ->where('advertiser_webpage.url', '!=', '')
                     ->where('hourly_stat.advertiser_id', $this->advertiserdata['advertiser_id'])
                    ->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "dl_campaigns.status,"
                            . "dl_campaigns.min_unit_price,"
                            . "advertiser_webpage.url,"
                            . "dl_campaigns.min_unit_price_currency,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3)as spend_currency,"
                            . "dl_campaigns.campaign_budget,"
                            . "dl_campaigns.campaign_budget_currency,"
                            . "hourly_stat.ad_id, sum(impression_count) as imp,"
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "hourly_stat.revenue_value as spend,"
                            . "hourly_stat.revenue_value_currency as spend_currency,"
                            . "hourly_stat.stat_date as timestamp")
                    ->groupBy('hourly_stat.stat_date', 'hourly_stat.url_id', 'dl_campaigns.campaign_id')
                    ->orderBy('hourly_stat.stat_date', 'desc')
                    ->orderBy('advertiser_webpage.url', 'asc')
                    ->orderBy('dl_campaigns.campaign_name', 'asc');
        } else if ($request->groupby == 3) {
            $statData = $statData->where('advertiser_webpage.webpage_name', '!=', '')
                    ->where('advertiser_webpage.url', '!=', '')
                     ->where('hourly_stat.advertiser_id', $this->advertiserdata['advertiser_id'])
                    ->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "advertiser_webpage.webpage_name,"
                            . "dl_campaigns.status,"
                            . "dl_campaigns.min_unit_price,"
                            . "dl_campaigns.min_unit_price_currency,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3)as spend_currency,"
                            . "dl_campaigns.campaign_budget,"
                            . "dl_campaigns.campaign_budget_currency,"
                            . "hourly_stat.ad_id, sum(impression_count) as imp,"
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "sum(hourly_stat.revenue_value) as spend,"
                            . "sum(hourly_stat.revenue_value_currency) as spend_currency,"
                            . "hourly_stat.stat_date as timestamp")
                    ->groupBy('hourly_stat.stat_date', 'hourly_stat.url_id', 'dl_campaigns.campaign_id')
                    ->orderBy('hourly_stat.stat_date', 'desc')
                    ->orderBy('advertiser_webpage.webpage_name', 'asc')
                    ->orderBy('dl_campaigns.campaign_name', 'asc');
        } else { //default
            $statData = $statData->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "dl_campaigns.status,"
                            . "dl_campaigns.min_unit_price,"
                            . "advertiser_webpage.url,"
                            . "dl_campaigns.min_unit_price_currency,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3)as spend_currency,"
                            . "dl_campaigns.campaign_budget,"
                            . "dl_campaigns.campaign_budget_currency,"
                            . "hourly_stat.ad_id, sum(impression_count) as imp,"
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "sum(hourly_stat.revenue_value) as spend,"
                            . "sum(hourly_stat.revenue_value_currency) as spend_currency,"
                            . "hourly_stat.stat_date as timestamp")
                    //->groupBy('hourly_stat.url_id', 'hourly_stat.stat_date')
                    ->groupBy('dl_campaigns.campaign_id', 'hourly_stat.stat_date')
                    ->orderBy('hourly_stat.stat_date', 'desc')
                    ->orderBy('dl_campaigns.campaign_name', 'asc');
        }
        //$statData = $statData->get();
        $statData = $statData->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        return $statData->toJson();
    }

    /*
      get ads info for logged in advertiser in json format
     *  */

private function campaigntype(){
     $statModel = new \App\Campaigns();
          $statData = $statModel::select('campaign_id','advertiser_id','campaign_pricing_model')->where('advertiser_id','=',$this->advertiserdata['advertiser_id'])->groupby('campaign_pricing_model')->get();
                 $advert_tyes=[];
             foreach ($statData as $key => $value) {
            $advert_tyes[$value['campaign_id']] = $value['campaign_pricing_model'];
            }   

            return  $advert_tyes;
}

private function camapiagn_list(){
     $statModel = new \App\Campaigns();
     $statData = $statModel::select('campaign_id','advertiser_id','campaign_pricing_model')->where('advertiser_id','=',$this->advertiserdata['advertiser_id'])->groupby('campaign_pricing_model')->get();
                 $advert_typess=[];
             foreach ($statData as $key => $value) {
            $advert_typess[$value['campaign_id']] = $value['campaign_id'];
            }   
           return   $advert_typess;
}

  /*
      get ads info for logged in advertiser in json format
     *  */

   public function getAdInfoAdvertiser(Request $request) {

//		echo '<pre>';print_r($this->advertiserdata);echo '</pre>'; exit();
        if(true){
        if (!isset($this->advertiserdata)) {
            return json_encode(false);
        }

        if (isset($request->start) && !empty($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->start = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        }

        if (isset($request->end) && !empty($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');

        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->end = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        }
        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start : '';
        $end = ( $request->end ) ? $request->end : '';

        $condition=[];
        //getting the stat records
        // $statModel = new \App\Campaigns();
        // if (trim($request->start) != '' && trim($request->end) != '') {
        //     $statData = $statModel::leftJoin('hourly_stat', function( $join)use($start, $end ) {
        //                 $join->on('dl_campaigns.campaign_id', '=', 'hourly_stat.campaign_id')
        //                  ->where('hourly_stat.stat_date', '>=', $start)
        //                 ->where('hourly_stat.stat_date', '<=', $end);
        //             })
        //             ->where('dl_campaigns.advertiser_id', $this->advertiserdata['advertiser_id'])
        //             ->where("dl_campaigns.status", "!=", "archived")
        //             ->where($condition)
        //             ->selectRaw("dl_campaigns.campaign_id,"
        //                     . "dl_campaigns.campaign_name," 
        //                     . "dl_campaigns.status,"
        //                     . "dl_campaigns.admin_status,"
        //                     ."dl_campaigns.campaign_pricing_model,"
        //                     ."dl_campaigns.campaign_ad_type,"
        //                     ."dl_campaigns.campaign_vertical,hourly_stat.revenue_value as spend,"
        //                     . "round(dl_campaigns.min_unit_price,3) as min_unit_price,"
        //                     . "round(IF(dl_campaigns.campaign_pricing_model = 'CPM',dl_campaigns.min_unit_price_currency,'0'),3) as min_unit_price_currency,"
        //                     . "round(IF(dl_campaigns.campaign_pricing_model = 'CPM',dl_campaigns.campaign_budget,hourly_stat.cost_value),3) as campaign_budget, "
        //                     . "round(if(dl_campaigns.campaign_pricing_model = 'CPM',dl_campaigns.campaign_budget_currency,hourly_stat.cost_value_currency),3) as campaign_budget_currency,"
        //                     . "dl_campaigns.campaign_budget_currency as campaign_budget_c,"
        //                     . "sum(hourly_stat.impression_count) as imp, "
        //                     . "sum(IF(dl_campaigns.campaign_pricing_model = 'CPM', hourly_stat.clicks_count,hourly_stat.clicks_count)) as clicks,"
        //                     . "sum(IF(dl_campaigns.campaign_pricing_model = 'CPM',hourly_stat.conversions_count, hourly_stat.conversions_count)) as conversions,"
        //                     . "round(sum(IF(dl_campaigns.campaign_pricing_model = 'CPM',hourly_stat.revenue_value, hourly_stat.revenue_value)),3) as spend_currency"
                          
        //             )
        //             ->groupBy('dl_campaigns.campaign_id')
        //             ->paginate($take, $columns = ['*'], $pageName = 'page', $page);

        //              // dd($statData);
        // } else {

        //     $statData = $statModel::leftJoin('hourly_stat', function( $join ) {
        //                 $join->on('dl_campaigns.campaign_id', '=', 'hourly_stat.campagin_id')
        //                    ->where('hourly_stat.stat_date', '>=', $start)
        //                 ->where('hourly_stat.stat_date', '<=', $end);
        //             })
        //             ->where('dl_campaigns.advertiser_id', $this->advertiserdata['advertiser_id'])
        //             ->where("dl_campaigns.status", "!=", "archived")
        //                  ->selectRaw("dl_campaigns.campaign_id,"
        //                     . "dl_campaigns.campaign_name," 
        //                     . "dl_campaigns.status,"
        //                     . "dl_campaigns.admin_status,"
        //                     ."dl_campaigns.campaign_pricing_model,"
        //                     ."dl_campaigns.campaign_ad_type,"
        //                     ."dl_campaigns.campaign_vertical,hourly_stat.revenue_value as spend,"
        //                     . "round(dl_campaigns.min_unit_price,3) as min_unit_price,"
        //                     . "round(IF(dl_campaigns.campaign_pricing_model = 'CPM',dl_campaigns.min_unit_price_currency,'0'),3) as min_unit_price_currency,"
        //                     . "round(IF(dl_campaigns.campaign_pricing_model = 'CPM',dl_campaigns.campaign_budget,hourly_stat.cost_value),3) as campaign_budget, "
        //                     . "round(if(dl_campaigns.campaign_pricing_model = 'CPM',dl_campaigns.campaign_budget_currency,hourly_stat.cost_value_currency),3) as campaign_budget_currency,"
        //                     . "dl_campaigns.campaign_budget_currency as campaign_budget_c,"
        //                     . "sum(hourly_stat.impression_count) as imp, "
        //                     . "sum(IF(dl_campaigns.campaign_pricing_model = 'CPM', hourly_stat.clicks_count,hourly_stat.clicks_count)) as clicks,"
        //                     . "sum(IF(dl_campaigns.campaign_pricing_model = 'CPM',hourly_stat.conversions_count, hourly_stat.conversions_count)) as conversions,"
        //                     . "round(sum(IF(dl_campaigns.campaign_pricing_model = 'CPM',hourly_stat.revenue_value, hourly_stat.revenue_value)),3) as spend_currency"
                          
        //             )
        //             ->groupBy('dl_campaigns.campaign_id')
        //             //->take($take)
        //             ->paginate($take, $columns = ['*'], $pageName = 'page', $page);

			
           $statData= $users = DB::table('motion_general_report')->where('date', '>=', $start)->where('date', '<=', $end)->paginate($take, $columns = ['*'], $pageName = 'page', $page);

        
        // dd($statData)
        return $statData->toJson();
       }else{
        return HTTP_REQUEST_NOT_ACCEPTED;   
       }
    }

    public function getSiteInfoAdvertiser(Request $request) {
        if(true){
        if (!isset($this->advertiserdata)) {
            return json_encode(false);
        }

        if (isset($request->start) && !empty($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->start = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        }

        if (isset($request->end) && !empty($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');

        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->end = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        }
        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start : '';
        $end = ( $request->end ) ? $request->end : '';

        $condition=[];
        
            $statData= $users = DB::table('motion_sitewise_report')
                    ->select(DB::raw('id as campaign_id, campaign_name as campaign_name, publisher as publisher, 
                        advertiser as advertiser, ad_type as ad_type, pricing_modal as pricing_modal, 
                        sum(clicks) as clicks, sum(impression) as impression, 
                            sum(spend) as spend, ctr as ctr, cpm as cpm, campaign_status'))
                    ->where('date', '>=', $start)
                    ->where('date', '<=', $end)
                    ->where('status', '=', '1')
                    ->groupby("publisher")->paginate($take, $columns = ['*'], $pageName = 'page', $page);

        
        // dd($statData)
        return $statData->toJson();
       }else{
        return HTTP_REQUEST_NOT_ACCEPTED;   
       }
    }

/*    public function getTotalAdReportAdvertiser(Request $request) {

        if(true){   
        if (isset($request->start) && !empty($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->start = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        }

        if (isset($request->end) && !empty($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->end = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        }
        $start = ( $request->start ) ? $request->start : '';
        $end = ( $request->end ) ? $request->end : '';

        //getting the stat records
        $statModel = new \App\Campaigns();
        if (trim($request->start) != '' && trim($request->end) != '') {
            $statData = $statModel::leftJoin('adacts_stat', function( $join)use($start, $end ) {
                        $join->on('dl_campaigns.campaign_id', '=', 'adacts_stat.id')
                        ->where('adacts_stat.timestamp', '>=', $start)
                        ->where('adacts_stat.timestamp', '<=', $end);
                    })
                    ->where('dl_campaigns.advertiser_id', $this->advertiserdata['advertiser_id'])
                    ->where("dl_campaigns.status", "!=", "'archived'")
                    ->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "dl_campaigns.advertiser_id,"
                            . "dl_campaigns.status,adacts_stat.creativeid, "
                            . "round(dl_campaigns.campaign_budget,3) as campaign_budget,"
                            . "round(dl_campaigns.campaign_budget_currency,3) as campaign_budget_currency,"
                            . "sum(dl_campaigns.impressions) as imp, "
                            . "sum(dl_campaigns.clicks) as clicks,"
                            . "sum(dl_campaigns.conversions) as conversions,"
                            . "round(sum(adacts_stat.spendings),3) as spend"
                
                    )->groupBy("dl_campaigns.campaign_id")->get();

        } else {
            $statData = $statModel::leftJoin('adacts_stat', function( $join ) {
                        $join->on('dl_campaigns.campaign_id', '=', 'adacts_stat.id');
                    })
                    ->where('dl_campaigns.advertiser_id', $this->advertiserdata['advertiser_id'])
                    ->where("dl_campaigns.status", "!=", "archived")
                    ->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "dl_campaigns.status,adacts_stat.creativeid, "
                            . "round(dl_campaigns.min_unit_price_currency,3) as min_unit_price_currency,"
                            . "round(dl_campaigns.campaign_budget,3) as campaign_budget,"
                            . "round(dl_campaigns.campaign_budget_currency,3) as campaign_budget_currency,"
                            . "adacts_stat.ad_id,"
                            . "sum(dl_impressions) as imp,"
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3) as spend_currency"
                    )
                    ->groupBy("dl_campaigns.campaign_id")
                    ->get();
        }
        $campaign_data = array();
        $campaign_data['running_count'] = 0;
        $campaign_data['spend_currency'] = 0;
        $campaign_data['conversions'] = 0;
        $campaign_data['clicks'] = 0;
        $campaign_data['campaign_budget_currency'] = 0;
        $campaign_data['account_balance_currency'] = $this->advertiserdata['balance_left_currency'] = 0;
        $statData = $statData->toArray();
        foreach ($statData as $statRow) {
            if ($statRow['status'] == 'running') {
                $campaign_data['running_count'] ++;
            }
            $campaign_data['campaign_budget_currency'] += $statRow['campaign_budget_currency'];
            $campaign_data['clicks'] += $statRow['clicks'];
            $campaign_data['conversions'] += $statRow['conversions'];
        }

        $stvdata = array('data' => $campaign_data);
        return json_encode($stvdata);
		}else{
		return HTTP_REQUEST_NOT_ACCEPTED;
		}
    }*/


  public function getTotalAdReportAdvertiser(Request $request) {

        if(true){   
        if (isset($request->start) && !empty($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->start = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        }

        if (isset($request->end) && !empty($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->end = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        }
        $start = ( $request->start ) ? $request->start : '';
        $end = ( $request->end ) ? $request->end : '';

        //getting the stat records
 //        $statModel = new \App\Campaigns();
 //        if (trim($request->start) != '' && trim($request->end) != '') {
 //            $statData = $statModel::leftJoin('hourly_stat', function( $join)use($start, $end ) {
 //                        $join->on('dl_campaigns.campaign_id','=','hourly_stat.campaign_id')
 //                       ->where('hourly_stat.stat_date', '>=', $start)
 //                      ->where('hourly_stat.stat_date', '<=', $end);
 //                    })
 //                    ->where('dl_campaigns.advertiser_id', $this->advertiserdata['advertiser_id'])
 //                    ->where("dl_campaigns.status", "!=", "'archived'")
 //                    ->selectRaw("dl_campaigns.campaign_id,"
 //                            . "dl_campaigns.campaign_name,"
 //                            . "dl_campaigns.status,"
 //                           . "dl_campaigns.admin_status,"
 //                            ."dl_campaigns.campaign_pricing_model,"
 //                             ."dl_campaigns.campaign_ad_type,"
 //                            ."dl_campaigns.campaign_vertical,"
 //                            . "round(dl_campaigns.min_unit_price,3) as min_unit_price,"
 //                            . "round(dl_campaigns.min_unit_price_currency,3) as min_unit_price_currency,"
 //                            . "round(dl_campaigns.campaign_budget,3) as campaign_budget, "
 //                            . "round(dl_campaigns.campaign_budget_currency,3) as campaign_budget_currency, "
 //                            . "dl_campaigns.campaign_budget_currency as campaign_budget_c,"
 //                            . "hourly_stat.campaign_id as id, "
 //                            . "hourly_stat.total_cost as spend, "
 //                            . "sum(hourly_stat.impression_count) as imp, "
	// 		    . "sum(hourly_stat.clicks_count) as clicks,"
	//                     . "sum(hourly_stat.conversions_count) as conversions,"
	// 		    . "sum(hourly_stat.request_count) as request_count,"
	// 		    . "round(sum(hourly_stat.revenue_value),3) as spend,"
 //                            . "round(sum(hourly_stat.total_win_cost),3) as spend_currency")
 //                            // . "round(sum(IF(dl_campaigns.campaign_pricing_model = 'CPM',adacts_stat_summery.spendings,0),3) as spend_currency")
 //                    ->groupBy('dl_campaigns.campaign_id')->get();

 //        } else {
 //            $statData = $statModel::leftJoin('hourly_stat', function( $join ) {
 //                        $join->on('dl_campaigns.campaign_id', '=', 'hourly_stat.campaign_id');
 //                    })
        
 //                    ->where('dl_campaigns.advertiser_id', $this->advertiserdata['advertiser_id'])
 //                    ->where("dl_campaigns.status", "!=", "archived")
 //                     ->selectRaw("dl_campaigns.campaign_id,"
 //                            . "dl_campaigns.campaign_name,"
 //                            . "dl_campaigns.status,"
 //                           . "dl_campaigns.admin_status,"
 //                            ."dl_campaigns.campaign_pricing_model,"
 //                             ."dl_campaigns.campaign_ad_type,"
 //                            ."dl_campaigns.campaign_vertical,"
 //                            . "round(dl_campaigns.min_unit_price,3) as min_unit_price,"
 //                            . "round(dl_campaigns.min_unit_price_currency,3) as min_unit_price_currency,"
 //                            . "round(dl_campaigns.campaign_budget,3) as campaign_budget, "
 //                            . "round(dl_campaigns.campaign_budget_currency,3) as campaign_budget_currency, "
 //                            . "dl_campaigns.campaign_budget_currency as campaign_budget_c,"
 //                            . "hourly_stat.campaign_id as id, "
 //                            . "hourly_stat.total_cost as spend, "
 //                            . "sum(hourly_stat.impression_count) as imp, "
 //                            . "sum(hourly_stat.clicks_count) as clicks,"
 //                            . "sum(hourly_stat.conversions_count) as conversions,"
	// 		    . "round(sum(hourly_stat.revenue_value),3) as spend,"
 //                            . "round(sum(hourly_stat.total_win_cost),3) as spend_currency,"
	// 		    . "sum(hourly_stat.request_count) as request_count,"
	// 			)
 //                            // . "round(sum(IF(dl_campaigns.campaign_pricing_model = 'CPM',adacts_stat_summery.spendings,0),3) as spend_currency")
 //                    ->groupBy('dl_campaigns.campaign_id')
 //                    ->get();
 //        }
 //        $campaign_data = array();
 //        $campaign_data['running_count'] = 0;
 //        $campaign_data['spend_currency'] = 0;
 //        $campaign_data['conversions'] = 0;
 //        $campaign_data['clicks'] = 0;
	// $campaign_data['imp'] = 0;
	// $campaign_data['request_count'] = 0;	
 //    $campaign_data['win_rate']=0;	
 //        $campaign_data['campaign_budget_currency'] = 0;
 //        $campaign_data['account_balance_currency'] = $this->advertiserdata['balance_left_currency'] = 0;
 //        $statData = $statData->toArray();
 //        foreach ($statData as $statRow) {
 //            if ($statRow['status'] == 'running') {
 //                $campaign_data['running_count'] ++;
 //            }
 //            $campaign_data['campaign_budget_currency'] += $statRow['campaign_budget_currency'];
 //            $campaign_data['clicks'] += $statRow['clicks'];
 //            $campaign_data['conversions'] += $statRow['conversions'];
	//     $campaign_data['imp'] += $statRow['imp'];
 //            $campaign_data['spend_currency'] += $statRow['spend_currency'];		
	//     $campaign_data['request_count'] += $statRow['request_count'];
		
 //        }
 //        if($campaign_data['request_count']>0)
 //        {
	//        $campaign_data['win_rate'] = ($campaign_data['imp']/$campaign_data['request_count'])*100;
 //        }else{
 //            $campaign_data['win_rate']=0;
 //
//        }	

//		 echo $this->advertiserdata['advertiser_id'];
//print_r("========================================================");exit();

          $statData= $users = DB::table('motion_general_report')->where('date', '>=', $start)->where('date', '<=', $end)->get();
         
           //$statData = $statData->toArray();
//iasdas

             $campaign_data = array();
        
              $campaign_data['clicks'] = 0;
             $campaign_data['imp'] = 0;
             $campaign_data['win_rate'] = 0;
             $campaign_data['spend_currency'] = 0;

          foreach ($statData as $statRow) {
            //$statRow = $statRow->toArray();
           


             $campaign_data['clicks'] += $statRow->clicks;
             $campaign_data['imp'] += $statRow->impression;
             $campaign_data['win_rate'] += $statRow->ctr;
             $campaign_data['spend_currency'] += $statRow->spend;

          }

        $stvdata = array('data' => $campaign_data);
        return json_encode($stvdata);
		}else{
		return HTTP_REQUEST_NOT_ACCEPTED;
		}
    }

    
    public function getTotalSiteReportAdvertiser(Request $request) {

        if(true){   
        if (isset($request->start) && !empty($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->start = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        }

        if (isset($request->end) && !empty($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->end = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        }
        $start = ( $request->start ) ? $request->start : '';
        $end = ( $request->end ) ? $request->end : '';

        //->select('sum(clicks) as clicks, sum(impression) as impression, sum(spend) as spend, ctr')

          $statData= $users = DB::table('motion_sitewise_report')
                  ->select(DB::raw('sum(clicks) as clicks, sum(impression) as impression, sum(spend) as spend, ctr'))
                  ->where('date', '>=', $start)
                  ->where('date', '<=', $end)
                  ->where('status', '=', '1')
                  ->groupby("publisher")->get();
         
           //$statData = $statData->toArray();


             $campaign_data = array();
        
              $campaign_data['clicks'] = 0;
             $campaign_data['imp'] = 0;
             $campaign_data['win_rate'] = 0;
             $campaign_data['spend_currency'] = 0;

          foreach ($statData as $statRow) {
            //$statRow = $statRow->toArray();
           


             $campaign_data['clicks'] += $statRow->clicks;
             $campaign_data['imp'] += $statRow->impression;
             $campaign_data['win_rate'] += $statRow->ctr;
             $campaign_data['spend_currency'] += $statRow->spend;

          }

        $stvdata = array('data' => $campaign_data);
        return json_encode($stvdata);
		}else{
		return HTTP_REQUEST_NOT_ACCEPTED;
		}
    }

    public function getAdminPubInfo(Request $request) {

       // echo "<pre>";print_r($request->all());die;

        if(isset($request->start) && !empty($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('Y-m-d', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        }

        if(isset($request->end) && !empty($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('Y-m-d', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        }

        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start : "";
        $end = ( $request->end ) ? $request->end : "";

        //getting the stat records
        $statModel = new \App\Publisher();

        $statData = $statModel::leftJoin('hourly_stat', function( $join ) {
                    $join->on('publishers.publisher_id', '=', 'hourly_stat.publisher_id');
                });
//                ->where('adacts_stat.advertiser_id', Session::get('UserID'))


        if ($start != "" && $end != ""){
            $statData = $statData->whereBetween("hourly_stat.stat_date", array($start, $end));
        }else{
            $start = $request->start = date('Y-m-d');
            $end = $request->end = date('Y-m-d');
            $statData = $statData->whereBetween("hourly_stat.stat_date", array($start, $end));
        }

        $statData = $statData->selectRaw("hourly_stat.stat_date,sum(hourly_stat.request_count) as request_count,sum(hourly_stat.bid_count) as bid_count,sum(hourly_stat.win_count) as win_count,sum(hourly_stat.impression_count) as impression_count,publishers.company,hourly_stat.publisher_id")
                ->groupBy('publishers.publisher_id')
                ->groupBy('hourly_stat.stat_date')
                ->where('hourly_stat.publisher_id', '!=', "NULL")
                //->take($take)
                ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        //echo "<pre>";print_r( $statData->toJson() );die;
        return $statData->toJson();
    }
    
    public function getAdvertiserListInfo(Request $request) {

        //echo "<pre>";print_r($request);die;
        

        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start : "";
        $end = ( $request->end ) ? $request->end : "";

        //getting the stat records
        $statModel = new \App\Advertiser();

        $statData = $statModel::leftJoin('cf_users', function( $join ) {
                    $join->on('dl_advertisers.account_id', '=', 'cf_users.default_account_id');
                });
//                ->where('adacts_stat.advertiser_id', Session::get('UserID'))


//        if ($start != "" && $end != "")
//            $statData = $statData->whereBetween("adacts_stat.timestamp", array($start, $end));

        $statData = $statData->selectRaw("dl_advertisers.account_id as ids,dl_advertisers.contact_name as name, dl_advertisers.company as comp,dl_advertisers.contact_email as email,dl_advertisers.contact_mobile as mobile")
//                ->groupBy('publishers.publisher_id')
                ->orderBy('dl_advertisers.company','DESC')
                ->where('dl_advertisers.status', '=', "1")
                ->where('cf_users.is_active', '=', "1")
                //->take($take)
                ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        //echo "<pre>";print_r( $statData->toJson() );die;
        return $statData->toJson();
    }
    
    public function getBillingInfo(Request $request) {

        //echo "<pre>";print_r($request);die;
        

        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $id = ( $request->adv_id ) ? $request->adv_id : "";
        

        //getting the stat records
        $statModel = new \App\Advertiser();

        $statData = $statModel::leftJoin('cf_users', function( $join ) {
                    $join->on('dl_advertisers.account_id', '=', 'cf_users.default_account_id');
                });
//                ->where('adacts_stat.advertiser_id', Session::get('UserID'))


//        if ($start != "" && $end != "")
//            $statData = $statData->whereBetween("adacts_stat.timestamp", array($start, $end));

        $statData = $statData->selectRaw("dl_advertisers.company as comp, dl_advertisers.account_id as ids, dl_advertisers.billing_address bill_address, dl_advertisers.billing_city as bill_city, dl_advertisers.billing_state as bill_state, dl_advertisers.billing_country as bill_country, dl_advertisers.billing_pin_code as bill_pin, dl_advertisers.billing_contact_email as bill_email, dl_advertisers.billing_contact_name as bill_name, dl_advertisers.billing_phone as bill_phone")
//                ->groupBy('publishers.publisher_id')
//                ->orderBy('dl_advertisers.company','DESC')
//                ->where('dl_advertisers.status', '=', "1")
                ->where('dl_advertisers.account_id', '=', $id)
                //->take($take)
                ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        //echo "<pre>";print_r( $statData->toJson() );die;
        return $statData->toJson();
    }

    public function getAdvPageInfo(Request $request) {

        //echo "<pre>";print_r($request);die;
        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start : "";
        $end = ( $request->end ) ? $request->end : "";
        $adv_id = ( $request->adv_id ) ? $request->adv_id : 0;
        //getting the stat records
        $statModel = new \App\CampaignWebpage();


        if ($start != "" && $end != "") {

            $statData = $statModel::leftJoin('adacts_stat_page', function( $join ) {
                        $join->on('advertiser_webpage.page_id', '=', 'adacts_stat_page.page_id');
                    })->whereBetween("adacts_stat_page.stat_date", array($start, $end))
                    ->where("advertiser_webpage.advertiser_id", "=", $adv_id)
                    ->selectRaw("sum(adacts_stat_page.clicks_count) as total_clicks,advertiser_webpage.page_id")
                    ->groupBy('advertiser_webpage.page_id')
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        } else {

            $statData = $statModel::leftJoin('adacts_stat_page', function( $join ) {
                        $join->on('advertiser_webpage.page_id', '=', 'adacts_stat_page.page_id');
                    })->where("advertiser_webpage.advertiser_id", "=", $adv_id)
                    ->selectRaw("sum(adacts_stat_page.clicks_count) as total_clicks,advertiser_webpage.page_id")
                    ->groupBy('advertiser_webpage.page_id')
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        }

        return $statData->toJson();
    }

    public function getAdminPubList() {
        $statData = DB::select("select publisher_id,company from publishers where status='1' and admin_status='approved'");
        //$data=json_encode($statData);
//                ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        $result['data'] = $statData;
        $data = json_encode($result);
        return $data;
    }

//    
//    public function getAdminPubList() {
//        $statData = selectRaw("publishers.publisher_id,publishers.company")
//                    ->where("publishers.status", "=", "1")
//                    ->where("publishers.admin_status", "=", "approved");
//        
////                ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
//                    return $statData->toJson();
//    }

    public function getAdminAdInfo(Request $request) {



        //echo "<pre>";print_r($request);die;
        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start : "";
        $end = ( $request->end ) ? $request->end : "";
        $all_live = ( $request->live == 1 ) ? 1 : 0;
        //getting the stat records
        $statModel = new \App\Campaigns();


        if ($start != "" && $end != "") {

            $end = date('Y-m-d H:i:s', strtotime("+1 days $end"));
            $statData = $statModel::leftJoin('adacts_stat', function( $join ) {
                        $join->on('adacts_stat.id', '=', 'dl_campaigns.campaign_id');
                    })->leftJoin('ads', function( $join ) {
                        $join->on('ads.campaign_id', '=', 'dl_campaigns.campaign_id');
                    })->selectRaw("dl_campaigns.campaign_id,dl_campaigns.campaign_name,dl_campaigns.status,round(dl_campaigns.min_unit_price,3) as min_unit_price,round(dl_campaigns.campaign_budget,3) as campaign_budget, adacts_stat.ad_id, sum(adacts_stat.impression) as imp, sum(adacts_stat.clicks_count) as clicks,round(sum(adacts_stat.revenue_value),3) as spend, sum(adacts_stat.conversions_count) as conv,ads.admin_cpm as adcpm,ads.current_cpm as curcpm,dl_campaigns.cpa_id as cpa_id,dl_campaigns.adomain as adomain,dl_campaigns.admin_status,ads.ad_status,ads.admin_status as admin_status_ad,ads.publisher_id as pubid")
                    ->groupBy('dl_campaigns.campaign_id')
                    ->whereBetween("dl_campaigns.create_date_time", array(date($start), date($end)))
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        } elseif ($all_live) {

            $statData = $statModel::leftJoin('adacts_stat', function( $join ) {
                        $join->on('adacts_stat.id', '=', 'dl_campaigns.campaign_id');
                    })->leftJoin('ads', function( $join ) {
                        $join->on('ads.campaign_id', '=', 'dl_campaigns.campaign_id');
                    })
                    ->where("dl_campaigns.status", "=", "running")
                    ->where("dl_campaigns.admin_status", "=", "approved")
                    ->where("ads.ad_status", "=", "1")
                    ->where("ads.admin_status", "=", "approved")
                    ->selectRaw("dl_campaigns.campaign_id,dl_campaigns.campaign_name,dl_campaigns.status,round(dl_campaigns.min_unit_price,3) as min_unit_price,round(dl_campaigns.campaign_budget,3) as campaign_budget, adacts_stat.ad_id, sum(adacts_stat.impression) as imp, sum(adacts_stat.clicks_count) as clicks,round(sum(adacts_stat.revenue_value),3) as spend, sum(adacts_stat.conversions_count) as conv,ads.admin_cpm as adcpm,ads.current_cpm as curcpm,dl_campaigns.cpa_id as cpa_id,dl_campaigns.adomain as adomain,dl_campaigns.admin_status,ads.ad_status,ads.admin_status as admin_status_ad,ads.publisher_id as pubid")
                    ->groupBy('dl_campaigns.campaign_id')
                    //->take($take)
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        } else {

            $statData = $statModel::leftJoin('adacts_stat', function( $join ) {
                        $join->on('adacts_stat.id', '=', 'dl_campaigns.campaign_id');
                    })->leftJoin('ads', function( $join ) {
                        $join->on('ads.campaign_id', '=', 'dl_campaigns.campaign_id');
                    })->selectRaw("dl_campaigns.campaign_id,dl_campaigns.campaign_name,dl_campaigns.status,round(dl_campaigns.min_unit_price,3) as min_unit_price,round(dl_campaigns.campaign_budget,3) as campaign_budget, adacts_stat.ad_id, sum(adacts_stat.impressions) as imp, sum(adacts_stat.clicks_count) as clicks,round(sum(adacts_stat.revenue_value),3) as spend, sum(adacts_stat.conversions_count) as conv,ads.admin_cpm as adcpm,ads.current_cpm as curcpm,dl_campaigns.cpa_id as cpa_id,dl_campaigns.adomain as adomain,dl_campaigns.admin_status,ads.ad_status,ads.admin_status as admin_status_ad,ads.publisher_id as pubid")
                    ->groupBy('dl_campaigns.campaign_id')
                    ->whereDate('dl_campaigns.create_date_time', '=', date('Y-m-d'))

                    //->take($take)
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
            //select count(*) as aggregate from `dl_campaigns` left join `adacts_stat` on `dl_campaigns`.`campaign_id` = `adacts_stat`.`campaign_id` left join `ads` on `ads`.`campaign_id` = `adacts_stat`.`campaign_id` group by `dl_campaigns`.`campaign_id
        }
        //echo "<pre>";print_r( $statData->toJson() );die;
        return $statData->toJson();
    }

    /*
      get ads running info in json format
     *  */

    public function geAdDetail(Request $request) {

        $campagin_id = $request->campaign_id;
        //$campagin_id=1; 
        //getting the stat records
        $camModel = new \App\Campaigns();

        $camData = $camModel::leftJoin('ads', function( $join ) {
                    $join->on('dl_campaigns.campaign_id', '=', 'ads.campaign_id');
                })->leftJoin('creative_groups', function( $join ) {
                    $join->on('creative_groups.group_id', '=', 'ads.creative_ids');
                })->leftJoin('ad_channel_group_assoc', function( $join ) {
                    $join->on('ad_channel_group_assoc.ad_id', '=', 'ads.ad_id');
                })->leftJoin('targeting_channel_group', function( $join ) {
                    $join->on('targeting_channel_group.channel_group_id', '=', 'ad_channel_group_assoc.channel_id');
                })
                ->where('dl_campaigns.campaign_id', $campagin_id)
                ->selectRaw("ad_channel_group_assoc.ad_targetting_group_id,dl_campaigns.*,dl_campaigns.activate_date_time as activate_date_times,dl_campaigns.expire_date_time as expire_date_times,ads.*,targeting_channel_group.*,creative_groups.*,creative_groups.update_date_time as creative_time,ads.creative_ids,ads.native_title,ads.native_description,ads.native_brand_name,ads.native_clicktoaction")
                ->get();

//        echo "<pre>";print_r( $camData );die;
        return $camData->toJson();
    }

    /*
      get ads running info in json format
     *  */

    public function getProfileDetail(Request $request) {

        $user_id = $request->user_id;
        $userModel = new \App\User();
        $statData = $userModel::where('user_id', '=', $user_id)->get();
        $final_array = array();
        if (count($statData) > 0) {
            foreach ($statData as $key => $val) {
                $final_array[] = $val['attributes'];
            }
        }
        //print_r($final_array);die;
        return json_encode($final_array);
    }

    public function getusr(Request $request) {

        $user_id = $request->email_address;
        $userModel = new \App\User();
        $statData = $userModel::where('email_address', 'like', '%'.$user_id.'%')->get();
        $final_array = array('status' => 0);
        if (count($statData) > 0) {
            foreach ($statData as $key => $val) {
                if ($val['attributes']['user_id'] != '') {
                    $final_array = array('status' => 1);
                }
            }
        }
        // print_r($final_array);die;
        return json_encode($final_array);
    }

    /*
      get timezone data
     *  */

    public function getTimezoneData(Request $request) {

        $userModel = new \App\TimezoneData();
        $statData = $userModel::whereNotNull('id')->get();
        //print_r($final_array);die;
        return $statData->toJson();
    }

    public function getCountriesfil() {
        $q = $_GET["q"];
        $getAll = new \App\Country;

        $pos = strpos($q, ',');
        if ($pos === false) {
            $statData = $getAll::where('iso3', '=', $q)->get();
        } else {
            $expd = explode(',', $q);

            $statData = $getAll::whereIn('iso3', $expd)->get();
        }

        $final_array = '';
        if (count($statData) > 0) {

            foreach ($statData as $key => $value) {
                // echo '<pre>';
                // print_r($value);die();
                // $final_array[]=$value;
                $final_array .='<option value="' . $value['iso'] . '">' . $value['name'] . '</option>';
            }
        }

        return $final_array;

//	print_r($getAll->toJson());
    }

    public function getCountriesName() {
        $q = $_GET["q"];
        $getAll = new \App\Country;

        $pos = strpos($q, ',');
        if ($pos === false) {
            $statData = $getAll::where('iso3', '=', $q)->get();
        } else {
            $expd = explode(',', $q);

            $statData = $getAll::whereIn('iso3', $expd)->get();
        }

        $final_array = array();
        if (count($statData) > 0) {

            foreach ($statData as $key => $value) {
// echo '<pre>';
// print_r($value);die();
                $final_array[] = $value;
            }
        }

        return $final_array;
    }

    /*
      get publisher report info in json format
     *  */
    //tbd
    public function getPubReport(Request $request) {

        //$dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', $request->start_date);
        //print_r($dateTimeObj);exit

        if (!isset($request->start_date)) {

            $dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', date("d-m-Y") . ' 00:00:00');
            //$dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', '2016-08-20 00:00:00');
            //$request->start_date = date("Y-m-d");
        } else {
            if (!isset($request->hour)) {
                $start = $request->start_date . " 00:00:00";
            } else {
                $start = $request->start_date . " " . str_pad($request->hour, 2, "0", STR_PAD_LEFT) . ':00:00';
            }
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', $start);
            //$dateTimeObj = \DateTime::createFromFormat('Y-m-d H:i:s', '2016-08-20 00:00:00');
        }

        $dateTimeObj->setTimezone(new \DateTimeZone('Asia/Kolkata'));
        $sMinute = $dateTimeObj->format('i');
        if ($sMinute <= 30) {
            $sstat_slot = 1;
        } else {
            $sstat_slot = 2;
        }

        $sdt = $dateTimeObj->format('YmdH') . $sstat_slot;
        if (!isset($request->end_date)) {
            $request->end_date = date("Y-m-d");
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', date("d-m-Y") . ' 23:59:59');
        } else {

            if (!isset($request->hour)) {
                $end = $request->end_date . " 23:59:59";
            } else {
                $end = $request->end_date . " " . str_pad($request->hour, 2, "0", STR_PAD_LEFT) . ':59:59';
            }
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', $end);
        }
        $dateTimeObj->setTimezone(new \DateTimeZone('Asia/Kolkata'));
        $eMinute = $dateTimeObj->format('i');
        if ($eMinute <= 30) {
            $estat_slot = 1;
        } else {
            $estat_slot = 2;
        }

        $edt = $dateTimeObj->format('YmdH') . $estat_slot;
        $statModel = new \App\publisherStat();
        $statData = $statModel::where('publisher_id', $this->session['sessiondata']['accounts'][0]['publisher_id'])
                ->where('date_key', '>=', $sdt)
                ->where('date_key', '<=', $edt)
                ->selectRaw("date_key,ad_spot_id,"
                        . "sum(request_count) as request_count ,"
                        . "sum(bid_count) as bid_count,"
                        . "sum(impressions) as impression_count,"
                        . "sum(win_count) as win_count,"
                        . "sum(clicks_count) as clicks_count,"
                        . "sum(total_win_cost) as total_cost,"
                        . "stat_date,ad_spot_id")
                ->groupBy('date_key', 'ad_spot_id')
                ->orderBy('date_key', 'dsc')
                ->orderBy('ad_spot_id', 'asc')
                ->get();
        $pubStat = array();
        $pubStat['data'] = array();
        $pubStat['type'] = 'hourly';
        $pubStat['data_total']['request_total'] = 0;
        $pubStat['data_total']['bid_total'] = 0;
        $pubStat['data_total']['imp_total'] = 0;
        $pubStat['data_total']['win_total'] = 0;
        $pubStat['data_total']['clicks_total'] = 0;
        $pubStat['data_total']['income_total'] = 0;
        //stored data in db is in Asia/Kolkata, $dateTimeObj should be created from this timezone
        date_default_timezone_set('Asia/Kolkata');
        $last_updated = $this->getLastUpdatedStatsTS($this->session['sessiondata']['accounts'][0]['publisher_id']);
        $dateTimeObj = \DateTime::createFromFormat('Y-m-d H:i:s', $last_updated);
        $dateTimeObj->setTimezone(new \DateTimeZone($this->session['sessiondata']['user_timezone']));
        $stats_last_updated = $dateTimeObj->format('Y-m-d H:i:s');
        $pubStat['stats_last_updated'] = 'Report last updated '.$dateTimeObj->format('h:i A, d-m-Y T') ;
        foreach ($statData as $statRow) {
            $date_key = $statRow['date_key'];
            $minute = substr($date_key, 10, 1);
            if ($minute) {
                $mkey = ':29:59';
            } else {
                $mkey = ':59:59';
            }
            //create dateTimeObj from Asia/Kolkata
            $dateTimeObj = \DateTime::createFromFormat('YmdH:i:s', substr($date_key, 0, 10) . $mkey);
            //change date time to user's timezone
            $dateTimeObj->setTimezone(new \DateTimeZone($this->session['sessiondata']['user_timezone']));
            $statUserDate = $dateTimeObj->format('d-m-Y');
            $statUserHour = $dateTimeObj->format('H');
            if (!$statRow['ad_spot_id']) {
                $statRow['ad_spot_id'] = 0;
            }
            if ($request->start_date != $request->end_date || 1) {
                if (!isset($pubStat['data'][$statUserDate][$statRow['ad_spot_id']])) {
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['request_count'] = 0;
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['bid_count'] = 0;
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['impression_count'] = 0;
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['win_count'] = 0;
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['clicks_count'] = 0;
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['total_cost'] = 0;
                }

                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['request_count'] += $statRow['request_count'];
                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['bid_count'] += $statRow['bid_count'];
                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['impression_count'] += $statRow['impression_count'];
                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['win_count'] += $statRow['win_count'];
                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['clicks_count'] += $statRow['clicks_count'];
                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['total_cost'] += $statRow['total_cost'];

                $pubStat['type'] = 'daily';
            } /* else {
              if (!isset($pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']])) {
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['request_count'] = 0;
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['bid_count'] = 0;
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['impression_count'] = 0;
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['win_count'] = 0;
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['clicks_count'] = 0;
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['total_cost'] = 0;
              }

              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['request_count'] += $statRow['request_count'];
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['bid_count'] += $statRow['bid_count'];
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['impression_count'] += $statRow['impression_count'];
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['win_count'] += $statRow['win_count'];
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['clicks_count'] += $statRow['clicks_count'];
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['total_cost'] += $statRow['total_cost'];
              $pubStat['type'] = 'hourly';
              } */

            $pubStat['data_total']['request_total'] += $statRow['request_count'];
            $pubStat['data_total']['bid_total'] += $statRow['bid_count'];
            $pubStat['data_total']['imp_total'] += $statRow['impression_count'];
            $pubStat['data_total']['win_total'] += $statRow['win_count'];
            $pubStat['data_total']['clicks_total'] += $statRow['clicks_count'];
            $pubStat['data_total']['income_total'] += $statRow['total_cost'];
        }
        $pubStat['today_total'] = json_decode($this->getTotalPubReport(), true);
        date_default_timezone_set($this->session['sessiondata']['user_timezone']);
        return json_encode($pubStat);
    }
    //tbd
    public function getTotalPubReport() {
        //carete dateTimeObj from user's timezone
        $dateTimeObj = \DateTime::createFromFormat('Y-m-d H:i:s', date("Y-m-d") . ' 00:00:00');
        //convert datetimezone to Asia/Kolkata as data in db is ist
        $dateTimeObj->setTimezone(new \DateTimeZone('Asia/Kolkata'));
        $sMinute = $dateTimeObj->format('i');
        if ($sMinute <= 30) {
            $sstat_slot = 1;
        } else {
            $sstat_slot = 2;
        }

        $sdt = $dateTimeObj->format('YmdH') . $sstat_slot;
        $dateTimeObj = \DateTime::createFromFormat('Y-m-d H:i:s', date("Y-m-d") . ' 23:59:59');
        $dateTimeObj->setTimezone(new \DateTimeZone('Asia/Kolkata'));
        $eMinute = $dateTimeObj->format('i');
        if ($eMinute <= 30) {
            $estat_slot = 1;
        } else {
            $estat_slot = 2;
        }

        $edt = $dateTimeObj->format('YmdH') . $estat_slot;
        //getting the stat records total
        $statModel = new \App\publisherStat();
        $statData = $statModel::where('publisher_id', $this->session['sessiondata']['accounts'][0]['publisher_id'])
                ->where('date_key', '>=', $sdt)
                ->where('date_key', '<=', $edt)
                ->selectRaw("sum(request_count) as request_count ,"
                        . "sum(bid_count) as bid_count,"
                        . "sum(impression_count) as impression_count,"
                        . "sum(win_count) as win_count,"
                        . "sum(clicks_count) as clicks_count,"
                        . "sum(total_win_cost) as total_cost")
                ->get();
        return $statData->toJson();
    }

    private function getLastUpdatedStatsTS($pubId = 0) {
        if ($pubId == 0)
            $last_updated = \App\hourlyStat::max('update_datetime');
        else
            $last_updated = \App\hourlyStat::where('publisher_id', $pubId)->max('update_datetime');
        return $last_updated;
    }

    public function getPubId($userId) {

        if ($userId) {

            $publisher = DB::table('publishers')->where('account_id', $userId)->first();
            if ($publisher->publisher_id > 0) {

                return $publisher->publisher_id;
            }
        }

        return null;
    }

   /* public function delCreativeGroupItems(Request $request) {

        $group_id = $request->group_id;
        $previous_img = $request->previous_img;

        if ($group_id) {

            $group_model = new \App\CreativeGroup();
            $group_model::find($group_id);
            $group_model->file_name = '';
            $group_model->content_dimensions = '';
            $group_model->content_extensions = '';
            $group_model->save();
            return '{"status": "ok"}';
        }
    }
	*/

public function delCreativeSingleItems(Request $request){

            echo '<pre>';
            print_r($request->all());
            echo '<pre>';
            exit();

        $group_id = $request->group_id;
        $previous_img = $request->previous_img;
        $ad_id = $request->ad_id;

        if ($group_id) {
             $pos = strpos(trim($group_id), ',');
            if($pos === false){
                   $adsModel = \App\Ads::find($ad_id);
                $adsModel->creative_ids='';
                $adsModel->save();
 
                 $group_model = \App\CreativeGroup::find($group_id);
                 $group_model->delete();
                
           
            
            }else{
                $group_idArr=explode(",",$group_id);
          $adsModel = \App\Ads::find($ad_id);
                $adsModel->creative_ids='';
                $adsModel->save();
                foreach($group_idArr as $key=>$group_ids){
                   $group_model = \App\CreativeGroup::find($group_ids);
                 $group_model->delete();
                }
            }
        }
        return '{"status": "ok"}';

}

public function delCreativeGroupItems(Request $request) {
     $group_id = $request->group_id;
        $previous_img = $request->previous_img;
    $ad_id = $request->ad_id;

        if ($group_id) {
             $pos = strpos(trim($group_id), ',');
            if($pos === false){
                   $adsModel = \App\Ads::find($ad_id);
                $adsModel->creative_ids='';
                $adsModel->save();
 
                 $group_model = \App\CreativeGroup::find($group_id);
                 $group_model->delete();
                
           
            
            }else{
                $group_idArr=explode(",",$group_id);
          $adsModel = \App\Ads::find($ad_id);
                $adsModel->creative_ids='';
                $adsModel->save();
                foreach($group_idArr as $key=>$group_ids){
                   $group_model = \App\CreativeGroup::find($group_ids);
                 $group_model->delete();
                }
            }
        }
        return '{"status": "ok"}';
    }
    public function adCpmCampaign(Request $request) {

        $cmpid = $request->cmpid;
        $cpmval = $request->cpmval;

        $adsModel = \App\Ads::where('ad_id', "=", $cmpid)
                ->update(['admin_cpm' => $cpmval]);

        $str_status = array('status' => 'Updated Successfully.');

        return json_encode($str_status);
    }

    public function adCpaIdCampaign(Request $request) {
        $cmpid = $request->cmpid;
        $cpmval = $request->cpmval;

        $adsModel = \App\Campaigns::where('campaign_id', $cmpid)
                ->update(['cpa_id' => $cpmval]);

        $str_status = array('status' => 'Updated Successfully.');
        return json_encode($str_status);
    }

    public function editcheck_balance_left_dollar(Request $request) {
        $sessiondata = Session::get('sessiondata');
        $advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
        $post_value = $request->post_value;
        $result = DB::table('dl_advertisers')->select('balance_left_currency')->where('advertiser_id', $advertiser_id)->get();

        if($post_value <= 0)
        {

            if (!empty($result)) {
                $balance_left_dollar = $result[0]->balance_left_currency;
            }

            if($balance_left_dollar <= 0)
                return 2;
            else
            {
                return 1;
            }
        }



        if (!empty($result)) {

            $balance_left_dollar = $result[0]->balance_left_currency;

            if ($post_value > $balance_left_dollar) {
                return 2;
            } else {

                return 1;
            }
        } else {
            return 2;
        }
    }

    public function adAdomianCampaign(Request $request) {

        $cmpid = $request->cmpid;
        $cpmval = $request->cpmval;

        $adsModel = \App\Campaigns::where('campaign_id', $cmpid)
                ->update(['adomain' => "'" . $cpmval . "'"]);

        $str_status = array('status' => 'Updated Successfully.');
        return json_encode($str_status);
    }

    public function getAllCampaign(Request $request)
    {

        if(Auth::check()){
            $condition=[];
            if(isset($request->term) || $request->term!='')
            {
                array_push($condition, ['campaign_name','like' ,$request->term.'%']);
            }
            $campagins = \App\Campaigns::select('campaign_id as id','campaign_name as text')
                        ->where('advertiser_id', $this->advertiserdata['advertiser_id'])
                        ->where($condition)
                        ->get()->toArray();
            $all=[];
            array_push($campagins, ['id'=> '-1','text' => 'All Campaigns', "selected" => true]);
            $result=array('results' => $campagins);
            return json_encode($result);
        }

    }

    public function getAdvId($userId) {

        if ($userId) {
            $publisher = DB::table('dl_advertisers')->where('account_id', $userId)->first();
            if ($publisher->advertiser_id > 0) {
                return $publisher->advertiser_id;
            }
        }

        return null;
    }
    
    public function saveBillingInfo(Request $request) {

        $id = $request->adv_id;
        $company = $request->comp;
        $addr = $request->add;
        $city = $request->cit;
        $state = $request->stat;
        $country = $request->coun;
        $pin = $request->pi;
        $mail = $request->mail;
        $name = $request->name;
        $phone = $request->phn;

        $adsModel = \App\Advertiser::where('account_id', $id)
                ->update(['company' => $company ,'billing_address' => $addr ,'billing_city' => $city ,'billing_state' => $state ,'billing_country' => $country ,'billing_pin_code' => $pin ,'billing_contact_email' => $mail ,'billing_contact_name' => $name ,'billing_phone' => $phone ]);

        $str_status = array('status' => 'Updated Successfully.');
        return json_encode($str_status);
    }


}
