<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Validator;
use Auth;
use Hash;
use App\User;
use Softon\Indipay\Facades\Indipay;
use App\Account;
use App\CurrencyDatabase;
use Detection\MobileDetect as MobileDetect;

/*PayPal*/
use Illuminate\Support\Facades\Input;
use PayPal\Api\Amount;
use PayPal\Api\Details;
use PayPal\Api\Item;
/** All Paypal Details class **/
use PayPal\Api\ItemList;
use PayPal\Api\Payer;
use PayPal\Api\Payment;
use PayPal\Api\PaymentExecution;
use PayPal\Api\RedirectUrls;
use PayPal\Api\Transaction;
use PayPal\Auth\OAuthTokenCredential;
use PayPal\Rest\ApiContext;
use Redirect;
use URL;

class PaymentController extends Controller {
    /* public function __construct() {
      $this->middleware('auth');
      } */
private $_api_context;

    public function __construct() {
        $this->session = SESSION::All();
        if(isset($this->session['sessiondata'])){
		$this->advertiserdata = Account::find($this->session['sessiondata']['accounts'][0]['account_id'])->advertiser;
		$this->advertiserdata = $this->advertiserdata->toArray();
        $this->currency = !empty($this->advertiserdata['currency']) ? $this->advertiserdata['currency'] : 'INR';
        $this->currencyminarray = config('paymentgateway.currencyminarray');
        $this->currencymin = $this->currencyminarray[$this->currency];
        $this->advertiserdata['currencymin'] = $this->currencymin;

         $paypal_conf = \Config::get('paypal');
        $this->_api_context = new ApiContext(new OAuthTokenCredential(
            $paypal_conf['sandbox_client_id'],
            $paypal_conf['sandbox_secret'])
        );
        $this->_api_context->setConfig($paypal_conf['settings']);

		}
    }

    public function getReport() {

        return view('mypayments');
    }

    public function addfunds() {
        
        $detect = new MobileDetect();
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
        $advertiserdata = Account::find($this->session['sessiondata']['accounts'][0]['account_id'])->advertiser;
        $advertiserdata = $advertiserdata->toArray();
        if ($this->currency == 'INR') {
             $json_url = url("json-data/get-countries");
              $json = file_get_contents($json_url);
              $data = json_decode($json, true);

              // return view('addfundshdfc', ['advertiserdata' => $this->advertiserdata, 'countries' => $data]); */
            if ($deviceType == 'computer') {
            // return view('addfunds', ['advertiserdata' => $this->advertiserdata]);
               return view('addfundshdfc',['advertiserdata' => $this->advertiserdata,'countries' => $data]); 
            }else{
                // return view('mob-addfunds', ['advertiserdata' => $this->advertiserdata]);
                return view('mob-addfundshdfc', ['advertiserdata' => $this->advertiserdata,'countries' => $data]);
            }
        } else {

            $json_url = url("json-data/get-countries");
            $json = file_get_contents($json_url);
            $data = json_decode($json, true);
            if ($deviceType == 'computer') {
            return view('addfundshdfc', ['advertiserdata' => $this->advertiserdata, 'countries' => $data]);
            }else{
              return view('mob-addfundshdfc', ['advertiserdata' => $this->advertiserdata, 'countries' => $data]);
            }
        }
    }

    public function paymentRequest(Request $request) {

        if (!Auth::check()) {
            return redirect("/login");
            // The user is not logged in...
        }
         $detect = new MobileDetect();
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');

        $advertiserdata = Account::find($this->session['sessiondata']['accounts'][0]['account_id'])->advertiser;

        $advertiserdata = $advertiserdata->toArray();


        $currency = !empty($advertiserdata['currency']) ? $advertiserdata['currency'] : 'INR';

        $currencyminarray = config('paymentgateway.currencyminarray');

        $currencymin = $currencyminarray[$currency];

        //get the country id
        $request->country = $this->session['sessiondata']['country_id'];

        $request->currency = $currency;

        $request->currencymin = $currencymin;

        $mobile = ($request->mobile) ? $request->mobile : "";

        $validator = Validator::make(
                        array(
                    'amount' => $request->amount, 'Phone' => $request->contact_mobile,
                        ), array(
                    'amount' => 'required|numeric|min:' . $currencymin, 'Phone' => 'required|numeric|min:10',
                        )
        );
        if ($validator->fails()) {

            return redirect('myaccount/addfunds')->withErrors($validator)->withInput();
        }

        if ($mobile != "") {

            return $this->paymentRequestFortumo($request);
        } else {

            if ($currency == 'INR') {

                return $this->paymentRequestPayu($request);
            } else {
                return $this->paymentRequestHDFC($request);
            }
        }   
        /*
          if (!empty($this->session['responseretry']) || isset($this->session['responseretry'])) {
          $previousGatewayId = SESSION::Pull('responseretry');
          } else {
          $previousGatewayId = 0;
          }

          $gatewayId = 0;


          $gatewayfallback = config('paymentgateway.gatewayfallback');

          $totalgateways = count($gatewayfallback);

          if ($previousGatewayId >= $totalgateways) {
          $previousGatewayId = 1;
          } else {
          $previousGatewayId++;
          }
          switch ($previousGatewayId) {

          case 1:
          //return $this->paymentRequestHDFC($request);
          return $this->paymentRequestPayu($request);
          break;
          case 2:
          return $this->paymentRequestPayu($request);
          //return $this->paymentRequestHDFC($request);
          break;
          } */
    }

    public function paymentRequestFortumo($request) {

         $detect = new MobileDetect();
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
        $advertiserdata = Account::find($this->session['sessiondata']['accounts'][0]['account_id'])->advertiser;
        $advertiserdata = $advertiserdata->toArray();

        //  $transaction_id = substr(md5(str_random(1000) . microtime()), rand(1, 15), 16);
        $transaction_id = time() . getmypid();
        $paymentTransactionModel = new \App\PaymentTransaction();
        $paymentTransactionModel->transaction_id = $transaction_id;
        $paymentTransactionModel->parent_id = 0;

        $paymentTransactionModel->account_id = $this->session['sessiondata']['accounts'][0]['account_id'];
        $paymentTransactionModel->user_id = $this->session['UserID'];
        $paymentTransactionModel->amount = $request->amount;
        $paymentTransactionModel->currency = $request->currency;
        $paymentTransactionModel->gateway_id = 3; //FORTUMO


        $paymentTransactionModel->stage = 1; //FIRST FORM SUBMIT
        $paymentTransactionModel->save();

        /* All Required Parameters by your Gateway */

        $parameters = [

            'txnid' => $transaction_id,
            'amount' => $request->amount,
            'currency' => $request->currency,
            'user_id' => $this->session['UserID'],
            'account_id' => $this->session['sessiondata']['accounts'][0]['account_id'],
            'advertiser_id' => $advertiserdata['advertiser_id'],
            'firstname' => $advertiserdata['contact_name'],
            'email' => $this->session['UserEmail'],
            'phone' => $request->mobile,
            'country' => $request->country,
            'productinfo' => htmlspecialchars("advt_payment"),
            "return_url" => url(config('paymentgateway.fortumo_return_url')),
        ];
        if ($deviceType == 'computer') {
        return view('paymentrequestfortumo', ['requestvars' => $parameters]);
        }else{
            return view('mob-paymentrequestfortumo', ['requestvars' => $parameters]);
        }
    }

    public function paymentRequestFortumoHid(Request $request) {

        $advertiserdata = Account::find($this->session['sessiondata']['accounts'][0]['account_id'])->advertiser;
        $advertiserdata = $advertiserdata->toArray();

        $parameters = [

            'txnid' => $request->txnid,
            'amount' => $request->amount,
            'currency' => $request->currency,
            'user_id' => $this->session['UserID'],
            'account_id' => $this->session['sessiondata']['accounts'][0]['account_id'],
            'advertiser_id' => $advertiserdata['advertiser_id'],
            'firstname' => $advertiserdata['contact_name'],
            'email' => $this->session['UserEmail'],
            'phone' => $request->phone,
            'country' => $request->country,
            'productinfo' => htmlspecialchars("advt_payment"),
            "return_url" => url(config('paymentgateway.fortumo_return_url')),
        ];

        return view('paymentrequestfortumohid', ['requestvars' => $parameters]);
    }

    public function paymentRequestPayu($request) {
        $advertiserdata = Account::find($this->session['sessiondata']['accounts'][0]['account_id'])->advertiser;
        $advertiserdata = $advertiserdata->toArray();
        $transaction_id = substr(md5(str_random(1000) . microtime()), rand(1, 15), 16);
        $paymentTransactionModel = new \App\PaymentTransaction();
        $paymentTransactionModel->transaction_id = $transaction_id;
        $paymentTransactionModel->parent_id = 0;
        $paymentTransactionModel->account_id = $this->session['sessiondata']['accounts'][0]['account_id'];
        $paymentTransactionModel->user_id = $this->session['UserID'];
        	 if($request->currency=='USD')
        {
           $amount= $request->amount * 74.05;
        }else{
               $amount= $request->amount;
        }
	$paymentTransactionModel->amount = $amount;
        $paymentTransactionModel->currency = $request->currency;
        $paymentTransactionModel->gateway_id = 1; //PAYU
        $paymentTransactionModel->stage = 1; //FIRST FORM SUBMIT
        // dd($paymentTransactionModel);
        $paymentTransactionModel->save();
        /* All Required Parameters by your Gateway */
        $parameters = [
            'txnid' => $transaction_id,
            'amount' => $amount,
            'userid' => $this->session['UserID'],
            'udf1' => $this->session['sessiondata']['accounts'][0]['account_id'],
            'udf2' => $advertiserdata['advertiser_id'],
            'firstname' => $advertiserdata['contact_name'],
            'email' => $this->session['UserEmail'],
            'phone' => ($request->contact_mobile !="") ? $request->contact_mobile : $request->phone ,
            'productinfo' => htmlspecialchars("advt_payment"),

        ];

        // dd($parameters);
// echo '<pre>';
// print_r($parameters);
// die();
        return Indipay::purchase($parameters);
    }

    public function paymentRequestHDFC(Request $request) {

 $detect = new MobileDetect();
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
        $validator = Validator::make(
                        array(
                    'amount' => $request->amount,
                    'name' => $request->name,
                    'email' => $request->email,
                    'phone' => $request->phone,
                    'address' => $request->address,
                    'city' => $request->city,
                    'country' => $request->country,
                    'postal_code' => $request->postal_code,
                        ), array(
                    'amount' => 'required|numeric|min:' . $this->currencymin,
                    'name' => 'required',
                    'email' => 'required|email',
                    'phone' => 'required',
                    'address' => 'required',
                    'city' => 'required',
                    'country' => 'required',
                    'postal_code' => 'required', 
                        )
        );

        if ($validator->fails()) {

            return redirect('myaccount/addfunds')->withErrors($validator)->withInput();

        }




        $transaction_id = substr(md5(str_random(1000) . microtime()), rand(1, 15), 16);

        $paymentTransactionModel = new \App\PaymentTransaction();

        $paymentTransactionModel->transaction_id = $transaction_id;
        $paymentTransactionModel->parent_id = 0;

        $paymentTransactionModel->account_id = $this->session['sessiondata']['accounts'][0]['account_id'];
        $paymentTransactionModel->user_id = $this->session['UserID'];
        $paymentTransactionModel->amount = $request->amount;
        $paymentTransactionModel->currency = $this->currency;
        $paymentTransactionModel->gateway_id = 2; //HDFC


        $paymentTransactionModel->stage = 1; //FIRST FORM SUBMIT
        $paymentTransactionModel->save();

        /* All Required Parameters by your Gateway */
        $value["channel"] = "10"; //required
        $value["account_id"] = config('paymentgateway.hdfcaccountid'); //required
        $value["reference_no"] = $transaction_id; // required
        $value["amount"] = $request->amount;
        $value["mode"] = "LIVE"; //required
        $value["currency"] = $this->currency; // required
        // $value["currency_code"] = $this->currency; // required
        $value["description"] = "advt_payment"; //requiredu
        $value["return_url"] = url(config('paymentgateway.hdfc_return_url'));
        $value["name"] = $this->advertiserdata['contact_name'];  //required
        $value["address"] = $request->address; //required
        $value["city"] = $request->city; //required
        $value["country"] = $request->country; //required
        $value["postal_code"] = $request->postal_code; //required
        $value["phone"] = $this->advertiserdata['contact_mobile']; //required
        $value["email"] = $this->advertiserdata['contact_email']; //required


        $value["ship_name"] = ""; //optional
        $value["ship_address"] = ""; //optional
        $value["ship_city"] = ""; //optional
        $value["ship_country"] = ""; //optional
        $value["ship_name"] = ""; //optional
        $value["ship_phone"] = ""; //optional
        $value["ship_postal_code"] = ""; //optional
        $value["ship_state"] = ""; //optional
        $value["state"] = ""; //optional
        ksort($value);

        $hashData = config('paymentgateway.hdfc_secret'); // Intialise with Secret Key
        // Sort the post parameters in alphabetical order of parameter names.
        //Append the posted values to $hashData

        foreach ($value as $key => $value1) {

//create the hashing input leaving out any fields that has no value and by concatenating the      values using a ‘|’ symbol.

            if (strlen($value1) > 0) {
                $hashData .= '|' . $value1;
            }
        }
        // echo $hashData; die();
// Create the secure hash and append it to the Post data

        if (strlen($hashData) > 0) {
            $hashvalue = strtoupper(md5($hashData));
            //$HASHING_METHOD = 'sha512';
            //$hashvalue  = strtoupper(hash($HASHING_METHOD, $hashData));
        }
        $value['secure_hash'] = $hashvalue;
         if ($deviceType == 'computer') {
        return view('paymentrequesthdfc', ['requestvars' => $value]);
         }else{
             return view('mob-paymentrequesthdfc', ['requestvars' => $value]);
         }
    }

    public function paymentResponsePayu(Request $request) {
         $detect = new MobileDetect();
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
        $response = Indipay::response($request);

        $paymentTransactionModel = new \App\PaymentTransaction();
        $paymentTransactionModel->user_id = $this->session['UserID'];
        $paymentTransactionModel->transaction_id = $response['txnid'];
        $paymentTransactionModel->parent_id = $response['txnid'];
        $paymentTransactionModel->account_id = $response['udf1'];
        //$paymentTransactionModel->advertiser_id = $response->udf2;
        $paymentTransactionModel->gateway_id = 1; //PAYU
        $paymentTransactionModel->stage = 2; //RESPONSE FROM PAYMENT GATEWAY
        $paymentTransactionModel->status_reason = $response['field9'];
        $paymentTransactionModel->gateway_transaction_id = $response['mihpayid'];
        $paymentTransactionModel->gateway_status_reason = $response['field9'];
        $paymentTransactionModel->extra = json_encode($response);
        $paymentTransactionModel->currency = 'INR';

        if ($response['status'] == 'failure') {
            $paymentTransactionModel->payment_status = 0;
        } elseif (strtolower($response['status']) == 'success') {
            $paymentTransactionModel->payment_status = 1;
            $paymentTransactionModel->payment_mode = $response['mode'];
            $paymentTransactionModel->amount = $response['amount'];
            //save data in credit table

            $accountFundsModel = new \App\AccountFunds();
            $accountFundsModel->transaction_id = $response['txnid'];
            $accountFundsModel->account_id = $response['udf1'];
            $accountFundsModel->user_id = $this->session['UserID'];
            $accountFundsModel->amount = $response['amount'];
            $accountFundsModel->currency = 'INR';
            $accountFundsModel->payment_status = strtoupper($response['status']);
            $accountFundsModel->debit_credit = 'CREDIT';
            if (strtolower($response['status']) == 'success' && !isset($this->session[$response['txnid']])) {
                $accountFundsModel->save();
                //convert added fund value to USD and add the same to dl_advertisers.balance_left_in_USD
                $this->addUSDFundToAdvertiser($response['amount'], 'INR');
            }
        }

        if (!isset($this->session[$response['txnid']])) {

            Session::Put($response['txnid'], 1);
            $paymentTransactionModel->save();
        }
        if ($deviceType == 'computer') {
        return view('paymentresponse', ['response' => $response]);
        }else{
             return view('mob-paymentresponse', ['response' => $response]);
        }
        //mail to user if transaction is successfull / failed
    }

    public function paymentResponseFortumo(Request $request) {
        $response = json_decode($request->data, true);

        $previousTransactionModal = new \App\PaymentTransaction();
        $previousTransaction = $previousTransactionModal::
                where(['transaction_id' => $response['cuid']])
                ->take(1)
                ->get();
        $currency = $previousTransaction[0]['currency'];
         $detect = new MobileDetect();
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');

        $paymentTransactionModel = new \App\PaymentTransaction();
        $paymentTransactionModel->user_id = $this->session['UserID'];
        $paymentTransactionModel->transaction_id = $response['cuid'];
        $paymentTransactionModel->parent_id = $response['cuid'];
        $paymentTransactionModel->account_id = $this->session['sessiondata']['accounts'][0]['account_id'];
        //$paymentTransactionModel->advertiser_id = $response->udf2;
        $paymentTransactionModel->gateway_id = 3; //FORTUMO
        $paymentTransactionModel->stage = 2; //RESPONSE FROM PAYMENT GATEWAY
        $rspStatus = '';
        if (preg_match("/completed/i", $response['status'])) {
            // mark payment as successful
            $rspStatus = 'success';
        } else {
            $rspStatus = 'failed';
        }
        $response['status'] = $rspStatus;
        $paymentTransactionModel->status_reason = $response['status'];
        if (isset($response['payment_id']) && trim($response['payment_id']) != '') {
            $paymentTransactionModel->gateway_transaction_id = trim($response['payment_id']);
        } else {
            $paymentTransactionModel->gateway_transaction_id = $response['cuid'];
        }


        $paymentTransactionModel->gateway_status_reason = $response['status'];
        $paymentTransactionModel->extra = json_encode($response);
        $paymentTransactionModel->currency = $currency;

        if ($response['status'] == 'failed') {
            $paymentTransactionModel->payment_status = 0;
        } else {
            if (isset($response['mode'])) {
                $paymentTransactionModel->payment_mode = $response['mode'];
            } else {
                $paymentTransactionModel->payment_mode = 'Live';
            }
            $paymentTransactionModel->amount = $response['amount'];
            //save data in credit table

            $accountFundsModel = new \App\AccountFunds();
            $accountFundsModel->transaction_id = $response['cuid'];
            $accountFundsModel->account_id = $this->session['sessiondata']['accounts'][0]['account_id'];
            $accountFundsModel->user_id = $this->session['UserID'];
            $accountFundsModel->currency = $currency;
            $accountFundsModel->payment_status = $response['status'];
            $accountFundsModel->debit_credit = 'CREDIT';
            if (strtolower($response['status']) == 'success' && !isset($this->session[$response['txnid']])) {
                $accountFundsModel->save();
                $this->addUSDFundToAdvertiser($amount, $currency);
            }
        }

        if (!isset($this->session[$response['txnid']])) {

            Session::Put($response['txnid'], 3);
            $paymentTransactionModel->save();
        }
        if ($deviceType == 'computer') {
        return view('paymentresponse', ['response' => $response]);
        }else{
            return view('mob-paymentresponse', ['response' => $response]);
        }
        //mail to user if transaction is successfull / failed
    }

    public function paymentResponseHDFC(Request $request) {
        $response = $request->toArray();
        $previousTransaction = \App\PaymentTransaction::
                where(['transaction_id' => $response['MerchantRefNo']])
                ->take(1)
                ->get();
        $currency = $previousTransaction[0]['currency'];
        $detect = new MobileDetect();
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');

        $paymentTransactionModel = new \App\PaymentTransaction();
        $paymentTransactionModel->user_id = $this->session['UserID'];
        $paymentTransactionModel->transaction_id = $response['MerchantRefNo'];
        $paymentTransactionModel->parent_id = $response['MerchantRefNo'];
        $paymentTransactionModel->account_id = $this->session['sessiondata']['accounts'][0]['account_id'];
        //$paymentTransactionModel->advertiser_id = $response->udf2;
        $paymentTransactionModel->gateway_id = 2; //HDFC
        $paymentTransactionModel->stage = 2; //RESPONSE FROM PAYMENT GATEWAY
        $paymentTransactionModel->status_reason = $response['ResponseCode'];
        $paymentTransactionModel->gateway_transaction_id = $response['PaymentID'];

        $response['status'] = ($response['ResponseCode'] == 0) ? 'SUCCESS' : 'failure';

        $paymentTransactionModel->gateway_status_reason = $response['status'];
        $paymentTransactionModel->extra = json_encode($response);
        $paymentTransactionModel->currency = $currency;

        if ($response['status'] == 'failure') {
            $paymentTransactionModel->payment_status = 0;
        } else {
            //$paymentTransactionModel->payment_mode = $response['mode'];
            $paymentTransactionModel->payment_mode = 'LIVE';
            $paymentTransactionModel->amount = $response['Amount'];
            //save data in credit table

            $accountFundsModel = new \App\AccountFunds();
            $accountFundsModel->transaction_id = $response['MerchantRefNo'];
            $accountFundsModel->account_id = $this->session['sessiondata']['accounts'][0]['account_id'];
            $accountFundsModel->user_id = $this->session['UserID'];
            $accountFundsModel->currency = $currency;
            $accountFundsModel->payment_status = $response['ResponseCode'];
            $accountFundsModel->debit_credit = 'CREDIT';
            if (strtolower($response['status']) == 'success' && !isset($this->session[$response['txnid']])) {
                $accountFundsModel->save();
             $this->addUSDFundToAdvertiser($response['Amount'], $currency);
            }
        }
        if (!isset($this->session[$response['txnid']])) {

            Session::Put($response['txnid'], 2);
            $paymentTransactionModel->save();
        }
        if ($deviceType == 'computer') {
        return view('paymentresponse', ['response' => $response]);
        }else{
            return view('mob-paymentresponse', ['response' => $response]);
        }
        //mail to user if transaction is successfull / failed
    }

    /* public function addUSDFundToAdvertiser($amount, $basecurrency = 'INR') {
      if ($basecurrency == 'USD')
      return $amount;
      $currencydata = CurrencyDatabase::where(['base_symbol' => $basecurrency, 'symbol' => 'USD'])
      ->orderBy('inserted_date', 'desc')
      ->take(1)
      ->get();
      $advertiserRow = \App\Advertiser::find($this->advertiserdata['advertiser_id']);
      $usdValue = $amount / ($currencydata[0]['value'] * 101 / 100);
      $advertiserRow->balance_left_dollar +=$usdValue;

      $advertiserRow->balance_left_currency= +$amount;
      $advertiserRow->save();
      return true;
      }

      public function convertCurrency($amount, $sourcecur , $requiredcur) {
      if ($sourcecur == $requiredcur)
      return $amount;
      $currencydata = CurrencyDatabase::where(['base_symbol' => $sourcecur, 'symbol' => $requiredcur])
      ->orderBy('inserted_date', 'desc')
      ->take(1)
      ->get();
      $convertedValue = $amount / ($currencydata[0]['value']);
      return $convertedValue;
      }
     */

    public function addUSDFundToAdvertiser($amount, $basecurrency = 'INR') {
        if ($basecurrency == 'USD') {
            $advertiserRow = \App\Advertiser::find($this->advertiserdata['advertiser_id']);
            $advertiserRow->balance_left_dollar +=$amount;
            $advertiserRow->balance_left_currency +=$amount;
            $advertiserRow->save();
            return true;
        } else {
             $currencydata = CurrencyDatabase::where(['base_symbol' => 'USD', 'symbol' => $basecurrency])
                    ->orderBy('inserted_date', 'desc')
                    ->take(1)
                    ->get();
            $advertiserRow = \App\Advertiser::find($this->advertiserdata['advertiser_id']);
            $usdValue = $amount / ($currencydata[0]['value'] * 101 / 100);
            $advertiserRow->balance_left_dollar_000 +=$usdValue;
            $advertiserRow->balance_left_currency +=$amount;
            $advertiserRow->save();

            return true;
        }
    }

    public function convertCurrency($amount, $sourcecur, $requiredcur) {
        if ($sourcecur == $requiredcur)
            return $amount;
        /* $currencydata = CurrencyDatabase::where(['base_symbol' => $sourcecur, 'symbol' => $requiredcur])
          ->orderBy('inserted_date', 'desc')
          ->take(1)
          ->get();

         */
        $currencydata = CurrencyDatabase::where(['base_symbol' => $requiredcur, 'symbol' => $sourcecur])
                ->orderBy('inserted_date', 'desc')
                ->take(1)
                ->get();

        $convertedValue = $amount / ($currencydata[0]['value']);
        return $convertedValue;
    }
 
    //TBD
    public function hdfcPayment() {

        $value["account_id"] = "16267";
        $value["address"] = "Test Address";
        $value["amount"] = "12.34";
        $value["channel"] = "10";
        $value["city"] = "Mumbai";
        $value["country"] = "IND";
        $value["currency"] = "INR";
        $value["description"] = "Test Product";
        $value["email"] = "test@test.com";
        $value["mode"] = "LIVE";
        $value["name"] = "Test Name";
        $value["phone"] = "2211112222";
        $value["postal_code"] = "400069";
        $value["reference_no"] = "1458205469";
        $value["return_url"] = "http://advertiser.collectcent.com/demo/hdfc/hdfc-php/response.php";
        $value["ship_address"] = "Test Address";
        $value["ship_city"] = "Mumbai";
        $value["ship_country"] = "IND";
        $value["ship_name"] = "Test Name";
        $value["ship_phone"] = "2211112222";
        $value["ship_postal_code"] = "400069";
        $value["ship_state"] = "MH";
        $value["state"] = "MH";
//        $value["secure_hash"]="36C39CD4F593952B0E4A9C421D4464CE97628A6965DEF89BFFD80DD02BD42CBF601B15277F76E48F44C532BFF41CAD458CF05B11CEB6F3A8C07BBA0C4729DBC9";
        $value["secure_hash"] = $this->createHDFChash($value);

        return View::make('indipay::ccavenue')->with('encRequest', $this->encRequest)
                        ->with('accessCode', $this->accessCode)
                        ->with('endPoint', $this->getEndPoint());
        //return redirect("https://secure.ebs.in/pg/ma/payment/request/");
    }


    public function paywithoption(Request $request){

        switch($request->submitbutton) {

    case 'paypal': 
        //action save here
    $pay= $this->payWithpaypal($request);
    
    break;

    case 'PayuMony':
        $pay= $this->paymentRequestPayu($request);
    break;
          
        }
        return $pay;
    }

     public function payWithpaypal($request)
    {
        $detect = new MobileDetect();
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
        $advertiserdata = Account::find($this->session['sessiondata']['accounts'][0]['account_id'])->advertiser;
        $advertiserdata = $advertiserdata->toArray();

        /* All Required Parameters by your Gateway */

        $paymentTransactionModel = new \App\PaymentTransaction();
        $paymentTransactionModel->parent_id = 0;

        $paymentTransactionModel->account_id = $this->session['sessiondata']['accounts'][0]['account_id'];
        $paymentTransactionModel->user_id = $this->session['UserID'];
        $paymentTransactionModel->amount = $request->amount;
        $paymentTransactionModel->currency = $request->currency;
        $paymentTransactionModel->gateway_id = 4; //Paypal


        $payer = new Payer();
        $payer->setPaymentMethod('paypal');
        $item_1 = new Item();
        $item_1->setName($this->session['UserEmail']) /** item name **/
            ->setCurrency($request->currency)
            ->setQuantity(1)
            ->setPrice($request->amount); /** unit price **/
        $item_list = new ItemList();
        $item_list->setItems(array($item_1));
        $amount = new Amount();
        $amount->setCurrency($request->currency)->setTotal($request->amount);
        $transaction = new Transaction();
        $transaction->setAmount($amount)->setItemList($item_list)
            ->setDescription('Add Fund in Vola Ad');
        $redirect_urls = new RedirectUrls();
        $redirect_urls->setReturnUrl(URL::to('/myaccount/status'))->setCancelUrl(URL::to('/myaccount/status'));
        $payment = new Payment();
        $payment->setIntent('Sale')->setPayer($payer)->setRedirectUrls($redirect_urls)->setTransactions(array($transaction));
        try {
            $payment->create($this->_api_context);
        } catch (\PayPal\Exception\PPConnectionException $ex) {
            if (\Config::get('app.debug')) {
                \Session::put('error', 'Connection timeout');
                        $paymentTransactionModel->stage = 1; //FIRST FORM SUBMIT
                        $paymentTransactionModel->stage = Session::get('error'); 
                       
                return Redirect::route('myaccount/paymentrequest4');
                } else {
                \Session::put('error', 'Some error occur, sorry for inconvenient');
                        $paymentTransactionModel->stage = 1; //FIRST FORM SUBMIT
                        $paymentTransactionModel->stage = Session::get('error'); 
                  return Redirect::route('myaccount/paymentrequest4');
                }

        }
        foreach ($payment->getLinks() as $link) {
            if ($link->getRel() == 'approval_url') {
                $redirect_url = $link->getHref();
                break;
            }
        }
        /** add payment ID to session **/
        Session::put('paypal_payment_id', $payment->getId());
        if (isset($redirect_url)) {
            /** redirect to paypal **/
            //  $transaction_id = substr(md5(str_random(1000) . microtime()), rand(1, 15), 16);
        $transaction_id = $payment->getId(); //PAY-4U42928953170384JLMVUIXA
        $paymentTransactionModel->transaction_id = $transaction_id;
          $paymentTransactionModel->save();
            return Redirect::away($redirect_url);
        }
        \Session::put('error', 'Unknown error occurred');
        if ($deviceType == 'computer') {
        return view('paymentresponse', ['response' => array('status'=>'Unknown error occurred')]);
        }else{
             return view('mob-paymentresponse', ['response' => array('status'=>'Unknown error occurred')]);
        }

    }


    // get payment paypal status
    public function getPaymentStatus()
    {
        
        $previousTransactionModal = new \App\PaymentTransaction();
        $previousTransaction = $previousTransactionModal::where(['transaction_id' => Session::get('paypal_payment_id')])->take(1)->get();

        $currency = $previousTransaction[0]['currency'];
        $detect = new MobileDetect();
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');

        $paymentTransactionModel = new \App\PaymentTransaction();
        $paymentTransactionModel->user_id = $this->session['UserID'];
        $paymentTransactionModel->transaction_id = Session::get('paypal_payment_id');
        $paymentTransactionModel->parent_id = '';
        $paymentTransactionModel->account_id = $this->session['sessiondata']['accounts'][0]['account_id'];
        $paymentTransactionModel->gateway_id = 4; //FORTUMO
        /** Get the payment ID before session clear **/
        $payment_id = Session::get('paypal_payment_id');
        /** clear the session payment ID **/
        Session::forget('paypal_payment_id');
        if (empty(Input::get('PayerID')) || empty(Input::get('token'))) {
            //RESPONSE FROM PAYMENT GATEWAY

            \Session::put('error', 'Payment failed');
             $paymentTransactionModel->stage ='FAILD'; 
              $paymentTransactionModel->stage =Session::get('error');
             if ($deviceType == 'computer') {
        return view('paymentresponse', ['response' => array('status'=>'failure')]);
        }else{
             return view('mob-paymentresponse', ['response' => array('status'=>'failure')]);
        }

        }
        $payment = Payment::get($payment_id, $this->_api_context);
        $execution = new PaymentExecution();
        $execution->setPayerId(Input::get('PayerID'));
        /**Execute the payment **/
        $result = $payment->execute($execution, $this->_api_context);


            $accountFundsModel = new \App\AccountFunds();
            $accountFundsModel->transaction_id = $payment_id;
            $accountFundsModel->account_id = $this->session['sessiondata']['accounts'][0]['account_id'];
            $accountFundsModel->user_id = $this->session['UserID'];
            $accountFundsModel->currency = $currency;
            $accountFundsModel->debit_credit = 'CREDIT';

        if ($result->getState() == 'approved') {

            \Session::put('success', 'Payment success');
            $paymentTransactionModel->stage =  'SUCCESS'; //RESPONSE FROM PAYMENT GATEWAY
            $transactions = $result->transactions[0]->related_resources[0]->sale->amount->total;
            $this->addUSDFundToAdvertiser($transactions, $currency);  
              
            $paymentTransactionModel->parent_id = isset($result->parent_payment)?$result->parent_payment:'0';
            $accountFundsModel->amount = $transactions;
            $accountFundsModel->payment_status = $result->getState();
            $paymentTransactionModel->save();

            $accountFundsModel->save(); 
              
            if ($deviceType == 'computer') {
        return view('paymentresponse', ['response' => array('status'=>'success')]);
        }else{
             return view('mob-paymentresponse', ['response' => array('status'=>'success')]);
        }

        }
        \Session::put('error', 'Payment failed');
         
          if ($deviceType == 'computer') {
        return view('paymentresponse', ['response' => array('status'=>'failure')]);
        }else{
             return view('mob-paymentresponse', ['response' => array('status'=>'failure')]);
        }

    }


    public function getaddadminfundadvertiser(Request $request){

    	$advertiserInfo = \App\Advertiser::where('account_id','=',$request->advertiser_id)->orderBy('contact_name','ASC')->get();

            // $advertiserInfo = $advertiserInfo->toArray();

         $data_array = $data_val = [];

        foreach($advertiserInfo as $key => $value) {
             
               
              $data_array[] = $value->account_id;
              $data_array[] = $value->contact_name;
              
              $data_array[] = $value->currency;
              
              $data_array[] = $value->balance_left_currency;
        }   
            
         $page_name= 'admin.addfundmanual';
        return view($page_name,compact('data_array'));

    }

    public function getadvertisercurrency(Request $request){

    		$advertiserInfo = \App\Advertiser::select('currency')->find($request->advertiser_id);
    		
            if(!($advertiserInfo) || empty($advertiserInfo['currency'])) {
                return array('msg' => 'Currency not found');
            }else{
            	$array_data =array('currency' => $advertiserInfo['currency']);
            	return $array_data;
            }

    }


  public function addadmountmanual(Request $request){

            $accounts = $request->account_id;
  		     $amount =$request->ammount;
             $commments = $request->commments;
  		 
         $advertiserdata =\App\Advertiser::where('account_id','=',$accounts)->with('AccountUserlist')->firstOrFail();

         $advertiserdata = $advertiserdata->toArray();
         $advertiser_id= $advertiserdata['advertiser_id'];
        $transaction_id=  time().mt_rand(1,100).'ccad';
           $paymentTransactionModel = new \App\PaymentTransaction();
        $paymentTransactionModel->transaction_id = $transaction_id;
        $paymentTransactionModel->parent_id = 0;

        $paymentTransactionModel->account_id = $advertiserdata['account_id'];
        $paymentTransactionModel->user_id = $advertiserdata['account_userlist']['user_id'];
        $paymentTransactionModel->amount =  $amount;
        $paymentTransactionModel->currency = $advertiserdata['currency'];
        $paymentTransactionModel->gateway_id = 6; //By admin backend
        $paymentTransactionModel->stage = 'SUCCESS'; //FIRST FORM SUBMIT
        $paymentTransactionModel->save();


         $accountFundsModel = new \App\AccountFunds();
 		 $accountFundsModel->transaction_id = $transaction_id;
         $accountFundsModel->account_id = $advertiserdata['account_id'];
         $accountFundsModel->user_id = $advertiserdata['account_userlist']['user_id'];
         $accountFundsModel->amount = $amount;
         $accountFundsModel->currency = $advertiserdata['currency'];
         $accountFundsModel->payment_status = 'success';
         $accountFundsModel->debit_credit = 'CREDIT';
         $accountFundsModel->commments = 'Add By Admin';

         if($accountFundsModel->save()){
            $this->addUSDFundToAdvertiserbyadmin($amount,$advertiserdata['currency'],$advertiser_id);
            $mes=  "1";
         }
         else{
             \Session::put('error', 'Payment Add failed');
            $mes=  "0";            
         }
         return $mes;

      }

        public function addUSDFundToAdvertiserbyadmin($amount, $basecurrency = 'INR',$advertiser_id) {
        if ($basecurrency == 'USD') {
            $advertiserRow = \App\Advertiser::find($advertiser_id);
            $advertiserRow->balance_left_dollar +=$amount;
            $advertiserRow->balance_left_currency +=$amount;
            $advertiserRow->save();
            return true;
        } else {
             $currencydata = CurrencyDatabase::where(['base_symbol' => 'USD', 'symbol' => $basecurrency])
                    ->orderBy('inserted_date', 'desc')
                    ->take(1)
                    ->get();
            $advertiserRow = \App\Advertiser::find($advertiser_id);
            $usdValue = $amount / ($currencydata[0]['value'] * 101 / 100);
            $advertiserRow->balance_left_dollar +=$usdValue;
            $advertiserRow->balance_left_currency +=$amount;
            $advertiserRow->save();

            return true;
        }
    }


}
