<?php

namespace App\Http\Controllers;

use DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;
//use App\Account;
//use App\Advertiser;
use App\Advertiser;
use Auth;
use Cache;

class PublisherController extends Controller {

    public function __construct() {

        $this->session = SESSION::All();
        if (Auth::check()) {
            $this->user = Auth::User();
            if ($this->user->cannot('TRAFFICKER')) {
                return json_encode(array('status' => 'failed', 'msg' => 'not_authorized'));
            }
        } else {
            Auth::logout();
            Session::flush();
            return redirect('/login');
        }
        //return json_encode(array('status' => 'failed', 'msg' => 'login_required'));
    }

    public function adspotView() {
        return View('/pubaccount_adspot');
    }

    public function getPubReport(Request $request) {
        if ($this->user->cannot('TRAFFICKER')) {
            return json_encode(false);
        }
        //$dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', $request->start_date);
        //print_r($dateTimeObj);exit

        if (!isset($request->start_date)) {

            $dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', date("d-m-Y") . ' 00:00:00');
            //$dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', '2016-08-20 00:00:00');
            //$request->start_date = date("Y-m-d");
        } else {
            if (!isset($request->hour)) {
                $start = $request->start_date . " 00:00:00";
            } else {
                $start = $request->start_date . " " . str_pad($request->hour, 2, "0", STR_PAD_LEFT) . ':00:00';
            }
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', $start);
            //$dateTimeObj = \DateTime::createFromFormat('Y-m-d H:i:s', '2016-08-20 00:00:00');
        }

        $dateTimeObj->setTimezone(new \DateTimeZone('Asia/Kolkata'));
        $sMinute = $dateTimeObj->format('i');
        if ($sMinute <= 30) {
            $sstat_slot = 1;
        } else {
            $sstat_slot = 2;
        }

        $sdt = $dateTimeObj->format('YmdH') . $sstat_slot;
        if (!isset($request->end_date)) {
            $request->end_date = date("Y-m-d");
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', date("d-m-Y") . ' 23:59:59');
        } else {

            if (!isset($request->hour)) {
                $end = $request->end_date . " 23:59:59";
            } else {
                $end = $request->end_date . " " . str_pad($request->hour, 2, "0", STR_PAD_LEFT) . ':59:59';
            }
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', $end);
        }
        $dateTimeObj->setTimezone(new \DateTimeZone('Asia/Kolkata'));
        $eMinute = $dateTimeObj->format('i');
        if ($eMinute <= 30) {
            $estat_slot = 1;
        } else {
            $estat_slot = 2;
        }

        $edt = $dateTimeObj->format('YmdH') . $estat_slot;
        $statModel = new \App\publisherStat();
        $statData = $statModel::where('publisher_id', $this->session['sessiondata']['accounts'][0]['publisher_id'])
                ->where('date_key', '>=', $sdt)
                ->where('date_key', '<=', $edt)
                ->selectRaw("date_key,ad_spot_id,"
                        . "sum(request_count) as request_count ,"
                        . "sum(bid_count) as bid_count,"
                        . "sum(impression_count) as impression_count,"
                        . "sum(win_count) as win_count,"
                        . "sum(clicks_count) as clicks_count,"
                        . "sum(total_win_cost) as total_cost,"
                        . "stat_date,ad_spot_id")
                ->groupBy('date_key', 'ad_spot_id')
                ->orderBy('date_key', 'dsc')
                ->orderBy('ad_spot_id', 'asc')
                ->get();
        $pubStat = array();
        $pubStat['data'] = array();
        $pubStat['type'] = 'hourly';
        $pubStat['data_total']['request_total'] = 0;
        $pubStat['data_total']['bid_total'] = 0;
        $pubStat['data_total']['imp_total'] = 0;
        $pubStat['data_total']['win_total'] = 0;
        $pubStat['data_total']['clicks_total'] = 0;
        $pubStat['data_total']['income_total'] = 0;
        //stored data in db is in Asia/Kolkata, $dateTimeObj should be created from this timezone
        date_default_timezone_set('Asia/Kolkata');
        $last_updated = $this->getLastUpdatedStatsTS($this->session['sessiondata']['accounts'][0]['publisher_id']);
        $dateTimeObj = \DateTime::createFromFormat('Y-m-d H:i:s', $last_updated);
        $dateTimeObj->setTimezone(new \DateTimeZone($this->session['sessiondata']['user_timezone']));
        $stats_last_updated = $dateTimeObj->format('Y-m-d H:i:s');
        $pubStat['stats_last_updated'] = 'Report last updated ' . $dateTimeObj->format('h:i A, d-m-Y T');
        foreach ($statData as $statRow) {
            $date_key = $statRow['date_key'];
            $minute = substr($date_key, 10, 1);
            if ($minute) {
                $mkey = ':29:59';
            } else {
                $mkey = ':59:59';
            }
            //create dateTimeObj from Asia/Kolkata
            $dateTimeObj = \DateTime::createFromFormat('YmdH:i:s', substr($date_key, 0, 10) . $mkey);
            //change date time to user's timezone
            $dateTimeObj->setTimezone(new \DateTimeZone($this->session['sessiondata']['user_timezone']));
            $statUserDate = $dateTimeObj->format('d-m-Y');
            $statUserHour = $dateTimeObj->format('H');
            if (!$statRow['ad_spot_id']) {
                $statRow['ad_spot_id'] = 0;
            }

            if ($request->group_by == 'adspot') {
                if (!isset($pubStat['data'][$statUserDate][$statRow['ad_spot_id']])) {
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['request_count'] = 0;
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['bid_count'] = 0;
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['impression_count'] = 0;
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['win_count'] = 0;
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['clicks_count'] = 0;
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['total_cost'] = 0;
                }

                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['request_count'] += $statRow['request_count'];
                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['bid_count'] += $statRow['bid_count'];
                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['impression_count'] += $statRow['impression_count'];
                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['win_count'] += $statRow['win_count'];
                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['clicks_count'] += $statRow['clicks_count'];
                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['total_cost'] += $statRow['total_cost'];
            } else {
                if (!isset($pubStat['data'][$statUserDate])) {
                    $pubStat['data'][$statUserDate]['request_count'] = 0;
                    $pubStat['data'][$statUserDate]['bid_count'] = 0;
                    $pubStat['data'][$statUserDate]['impression_count'] = 0;
                    $pubStat['data'][$statUserDate]['win_count'] = 0;
                    $pubStat['data'][$statUserDate]['clicks_count'] = 0;
                    $pubStat['data'][$statUserDate]['total_cost'] = 0;
                }

                $pubStat['data'][$statUserDate]['request_count'] += $statRow['request_count'];
                $pubStat['data'][$statUserDate]['bid_count'] += $statRow['bid_count'];
                $pubStat['data'][$statUserDate]['impression_count'] += $statRow['impression_count'];
                $pubStat['data'][$statUserDate]['win_count'] += $statRow['win_count'];
                $pubStat['data'][$statUserDate]['clicks_count'] += $statRow['clicks_count'];
                $pubStat['data'][$statUserDate]['total_cost'] += $statRow['total_cost'];
            }

            $pubStat['data_total']['request_total'] += $statRow['request_count'];
            $pubStat['data_total']['bid_total'] += $statRow['bid_count'];
            $pubStat['data_total']['imp_total'] += $statRow['impression_count'];
            $pubStat['data_total']['win_total'] += $statRow['win_count'];
            $pubStat['data_total']['clicks_total'] += $statRow['clicks_count'];
            $pubStat['data_total']['income_total'] += $statRow['total_cost'];
        }
        //print_r($pubStat);exit;
        $pubStat['today_total'] = json_decode($this->getTotalPubReport(), true);
        date_default_timezone_set($this->session['sessiondata']['user_timezone']);
        return json_encode($pubStat);
    }

    public function getTotalPubReport() {
        if ($this->user->cannot('TRAFFICKER')) {
            return json_encode(false);
        }

        //carete dateTimeObj from user's timezone
        $dateTimeObj = \DateTime::createFromFormat('Y-m-d H:i:s', date("Y-m-d") . ' 00:00:00');
        //convert datetimezone to Asia/Kolkata as data in db is ist
        $dateTimeObj->setTimezone(new \DateTimeZone('Asia/Kolkata'));
        $sMinute = $dateTimeObj->format('i');
        if ($sMinute <= 30) {
            $sstat_slot = 1;
        } else {
            $sstat_slot = 2;
        }

        $sdt = $dateTimeObj->format('YmdH') . $sstat_slot;
        $dateTimeObj = \DateTime::createFromFormat('Y-m-d H:i:s', date("Y-m-d") . ' 23:59:59');
        $dateTimeObj->setTimezone(new \DateTimeZone('Asia/Kolkata'));
        $eMinute = $dateTimeObj->format('i');
        if ($eMinute <= 30) {
            $estat_slot = 1;
        } else {
            $estat_slot = 2;
        }

        $edt = $dateTimeObj->format('YmdH') . $estat_slot;
        //getting the stat records total
        $statModel = new \App\publisherStat();
        $statData = $statModel::where('publisher_id', $this->session['sessiondata']['accounts'][0]['publisher_id'])
                ->where('date_key', '>=', $sdt)
                ->where('date_key', '<=', $edt)
                ->selectRaw("sum(request_count) as request_count ,"
                        . "sum(bid_count) as bid_count,"
                        . "sum(impression_count) as impression_count,"
                        . "sum(win_count) as win_count,"
                        . "sum(clicks_count) as clicks_count,"
                        . "sum(total_win_cost) as total_cost")
                ->get();
        return $statData->toJson();
    }

    private function getLastUpdatedStatsTS($pubId = 0) {

        if ($pubId == 0)
            $last_updated = \App\hourlyStat::max('update_datetime');
        else
            $last_updated = \App\hourlyStat::where('publisher_id', $pubId)->max('update_datetime');
        return $last_updated;
    }

    public function getPubId($userId) {

        if ($userId) {

            $publisher = DB::table('publishers')->where('account_id', $userId)->first();
            if ($publisher->publisher_id > 0) {

                return $publisher->publisher_id;
            }
        }

        return null;
    }
    
    public function pubstats(){
	 	return view('publisher.pubstats');
	}

}
