<?php

namespace App\Http\Controllers;

use DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;
//use App\Account;
//use App\Advertiser;
use App\Advertiser;
use Auth;
use Cache;

class SessionController extends Controller {

    public function __construct() {
        $this->session = SESSION::All();
        $this->user = Auth::User();
    }

    public function validateUser() {

        if (Auth::check()) {
            $this->user = Auth::User();
            if ($this->user->cannot('ADMIN_ALL') && $this->user->cannot('ADMIN_JSON_CONTROLLER_RIGHTS')) {
                return array('status' => 'failed', 'msg' => 'not_authorized');
            } else {
                return array("status" => "success");
            }
        } else {
            return array('status' => 'failed', 'msg' => 'guest');
        }
    }

    public function getUserAccountsAdvts() {
        if (isset($this->advertiserObj)) {
            return $this->advertiserObj;
        }
        $advertiserObj = array();
        if (Auth::check()) {
            $user = Auth::User();
            $roles = $user->roles;
            if ($roles[0]['role_slug'] == 'ADMIN') {
                $accountModel = new \App\Account();
                $accountModel = $accountModel->where('account_type', '=', 'ADVERTISER');

                /* if (is_array($accountsArr) && count($accountsArr)) {
                  $accountModel = $accountModel::whereIn('account_id', $accountArr);
                  } */
                $accountInfoObj = $accountModel->get();
            } else {
                $accountInfoObj = $user->accounts;
            }

            foreach ($accountInfoObj as $accountRow) {
                if ($accountRow->advertiser != false) {
                    $advertiserObj[$accountRow->advertiser->advertiser_id] = $accountRow->advertiser;
                }
            }

            $this->advertiserObj = $advertiserObj;
        }
        return $advertiserObj;
    }

    //params:: array("advertisers"=>array(1,2,3),"campaigns"=>array(1,2,3))
}
