<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Publisher extends Model {

    protected $table = 'publishers';
    protected $primaryKey = 'publisher_id';
    protected $auditEnabled = true;
    public $timestamps = false;

    public function account() {
        return $this->belongsTo('\App\Account', 'account_id');
    }

    public function ads() {
        return $this->belongsToMany('App\Ads', 'ad_publisher', 'publisher_id', 'ad_id');
    }
}
