<?php

namespace App;

use Illuminate\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Auth\Passwords\CanResetPassword;
use Illuminate\Foundation\Auth\Access\Authorizable;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Contracts\Auth\Access\Authorizable as AuthorizableContract;
use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract;
use OwenIt\Auditing\AuditingTrait;

//class User extends Model implements AuthenticatableContract, AuthorizableContract, CanResetPasswordContract {
class User extends Model implements AuthenticatableContract, CanResetPasswordContract {

    use Authenticatable,
        Authorizable,
        CanResetPassword,
        AuditingTrait;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'cf_users';
    public $timestamps = false;
    protected $auditEnabled  = true;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['user_id', 'first_name', 'phone_country_code', 'phone_number', 'email_address',
        'activation_code', 'default_account_id', 'is_active', 'password', 'iso3_country'];
    protected $primaryKey = 'user_id';

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = ['password', 'remember_token'];

    public function getId() {
        return $this->user_id;
    }

    public function setid($user_id) {
        $this->user_id = $user_id;
    }

    /**
     * Checks a Permission
     * @param  String permission Slug of a permission (i.e: manage_user)
     * @return Boolean true if has permission, otherwise false
     */
    public function can($permission = null) {
        return $this->checkIfHavePermission($permission);
        //return !is_null($permission) && $this->checkPermission($permission);
    }

    private function checkIfHavePermission($permission = null) {
        $havePermission = $this->roles->first()->permissions->where('permission_slug', $permission);
        return !$havePermission->isEmpty();
    }

    /**
     * Check if the permission matches with any permission user has
     * @param  String permission slug of a permission
     * @return Boolean true if permission exists, otherwise false
     */
    protected function checkPermission($perm) {
        $permissions = $this->getAllPernissionsFormAllRoles();
        $permissionArray = is_array($perm) ? $perm : [$perm];
        return count(array_intersect($permissions, $permissionArray));
    }

    /**
     * Get all permission slugs from all permissions of all roles
     *
     * @return Array of permission slugs
     */
    protected function getAllPernissionsFormAllRoles() {
        $permissionsArray = [];
        $permissions = $this->roles->load('permissions'); //->fetch('permissions')->toArray();
        $permissions = $permissions->toArray();
        return array_map('strtolower', array_unique(array_flatten(array_map(function ($permission) {
                                    return array_fetch($permission, 'permission_slug');
                                }, $permissions))));
    }

    public function accounts() {
        return $this->belongsToMany('App\Account', 'account_user', 'user_id', 'account_id');
    }


         public function advertiser() {
        return $this->belongsTo('App\Advertiser', 'account_user', 'user_id', 'advertiser_id');
    }

    /*
      |--------------------------------------------------------------------------
      | Relationship Methods
      |--------------------------------------------------------------------------
     */

    /**
     * Many-To-Many Relationship Method for accessing the User->roles
     *
     * @return QueryBuilder Object
     */
    public function roles() {
        return $this->belongsToMany('App\Role', 'role_user', 'user_id', 'role_id');
    }

}
