<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Validator;
use Auth;
use Hash;
use App\User;

class CreatadController extends Controller {

    public function __construct() {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    
    public function index() {
        var_dump('id:', \Session::getId());
        return View('creat-ad');
    }

    /**
     * Show the form for creating a new resource.
     * This function is use for create a user in singup
     * @return \Illuminate\Http\Response
     */
    public function create_add(Request $request) {

        $id = $request->invisible;
        if (isset($id) && $id != "") {
            $valueArr = explode("_", $id);


		$json_url = url("json-data/get-categories");
		$json = file_get_contents( $json_url );

		$data = json_decode($json,true);
		$typeCat=$valueArr[2];
		$catid=$valueArr[1];
		$subcatid=$valueArr[0];
            $categories = $data[$typeCat][0][$catid];
            $subcategories = $data[$typeCat][$catid][$subcatid];	
            
            return view('creat-ad', ['categories' => $categories, 'subcategories' => $subcategories,'catid'=>$catid,'subcatid'=>$subcatid]);
        } else {
            return redirect('creat-ad')->with('error_login', 'No data Found');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function create_add_pages(Request $request) {
        //

        $data = Session::all();
        echo "<pre>";
        print_r($data);
        die;

        $id = $request->input_data;
        return response()->json(['name' => $id]); // Bob
        //
            //
          // return redirect('/creat-ad')->with('valuse',$this->create_add()); 
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        //
    }
     /**
     * submit the form for creating a new resource.
     * This function is use for create a user in singup
     * @return \Illuminate\Http\Response
     */
    public function editAddSubmit(Request $request) {
        
        $post = $request->all();
        //echo "<pre>";
        //print_r($post);
        //die;
        $destinationPath = public_path('images');
        $images = $post["img"];
        $nameArr[]= $post["previous_img"];
        $dmArr[] = $post["previous_dm"];
        $extArr[]= $post["previous_ext"];
        
        //if image found then edited
        if ( $images ) {
                       
                foreach ( $images as $image ) {
                    if(trim($image)!=''){
                    if ($image->isValid()) {
                        
                        
                        $dmsarr=array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31');
                        $imageVal = getimagesize($image);
                        
                        $chkdm=$imageVal[0] . 'X' . $imageVal[1];
                        if(in_array($chkdm, $dmsarr))
                        {
                             $extArr[] = $extension = $image->getClientOriginalExtension(); 
                              $imageVal2 = getimagesize($image);
                              $dmArr[] = $imageVal2[0] . 'X' . $imageVal2[1];
                               $nameArr[] = $fileName = $post["group_id"]. '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image
                        $image->move($destinationPath, $fileName); // uploading file to given path       
                       
                        }
                        
                        
                        
                       /* echo "<pre>";print_r($image);
                        $extArr[] = $extension = $image->getClientOriginalExtension(); // getting image extension
                        $imageVal = getimagesize($image);
                        $dmArr[] = $imageVal[0] . 'X' . $imageVal[1];
                        $nameArr[] = $fileName = $post["group_id"] . '_' . $imageVal[0] . 'X' . $imageVal[1] . '.' . $extension; // renameing image
                        $image->move($destinationPath, $fileName); // uploading file to given path       
                        echo $fileName."\n"; */
                    }
                    }
                    // sending back with message
                    //Session::flash('success', 'Upload successfully'); 
                    //return Redirect::to('upload');
                }
                    //set creative groups values to save
                    //###################################
                    
                    $creativeModel= \App\CreativeGroup::find($post["group_id"]);
                    $creativeModel->file_name = implode(',', $nameArr);
                    $creativeModel->content_dimensions = implode(',', $dmArr);
                    $creativeModel->content_extensions = implode(",", $extArr);
                    $creativeModel->save();
                    
        } 
                    
                    $camModel = \App\Campaigns::find( $post['campaign_id'] );
                    
                    $camModel->advertiser_id = $creativeModel->advertiser_id;
                    $camModel->campaign_name = $post['adname'];
                    $camModel->iab_categories = "";
                    $camModel->adomain = $post['adomain'];
                    //                    $camModel->priority="";
                    //                    $camModel->weight="";
                    //                    $camModel->target_impressions="";
                    //                    $camModel->target_clicks="";
                    //                    $camModel->target_conversions="";
                    $camModel->campaign_budget = $post['total_budget'];
                    $camModel->daily_budget = $post['budget'];
                    //                    $camModel->total_spend="";
                    $camModel->revenue_type = "CPC";
                    $camModel->min_unit_price = $post['cpc'];
                    $camModel->status = "pending";
                    $camModel->admin_status = "pending";
                    $camModel->admin_remarks = "";
                    $camModel->time_zone = "";
                    //                    $camModel->impressions="";
                    //                    $camModel->clicks="";
                    //                    $camModel->conversions="";
                    //                    $camModel->amount="";
                    //                    $camModel->activate_date_time ="";
                    //                    $camModel->expire_date_time   ="";
                    //                    $camModel->targeting_methods="";
                    //                    $camModel->methods_plugins="";
                    $camModel->create_date_time = date("Y-m-d h:i:s");
                    $camModel->update_date_time = date("Y-m-d h:i:s");
                    $camModel->adv_cat_id = $post['cat_id'];
                    $camModel->adv_subcat_id = $post['subcat_id'];
                    
                    
                    //campaign model 
                    //##############
                    
                    if ( $camModel->save() ) {
                        
                        $adsModel = \App\Ads::find( $post['ad_id'] );
                        $adsModel->campaign_id = $camModel->campaign_id;
                        $adsModel->content_type = "image";
                        $adsModel->creative_ids = $creativeModel->group_id;
                        $adsModel->ad_html = '<a href="__SERVERHTTPURL__/CR/c?cc=__CC__"><img src="__CDNURL__/__DIMENSION__/__IMAGENAME__"/></a> <img src="__SERVERHTTPURL__/ImpressionHandler/Handler?cc=__CC__" />';
                        $adsModel->ad_json = "";
                        $adsModel->ad_vast_url = "";
                        $adsModel->destination_url = $post['url'];
                        $adsModel->alt = "";
                        $adsModel->description = (isset($post['text_area_value'])) ? $post['text_area_value'] : "" ;
                        $adsModel->ad_status = "0";
                        $adsModel->ad_budget = $post['total_budget'];
                        $adsModel->ad_targeting_methods = "";
                        $adsModel->ad_method_plugins = "";
                        $adsModel->alternate_filename = "";
                        $adsModel->alternate_content_type = "";
                        $adsModel->admin_status = "pending";
                        $adsModel->admin_remarks = "";
                        //$adsModel->iab_attributes="";
                        //$adsModel->iab_categories="";
                        $adsModel->time_zone = "";
                        //$adsModel->activate_date_time="";
                        //$adsModel->expire_date_time="";
                        $adsModel->create_date_time = date("Y-m-d h:i:s");
                        $adsModel->update_date_time = date("Y-m-d h:i:s");

                        if ($adsModel->save()) {

                            if (isset($post['savecountry'])) { 

                                if(isset( $post['country_targetting_id'] )){
                                    
                                    $targModel = \App\TargettingChannelGroup::findOrNew($post['country_targetting_id']);
                                    
                                }
                                 
                                $targModel->channel_type = "advertiser";
                                $targModel->owner_id = $creativeModel->advertiser_id;
                                $targModel->logical = "EQU";
                                $targModel->type = "COUNTRY";
                                $targModel->data = $post['savecountry'];
                                $targModel->update_date_time = date("Y-m-d h:i:s");

                                if ($targModel->save()) {
                                    
                                  if( isset( $post['country_group_id'] ) ){
                                    
                                    $assocModel = \App\AdChannelGroupAssoc::findOrNew($post['country_group_id']);  
                                   } 
                                    
                                   $assocModel->ad_id = $adsModel->ad_id;
                                   $assocModel->channel_id = $targModel->channel_group_id;
                                   $assocModel->last_update = date("Y-m-d h:i:s");
                                   $assocModel->create_date = date("Y-m-d h:i:s");
                                   $assocModel->status = "1";
                                   $assocModel->save();
                                   
                                }
                            }

                     if (isset($post['state'])) {

                                
                                if(isset($post['state_targetting_id'])){
                                    $targModel = \App\TargettingChannelGroup::findOrNew($post['state_targetting_id']);
                                } 
                                
                                $targModel->channel_type = "advertiser";
                                $targModel->owner_id = $creativeModel->advertiser_id;
                                $targModel->logical = "EQU";
                                $targModel->type = "STATE";
                                $targModel->data = $post['state'];
                                $targModel->update_date_time = date("Y-m-d h:i:s");

                                if ( $targModel->save() ) {
                                    
                                if( isset( $post['state_group_id'] ) ){
                                    
                                    $assocModel = \App\AdChannelGroupAssoc::findOrNew($post['state_group_id']);  
                                    
                                  } 
                                  
                                  $assocModel->ad_id = $adsModel->ad_id;
                                  $assocModel->channel_id = $targModel->channel_group_id;
                                  $assocModel->last_update = date("Y-m-d h:i:s");
                                  $assocModel->create_date = date("Y-m-d h:i:s");
                                  $assocModel->status = "1";

                                  $assocModel->save();
                                }
                            }


                            if ( isset($post['pin']) ) {

                                if(isset($post['pin_targetting_id'])){
                                    $targModel = \App\TargettingChannelGroup::findOrNew($post['pin_targetting_id']);
                                } 

                                $targModel->channel_type = "advertiser";
                                $targModel->owner_id = $creativeModel->advertiser_id;
                                $targModel->logical = "EQU";
                                $targModel->type = "PIN";
                                $targModel->data = $post['pin'];
                                
                                $targModel->update_date_time = date("Y-m-d h:i:s");

                                if ($targModel->save()) {
                                    
                                  if( isset( $post['pin_group_id'] ) ){
                                    $assocModel = \App\AdChannelGroupAssoc::findOrNew($post['pin_group_id']);  
                                  } 
                                    
                                    $assocModel->ad_id = $adsModel->ad_id;
                                    $assocModel->channel_id = $targModel->channel_group_id;
                                    $assocModel->last_update = date("Y-m-d h:i:s");
                                    
                                    $assocModel->status = "1";

                                    $assocModel->save();
                                }
                            }
                            
                            
                            if ( isset($post['device'])) {

                               
                                if(isset($post['device_targetting_id'])){
                                    $targModel = \App\TargettingChannelGroup::findOrNew($post['device_targetting_id']);
                                }

                                $targModel->channel_type = "advertiser";
                                $targModel->owner_id = $creativeModel->advertiser_id;
                                $targModel->logical = "EQU";
                                $targModel->type = "DEVICE";
                                $targModel->data = $post['device'];
                                $targModel->create_date_time = date("Y-m-d h:i:s");
                                $targModel->update_date_time = date("Y-m-d h:i:s");

                                if ($targModel->save()) {
                                    
                                 if(isset($post['device_group_id'])){
                                    $assocModel = \App\AdChannelGroupAssoc::findOrNew($post['device_group_id']);  
                                  } 
                                    $assocModel->ad_id = $adsModel->ad_id;
                                    $assocModel->channel_id = $targModel->channel_group_id;
                                    $assocModel->last_update = date("Y-m-d h:i:s");
                                    
                                    $assocModel->status = "1";

                                    $assocModel->save();
                                }
                            }

                            if (isset($post['os'])) {

                               
                                if(isset($post['os_targetting_id'])){
                                    $targModel = \App\TargettingChannelGroup::findOrNew($post['os_targetting_id']);
                                }
                                
                                $targModel->channel_type = "advertiser";
                                $targModel->owner_id = $creativeModel->advertiser_id;
                                $targModel->logical = "EQU";
                                $targModel->type = "OS";
                                $targModel->data = $post['os'];
                                
                                $targModel->update_date_time = date("Y-m-d h:i:s");

                                if ($targModel->save()) {
                                    
                                    
                                 if(isset($post['os_group_id'])){
                                    $assocModel = \App\AdChannelGroupAssoc::findOrNew($post['os_group_id']);  
                                  }
                                    $assocModel->ad_id = $adsModel->ad_id;
                                    $assocModel->channel_id = $targModel->channel_group_id;
                                    $assocModel->last_update = date("Y-m-d h:i:s");
                                    
                                    $assocModel->status = "1";

                                    $assocModel->save();
                                }
                            }


                            if (isset($post['browser'])) {

                                  
                                if(isset($post['browser_targetting_id'])){
                                    $targModel = \App\TargettingChannelGroup::findOrNew($post['browser_targetting_id']);
                                } 
                                $targModel->channel_type = "advertiser";
                                $targModel->owner_id = $creativeModel->advertiser_id;
                                $targModel->logical = "EQU";
                                $targModel->type = "BROWSER";
                                $targModel->data = $post['browser'];
                                
                                $targModel->update_date_time = date("Y-m-d h:i:s");

                                if ($targModel->save()) {
                                    
                                    
                                  if(isset($post['browser_group_id'])){
                                    $assocModel = \App\AdChannelGroupAssoc::findOrNew($post['browser_group_id']);  
                                  } 
                                  
                                    $assocModel->ad_id = $adsModel->ad_id;
                                    $assocModel->channel_id = $targModel->channel_group_id;
                                    $assocModel->last_update = date("Y-m-d h:i:s");
                                    
                                    $assocModel->status = "1";

                                    $assocModel->save();
                                }
                            }


                            if (isset($post['tele'])) {

                               if(isset($post['tele_targetting_id'])){
                                    $targModel = \App\TargettingChannelGroup::findOrNew($post['tele_targetting_id']);
                                } 

                                $targModel->channel_type = "advertiser";
                                $targModel->owner_id = $creativeModel->advertiser_id;
                                $targModel->logical = "EQU";
                                $targModel->type = "OPERATOR";
                                $targModel->data = $post['tele'];
                                
                                $targModel->update_date_time = date("Y-m-d h:i:s");

                                if ($targModel->save()) {
                                    
                                  if(isset($post['tele_group_id'])){
                                    $assocModel = \App\AdChannelGroupAssoc::findOrNew($post['tele_group_id']);  
                                  } 
                                    
                                    $assocModel->ad_id = $adsModel->ad_id;
                                    $assocModel->channel_id = $targModel->channel_group_id;
                                    $assocModel->last_update = date("Y-m-d h:i:s");
                                    $assocModel->status = "1";
                                    $assocModel->save();
                                }
                            }
                        } //ads entry to the database
                    } // campaign entry to the database
                
            return redirect('myaccount')->with('success_ad', 'Ad Edited Succesfully!');
            
        //dd( DB::getQueryLog() );
        //foreach closed
        //echo "<pre>";print_r( $post );
            
    }
    /**
     * submit the form for creating a new resource.
     * This function is use for create a user in singup
     * @return \Illuminate\Http\Response
     */
    public function createAddSubmit(Request $request) {
        
        $post = $request->all();
        /*$sd=Session::all();
        echo "<pre>";
        print_r($sd);
        die;*/
        $destinationPath = public_path('images');
        $images = $post["img"];

        if ($images) {

            // upload path
            $creativeModel = new \App\CreativeGroup;
            
            $creativeModel->advertiser_id = Session::get('UserID');
            
            $creativeModel->content_type = "image";
            $creativeModel->create_date_time = date('Y-m-d h:i:s');
            $nameArr=array();
            $dmArr=array();
            $extArr=array();

            if ($creativeModel->save()) {
                
                foreach ($images as $image) {

                    if ($image->isValid()) {
                        
                        //echo "<pre>";print_r($image);
                        
                        $dmsarr=array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31');
                        $imageVal = getimagesize($image);
                        
                        $chkdm=$imageVal[0] . 'X' . $imageVal[1];
                        if(in_array($chkdm, $dmsarr))
                        {
                             $extArr[] = $extension = $image->getClientOriginalExtension(); 
                              $imageVal2 = getimagesize($image);
                              $dmArr[] = $imageVal2[0] . 'X' . $imageVal2[1];
                               $nameArr[] = $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image
                        $image->move($destinationPath, $fileName); // uploading file to given path       
                       
                        }
                       /* $extArr[] = $extension = $image->getClientOriginalExtension(); // getting image extension
                        $imageVal = getimagesize($image);
                        $dmArr[] = $imageVal[0] . 'X' . $imageVal[1];
                        $nameArr[] = $fileName = $creativeModel->group_id . '_' . $imageVal[0] . 'X' . $imageVal[1] . '.' . $extension; // renameing image
                        $image->move($destinationPath, $fileName); // uploading file to given path       
                        echo $fileName."\n";
                        */
                        
                    }
                    
                    // sending back with message
                    //Session::flash('success', 'Upload successfully'); 
                    //return Redirect::to('upload');
                }

                $creativeModel->file_name = implode(',', $nameArr);
                $creativeModel->content_dimensions = implode(',', $dmArr);
                $creativeModel->content_extensions = implode(",", $extArr);

                if ($creativeModel->save()) {

                    $adsModel = new \App\Ads;
                    $camModel = new \App\Campaigns;

                    $camModel->advertiser_id = $creativeModel->advertiser_id;
                    $camModel->campaign_name = $post['adname'];
                    $camModel->iab_categories = "";
                    $camModel->adomain = $post['adomain'];
                    //                    $camModel->priority="";
                    //                    $camModel->weight="";
                    //                    $camModel->target_impressions="";
                    //                    $camModel->target_clicks="";
                    //                    $camModel->target_conversions="";
                    $camModel->campaign_budget = $post['total_budget'];
                    $camModel->daily_budget = $post['budget'];
                    //                    $camModel->total_spend="";
                    $camModel->revenue_type = "CPC";
                    $camModel->min_unit_price = $post['cpc'];
                    $camModel->status = "pending";
                    $camModel->admin_status = "pending";
                    $camModel->admin_remarks = "";
                    $camModel->time_zone = "";
                    //                    $camModel->impressions="";
                    //                    $camModel->clicks="";
                    //                    $camModel->conversions="";
                    //                    $camModel->amount="";
                    //                    $camModel->activate_date_time ="";
                    //                    $camModel->expire_date_time   ="";
                    //                    $camModel->targeting_methods="";
                    //                    $camModel->methods_plugins="";
                    $camModel->create_date_time = date("Y-m-d h:i:s");
                    $camModel->update_date_time = date("Y-m-d h:i:s");
                    $camModel->adv_cat_id = $post['cat_id'];
                    $camModel->adv_subcat_id = $post['subcat_id'];

                    if ($camModel->save()) {

                        $adsModel->campaign_id = $camModel->campaign_id;
                        $adsModel->content_type = "image";
                        $adsModel->creative_ids = $creativeModel->group_id;
                        $adsModel->ad_html = '';
                        $adsModel->ad_json = "";
                        $adsModel->ad_vast_url = "";
                        $adsModel->destination_url = $post['url'];
                        $adsModel->alt = "";
                        $adsModel->description = (isset($post['text_area_value'])) ? $post['text_area_value'] : "" ;
                        $adsModel->ad_status = "0";
                        $adsModel->ad_budget = $post['total_budget'];
                        $adsModel->ad_targeting_methods = "";
                        $adsModel->ad_method_plugins = "";
                        $adsModel->alternate_filename = "";
                        $adsModel->alternate_content_type = "";
                        $adsModel->admin_status = "pending";
                        $adsModel->admin_remarks = "";
                        //                       $adsModel->iab_attributes="";
                        //                       $adsModel->iab_categories="";
                        $adsModel->time_zone = "";
                        //                       $adsModel->activate_date_time="";
                        //                       $adsModel->expire_date_time="";
                        $adsModel->create_date_time = date("Y-m-d h:i:s");
                        $adsModel->update_date_time = date("Y-m-d h:i:s");

                        if ($adsModel->save()) {

                            if (isset($post['savecountry'])) { 

                                $assocModel = new \App\AdChannelGroupAssoc;
                                $targModel = new \App\TargettingChannelGroup;

                                $targModel->channel_type = "advertiser";
                                $targModel->owner_id = $creativeModel->advertiser_id;
                                $targModel->logical = "EQU";
                                $targModel->type = "COUNTRY";
                                $targModel->data = $post['savecountry'];
                                $targModel->create_date_time = date("Y-m-d h:i:s");
                                $targModel->update_date_time = date("Y-m-d h:i:s");

                                if ($targModel->save()) {

                                    $assocModel->ad_id = $adsModel->ad_id;
                                    $assocModel->channel_id = $targModel->channel_group_id;
                                    $assocModel->last_update = date("Y-m-d h:i:s");
                                    $assocModel->create_date = date("Y-m-d h:i:s");
                                    $assocModel->status = "1";

                                    $assocModel->save();
                                }
                            }

                     if (isset($post['state'])) {

                                $assocModel = new \App\AdChannelGroupAssoc;
                                $targModel = new \App\TargettingChannelGroup;


                                $targModel->channel_type = "advertiser";
                                $targModel->owner_id = $creativeModel->advertiser_id;
                                $targModel->logical = "EQU";
                                $targModel->type = "STATE";
                                $targModel->data = $post['state'];
                                $targModel->create_date_time = date("Y-m-d h:i:s");
                                $targModel->update_date_time = date("Y-m-d h:i:s");

                                if ($targModel->save()) {

                                    $assocModel->ad_id = $adsModel->ad_id;
                                    $assocModel->channel_id = $targModel->channel_group_id;
                                    $assocModel->last_update = date("Y-m-d h:i:s");
                                    $assocModel->create_date = date("Y-m-d h:i:s");
                                    $assocModel->status = "1";

                                    $assocModel->save();
                                }
                            }


                            if ( isset($post['pin']) ) {

                                $assocModel = new \App\AdChannelGroupAssoc;
                                $targModel = new \App\TargettingChannelGroup;


                                $targModel->channel_type = "advertiser";
                                $targModel->owner_id = $creativeModel->advertiser_id;
                                $targModel->logical = "EQU";
                                $targModel->type = "PIN";
                                $targModel->data = $post['pin'];
                                $targModel->create_date_time = date("Y-m-d h:i:s");
                                $targModel->update_date_time = date("Y-m-d h:i:s");

                                if ($targModel->save()) {

                                    $assocModel->ad_id = $adsModel->ad_id;
                                    $assocModel->channel_id = $targModel->channel_group_id;
                                    $assocModel->last_update = date("Y-m-d h:i:s");
                                    $assocModel->create_date = date("Y-m-d h:i:s");
                                    $assocModel->status = "1";

                                    $assocModel->save();
                                }
                            }

                            if ( isset($post['device'])) {

                                $assocModel = new \App\AdChannelGroupAssoc;
                                $targModel = new \App\TargettingChannelGroup;


                                $targModel->channel_type = "advertiser";
                                $targModel->owner_id = $creativeModel->advertiser_id;
                                $targModel->logical = "EQU";
                                $targModel->type = "DEVICE";
                                $targModel->data = $post['device'];
                                $targModel->create_date_time = date("Y-m-d h:i:s");
                                $targModel->update_date_time = date("Y-m-d h:i:s");

                                if ($targModel->save()) {

                                    $assocModel->ad_id = $adsModel->ad_id;
                                    $assocModel->channel_id = $targModel->channel_group_id;
                                    $assocModel->last_update = date("Y-m-d h:i:s");
                                    $assocModel->create_date = date("Y-m-d h:i:s");
                                    $assocModel->status = "1";

                                    $assocModel->save();
                                }
                            }

                            if (isset($post['os'])) {

                                $assocModel = new \App\AdChannelGroupAssoc;
                                $targModel = new \App\TargettingChannelGroup;


                                $targModel->channel_type = "advertiser";
                                $targModel->owner_id = $creativeModel->advertiser_id;
                                $targModel->logical = "EQU";
                                $targModel->type = "OS";
                                $targModel->data = $post['os'];
                                $targModel->create_date_time = date("Y-m-d h:i:s");
                                $targModel->update_date_time = date("Y-m-d h:i:s");

                                if ($targModel->save()) {

                                    $assocModel->ad_id = $adsModel->ad_id;
                                    $assocModel->channel_id = $targModel->channel_group_id;
                                    $assocModel->last_update = date("Y-m-d h:i:s");
                                    $assocModel->create_date = date("Y-m-d h:i:s");
                                    $assocModel->status = "1";

                                    $assocModel->save();
                                }
                            }


                            if (isset($post['browser'])) {

                                $assocModel = new \App\AdChannelGroupAssoc;
                                $targModel = new \App\TargettingChannelGroup;


                                $targModel->channel_type = "advertiser";
                                $targModel->owner_id = $creativeModel->advertiser_id;
                                $targModel->logical = "EQU";
                                $targModel->type = "BROWSER";
                                $targModel->data = $post['browser'];
                                $targModel->create_date_time = date("Y-m-d h:i:s");
                                $targModel->update_date_time = date("Y-m-d h:i:s");

                                if ($targModel->save()) {

                                    $assocModel->ad_id = $adsModel->ad_id;
                                    $assocModel->channel_id = $targModel->channel_group_id;
                                    $assocModel->last_update = date("Y-m-d h:i:s");
                                    $assocModel->create_date = date("Y-m-d h:i:s");
                                    $assocModel->status = "1";

                                    $assocModel->save();
                                }
                            }


                            if (isset($post['tele'])) {

                                $assocModel = new \App\AdChannelGroupAssoc;
                                $targModel = new \App\TargettingChannelGroup;


                                $targModel->channel_type = "advertiser";
                                $targModel->owner_id = $creativeModel->advertiser_id;
                                $targModel->logical = "EQU";
                                $targModel->type = "OPERATOR";
                                $targModel->data = $post['tele'];
                                $targModel->create_date_time = date("Y-m-d h:i:s");
                                $targModel->update_date_time = date("Y-m-d h:i:s");

                                if ($targModel->save()) {

                                    $assocModel->ad_id = $adsModel->ad_id;
                                    $assocModel->channel_id = $targModel->channel_group_id;
                                    $assocModel->last_update = date("Y-m-d h:i:s");
                                    $assocModel->create_date = date("Y-m-d h:i:s");
                                    $assocModel->status = "1";

                                    $assocModel->save();
                                }
                            }
                        } //ads entry to the database
                    } // campaign entry to the database
                } // image update to database
            }// image entry to the database
        } else {

            return redirect('creat-ad')->with('error_ad', 'Image not selected!');
        } //check image condition ends here

            return redirect('myaccount')->with('success_ad', 'Ad Created Succesfully!');
        //dd( DB::getQueryLog() );
        //foreach closed
        //echo "<pre>";print_r( $post );
            
    }

    public function destroy_ad(Request $request) {
        $check_campagin_id = $request->check_ad;
        $advertiser_id = $request->advertiser_id;
        if ($check_campagin_id) {

            $check_campagin_id = rtrim(str_replace(array("null,", ",null"), "", $check_campagin_id), ',');
            $check_campagin_ar = explode(",", $check_campagin_id);
            $campaignModel = new \App\Campaigns();

            foreach ($check_campagin_ar as $value) {
                $campaignModel::where('campaign_id', '=', $value)->update(['status' => 'complete']);
            }

            return "success";
        }

        return "not success";
    }

    //make function for Active ad
    public function make_active_ad(Request $request) {
        $check_campagin_id = $request->check_ad;
        $advertiser_id = $request->advertiser_id;
        if ($check_campagin_id) {

            $check_campagin_id = rtrim(str_replace(array("null,", ",null"), "", $check_campagin_id), ',');
            $check_campagin_ar = explode(",", $check_campagin_id);
            $campaignModel = new \App\Campaigns();
            $adsModel = new \App\Ads();
            
            
            foreach ($check_campagin_ar as $value) {
                $campaignModel::where('campaign_id', '=', $value)->update(['status' => 'running','admin_status' => 'approved']);
                $adsModel::where('campaign_id', '=', $value)->update(['ad_status' => '1','admin_status' => 'approved']);
            }

            return "success";
        }

        return "not success";
    }

    //make function for pause ad

    public function make_pause_ad(Request $request) {

        $check_campagin_id = $request->check_ad;
        $advertiser_id = $request->advertiser_id;
        if ($check_campagin_id) {

            $check_campagin_id = rtrim(str_replace(array("null,", ",null"), "", $check_campagin_id), ',');
            $check_campagin_ar = explode(",", $check_campagin_id);
            $campaignModel = new \App\Campaigns();
            $adsModel = new \App\Ads();
            

            foreach ($check_campagin_ar as $value) {
                 $campaignModel::where('campaign_id', '=', $value)->update(['status' => 'pause','admin_status' => 'pending']);
                 $adsModel::where('campaign_id', '=', $value)->update(['ad_status' => '0','admin_status' => 'pending']);
            }

            return "success";
        }

        return "not success";
    }

    public function change_cpc(Request $request) {

        $check_campagin_id = $request->check_ad;
        $new_cpc = $request->new_cpc;
        $advertiser_id = $request->advertiser_id;

        if ($check_campagin_id) {

            $check_campagin_id = rtrim(str_replace(array("null,", ",null"), "", $check_campagin_id), ',');
            $check_campagin_ar = explode(",", $check_campagin_id);
            $campaignModel = new \App\Campaigns();

            foreach ($check_campagin_ar as $value) {
                $campaignModel::where('campaign_id', '=', $value)->update(['min_unit_price' => $new_cpc]);
            }

            return "success";
        }

        return "not success";
    }

    public function change_budget(Request $request) {

        $check_campagin_id = $request->check_ad;
        $new_cpc = $request->new_budget;
        $advertiser_id = $request->advertiser_id;

        if ($check_campagin_id) {

            $check_campagin_id = rtrim(str_replace(array("null,", ",null"), "", $check_campagin_id), ',');
            $check_campagin_ar = explode(",", $check_campagin_id);
            $campaignModel = new \App\Campaigns();

            foreach ($check_campagin_ar as $value) {
                $campaignModel::where('campaign_id', '=', $value)->update(['campaign_budget' => $new_cpc]);
            }

            return "success";
        }

        return "not success";
    }

    /*
      get ads running info in json format
     *  */

    public function createSimilarAd(Request $request) {

        $check_campagin_id = $request->check_ad;
        $advertiser_id = $request->advertiser_id;

        //getting the stat records
        $statModel = new \App\Campaigns();
        $adModel = new \App\Ads();
        
        //$statData = $statModel::find(7)->replicate()->save();
        $adData = $adModel::where("campaign_id","=",7)->get()->replicate()->save();
        echo "<pre>";print_r( $adData );die;
        if($statData ==1 && $adData ==1)
            return "success";
        else
            return "not success";
        
//        echo "<pre>";print_r( $statData );die;
        return $statData->toJson();
    }
    
    
     public function editad(Request $request) {
        //var_dump('id:', \Session::getId());
        $cmpid=$request->campaign_id;
        
        if($cmpid !=''){
         // $json_urlv = url("geAdDetail");
              $json_urlv = url('creat-ad/get-detail?campaign_id='.$cmpid);
        $jsonv = file_get_contents( $json_urlv );
                //echo $jsonv;
        $data = json_decode($jsonv,true);  
               
                
          $json_url = url("json-data/get-categories");
        $json = file_get_contents( $json_url );

        $datacat = json_decode($json,true);
        $typeCat=0;
        $catid=$data[0]['adv_cat_id'];
        $subcatid=$data[0]['adv_subcat_id'];
            $categories = $datacat[$typeCat][0][$catid];
       $subcategories = $datacat[$typeCat][$catid][$subcatid];          
        
        return View('edit-ad',['cmpid'=>$cmpid,'dataval'=>$data,'categories' => $categories, 'subcategories' => $subcategories,'catid'=>$catid,'subcatid'=>$subcatid]);
        }  else {
          return redirect('myaccount');    
        }
    }
    
    public function getReport(){
        
          //var_dump('id:', \Session::getId());
        $session    = Session::all();
        $currency   = $this->getCurrencyFromAccount( $session['sessiondata']['accounts'][0]['account_id'] );
        return View('reports_tab',['currency'=>$currency]);
        
    }
    
     public function editProfileDetail(Request $request){
        
       $post = $request->all(); 
       $user_email  =  Session::get('UserEmail');
       $userModel=  new \App\User();
       $userData  =  $userModel::where('email_address' , '=', $user_email)->first();

       
       $name=trim($post['name']);
       $pos = strpos($name,' ');
       if($pos===false)
       {
           $userData->first_name = $name;
       }  else {
           $expd =  explode(' ', $name);
          $cnt=count($expd)-1;
          if(!empty($expd[$cnt])){
          $userData->last_name = $expd[$cnt];
          }
          $namestr='';
          for($v=0;$v<count($expd)-1;$v++)
          {
             $namestr .= $expd[$v];
          }
          $userData->first_name = $namestr;
       }
       
       
       //
      // $userData->last_name = $post['last_name'];
       $userData->email_address = $post['email'];
       $userData->phone_number = $post['mobile'];
       $userData->phone_country_code = $post['phone_country'];
       $userData->country_id = $post['country'];
       
       
       if(trim($post['cpwd'])!='' && trim($post['email'])!='' && trim($post['npwd'])!=''){
         if (Auth::attempt(['email_address' => $post['email'], 'password' => $post['cpwd']])) {

            $user = Auth::user();
            if ($user) {
//                Session::put('UserID', $user->user_id);               
                $userData->password  =  Hash::make($post['npwd']) ;                
            } else {
            return redirect('/myprofile')->with('error_pwd', 'Please provide valid current password');
        }     
         }
        }
       
       
       if( $userData->save() ){
           
         return  redirect("/myprofile")->with('status', 'Profile updated!');
           
       } 
       
      return  redirect("/myprofile")->with('status', 'Profile not updated!');
       //echo "<pre>";print_r($userModel::find($user_id)->toJson());die;
       
    }
    
        public function getPubReport(){
        
        //var_dump('id:', \Session::getId());
        return View("/pubadmaccount");
        
    }
    
     public function getCurrencyFromAccount($account_id){
        
     $data =    \App\Advertiser::where('dl_advertisers.account_id',$account_id)
                ->leftJoin('currency_database', 'currency_database.id', '=', 'dl_advertisers.default_currency')
                ->selectRaw('currency_database.symbol')
                ->take(1)->get(); 
        
        
        return  ($data[0]->symbol) ? $data[0]->symbol : 0 ;
    }
   
}
