<?php

namespace App\Http\Controllers;

use DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;
use App\Account;
use Auth;
use Cache;

class JsonController extends Controller {

    public function __construct() {
        $this->session = SESSION::All();
        if (!isset($this->session['sessiondata']['user_timezone']) && empty($this->session['sessiondata']['user_timezone'])) {
            date_default_timezone_set(date('e'));
        } else {
            date_default_timezone_set($this->session['sessiondata']['user_timezone']);
        }
        // date_default_timezone_set('Pacific/Tongatapu');
        if (Auth::check() && isset($this->session['sessiondata']['accounts'][0]['account_type']) && $this->session['sessiondata']['accounts'][0]['account_type'] == 'ADVERTISER') {
            $this->advertiserdata = Account::find($this->session['sessiondata']['accounts'][0]['account_id'])->advertiser;
            $this->advertiserdata = $this->advertiserdata->toArray();
            $this->currency = !empty($this->advertiserdata['currency']) ? $this->advertiserdata['currency'] : 'USD';
            $this->currencyminarray = config('paymentgateway.currencyminarray');
            $this->currencymin = $this->currencyminarray[$this->currency];
            $this->advertiserdata['currencymin'] = $this->currencymin;
        }
    }

    /*
      get all categories in json format
     *
     */

    public function getCountries() {
        $getAll = Cache::get('countries');
        if (!($getAll)) {
            $getAll = \App\Country::all();
            Cache::store('apc')->put('countries', $getAll, 36000);
        }
        return $getAll->toJson();
    }

    /*
     * get all state
     * 
     */
     public function getState(Request $request) {
          $q = $request->q;
        $pos = strpos($q, ',');
        $qArr = array();
        if ($pos === false) {
            $qArr[] = $q;
        } else {
            $qArr = explode(',', $q);
        }
         $statModel = new \App\StatezipCode;
         $statData = Cache::get('state_' . $q);
         if (!$statData) {
             /*SELECT DISTINCT(`region`),`iso2` FROM `country_region_zip` WHERE `iso2` in ('IN','CA') order by region,iso2*/
  //$qv=implode("','",  explode(",",$q));
// echo $qv="'".$qv."'";
 
         $statData = DB::table('country_region_zip')
         ->select(DB::raw('distinct(region), iso2'))
         ->whereIn('iso2',$qArr)
         ->orderBy('region')
         ->orderBy('iso2')->get();
 
 
            Cache::store('apc')->put('state_' . $q, $statData, 36000);
        }
        $final_array = array();
        if (count($statData) > 0) {
            foreach ($statData as $key => $value) {
                $sb = array();
                $sb['id'] = $value->iso2;
                $sb['region'] = $value->region;
               
                $final_array[] = $sb;
            }
        }
        return json_encode($final_array);
         
    }
    
    /*
      get all cities in json format
     *  */

    public function getAllCities(Request $request) {
        //$advertisers = DB::table('dl_advertisers')->get();
        // $q = $_GET["q"];
        $q = $request->q;

        $statModel = new \App\Cities;
        $statData = Cache::get('city_' . $q);
        //$statData = $statModel::where('city', 'LIKE', '%'.$q.'%')->get();
        if (!$statData) {
            $statData = $statModel::where('country_iso', '=', $q)->orderBy('city', 'desc')->get();
            Cache::store('apc')->put('city_' . $q, $statData, 36000);
        }
        $final_array = array();
        if (count($statData) > 0) {

            foreach ($statData as $key => $value) {
                $sb = array();
                $sb['id'] = $value->city;
                $sb['name'] = $value->city;
                $final_array[] = $sb;
            }
        }

        return json_encode($final_array);
    }

    /*
      get Selected countries cities  in json format
     *  */

    public function getSelectedCities(Request $request) {

        //$advertisers = DB::table('dl_advertisers')->get();
        // $q = $_GET["q"];
        $q = $request->q;
        $pos = strpos($q, ',');
        $qArr = array();
        if ($pos === false) {
            $qArr[] = $q;
        } else {
            $qArr = explode(',', $q);
        }

        $statModel = new \App\Cities;



        $statData = $statModel::whereIn('country_iso3', $qArr)->get();
        //->groupBy('country_iso3')
        //->all();
        $final_array = array();
        if (count($statData) > 0) {

            foreach ($statData as $key => $value) {
                $sb = array();
                $sb['id'] = $value->city;
                $sb['name'] = $value->city;
                $sb['iso3'] = $value->country_iso3;
                $final_array[] = $sb;
            }
        }

        return json_encode($final_array);
    }

    /*
      get all categories in json format
     *  */

    public function getIabCategories() {


        $getAll = Cache::get('iab_categories');
        if (!$getAll) {
            $getAll = \App\CfCategory::all();
            Cache::store('apc')->put('iab_categories', $getAll, 36000);
        }

        $final_array = array();
        if (count($getAll) > 0) {

            foreach ($getAll as $key => $value) {

                $value->iab_category_id = ($value->iab_category_id) ? $value->iab_category_id : $value->category_id;
                $value->iab_parent_id = ($value->iab_parent_id) ? $value->iab_parent_id : 0;
                $final_array[$value->iab_parent_id][$value->iab_category_id] = $value->description;
            }
        }
        return json_encode($final_array);
    }

    /*
      get all categories in json format
     *  */

    public function getCategories() {

        //$advertisers = DB::table('dl_advertisers')->get();

        $getAll = Cache::get('adv_categories');
        if (!$getAll) {
            $getAll = \App\AdvCategory::all();
            Cache::store('apc')->put('adv_categories', $getAll, 36000);
        }

        $final_array = array();
        if (count($getAll) > 0) {

            foreach ($getAll as $key => $value) {

                if ($value->type == "B")
                    $final_array[0][$value->parent_id][$value->id] = $value->description;
                else
                    $final_array[1][$value->parent_id][$value->id] = $value->description;
            }
        }
        //echo "<pre>";print_r($final_array);
        return json_encode($final_array);
    }

    /*
      get all devices in json format
     *  */

    public function getDevices(Request $request) {


        if (isset($request->q) && trim($request->q) != '') {
            $q = $request->q;
        } else {
            $q = 'all';
        }
        $pos = strpos($q, ',');
        $qArr = array();
        if ($pos === false) {
            $qArr[] = $q;
        } else {
            $qArr = explode(',', $q);
        }

        $statModel = new \App\Devices;

        if ($q == 'all' || $qArr[0] == 'all') {
            $statData = $statModel::distinct()->select('device_brand')
                    ->orderBy('device_brand', 'asc')
                    ->get();
        } else {

            $statData = $statModel::whereIn('device_type', $qArr)->get();
        }
        $final_array = array();
        $final_array2 = array();
        if (count($statData) > 0) {

            foreach ($statData as $key => $value) {
                $final_array[] = $value->device_brand;
            }
        }

        $final_array2 = array();
        $statDatav = Cache::get('device_brands');
        if (!$statDatav) {
            $statDatav = $statModel::distinct()->select('device_brand')
                    ->orderBy('device_brand', 'asc')
                    ->get();
            Cache::store('apc')->put('device_brands', $statDatav, 36000);
        }

        if (count($statDatav) > 0) {

            foreach ($statDatav as $key => $value) {

                if (in_array(trim($value->device_brand), $final_array)) {
                    $final_array2[$value->device_brand] = 'checked';
                } else {
                    $final_array2[$value->device_brand] = '';
                }
            }
        }
        return json_encode($final_array2);
    }

    /*
      get all os in json format
     *  */

    public function getOs(Request $request) {

        if (isset($request->q) && trim($request->q) != '') {
            $q = $request->q;
        } else {
            $q = 'all';
        }

        $os_list = Cache::get('device_os_list');
        if (!$os_list) {
            $os_list = parse_ini_file('target_data/category_os.php', true);
            Cache::store('apc')->put('device_os_list', $os_list, 36000);
        }

        $pos = strpos($q, ',');
        $qArr = array();
        if ($pos === false) {
            $qArr[] = $q;
        } else {
            $qArr = explode(',', $q);
        }
        $final_array = array();
        foreach ($os_list as $device_type => $os) {
            if ($q == 'all' || $qArr[0] == 'all') {
                $final_array = array_merge($final_array, $os);
            } else {
                if (array_key_exists($device_type, $qArr)) {
                    $final_array = array_merge($final_array, $os);
                }
            }
        }
        return json_encode($final_array);
    }

    /*
      get all osv in json format
     *  */

    public function getOsV() {

        //$contents = Storage::disk('local')->get('target_data/device_list.include');
        $contents = file('target_data/osv_list.include');
        //print_r( json_encode($contents) );
        return json_encode($contents);
    }

    /*
      get all browser in json format
     *  */

    public function getBrowser() {

        //$contents = Storage::disk('local')->get('target_data/device_list.include');
        $contents = file('target_data/browser_list.include');
        //print_r( json_encode($contents) );
        return json_encode($contents);
    }

    /*
      get all browser versions in json format
     *  */

    public function getBrowserV() {

        //$contents = Storage::disk('local')->get('target_data/device_list.include');
        $contents = file('target_data/browserv_list.include');
        //print_r( json_encode($contents) );
        return json_encode($contents);
    }

    /*
      get all browser in json format
     *  */

    public function getOperator(Request $request) {
        $country = $request->q;

        if (trim($country) == '' || !$country) {
            $country[] = 'IND';
        } else {
            $country = explode(',', $country);
        }

        $operators_list = Cache::get('operators_list');

        if (!$operators_list) {
            $operators_list = parse_ini_file('target_data/operators.php', true);
            Cache::store('apc')->put('operators_list', $operators_list, 36000);
        }

        $selected_operators = array();
        $counter = 0;
        foreach ($operators_list as $ckey => $operators) {
            if (in_array(trim($ckey), $country)) {
                foreach ($operators as $operator_name => $operator_id) {
                    $selected_operators[$counter]['operator_id'] = $operator_id;
                    $selected_operators[$counter]['operator_name'] = $operator_name;
                    $selected_operators[$counter]['country_name_iso3'] = $ckey;
                    $counter++;
                }
            }
        }
        return json_encode($selected_operators);
    }

    /*
      get ads running info in json format
     * */

    public function getReportInfoAdvertiser(Request $request) {
        if (!isset($this->advertiserdata)) {
            return false;
        }

        if (isset($request->start) && !empty($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Ymd');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->start = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Ymd');
        }

        if (isset($request->end) && !empty($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Ymd');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->end = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Ymd');
        }

        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start . '000000' : date("Ymd") . '000000';
        $end = ( $request->end ) ? $request->end . '235959' : date("Ymd") . '235959';
        //getting the stat records
        if (!isset($request->groupby)) {
            $request->groupby = 1;
        }
        $statModel = new \App\hourlyStat();

        $statData = $statModel->join('dl_campaigns', 'hourly_stat.campaign_id', '=', 'dl_campaigns.campaign_id')
                ->leftJoin('advertiser_webpage', 'advertiser_webpage.page_id', '=', 'hourly_stat.url_id')
                ->where('hourly_stat.advertiser_id', $this->advertiserdata['advertiser_id'])
                ->where('hourly_stat.stat_date', '>=', $start)
                ->where('hourly_stat.stat_date', '<=', $end);
        if ($request->groupby == 2) {
            $statData = $statData->where('advertiser_webpage.webpage_name', '=', '')
                    ->where('advertiser_webpage.url', '!=', '')
                    ->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "dl_campaigns.status,"
                            . "dl_campaigns.min_unit_price,"
                            . "advertiser_webpage.url,"
                            . "dl_campaigns.min_unit_price_currency,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3)as spend_currency,"
                            . "dl_campaigns.campaign_budget,"
                            . "dl_campaigns.campaign_budget_currency,"
                            . "hourly_stat.ad_id, sum(impression_count) as imp,"
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "hourly_stat.revenue_value as spend,"
                            . "hourly_stat.revenue_value_currency as spend_currency,"
                            . "hourly_stat.stat_date")
                    ->groupBy('hourly_stat.stat_date', 'hourly_stat.url_id', 'dl_campaigns.campaign_id')
                    ->orderBy('hourly_stat.stat_date', 'desc')
                    ->orderBy('advertiser_webpage.url', 'asc')
                    ->orderBy('dl_campaigns.campaign_name', 'asc');
        } else if ($request->groupby == 3) {
            $statData = $statData->where('advertiser_webpage.webpage_name', '!=', '')
                    ->where('advertiser_webpage.url', '!=', '')
                    ->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "advertiser_webpage.webpage_name,"
                            . "dl_campaigns.status,"
                            . "dl_campaigns.min_unit_price,"
                            . "dl_campaigns.min_unit_price_currency,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3)as spend_currency,"
                            . "dl_campaigns.campaign_budget,"
                            . "dl_campaigns.campaign_budget_currency,"
                            . "hourly_stat.ad_id, sum(impression_count) as imp,"
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "hourly_stat.revenue_value as spend,"
                            . "hourly_stat.revenue_value_currency as spend_currency,"
                            . "hourly_stat.stat_date")
                    ->groupBy('hourly_stat.stat_date', 'hourly_stat.url_id', 'dl_campaigns.campaign_id')
                    ->orderBy('hourly_stat.stat_date', 'desc')
                    ->orderBy('advertiser_webpage.webpage_name', 'asc')
                    ->orderBy('dl_campaigns.campaign_name', 'asc');
        } else { //default
            $statData = $statData->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "dl_campaigns.status,"
                            . "dl_campaigns.min_unit_price,"
                            . "advertiser_webpage.url,"
                            . "dl_campaigns.min_unit_price_currency,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3)as spend_currency,"
                            . "dl_campaigns.campaign_budget,"
                            . "dl_campaigns.campaign_budget_currency,"
                            . "hourly_stat.ad_id, sum(impression_count) as imp,"
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "hourly_stat.revenue_value as spend,"
                            . "hourly_stat.revenue_value_currency as spend_currency,"
                            . "hourly_stat.stat_date")
                    //->groupBy('hourly_stat.url_id', 'hourly_stat.stat_date')
                    ->groupBy('dl_campaigns.campaign_id', 'hourly_stat.stat_date')
                    ->orderBy('hourly_stat.stat_date', 'desc')
                    ->orderBy('dl_campaigns.campaign_name', 'asc');
        }
        //$statData = $statData->get();
        $statData = $statData->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        return $statData->toJson();
    }

    /*
      get ads info for logged in advertiser in json format
     *  */

    public function getAdInfoAdvertiser(Request $request) {
        if (!isset($this->advertiserdata)) {
            return json_encode(false);
        }

        if (isset($request->start) && !empty($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->start = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        }

        if (isset($request->end) && !empty($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->end = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        }
        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start : '';
        $end = ( $request->end ) ? $request->end : '';

        //getting the stat records
        $statModel = new \App\Campaigns();
        if (trim($request->start) != '' && trim($request->end) != '') {
            $statData = $statModel::leftJoin('hourly_stat', function( $join)use($start, $end ) {
                        $join->on('dl_campaigns.campaign_id', '=', 'hourly_stat.campaign_id')
                        ->where('hourly_stat.stat_date', '>=', $start)
                        ->where('hourly_stat.stat_date', '<=', $end);
                    })
                    ->where('dl_campaigns.advertiser_id', $this->advertiserdata['advertiser_id'])
                    ->where("dl_campaigns.status", "!=", "archived")
                    //->whereBetween("hourly_stat.stat_date", array($start, $end))
                    ->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "dl_campaigns.status,"
                            . "dl_campaigns.admin_status,"
                            . "round(dl_campaigns.min_unit_price,3) as min_unit_price,"
                            . "round(dl_campaigns.min_unit_price_currency,3) as min_unit_price_currency,"
                            . "round(dl_campaigns.campaign_budget,3) as campaign_budget, "
                            . "round(dl_campaigns.campaign_budget_currency,3) as campaign_budget_currency,"
                            . "hourly_stat.ad_id, sum(impression_count) as imp, "
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3) as spend_currency"
                    )
                    ->groupBy('dl_campaigns.campaign_id')
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        } else {

            $statData = $statModel::leftJoin('hourly_stat', function( $join ) {
                        $join->on('dl_campaigns.campaign_id', '=', 'hourly_stat.campaign_id')
                        ->where('hourly_stat.stat_date', '>=', $start)
                        ->where('hourly_stat.stat_date', '<=', $end);
                    })
                    ->where('dl_campaigns.advertiser_id', $this->advertiserdata['advertiser_id'])
                    ->where("dl_campaigns.status", "!=", "archived")
                    //->where('dl_campaigns.status', '!=', "complete")
                    ->whereBetween("hourly_stat.stat_date", array(date("Y-m-d"), date("Y-m-d")))
                    ->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "dl_campaigns.status,"
                            . "dl_campaigns.admin_status,"
                            . "round(dl_campaigns.min_unit_price,3) as min_unit_price,"
                            . "round(dl_campaigns.min_unit_price_currency,3) as min_unit_price_currency,"
                            . "round(dl_campaigns.campaign_budget,3) as campaign_budget, "
                            . "round(dl_campaigns.campaign_budget_currency,3) as campaign_budget_currency, "
                            . "hourly_stat.ad_id, "
                            . "sum(impression_count) as imp, "
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3) as spend_currency")
                    ->groupBy('dl_campaigns.campaign_id')
                    //->take($take)
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        }
        return $statData->toJson();
    }

    public function getTotalAdReportAdvertiser(Request $request) {

        if (isset($request->start) && !empty($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->start = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        }

        if (isset($request->end) && !empty($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->end = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        }
        $start = ( $request->start ) ? $request->start : '';
        $end = ( $request->end ) ? $request->end : '';

        //getting the stat records
        $statModel = new \App\Campaigns();
        if (trim($request->start) != '' && trim($request->end) != '') {
            $statData = $statModel::leftJoin('hourly_stat', function( $join)use($start, $end ) {
                        $join->on('dl_campaigns.campaign_id', '=', 'hourly_stat.campaign_id')
                        ->where('hourly_stat.stat_date', '>=', $start)
                        ->where('hourly_stat.stat_date', '<=', $end);
                    })
                    ->where('dl_campaigns.advertiser_id', $this->advertiserdata['advertiser_id'])
                    ->where("dl_campaigns.status", "!=", "archived")
                    ->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "dl_campaigns.advertiser_id,"
                            . "dl_campaigns.status,"
                            . "round(dl_campaigns.min_unit_price,3) as min_unit_price,"
                            . "round(dl_campaigns.min_unit_price_currency,3) as min_unit_price_currency,"
                            . "round(dl_campaigns.campaign_budget,3) as campaign_budget,"
                            . "round(dl_campaigns.campaign_budget_currency,3) as campaign_budget_currency,"
                            . "hourly_stat.ad_id, "
                            . "sum(impression_count) as imp, "
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3) as spend_currency"
                    )
                    ->groupBy("dl_campaigns.campaign_id")
                    ->get();
        } else {
            $statData = $statModel::leftJoin('hourly_stat', function( $join ) {
                        $join->on('dl_campaigns.campaign_id', '=', 'hourly_stat.campaign_id');
                    })
                    ->where('dl_campaigns.advertiser_id', $this->advertiserdata['advertiser_id'])
                    ->where("dl_campaigns.status", "!=", "archived")
//                ->where('dl_campaigns.status', '!=', "complete")
                    // ->whereBetween("hourly_stat.stat_date", array($start, $end))	
                    ->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "dl_campaigns.status,"
                            . "round(dl_campaigns.min_unit_price,3) as min_unit_price,"
                            . "round(dl_campaigns.min_unit_price_currency,3) as min_unit_price_currency,"
                            . "round(dl_campaigns.campaign_budget,3) as campaign_budget,"
                            . "round(dl_campaigns.campaign_budget_currency,3) as campaign_budget_currency,"
                            . "hourly_stat.ad_id,"
                            . "sum(impression_count) as imp,"
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3) as spend_currency"
                    )
                    ->groupBy("dl_campaigns.campaign_id")
                    ->get();
        }
        $campaign_data = array();
        $campaign_data['running_count'] = 0;
        $campaign_data['spend_currency'] = 0;
        $campaign_data['conversions'] = 0;
        $campaign_data['clicks'] = 0;
        $campaign_data['campaign_budget_currency'] = 0;
        $campaign_data['account_balance_currency'] = $this->advertiserdata['balance_left_currency'] = 0;
        $statData = $statData->toArray();
        foreach ($statData as $statRow) {
            if ($statRow['status'] == 'running') {
                $campaign_data['running_count'] ++;
            }
            $campaign_data['spend_currency'] += $statRow['spend_currency'];
            $campaign_data['campaign_budget_currency'] += $statRow['campaign_budget_currency'];
            $campaign_data['clicks'] += $statRow['clicks'];
            $campaign_data['conversions'] += $statRow['conversions'];
        }

        $stvdata = array('data' => $campaign_data);
        return json_encode($stvdata);
    }

    public function getAdminPubInfo(Request $request) {

        //echo "<pre>";print_r($request);die;
        if (isset($request->start) && !empty($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        }

        if (isset($request->end) && !empty($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        }

        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start : "";
        $end = ( $request->end ) ? $request->end : "";

        //getting the stat records
        $statModel = new \App\Publisher();

        $statData = $statModel::leftJoin('hourly_stat', function( $join ) {
                    $join->on('publishers.publisher_id', '=', 'hourly_stat.publisher_id');
                });
//                ->where('hourly_stat.advertiser_id', Session::get('UserID'))


        if ($start != "" && $end != "")
            $statData = $statData->whereBetween("hourly_stat.stat_date", array($start, $end));

        $statData = $statData->selectRaw("sum(hourly_stat.request_count) as request_count,sum(hourly_stat.bid_count) as bid_count,sum(hourly_stat.win_count) as win_count,sum(hourly_stat.impression_count) as impression_count,publishers.company,hourly_stat.publisher_id")
                ->groupBy('publishers.publisher_id')
                ->where('hourly_stat.publisher_id', '!=', "NULL")
                //->take($take)
                ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        //echo "<pre>";print_r( $statData->toJson() );die;
        return $statData->toJson();
    }
    
    public function getAdvertiserListInfo(Request $request) {

        //echo "<pre>";print_r($request);die;
        

        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start : "";
        $end = ( $request->end ) ? $request->end : "";

        //getting the stat records
        $statModel = new \App\Advertiser();

        $statData = $statModel::leftJoin('cf_users', function( $join ) {
                    $join->on('dl_advertisers.account_id', '=', 'cf_users.default_account_id');
                });
//                ->where('hourly_stat.advertiser_id', Session::get('UserID'))


//        if ($start != "" && $end != "")
//            $statData = $statData->whereBetween("hourly_stat.stat_date", array($start, $end));

        $statData = $statData->selectRaw("dl_advertisers.account_id as ids,dl_advertisers.contact_name as name, dl_advertisers.company as comp,dl_advertisers.contact_email as email,dl_advertisers.contact_mobile as mobile")
//                ->groupBy('publishers.publisher_id')
                ->orderBy('dl_advertisers.company','DESC')
                ->where('dl_advertisers.status', '=', "1")
                ->where('cf_users.is_active', '=', "1")
                //->take($take)
                ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        //echo "<pre>";print_r( $statData->toJson() );die;
        return $statData->toJson();
    }
    
    public function getBillingInfo(Request $request) {

        //echo "<pre>";print_r($request);die;
        

        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $id = ( $request->adv_id ) ? $request->adv_id : "";
        

        //getting the stat records
        $statModel = new \App\Advertiser();

        $statData = $statModel::leftJoin('cf_users', function( $join ) {
                    $join->on('dl_advertisers.account_id', '=', 'cf_users.default_account_id');
                });
//                ->where('hourly_stat.advertiser_id', Session::get('UserID'))


//        if ($start != "" && $end != "")
//            $statData = $statData->whereBetween("hourly_stat.stat_date", array($start, $end));

        $statData = $statData->selectRaw("dl_advertisers.company as comp, dl_advertisers.account_id as ids, dl_advertisers.billing_address bill_address, dl_advertisers.billing_city as bill_city, dl_advertisers.billing_state as bill_state, dl_advertisers.billing_country as bill_country, dl_advertisers.billing_pin_code as bill_pin, dl_advertisers.billing_contact_email as bill_email, dl_advertisers.billing_contact_name as bill_name, dl_advertisers.billing_phone as bill_phone")
//                ->groupBy('publishers.publisher_id')
//                ->orderBy('dl_advertisers.company','DESC')
//                ->where('dl_advertisers.status', '=', "1")
                ->where('dl_advertisers.account_id', '=', $id)
                //->take($take)
                ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        //echo "<pre>";print_r( $statData->toJson() );die;
        return $statData->toJson();
    }

    public function getAdvPageInfo(Request $request) {

        //echo "<pre>";print_r($request);die;
        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start : "";
        $end = ( $request->end ) ? $request->end : "";
        $adv_id = ( $request->adv_id ) ? $request->adv_id : 0;
        //getting the stat records
        $statModel = new \App\CampaignWebpage();


        if ($start != "" && $end != "") {

            $statData = $statModel::leftJoin('hourly_stat_page', function( $join ) {
                        $join->on('advertiser_webpage.page_id', '=', 'hourly_stat_page.page_id');
                    })->whereBetween("hourly_stat_page.stat_date", array($start, $end))
                    ->where("advertiser_webpage.advertiser_id", "=", $adv_id)
                    ->selectRaw("sum(hourly_stat_page.clicks_count) as total_clicks,advertiser_webpage.page_id")
                    ->groupBy('advertiser_webpage.page_id')
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        } else {

            $statData = $statModel::leftJoin('hourly_stat_page', function( $join ) {
                        $join->on('advertiser_webpage.page_id', '=', 'hourly_stat_page.page_id');
                    })->where("advertiser_webpage.advertiser_id", "=", $adv_id)
                    ->selectRaw("sum(hourly_stat_page.clicks_count) as total_clicks,advertiser_webpage.page_id")
                    ->groupBy('advertiser_webpage.page_id')
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        }

        return $statData->toJson();
    }

    public function getAdminPubList() {
        $statData = DB::select("select publisher_id,company from publishers where status='1' and admin_status='approved'");
        //$data=json_encode($statData);
//                ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        $result['data'] = $statData;
        $data = json_encode($result);
        return $data;
    }

//    
//    public function getAdminPubList() {
//        $statData = selectRaw("publishers.publisher_id,publishers.company")
//                    ->where("publishers.status", "=", "1")
//                    ->where("publishers.admin_status", "=", "approved");
//        
////                ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
//                    return $statData->toJson();
//    }

    public function getAdminAdInfo(Request $request) {



        //echo "<pre>";print_r($request);die;
        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start : "";
        $end = ( $request->end ) ? $request->end : "";
        $all_live = ( $request->live == 1 ) ? 1 : 0;
        //getting the stat records
        $statModel = new \App\Campaigns();


        if ($start != "" && $end != "") {

            $end = date('Y-m-d H:i:s', strtotime("+1 days $end"));
            $statData = $statModel::leftJoin('hourly_stat', function( $join ) {
                        $join->on('hourly_stat.campaign_id', '=', 'dl_campaigns.campaign_id');
                    })->leftJoin('ads', function( $join ) {
                        $join->on('ads.campaign_id', '=', 'dl_campaigns.campaign_id');
                    })->selectRaw("dl_campaigns.campaign_id,dl_campaigns.campaign_name,dl_campaigns.status,round(dl_campaigns.min_unit_price,3) as min_unit_price,round(dl_campaigns.campaign_budget,3) as campaign_budget, hourly_stat.ad_id, sum(hourly_stat.impression_count) as imp, sum(hourly_stat.clicks_count) as clicks,round(sum(hourly_stat.revenue_value),3) as spend, sum(hourly_stat.conversions_count) as conv,ads.admin_cpm as adcpm,ads.current_cpm as curcpm,dl_campaigns.cpa_id as cpa_id,dl_campaigns.adomain as adomain,dl_campaigns.admin_status,ads.ad_status,ads.admin_status as admin_status_ad,ads.publisher_id as pubid")
                    ->groupBy('dl_campaigns.campaign_id')
                    ->whereBetween("dl_campaigns.create_date_time", array(date($start), date($end)))
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        } elseif ($all_live) {

            $statData = $statModel::leftJoin('hourly_stat', function( $join ) {
                        $join->on('hourly_stat.campaign_id', '=', 'dl_campaigns.campaign_id');
                    })->leftJoin('ads', function( $join ) {
                        $join->on('ads.campaign_id', '=', 'dl_campaigns.campaign_id');
                    })
                    ->where("dl_campaigns.status", "=", "running")
                    ->where("dl_campaigns.admin_status", "=", "approved")
                    ->where("ads.ad_status", "=", "1")
                    ->where("ads.admin_status", "=", "approved")
                    ->selectRaw("dl_campaigns.campaign_id,dl_campaigns.campaign_name,dl_campaigns.status,round(dl_campaigns.min_unit_price,3) as min_unit_price,round(dl_campaigns.campaign_budget,3) as campaign_budget, hourly_stat.ad_id, sum(hourly_stat.impression_count) as imp, sum(hourly_stat.clicks_count) as clicks,round(sum(hourly_stat.revenue_value),3) as spend, sum(hourly_stat.conversions_count) as conv,ads.admin_cpm as adcpm,ads.current_cpm as curcpm,dl_campaigns.cpa_id as cpa_id,dl_campaigns.adomain as adomain,dl_campaigns.admin_status,ads.ad_status,ads.admin_status as admin_status_ad,ads.publisher_id as pubid")
                    ->groupBy('dl_campaigns.campaign_id')
                    //->take($take)
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        } else {

            $statData = $statModel::leftJoin('hourly_stat', function( $join ) {
                        $join->on('hourly_stat.campaign_id', '=', 'dl_campaigns.campaign_id');
                    })->leftJoin('ads', function( $join ) {
                        $join->on('ads.campaign_id', '=', 'dl_campaigns.campaign_id');
                    })->selectRaw("dl_campaigns.campaign_id,dl_campaigns.campaign_name,dl_campaigns.status,round(dl_campaigns.min_unit_price,3) as min_unit_price,round(dl_campaigns.campaign_budget,3) as campaign_budget, hourly_stat.ad_id, sum(hourly_stat.impression_count) as imp, sum(hourly_stat.clicks_count) as clicks,round(sum(hourly_stat.revenue_value),3) as spend, sum(hourly_stat.conversions_count) as conv,ads.admin_cpm as adcpm,ads.current_cpm as curcpm,dl_campaigns.cpa_id as cpa_id,dl_campaigns.adomain as adomain,dl_campaigns.admin_status,ads.ad_status,ads.admin_status as admin_status_ad,ads.publisher_id as pubid")
                    ->groupBy('dl_campaigns.campaign_id')
                    ->whereDate('dl_campaigns.create_date_time', '=', date('Y-m-d'))

                    //->take($take)
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
            //select count(*) as aggregate from `dl_campaigns` left join `hourly_stat` on `dl_campaigns`.`campaign_id` = `hourly_stat`.`campaign_id` left join `ads` on `ads`.`campaign_id` = `hourly_stat`.`campaign_id` group by `dl_campaigns`.`campaign_id
        }
        //echo "<pre>";print_r( $statData->toJson() );die;
        return $statData->toJson();
    }

    /*
      get ads running info in json format
     *  */

    public function geAdDetail(Request $request) {

        $campagin_id = $request->campaign_id;
        //$campagin_id=1; 
        //getting the stat records
        $camModel = new \App\Campaigns();

        $camData = $camModel::leftJoin('ads', function( $join ) {
                    $join->on('dl_campaigns.campaign_id', '=', 'ads.campaign_id');
                })->leftJoin('creative_groups', function( $join ) {
                    $join->on('creative_groups.group_id', '=', 'ads.creative_ids');
                })->leftJoin('ad_channel_group_assoc', function( $join ) {
                    $join->on('ad_channel_group_assoc.ad_id', '=', 'ads.ad_id');
                })->leftJoin('targeting_channel_group', function( $join ) {
                    $join->on('targeting_channel_group.channel_group_id', '=', 'ad_channel_group_assoc.channel_id');
                })
                ->where('dl_campaigns.campaign_id', $campagin_id)
                ->selectRaw("ad_channel_group_assoc.ad_targetting_group_id,dl_campaigns.*,ads.*,targeting_channel_group.*,creative_groups.*,creative_groups.update_date_time as creative_time,ads.creative_ids")
                ->get();

//        echo "<pre>";print_r( $camData );die;
        return $camData->toJson();
    }

    /*
      get ads running info in json format
     *  */

    public function getProfileDetail(Request $request) {

        $user_id = $request->user_id;
        $userModel = new \App\User();
        $statData = $userModel::where('user_id', '=', $user_id)->get();
        $final_array = array();
        if (count($statData) > 0) {
            foreach ($statData as $key => $val) {
                $final_array[] = $val['attributes'];
            }
        }
        //print_r($final_array);die;
        return json_encode($final_array);
    }

    public function getusr(Request $request) {

        $user_id = $request->email_address;
        $userModel = new \App\User();
        $statData = $userModel::where('email_address', '=', $user_id)->get();
        $final_array = array('status' => 0);
        if (count($statData) > 0) {
            foreach ($statData as $key => $val) {
                if ($val['attributes']['user_id'] != '') {
                    $final_array = array('status' => 1);
                }
            }
        }
        //print_r($final_array);die;
        return json_encode($final_array);
    }

    /*
      get timezone data
     *  */

    public function getTimezoneData(Request $request) {

        $userModel = new \App\TimezoneData();
        $statData = $userModel::whereNotNull('id')->get();
        //print_r($final_array);die;
        return $statData->toJson();
    }

    public function getCountriesfil() {
        $q = $_GET["q"];
        $getAll = new \App\Country;

        $pos = strpos($q, ',');
        if ($pos === false) {
            $statData = $getAll::where('iso3', '=', $q)->get();
        } else {
            $expd = explode(',', $q);

            $statData = $getAll::whereIn('iso3', $expd)->get();
        }

        $final_array = '';
        if (count($statData) > 0) {

            foreach ($statData as $key => $value) {
                // echo '<pre>';
                // print_r($value);die();
                // $final_array[]=$value;
                $final_array .='<option value="' . $value['iso'] . '">' . $value['name'] . '</option>';
            }
        }

        return $final_array;

//	print_r($getAll->toJson());
    }

    public function getCountriesName() {
        $q = $_GET["q"];
        $getAll = new \App\Country;

        $pos = strpos($q, ',');
        if ($pos === false) {
            $statData = $getAll::where('iso3', '=', $q)->get();
        } else {
            $expd = explode(',', $q);

            $statData = $getAll::whereIn('iso3', $expd)->get();
        }

        $final_array = array();
        if (count($statData) > 0) {

            foreach ($statData as $key => $value) {
// echo '<pre>';
// print_r($value);die();
                $final_array[] = $value;
            }
        }

        return $final_array;
    }

    /*
      get publisher report info in json format
     *  */
    //tbd
    public function getPubReport(Request $request) {

        //$dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', $request->start_date);
        //print_r($dateTimeObj);exit

        if (!isset($request->start_date)) {

            $dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', date("d-m-Y") . ' 00:00:00');
            //$dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', '2016-08-20 00:00:00');
            //$request->start_date = date("Y-m-d");
        } else {
            if (!isset($request->hour)) {
                $start = $request->start_date . " 00:00:00";
            } else {
                $start = $request->start_date . " " . str_pad($request->hour, 2, "0", STR_PAD_LEFT) . ':00:00';
            }
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', $start);
            //$dateTimeObj = \DateTime::createFromFormat('Y-m-d H:i:s', '2016-08-20 00:00:00');
        }

        $dateTimeObj->setTimezone(new \DateTimeZone('Asia/Kolkata'));
        $sMinute = $dateTimeObj->format('i');
        if ($sMinute <= 30) {
            $sstat_slot = 1;
        } else {
            $sstat_slot = 2;
        }

        $sdt = $dateTimeObj->format('YmdH') . $sstat_slot;
        if (!isset($request->end_date)) {
            $request->end_date = date("Y-m-d");
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', date("d-m-Y") . ' 23:59:59');
        } else {

            if (!isset($request->hour)) {
                $end = $request->end_date . " 23:59:59";
            } else {
                $end = $request->end_date . " " . str_pad($request->hour, 2, "0", STR_PAD_LEFT) . ':59:59';
            }
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', $end);
        }
        $dateTimeObj->setTimezone(new \DateTimeZone('Asia/Kolkata'));
        $eMinute = $dateTimeObj->format('i');
        if ($eMinute <= 30) {
            $estat_slot = 1;
        } else {
            $estat_slot = 2;
        }

        $edt = $dateTimeObj->format('YmdH') . $estat_slot;
        $statModel = new \App\publisherStat();
        $statData = $statModel::where('publisher_id', $this->session['sessiondata']['accounts'][0]['publisher_id'])
                ->where('date_key', '>=', $sdt)
                ->where('date_key', '<=', $edt)
                ->selectRaw("date_key,ad_spot_id,"
                        . "sum(request_count) as request_count ,"
                        . "sum(bid_count) as bid_count,"
                        . "sum(impression_count) as impression_count,"
                        . "sum(win_count) as win_count,"
                        . "sum(clicks_count) as clicks_count,"
                        . "sum(total_win_cost) as total_cost,"
                        . "stat_date,ad_spot_id")
                ->groupBy('date_key', 'ad_spot_id')
                ->orderBy('date_key', 'dsc')
                ->orderBy('ad_spot_id', 'asc')
                ->get();
        $pubStat = array();
        $pubStat['data'] = array();
        $pubStat['type'] = 'hourly';
        $pubStat['data_total']['request_total'] = 0;
        $pubStat['data_total']['bid_total'] = 0;
        $pubStat['data_total']['imp_total'] = 0;
        $pubStat['data_total']['win_total'] = 0;
        $pubStat['data_total']['clicks_total'] = 0;
        $pubStat['data_total']['income_total'] = 0;
        //stored data in db is in Asia/Kolkata, $dateTimeObj should be created from this timezone
        date_default_timezone_set('Asia/Kolkata');
        $last_updated = $this->getLastUpdatedStatsTS($this->session['sessiondata']['accounts'][0]['publisher_id']);
        $dateTimeObj = \DateTime::createFromFormat('Y-m-d H:i:s', $last_updated);
        $dateTimeObj->setTimezone(new \DateTimeZone($this->session['sessiondata']['user_timezone']));
        $stats_last_updated = $dateTimeObj->format('Y-m-d H:i:s');
        $pubStat['stats_last_updated'] = 'Report last updated '.$dateTimeObj->format('h:i A, d-m-Y T') ;
        foreach ($statData as $statRow) {
            $date_key = $statRow['date_key'];
            $minute = substr($date_key, 10, 1);
            if ($minute) {
                $mkey = ':29:59';
            } else {
                $mkey = ':59:59';
            }
            //create dateTimeObj from Asia/Kolkata
            $dateTimeObj = \DateTime::createFromFormat('YmdH:i:s', substr($date_key, 0, 10) . $mkey);
            //change date time to user's timezone
            $dateTimeObj->setTimezone(new \DateTimeZone($this->session['sessiondata']['user_timezone']));
            $statUserDate = $dateTimeObj->format('d-m-Y');
            $statUserHour = $dateTimeObj->format('H');
            if (!$statRow['ad_spot_id']) {
                $statRow['ad_spot_id'] = 0;
            }
            if ($request->start_date != $request->end_date || 1) {
                if (!isset($pubStat['data'][$statUserDate][$statRow['ad_spot_id']])) {
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['request_count'] = 0;
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['bid_count'] = 0;
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['impression_count'] = 0;
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['win_count'] = 0;
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['clicks_count'] = 0;
                    $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['total_cost'] = 0;
                }

                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['request_count'] += $statRow['request_count'];
                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['bid_count'] += $statRow['bid_count'];
                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['impression_count'] += $statRow['impression_count'];
                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['win_count'] += $statRow['win_count'];
                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['clicks_count'] += $statRow['clicks_count'];
                $pubStat['data'][$statUserDate][$statRow['ad_spot_id']]['total_cost'] += $statRow['total_cost'];

                $pubStat['type'] = 'daily';
            } /* else {
              if (!isset($pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']])) {
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['request_count'] = 0;
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['bid_count'] = 0;
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['impression_count'] = 0;
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['win_count'] = 0;
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['clicks_count'] = 0;
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['total_cost'] = 0;
              }

              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['request_count'] += $statRow['request_count'];
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['bid_count'] += $statRow['bid_count'];
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['impression_count'] += $statRow['impression_count'];
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['win_count'] += $statRow['win_count'];
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['clicks_count'] += $statRow['clicks_count'];
              $pubStat['data'][$statUserDate][$statUserHour][$statRow['ad_spot_id']]['total_cost'] += $statRow['total_cost'];
              $pubStat['type'] = 'hourly';
              } */

            $pubStat['data_total']['request_total'] += $statRow['request_count'];
            $pubStat['data_total']['bid_total'] += $statRow['bid_count'];
            $pubStat['data_total']['imp_total'] += $statRow['impression_count'];
            $pubStat['data_total']['win_total'] += $statRow['win_count'];
            $pubStat['data_total']['clicks_total'] += $statRow['clicks_count'];
            $pubStat['data_total']['income_total'] += $statRow['total_cost'];
        }
        $pubStat['today_total'] = json_decode($this->getTotalPubReport(), true);
        date_default_timezone_set($this->session['sessiondata']['user_timezone']);
        return json_encode($pubStat);
    }
    //tbd
    public function getTotalPubReport() {
        //carete dateTimeObj from user's timezone
        $dateTimeObj = \DateTime::createFromFormat('Y-m-d H:i:s', date("Y-m-d") . ' 00:00:00');
        //convert datetimezone to Asia/Kolkata as data in db is ist
        $dateTimeObj->setTimezone(new \DateTimeZone('Asia/Kolkata'));
        $sMinute = $dateTimeObj->format('i');
        if ($sMinute <= 30) {
            $sstat_slot = 1;
        } else {
            $sstat_slot = 2;
        }

        $sdt = $dateTimeObj->format('YmdH') . $sstat_slot;
        $dateTimeObj = \DateTime::createFromFormat('Y-m-d H:i:s', date("Y-m-d") . ' 23:59:59');
        $dateTimeObj->setTimezone(new \DateTimeZone('Asia/Kolkata'));
        $eMinute = $dateTimeObj->format('i');
        if ($eMinute <= 30) {
            $estat_slot = 1;
        } else {
            $estat_slot = 2;
        }

        $edt = $dateTimeObj->format('YmdH') . $estat_slot;
        //getting the stat records total
        $statModel = new \App\publisherStat();
        $statData = $statModel::where('publisher_id', $this->session['sessiondata']['accounts'][0]['publisher_id'])
                ->where('date_key', '>=', $sdt)
                ->where('date_key', '<=', $edt)
                ->selectRaw("sum(request_count) as request_count ,"
                        . "sum(bid_count) as bid_count,"
                        . "sum(impression_count) as impression_count,"
                        . "sum(win_count) as win_count,"
                        . "sum(clicks_count) as clicks_count,"
                        . "sum(total_win_cost) as total_cost")
                ->get();
        return $statData->toJson();
    }

    private function getLastUpdatedStatsTS($pubId = 0) {
        if ($pubId == 0)
            $last_updated = \App\hourlyStat::max('update_datetime');
        else
            $last_updated = \App\hourlyStat::where('publisher_id', $pubId)->max('update_datetime');
        return $last_updated;
    }

    public function getPubId($userId) {

        if ($userId) {

            $publisher = DB::table('publishers')->where('account_id', $userId)->first();
            if ($publisher->publisher_id > 0) {

                return $publisher->publisher_id;
            }
        }

        return null;
    }

    public function delCreativeGroupItems(Request $request) {

        $group_id = $request->group_id;
        $previous_img = $request->previous_img;

        if ($group_id) {

            $group_model = new \App\CreativeGroup();
            $group_model::find($group_id);
            $group_model->file_name = '';
            $group_model->content_dimensions = '';
            $group_model->content_extensions = '';
            $group_model->save();
            return '{"status": "ok"}';
        }
    }

    public function adCpmCampaign(Request $request) {
        $cmpid = $request->cmpid;
        $cpmval = $request->cpmval;

        $adsModel = \App\Ads::where('campaign_id', "=", $cmpid)
                ->update(['admin_cpm' => $cpmval]);

        $str_status = array('status' => 'Updated Successfully.');

        return json_encode($str_status);
    }

    public function adCpaIdCampaign(Request $request) {
        $cmpid = $request->cmpid;
        $cpmval = $request->cpmval;

        $adsModel = \App\Campaigns::where('campaign_id', $cmpid)
                ->update(['cpa_id' => $cpmval]);

        $str_status = array('status' => 'Updated Successfully.');
        return json_encode($str_status);
    }

    public function editcheck_balance_left_dollar(Request $request) {
        $sessiondata = Session::get('sessiondata');
        $advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
        $post_value = $request->post_value;

        $result = DB::table('dl_advertisers')->select('balance_left_currency')->where('advertiser_id', $advertiser_id)->get();

        if (!empty($result)) {

            $balance_left_dollar = $result[0]->balance_left_currency;

            if ($post_value > $balance_left_dollar) {
                return 2;
            } else {

                return 1;
            }
        } else {
            return 2;
        }
    }

    public function adAdomianCampaign(Request $request) {

        $cmpid = $request->cmpid;
        $cpmval = $request->cpmval;

        $adsModel = \App\Campaigns::where('campaign_id', $cmpid)
                ->update(['adomain' => "'" . $cpmval . "'"]);

        $str_status = array('status' => 'Updated Successfully.');
        return json_encode($str_status);
    }

    public function getAdvId($userId) {

        if ($userId) {

            $publisher = DB::table('dl_advertisers')->where('account_id', $userId)->first();
            if ($publisher->advertiser_id > 0) {

                return $publisher->advertiser_id;
            }
        }

        return null;
    }
    
    public function saveBillingInfo(Request $request) {

        $id = $request->adv_id;
        $company = $request->comp;
        $addr = $request->add;
        $city = $request->cit;
        $state = $request->stat;
        $country = $request->coun;
        $pin = $request->pi;
        $mail = $request->mail;
        $name = $request->name;
        $phone = $request->phn;

        $adsModel = \App\Advertiser::where('account_id', $id)
                ->update(['company' => $company ,'billing_address' => $addr ,'billing_city' => $city ,'billing_state' => $state ,'billing_country' => $country ,'billing_pin_code' => $pin ,'billing_contact_email' => $mail ,'billing_contact_name' => $name ,'billing_phone' => $phone ]);

        $str_status = array('status' => 'Updated Successfully.');
        return json_encode($str_status);
    }

}
