<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Validator;
use DB;
use Auth;
use Illuminate\Support\Facades\Mail; //TBD
use Illuminate\Mail\Mailer; //TBD
use Hash;
use App\User;
//use App\Role;
//use App\Account;
use Session;
use App\Http\Requests;
use App\Http\Controllers\Controller;

class LoginController1 extends Controller {

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() {

        if (Auth::check()) {
            return redirect("/");
            // The user is logged in...
        }

        //echo "<pre>";print_r( $ispData );die;
        $countryId = $this->getCountryId();
        return View('/login')->with('country_id', $countryId);
    }

    /**
     * Show the form for login validated the users.
     * This function is use for validated the a user in login process
     * @return \Illuminate\Http\Response
     */
    public function validateUser(Request $request) {
        if ($request->email_address) {
            $validator = Validator::make(
                            array(
                        'email_address' => $request->email_address,
                            ), array(
                        'email_address' => 'required|email',
                            )
            );
            if ($validator->fails()) {
                $authkey = 'phone_number';
            } else {
                $authkey = 'email_address';
            }
        }
        if (Auth::attempt([$authkey => $request->email_address, 'password' => $request->password, 'is_active' => 1])) {
            $user = Auth::User();

            if ($user) {
                $sessdata = array();
                $sessdata['country_id'] = $user->country_id;
                $count = 0;
                foreach ($user->roles as $role) {
                    $sessdata['roles'][$count]['role_id'] = $role->id;
                    $sessdata['roles'][$count]['role_slug'] = $role->role_slug;
                    $count++;
                }
                $count = 0;
                foreach ($user->accounts as $accounts) {
                    $sessdata['accounts'][$count]['account_id'] = $accounts->account_id;
                    $sessdata['accounts'][$count]['account_type'] = $accounts->account_type;
                    $count++;
                }

                Session::put('UserEmail', $user->email_address);
                Session::put('sessiondata', $sessdata);
            }
            return redirect('/myaccount'); //->intended('/myaccount');
        } else {

            return redirect('/login')->with('error_login', 'Please provide valid email and password');
        }
    }

    /**
     * redirect to myaccount.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function user_accounts() {
        if (!Auth::check()) {
            return redirect('/login');
        }
        $session = Session::all();
        switch ($session['sessiondata']['roles'][0]['role_slug']) {
            case 'ADVERTISER':
                return View("/myaccount"); //advertiser account
                break;
            case 'MANAGER':
                return View("/advaccounts"); // list of advertiser accounts
                break;
            case 'ADMIN':
                return View("/advaccounts"); // list of advertiser accounts
                break;
            case 'PUBLISHER':
                return View("/pubaccounts"); // list of advertiser accounts
                break;
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store() {
        // 
    }

    /**
     * Show the form for creating a new resource.
     * This function is use for create a user in singup
     * @return \Illuminate\Http\Response
     */
    public function create_user(Request $request) { // create advertiser
        //print_r($request->all());
        //die();
        $email = $request->email_address;
        $password = $request->password;
        $password = $request->password_confirmation;
        $phone = $request->phone_number;
        $captcha = $request->captcha;
        $validator = Validator::make(
                        array(
                    'email_address' => $request->email_address,
                    'password' => $password = $request->password,
                    'password_confirmation' => $request->password_confirmation,
                    'phone_number' => $request->phone_number,
                    'captcha' => $request->captcha,
                    'country_code' => $request->country_code,
                        ), array(
                    'email_address' => 'required|email|unique:cf_users',
                    'password' => 'required|confirmed|min:6',
                    'phone_number' => 'required|unique:cf_users',
                    'country_code' => 'required',
                        //'captcha'=>'required|captcha', 
                        )
        );

        /* $validator->after(function($validator) {

          $validator->errors()->add('captcha', 'Your input captcha is worng!');
          }); */

        if ($validator->fails()) {
            return redirect('/login')->withErrors($validator)->withInput();
        } else {
            $data = array(
                "email_address" => $email,
                "password" => Hash::make($password),
                'phone_number' => $request->phone_number,
                'phone_country_code' => $request->country_code,
            );


            /* create an account during sign up
              insert order
              1) cf_accounts
              2) cf_users -- dependency: cf_accounts->account_id
              3) user_role -- dependency: cf_users->user_id and roles->rolid=2 (for ADVERTISER)

             */
            $this->account_id = DB::table('cf_accounts')->insertGetId(array('account_type' => 'ADVERTISER'));
            if (!empty($this->account_id) && is_numeric($this->account_id)) {
                $data['default_account_id'] = $this->account_id;
                $confirmation_code = str_random(30);
                $data['activation_code'] = $confirmation_code;

                $this->user_id = DB::table('cf_users')->insertGetId($data);
                if ($this->user_id && is_numeric($this->user_id)) {
                    DB::table('dl_advertisers')->insert(array('account_id' => $data['default_account_id'],
                        'contact_email' => $data['email_address'], 'contact_mobile' => $data['phone_number'], 'status' => 1));
                    DB::table('role_user')->insert(array('role_id' => 2, 'user_id' => $this->user_id));
                    DB::table('account_user')->insert(array('account_id' => $this->account_id, 'user_id' => $this->user_id));
                    
                      Mail::send('email_verify', ['confirmation_code'=>$confirmation_code], function($message) use ($email) {
                      //$message->to($email)
                      $message->from('admin@audience.nest','hello')
                              ->to($email, 'Advertiser')
                              ->subject('Verify your Email address');
                      }); 

                    return redirect('/login')->with("success_singup", "Sing Up Successfull. Please check your mail to verify Email.");
                }
            }
            return redirect('/login')->with("error_after_loging", "Not Insert");
        }
    }

    public function create_pub(Request $request) { // create advertiser

        /* uncomment the code to make it live
         * 
         *
          $email = $request->email_address;
          $password = $request->password;
          $password = $request->password_confirmation;
          $phone = $request->phone_number;
          $captcha = $request->captcha;
          $validator = Validator::make(
          array(
          'email_address' => $request->email_address,
          'password' => $password = $request->password,
          'password_confirmation' => $request->password_confirmation,
          'phone_number' => $request->phone_number,
          'captcha' => $request->captcha,
          'country_code' => $request->country_code,
          ), array(
          'email_address' => 'required|email|unique:cf_users',
          'password' => 'required|confirmed|min:6',
          'phone_number' => 'required|unique:cf_users',
          'country_code' => 'required',
          //'captcha'=>'required|captcha',
          )
          );


          if ($validator->fails()) {
          return redirect('/regpub')->withErrors($validator)->withInput();
          } else {
          $data = array(
          "email_address" => $email,
          "password" => Hash::make($password),
          'phone_number' => $request->phone_number,
          'phone_country_code' => $request->country_code,
          );


          /* create an account during sign up
          insert order
          1) cf_accounts
          2) cf_users -- dependency: cf_accounts->account_id
          3) user_role -- dependency: cf_users->user_id and roles->rolid=2 (for ADVERTISER)

         */
        /* end comment */

        $this->account_id = DB::table('cf_accounts')->insertGetId(array('account_type' => 'TRAFFICKER'));
        $data['email_address'] = 'newpub@gmail.com';

        if (!empty($this->account_id) && is_numeric($this->account_id)) {
            $data['default_account_id'] = $this->account_id;
            $confirmation_code = str_random(30);
            $data['activation_code'] = $confirmation_code;

            $this->user_id = DB::table('cf_users')->insertGetId($data);
            if ($this->user_id && is_numeric($this->user_id)) {
                DB::table('role_user')->insert(array('role_id' => 3, 'user_id' => $this->user_id));
                DB::table('account_user')->insert(array('account_id' => $this->account_id, 'user_id' => $this->user_id));
                /*
                  Mail::send('email_verify', ['confirmation_code'=>$confirmation_code], function($message) use ($email) {
                  //$message->to(Input::get('email_address'), Input::get('username'))
                  $message->from('admin@audience.nest','hello');
                  $message->to($email, 'Advertiser')
                  ->subject('Verify your Email address');
                  }); */

                //Flash::message('Thanks for signing up! Please check your email.');
                DB::table('publishers')->insertGetId(array('publisher_key' => 'keypub34567', 'company' => 'pubcompany',
                    'contact_email' => $data['email_address'], 'account_id' => $this->account_id));
                exit;
                //return redirect('/login')->with("success_singup", "Sing Up Successfull. Please check your mail to verify Email.");
            }
        }
        return redirect('/login')->with("error_after_loging", "Not Insert");
    }

    public function confirm($confirmation_code) {
        if (!$confirmation_code) {
            throw new InvalidConfirmationCodeException;
        }
        $user = User::where('activation_code', '=', $confirmation_code)->get()->first();
        //$user = User::whereConfirmationCode($confirmation_code)->first();

        if (!$user) {
            throw new InvalidConfirmationCodeException;
        }

        $user->is_active = 1;
        $user->activation_code = null;
        $user->save();
        return redirect('/login')->with("success_singup", "Your account has been verified successfully.");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        //
    }

    /**
     * Logout the specified resource user.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function doLogout() {
        Auth::logout();
        Session::flush();
        return redirect('/login');
    }

    public function webpagecreation() {
        return View('/webpagecreation');
    }

    function getCountryId() {
        $ipAddress = $this->getIpAddress();

        $countryId = "226"; //TBD
        $ipAddress = ip2long("204.147.128.0"); //TBD
        $ispModel = new \App\MaxmindData();
        $ispData = $ispModel::join('country', function( $join ) {
                    $join->on('maxmind_ip_pool.iso_country_code', '=', 'country.iso');
                })
                ->selectRaw("country.id")
                ->where("maxmind_ip_pool.long_higher_ip", ">=", $ipAddress)
                ->where("maxmind_ip_pool.long_lower_ip", "<=", $ipAddress)
                ->get();

        if (isset($ispData[0]->id)) {
            $countryId = $ispData[0]->id;
        }
        return $countryId;
    }

    function getIpAddress() {
        // check for shared internet/ISP IP
        if (!empty($_SERVER['HTTP_CLIENT_IP']) && validate_ip($_SERVER['HTTP_CLIENT_IP'])) {
            return $_SERVER['HTTP_CLIENT_IP'];
        }

        // check for IPs passing through proxies
        if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            // check if multiple ips exist in var
            if (strpos($_SERVER['HTTP_X_FORWARDED_FOR'], ',') !== false) {
                $iplist = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
                foreach ($iplist as $ip) {
                    if (validate_ip($ip))
                        return $ip;
                }
            } else {
                if (validate_ip($_SERVER['HTTP_X_FORWARDED_FOR']))
                    return $_SERVER['HTTP_X_FORWARDED_FOR'];
            }
        }
        if (!empty($_SERVER['HTTP_X_FORWARDED']) && validate_ip($_SERVER['HTTP_X_FORWARDED']))
            return $_SERVER['HTTP_X_FORWARDED'];
        if (!empty($_SERVER['HTTP_X_CLUSTER_CLIENT_IP']) && validate_ip($_SERVER['HTTP_X_CLUSTER_CLIENT_IP']))
            return $_SERVER['HTTP_X_CLUSTER_CLIENT_IP'];
        if (!empty($_SERVER['HTTP_FORWARDED_FOR']) && validate_ip($_SERVER['HTTP_FORWARDED_FOR']))
            return $_SERVER['HTTP_FORWARDED_FOR'];
        if (!empty($_SERVER['HTTP_FORWARDED']) && validate_ip($_SERVER['HTTP_FORWARDED']))
            return $_SERVER['HTTP_FORWARDED'];

        // return unreliable ip since all else failed
        return $_SERVER['REMOTE_ADDR'];
    }
    
     public function user_profile() {
            
        $uid=Session::get('UserEmail');
        $userModel=  new \App\User();
       $userData  =  $userModel::where('email_address' , '=', $uid)->first();
       
        if($userData->user_id!='')
        {
         $json_url = url("json-data/get-profile?user_id=".$userData->user_id);
        
         $json = file_get_contents( $json_url );

        $datav = json_decode($json,true);
         
        
       $countryId = $this->getCountryId();
        
       
        return View("/myprofile",['profiledata'=>$datav,'countryId'=>$countryId]);
        }else
        {
            return redirect('/login');
        }
        
    }

}
