<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Validator;
use Auth;
use Hash;
use App\User;
use Softon\Indipay\Facades\Indipay;
use App\Account;

class PaymentController extends Controller {
    /* public function __construct() {
      $this->middleware('auth');
      } */

    public function getReport() {

        return view('mypayments');
    }

    public function addfunds() {
        return view('addfunds');
    }

    public function paymentRequest(Request $request) {

        if (!Auth::check()) {
            return redirect("/login");
            // The user is logged in...
        }


        $validator = Validator::make(
                        array(
                    'amount' => $request->amount,
                        ), array(
                    'amount' => 'required|numeric|min:250',
                        )
        );
        if ($validator->fails()) {
            return redirect('myaccount/addfunds')->withErrors($validator)->withInput();
        }
        $session = SESSION::All();
        if (!empty($session['responseretry']) || isset($session['responseretry'])) {
            SESSION::Pull('responseretry');
        }
        $advertiserdata = Account::find($session['sessiondata']['accounts'][0]['account_id'])->advertiser;
        $advertiserdata = $advertiserdata->toArray();

        $transaction_id = substr(md5(str_random(1000) . microtime()), rand(1, 15), 16);

        $paymentTransactionModel = new \App\PaymentTransaction();
        //print_r($paymentTransactionModel);
        $paymentTransactionModel->transaction_id = $transaction_id;
        $paymentTransactionModel->parent_id = 0;

        $paymentTransactionModel->account_id = $session['sessiondata']['accounts'][0]['account_id'];
        $paymentTransactionModel->user_id = $session['UserID'];
        $paymentTransactionModel->amount = $request->amount;
        $paymentTransactionModel->currency = 'INR';
        $paymentTransactionModel->gateway_id = 1; //PAYU


        $paymentTransactionModel->stage = 1; //FIRST FORM SUBMIT
        $paymentTransactionModel->save();

        /* All Required Parameters by your Gateway */

        $parameters = [

            'txnid' => $transaction_id,
            'amount' => $request->amount,
            'userid' => $session['UserID'],
            'udf1' => $session['sessiondata']['accounts'][0]['account_id'],
            'udf2' => $advertiserdata['advertiser_id'],
            'firstname' => $advertiserdata['contact_name'],
            'email' => $session['UserEmail'],
            'phone' => $advertiserdata['contact_mobile'],
            'productinfo' => htmlspecialchars("advt_payment"),
        ];
        print_r($parameters);exit;
        return Indipay::purchase($parameters);
    }

    public function paymentResponse(Request $request) {
        $session = SESSION::All();
        //print_r($session);
        $response = Indipay::response($request);
        $paymentTransactionModel = new \App\PaymentTransaction();
        $paymentTransactionModel->user_id = $session['UserID'];
        $paymentTransactionModel->transaction_id = $response['txnid'];
        $paymentTransactionModel->parent_id = $response['txnid'];
        $paymentTransactionModel->account_id = $response['udf1'];
        //$paymentTransactionModel->advertiser_id = $response->udf2;
        $paymentTransactionModel->gateway_id = 1; //PAYU
        $paymentTransactionModel->stage = 2; //RESPONSE FROM PAYMENT GATEWAY
        $paymentTransactionModel->status_reason = $response['field9'];
        $paymentTransactionModel->gateway_transaction_id = $response['mihpayid'];
        $paymentTransactionModel->gateway_status_reason = $response['field9'];
        $paymentTransactionModel->extra = json_encode($response);
        $paymentTransactionModel->currency = 'INR';

        if ($response['status'] == 'failure') {
            $paymentTransactionModel->payment_status = 0;
        } elseif (strtolower($response['status']) == 'success') {
            $paymentTransactionModel->payment_status = 1;
            $paymentTransactionModel->payment_mode = $response['mode'];
            $paymentTransactionModel->amount = $response['amount'];
            //save data in credit table

            $accountFundsModel = new \App\AccountFunds();
            $accountFundsModel->transaction_id = $response['txnid'];
            $accountFundsModel->account_id = $response['udf1'];
            $accountFundsModel->user_id = $session['UserID'];
            $accountFundsModel->amount = $response['amount'];
            $accountFundsModel->currency = 'INR';
            $accountFundsModel->payment_status = $response['field9'];
            $accountFundsModel->debit_credit = 'CREDIT';
            if (strtolower($response['status']) == 'success' && !isset($session['responseretry'])) {
                $accountFundsModel->save();
            }
        }

        if (!isset($session['responseretry'])) {

            Session::Put('responseretry', true);
            $paymentTransactionModel->save();
        }
        return view('paymentresponse', ['response' => $response]);
        //mail to user if transaction is successfull / failed
    }
    
       public function hdfcPayment() {
       
        $value["account_id"]="16267";
        $value["address"]="Test Address";
        $value["amount"]="12.34"; 
        $value["channel"]="10"; 
        $value["city"]="Mumbai";
        $value["country"]="IND";
        $value["currency"]="INR"; 
        $value["description"]="Test Product";
        $value["email"]="test@test.com";
        $value["mode"]="LIVE";
        $value["name"]="Test Name";
        $value["phone"]="2211112222";
        $value["postal_code"]="400069";
        $value["reference_no"]="1458205469";
        $value["return_url"]="http://advertiser.collectcent.com/demo/hdfc/hdfc-php/response.php";
        $value["ship_address"]="Test Address";
        $value["ship_city"]="Mumbai";
        $value["ship_country"]="IND";
        $value["ship_name"]="Test Name";
        $value["ship_phone"]="2211112222";
        $value["ship_postal_code"]="400069";
        $value["ship_state"]="MH";
        $value["state"]="MH"; 
        $value["secure_hash"]="36C39CD4F593952B0E4A9C421D4464CE97628A6965DEF89BFFD80DD02BD42CBF601B15277F76E48F44C532BFF41CAD458CF05B11CEB6F3A8C07BBA0C4729DBC9";
        
        return View::make('indipay::ccavenue')->with('encRequest',$this->encRequest)
                             ->with('accessCode',$this->accessCode)
                             ->with('endPoint',$this->getEndPoint());
        
        //return redirect("https://secure.ebs.in/pg/ma/payment/request/");
   }

}
