<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Account extends Model {

    /**
     * The database table used by the model.
     * @var string
     */
    protected $table = 'cf_accounts';
    protected $primaryKey = 'account_id';
    protected $fillable = ['account_id', 'account_type',];
    public $timestamps = false;

    /*
      |--------------------------------------------------------------------------
      | Relationship Methods
      |--------------------------------------------------------------------------
     */

    /**
     * many-to-many relationship method.
     *
     * @return QueryBuilder
     */
    public function users() {
        return $this->belongsToMany('\App\User', 'account_user', 'account_id', 'user_id');
    }

    public function advertiser() {
        return $this->hasOne('\App\Advertiser', 'account_id');
    }
    
    public function publisher() {
        return $this->hasOne('\App\Publisher', 'account_id');
    }

}
