<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Campaigns extends Model {

    protected $table = 'dl_campaigns';
    protected $primaryKey = 'campaign_id';
    protected $fillable = ['campaign_id', 'advertiser_id', 'campaign_name', 'iab_categories', 'priority', 'weight', 'target_impressions',
        'target_clicks', 'target_conversions', 'campaign_budget', 'campaign_budget_currency', 'daily_budget', 'daily_budget_currency',
        'total_spend', 'revenue_type', 'min_unit_price', 'min_unit_price_currency', 'status', 'admin_status', 'admin_remarks',
        'time_zone', 'impressions', 'clicks', 'conversions', 'amount', 'activate_date_time', 'expire_date_time', 'targeting_methods',
        'methods_plugins', 'create_date_time', 'update_date_time', 'adv_cat_id', 'adv_subcat_id', 'adomain', 'cpa_id', 'cpm_status',
        'advertiser_key',];
    public $timestamps = false;

    public function getRelatedAds() {
        return $this->hasOne('\App\Ads', 'campaign_id');
    }

    public function advertiser() {
        return $this->belongsTo('\App\Advertiser', 'advertiser_id');
    }

}
