<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Validator;
use Auth;
use Hash;
use App\User;
use Softon\Indipay\Facades\Indipay;
use App\Account;
use App\CurrencyDatabase;

class PaymentController extends Controller {
    /* public function __construct() {
      $this->middleware('auth');
      } */

    public function __construct() {
        $this->session = SESSION::All();
        $this->advertiserdata = Account::find($this->session['sessiondata']['accounts'][0]['account_id'])->advertiser;
        $this->advertiserdata = $this->advertiserdata->toArray();
        $this->currency = !empty($this->advertiserdata['currency']) ? $this->advertiserdata['currency'] : 'INR';
        $this->currencyminarray = config('paymentgateway.currencyminarray');
        $this->currencymin = $this->currencyminarray[$this->currency];
        $this->advertiserdata['currencymin'] = $this->currencymin;
    }

    public function getReport() {

        return view('mypayments');
    }

    public function addfunds() {
        $advertiserdata = Account::find($this->session['sessiondata']['accounts'][0]['account_id'])->advertiser;
        $advertiserdata = $advertiserdata->toArray();
        if ($this->currency == 'INR') {
            return view('addfunds', ['advertiserdata' => $this->advertiserdata]);
        } else {

            $json_url = url("json-data/get-countries");
            $json = file_get_contents($json_url);
            $data = json_decode($json, true);

            return view('addfundshdfc', ['advertiserdata' => $this->advertiserdata, 'countries' => $data]);
        }
    }

    public function paymentRequest(Request $request) {

        if (!Auth::check()) {
            return redirect("/login");
            // The user is not logged in...
        }
        
        
        $advertiserdata = Account::find($this->session['sessiondata']['accounts'][0]['account_id'])->advertiser;
        
        $advertiserdata = $advertiserdata->toArray();
        
        $currency = !empty($advertiserdata['currency']) ? $advertiserdata['currency'] : 'INR';
        
        $currencyminarray = config('paymentgateway.currencyminarray');
        
        $currencymin = $currencyminarray[$currency];
        
        //get the country id
        $request->country = $this->session['sessiondata']['country_id'];
        
        $request->currency = $currency;
        
        $request->currencymin = $currencymin;
        
        $mobile = ($request->mobile) ? $request->mobile : "";
        
        $validator = Validator::make(
                        array(
                    'amount' => $request->amount,
                        ), array(
                    'amount' => 'required|numeric|min:' . $currencymin,
                        )
        );
        if ($validator->fails()) {

            return redirect('myaccount/addfunds')->withErrors($validator)->withInput();
        }
        
        if($mobile !="" ){
            
            return $this->paymentRequestFortumo( $request );
            
        } else {
            
        if ($currency == 'INR') {
            return $this->paymentRequestPayu( $request );
        } else {
            return $this->paymentRequestHDFC( $request );
        }
       
    }
        /*
          if (!empty($this->session['responseretry']) || isset($this->session['responseretry'])) {
          $previousGatewayId = SESSION::Pull('responseretry');
          } else {
          $previousGatewayId = 0;
          }

          $gatewayId = 0;


          $gatewayfallback = config('paymentgateway.gatewayfallback');

          $totalgateways = count($gatewayfallback);

          if ($previousGatewayId >= $totalgateways) {
          $previousGatewayId = 1;
          } else {
          $previousGatewayId++;
          }
          switch ($previousGatewayId) {

          case 1:
          //return $this->paymentRequestHDFC($request);
          return $this->paymentRequestPayu($request);
          break;
          case 2:
          return $this->paymentRequestPayu($request);
          //return $this->paymentRequestHDFC($request);
          break;
          } */
    }
    
    
    public function paymentRequestFortumo( $request ){
        
       
        $advertiserdata = Account::find($this->session['sessiondata']['accounts'][0]['account_id'])->advertiser;
        $advertiserdata = $advertiserdata->toArray();

        $transaction_id = substr(md5(str_random(1000) . microtime()), rand(1, 15), 16);

        $paymentTransactionModel = new \App\PaymentTransaction();
        $paymentTransactionModel->transaction_id = $transaction_id;
        $paymentTransactionModel->parent_id = 0;

        $paymentTransactionModel->account_id = $this->session['sessiondata']['accounts'][0]['account_id'];
        $paymentTransactionModel->user_id = $this->session['UserID'];
        $paymentTransactionModel->amount = $request->amount;
        $paymentTransactionModel->currency = $request->currency;
        $paymentTransactionModel->gateway_id = 3; //FORTUMO


        $paymentTransactionModel->stage = 1; //FIRST FORM SUBMIT
        $paymentTransactionModel->save();

        /* All Required Parameters by your Gateway */

        $parameters = [

            'txnid' => $transaction_id,
            'amount' => $request->amount,
            'currency' => $request->currency,
            'user_id' => $this->session['UserID'],
            'account_id' => $this->session['sessiondata']['accounts'][0]['account_id'],
            'advertiser_id' => $advertiserdata['advertiser_id'],
            'firstname' => $advertiserdata['contact_name'],
            'email' => $this->session['UserEmail'],
            'phone' => $request->mobile,
            'country' => $request->country,
            'productinfo' => htmlspecialchars("advt_payment"),
            "return_url" => url(config('paymentgateway.fortumo_return_url')),
            
        ];

        return view('paymentrequestfortumo', ['requestvars' => $parameters]);
    }

    public function paymentRequestPayu($request) {

        $advertiserdata = Account::find($this->session['sessiondata']['accounts'][0]['account_id'])->advertiser;
        $advertiserdata = $advertiserdata->toArray();

        $transaction_id = substr(md5(str_random(1000) . microtime()), rand(1, 15), 16);

        $paymentTransactionModel = new \App\PaymentTransaction();
        $paymentTransactionModel->transaction_id = $transaction_id;
        $paymentTransactionModel->parent_id = 0;

        $paymentTransactionModel->account_id = $this->session['sessiondata']['accounts'][0]['account_id'];
        $paymentTransactionModel->user_id = $this->session['UserID'];
        $paymentTransactionModel->amount = $request->amount;
        $paymentTransactionModel->currency = $request->currency;
        $paymentTransactionModel->gateway_id = 1; //PAYU


        $paymentTransactionModel->stage = 1; //FIRST FORM SUBMIT
        $paymentTransactionModel->save();

        /* All Required Parameters by your Gateway */

        $parameters = [

            'txnid' => $transaction_id,
            'amount' => $request->amount,
            'userid' => $this->session['UserID'],
            'udf1' => $this->session['sessiondata']['accounts'][0]['account_id'],
            'udf2' => $advertiserdata['advertiser_id'],
            'firstname' => $advertiserdata['contact_name'],
            'email' => $this->session['UserEmail'],
            'phone' => $advertiserdata['contact_mobile'],
            'productinfo' => htmlspecialchars("advt_payment"),
        ];

        return Indipay::purchase($parameters);
    }

    public function paymentRequestHDFC(Request $request) {


        $validator = Validator::make(
                        array(
                    'amount' => $request->amount,
                    'name' => $request->name,
                    'email' => $request->email,
                    'phone' => $request->phone,
                    'address' => $request->address,
                    'city' => $request->city,
                    'country' => $request->country,
                    'postal_code' => $request->postal_code,
                        ), array(
                    'amount' => 'required|numeric|min:' . $this->currencymin,
                    'name' => 'required',
                    'email' => 'required|email',
                    'phone' => 'required',
                    'address' => 'required',
                    'city' => 'required',
                    'country' => 'required',
                    'postal_code' => 'required',
                        )
        );

        if ($validator->fails()) {

            return redirect('myaccount/addfundshdfc')->withErrors($validator)->withInput();
        }




        $transaction_id = substr(md5(str_random(1000) . microtime()), rand(1, 15), 16);

        $paymentTransactionModel = new \App\PaymentTransaction();

        $paymentTransactionModel->transaction_id = $transaction_id;
        $paymentTransactionModel->parent_id = 0;

        $paymentTransactionModel->account_id = $this->session['sessiondata']['accounts'][0]['account_id'];
        $paymentTransactionModel->user_id = $this->session['UserID'];
        $paymentTransactionModel->amount = $request->amount;
        $paymentTransactionModel->currency = $this->currency;
        $paymentTransactionModel->gateway_id = 2; //HDFC


        $paymentTransactionModel->stage = 1; //FIRST FORM SUBMIT
        $paymentTransactionModel->save();

        /* All Required Parameters by your Gateway */
        $value["channel"] = "10"; //required
        $value["account_id"] = config('paymentgateway.hdfcaccountid'); //required
        $value["reference_no"] = $transaction_id; // required
        $value["amount"] = 12.34; //test payment //$request->amount;
        $value["mode"] = "LIVE"; //required
        $value["currency"] = $this->currency; // required
        $value["currency_code"] = $this->currency; // required
        $value["description"] = "advt_payment"; //requiredu
        $value["return_url"] = url(config('paymentgateway.hdfc_return_url'));
        $value["name"] = $this->advertiserdata['contact_name'];  //required
        $value["address"] = $request->address; //required
        $value["city"] = $request->city; //required
        $value["country"] = $request->country; //required
        $value["postal_code"] = $request->postal_code; //required
        $value["phone"] = $this->advertiserdata['contact_mobile']; //required
        $value["email"] = $this->advertiserdata['contact_email']; //required


        $value["ship_name"] = ""; //optional
        $value["ship_address"] = ""; //optional
        $value["ship_city"] = ""; //optional
        $value["ship_country"] = ""; //optional
        $value["ship_name"] = ""; //optional
        $value["ship_phone"] = ""; //optional
        $value["ship_postal_code"] = ""; //optional
        $value["ship_state"] = ""; //optional
        $value["state"] = ""; //optional
        ksort($value);

        $hashData = config('paymentgateway.hdfc_secret'); // Intialise with Secret Key  
        // Sort the post parameters in alphabetical order of parameter names.  
        //Append the posted values to $hashData  

        foreach ($value as $key => $value1) {

//create the hashing input leaving out any fields that has no value and by concatenating the      values using a ‘|’ symbol.  

            if (strlen($value1) > 0) {
                $hashData .= '|' . $value1;
            }
        }
// Create the secure hash and append it to the Post data  

        if (strlen($hashData) > 0) {
            $hashvalue = strtoupper(md5($hashData));
        }
        $value['secure_hash'] = $hashvalue;

        return view('paymentrequesthdfc', ['requestvars' => $value]);
    }

    public function paymentResponsePayu(Request $request) {

        $response = Indipay::response($request);
        $paymentTransactionModel = new \App\PaymentTransaction();
        $paymentTransactionModel->user_id = $this->session['UserID'];
        $paymentTransactionModel->transaction_id = $response['txnid'];
        $paymentTransactionModel->parent_id = $response['txnid'];
        $paymentTransactionModel->account_id = $response['udf1'];
        //$paymentTransactionModel->advertiser_id = $response->udf2;
        $paymentTransactionModel->gateway_id = 1; //PAYU
        $paymentTransactionModel->stage = 2; //RESPONSE FROM PAYMENT GATEWAY
        $paymentTransactionModel->status_reason = $response['field9'];
        $paymentTransactionModel->gateway_transaction_id = $response['mihpayid'];
        $paymentTransactionModel->gateway_status_reason = $response['field9'];
        $paymentTransactionModel->extra = json_encode($response);
        $paymentTransactionModel->currency = 'INR';

        if ($response['status'] == 'failure') {
            $paymentTransactionModel->payment_status = 0;
        } elseif (strtolower($response['status']) == 'success') {
            $paymentTransactionModel->payment_status = 1;
            $paymentTransactionModel->payment_mode = $response['mode'];
            $paymentTransactionModel->amount = $response['amount'];
            //save data in credit table

            $accountFundsModel = new \App\AccountFunds();
            $accountFundsModel->transaction_id = $response['txnid'];
            $accountFundsModel->account_id = $response['udf1'];
            $accountFundsModel->user_id = $this->session['UserID'];
            $accountFundsModel->amount = $response['amount'];
            $accountFundsModel->currency = 'INR';
            $accountFundsModel->payment_status = $response['field9'];
            $accountFundsModel->debit_credit = 'CREDIT';
            if (strtolower($response['status']) == 'success' && !isset($this->session['responseretry'])) {
                $accountFundsModel->save();
                //convert added fund value to USD and add the same to dl_advertisers.balance_left_in_USD
                $this->addUSDFundToAdvertiser($response['amount'], 'INR');
            }
        }

        if (!isset($this->session['responseretry'])) {

            Session::Put('responseretry', 1);
            $paymentTransactionModel->save();
        }
        return view('paymentresponse', ['response' => $response]);
        //mail to user if transaction is successfull / failed
    }
    
    
        public function paymentResponseFortumo(Request $request) {
            
            
        $response = $request->toArray();    
        $previousTransaction = App\PaymentTransaction::
                where(['transaction_id' => $response['MerchantRefNo']])
                ->take(1)
                ->get();
        $currency = $previousTransaction[0]['currency'];

        
        $paymentTransactionModel = new \App\PaymentTransaction();
        $paymentTransactionModel->user_id = $this->session['UserID'];
        $paymentTransactionModel->transaction_id = $response['MerchantRefNo'];
        $paymentTransactionModel->parent_id = $response['MerchantRefNo'];
        $paymentTransactionModel->account_id = $this->session['sessiondata']['accounts'][0]['account_id'];
        //$paymentTransactionModel->advertiser_id = $response->udf2;
        $paymentTransactionModel->gateway_id = 3; //FORTUMO
        $paymentTransactionModel->stage = 2; //RESPONSE FROM PAYMENT GATEWAY
        $paymentTransactionModel->status_reason = $response['ResponseCode'];
        $paymentTransactionModel->gateway_transaction_id = $response['PaymentID'];

        $response['status'] = ($response['ResponseCode'] == 0) ? 'SUCCESS' : 'failure';

        $paymentTransactionModel->gateway_status_reason = $response['status'];
        $paymentTransactionModel->extra = json_encode($response);
        $paymentTransactionModel->currency = $currency;

        if ($response['status'] == 'failure') {
            $paymentTransactionModel->payment_status = 0;
        } else {
            $paymentTransactionModel->payment_mode = $response['mode'];
            $paymentTransactionModel->amount = $response['Amount'];
            //save data in credit table

            $accountFundsModel = new \App\AccountFunds();
            $accountFundsModel->transaction_id = $response['MerchantRefNo'];
            $accountFundsModel->account_id = $this->session['sessiondata']['accounts'][0]['account_id'];
            $accountFundsModel->user_id = $this->session['UserID'];
            $accountFundsModel->currency = $currency;
            $accountFundsModel->payment_status = $response['ResponseCode'];
            $accountFundsModel->debit_credit = 'CREDIT';
            if (strtolower($response['status']) == 'success' && !isset($this->session['responseretry'])) {
                $accountFundsModel->save();
                $this->addUSDFundToAdvertiser($amount, $currency);
            }
        }
        
        if (!isset($this->session['responseretry'])) {

            Session::Put('responseretry', 1);
            $paymentTransactionModel->save();
        }
        return view('paymentresponse', ['response' => $response]);
        //mail to user if transaction is successfull / failed
    }

    public function paymentResponseHDFC(Request $request) {
        $previousTransaction = App\PaymentTransaction::
                where(['transaction_id' => $response['MerchantRefNo']])
                ->take(1)
                ->get();
        $currency = $previousTransaction[0]['currency'];

        $response = $request->toArray();
        $paymentTransactionModel = new \App\PaymentTransaction();
        $paymentTransactionModel->user_id = $this->session['UserID'];
        $paymentTransactionModel->transaction_id = $response['MerchantRefNo'];
        $paymentTransactionModel->parent_id = $response['MerchantRefNo'];
        $paymentTransactionModel->account_id = $this->session['sessiondata']['accounts'][0]['account_id'];
        //$paymentTransactionModel->advertiser_id = $response->udf2;
        $paymentTransactionModel->gateway_id = 2; //HDFC
        $paymentTransactionModel->stage = 2; //RESPONSE FROM PAYMENT GATEWAY
        $paymentTransactionModel->status_reason = $response['ResponseCode'];
        $paymentTransactionModel->gateway_transaction_id = $response['PaymentID'];

        $response['status'] = ($response['ResponseCode'] == 0) ? 'SUCCESS' : 'failure';

        $paymentTransactionModel->gateway_status_reason = $response['status'];
        $paymentTransactionModel->extra = json_encode($response);
        $paymentTransactionModel->currency = $currency;

        if ($response['status'] == 'failure') {
            $paymentTransactionModel->payment_status = 0;
        } else {
            $paymentTransactionModel->payment_mode = $response['mode'];
            $paymentTransactionModel->amount = $response['Amount'];
            //save data in credit table

            $accountFundsModel = new \App\AccountFunds();
            $accountFundsModel->transaction_id = $response['MerchantRefNo'];
            $accountFundsModel->account_id = $this->session['sessiondata']['accounts'][0]['account_id'];
            $accountFundsModel->user_id = $this->session['UserID'];
            $accountFundsModel->currency = $currency;
            $accountFundsModel->payment_status = $response['ResponseCode'];
            $accountFundsModel->debit_credit = 'CREDIT';
            if (strtolower($response['status']) == 'success' && !isset($this->session['responseretry'])) {
                $accountFundsModel->save();
                $this->addUSDFundToAdvertiser($amount, $currency);
            }
        }
        if (!isset($this->session['responseretry'])) {

            Session::Put('responseretry', 2);
            $paymentTransactionModel->save();
        }
        return view('paymentresponse', ['response' => $response]);
        //mail to user if transaction is successfull / failed
    }

    public function addUSDFundToAdvertiser($amount, $basecurrency = 'INR') {
        if ($basecurrency == 'USD')
            return $amount;
        $currencydata = CurrencyDatabase::where(['base_symbol' => $basecurrency, 'symbol' => 'USD'])
                ->orderBy('inserted_date', 'desc')
                ->take(1)
                ->get();
        $advertiserRow = App\Advertiser::find($this->advertiserdata['advertiser_id']);
        $usdValue = $amount / ($currencydata[0]['value'] * 101 / 100);
        $advertiserRow->balance_left_in_dollar +=$usdValue;
        $advertiserRow->save();
        return true;
    }

    public function convertCurrency($amount, $sourcecur , $requiredcur) {
        if ($sourcecur == $requiredcur)
            return $amount;
        $currencydata = CurrencyDatabase::where(['base_symbol' => $sourcecur, 'symbol' => $requiredcur])
                ->orderBy('inserted_date', 'desc')
                ->take(1)
                ->get();
        $convertedValue = $amount / ($currencydata[0]['value']);
        return $convertedValue;
    }

    //TBD
    public function hdfcPayment() {

        $value["account_id"] = "16267";
        $value["address"] = "Test Address";
        $value["amount"] = "12.34";
        $value["channel"] = "10";
        $value["city"] = "Mumbai";
        $value["country"] = "IND";
        $value["currency"] = "INR";
        $value["description"] = "Test Product";
        $value["email"] = "test@test.com";
        $value["mode"] = "LIVE";
        $value["name"] = "Test Name";
        $value["phone"] = "2211112222";
        $value["postal_code"] = "400069";
        $value["reference_no"] = "1458205469";
        $value["return_url"] = "http://advertiser.collectcent.com/demo/hdfc/hdfc-php/response.php";
        $value["ship_address"] = "Test Address";
        $value["ship_city"] = "Mumbai";
        $value["ship_country"] = "IND";
        $value["ship_name"] = "Test Name";
        $value["ship_phone"] = "2211112222";
        $value["ship_postal_code"] = "400069";
        $value["ship_state"] = "MH";
        $value["state"] = "MH";
//        $value["secure_hash"]="36C39CD4F593952B0E4A9C421D4464CE97628A6965DEF89BFFD80DD02BD42CBF601B15277F76E48F44C532BFF41CAD458CF05B11CEB6F3A8C07BBA0C4729DBC9";
        $value["secure_hash"] = $this->createHDFChash($value);

        return View::make('indipay::ccavenue')->with('encRequest', $this->encRequest)
                        ->with('accessCode', $this->accessCode)
                        ->with('endPoint', $this->getEndPoint());
        //return redirect("https://secure.ebs.in/pg/ma/payment/request/");
    }

}
