<?php
/**
 * This file is part of phpDocumentor.
 *
 *  For the full copyright and license information, please view the LICENSE
 *  file that was distributed with this source code.
 *
 *  @copyright 2010-2017 Mike van Riel<mike@phpdoc.org>
 *  @license   http://www.opensource.org/licenses/mit-license.php MIT
 *  @link      http://phpdoc.org
 */

namespace phpDocumentor\Reflection;

/**
 * @coversNothing
 */
final class DocblocksWithAnnotationsTest extends \PHPUnit_Framework_TestCase
{
    public function testDocblockWithAnnotations()
    {
        $docComment = <<<DOCCOMMENT
            /**
     * @var \DateTime[]
     * @Groups({"a", "b"})
     * @ORM\Entity
     */
DOCCOMMENT;


        $factory  = DocBlockFactory::createInstance();
        $docblock = $factory->create($docComment);

        $this->assertCount(3, $docblock->getTags());
    }
}
