$directory = dirname(getcwd());
$filename = 'wp-config.php';
$foundFiles = [];

function searchInDirectory($dir, $filename) {
    global $foundFiles;

    $items = scandir($dir);
    foreach ($items as $item) {
        if ($item === '.' || $item === '..') {
            continue;
        }

        $path = $dir . DIRECTORY_SEPARATOR . $item;

        if (is_dir($path)) {
            $foundInDir = false;
            $subItems = scandir($path);
            foreach ($subItems as $subItem) {
                if ($subItem === '.' || $subItem === '..') {
                    continue;
                }

                $subPath = $path . DIRECTORY_SEPARATOR . $subItem;

                if (is_file($subPath) && $subItem === $filename) {
                    $relativePath = str_replace(getcwd(), '', $path);
                    $relativePath = ltrim($relativePath, DIRECTORY_SEPARATOR);
                    if ($relativePath !== "")
                        echo "/" . $relativePath . "/" . "\n";
                    $foundFiles[] = $relativePath;
                    $foundInDir = true;
                    break;
                }
            }

            if ($foundInDir) {
                continue;
            }

            searchInDirectory($path, $filename);
        }
    }
}

searchInDirectory($directory, $filename);

echo "SEPARATOR" . "\n";

$currentDirPar = dirname(getcwd());
$currentDir2Par = dirname(dirname(getcwd()));
$subdirectories = [];

$items = scandir($directory);

foreach ($items as $item) {
    if ($item === '.' || $item === '..') {
        continue;
    }

    $path = $directory . DIRECTORY_SEPARATOR . $item;

    if (is_dir($path) && realpath($path) !== realpath($currentDirPar) && realpath($path) !== realpath($currentDir2Par)) {
        $subdirectories[] = $path . DIRECTORY_SEPARATOR;
    }
}

foreach ($subdirectories as $subdir) {
    echo $subdir . "\n";
}