<?php
// Settings
$cache_ext = '.html'; // File extension
$cache_time = 3600; // Cache file expires after these seconds (1 hour = 3600 sec)
$cache_folder = '/var/www/html/myairtrip/offers/cache/';
$ignore_pages = array('', '');

$dynamic_url = 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
$cache_file = $cache_folder . md5($dynamic_url) . $cache_ext; // Construct a cache file
// $ignore = (in_array($dynamic_url, $ignore_pages)) ? true : false; // Check if the URL is in the ignore list

if (file_exists($cache_file) && time() - $cache_time < filemtime($cache_file)) {
    // Check Cache exists and it's not expired.
    ob_start('ob_gzhandler'); // Turn on output buffering, "ob_gzhandler" for compressed page with gzip.
    readfile($cache_file); // Read Cache file
    echo '<!-- cached page - ' . date('l jS \of F Y h:i
:s
 A', filemtime($cache_file)) . ', Page : ' . $dynamic_url . ' -->';
    ob_end_flush(); // Flush and turn off output buffering
    exit(); // No need to proceed further, exit the flow.
}

// Turn on output buffering with gzip compression.
ob_start('ob_gzhandler');
