const track = document.querySelector('.carousel-track');
const cards = document.querySelectorAll('.card');
const prevBtn = document.querySelector('.prev-btn');
const nextBtn = document.querySelector('.next-btn');
let currentIndex = 1; // Start at the first actual card (index 1)
const cardWidth = cards[0].offsetWidth + 20; // Card width + margin

// Initial position: Move to the first card (hide cloned last card)
track.style.transform = `translateX(-${cardWidth * currentIndex}px)`;

// Move to the next slide
function moveToNext() {
    currentIndex++;
    track.style.transition = 'transform 0.5s ease-in-out'; // Smooth slide
    track.style.transform = `translateX(-${cardWidth * currentIndex}px)`;

    // When the cloned first card is reached, snap back to the actual first card
    if (currentIndex === cards.length - 3) {
        setTimeout(() => {
            track.style.transition = 'none'; // Disable transition for the snap
            currentIndex = 1; // Go to the actual first card
            track.style.transform = `translateX(-${cardWidth * currentIndex}px)`;
        }, 500); // Wait for the sliding transition to finish
    }
}

// Move to the previous slide
function moveToPrev() {
    currentIndex--;
    track.style.transition = 'transform 0.5s ease-in-out'; // Smooth slide
    track.style.transform = `translateX(-${cardWidth * currentIndex}px)`;

    // When the cloned last card is reached, snap back to the actual last card
    if (currentIndex === 0) {
        setTimeout(() => {
            track.style.transition = 'none'; // Disable transition for the snap
            currentIndex = cards.length - 3; // Go to the actual last card
            track.style.transform = `translateX(-${cardWidth * currentIndex}px)`;
        }, 500); // Wait for the sliding transition to finish
    }
}

// Event listeners for buttons
nextBtn.addEventListener('click', moveToNext);
prevBtn.addEventListener('click', moveToPrev);

