<?php
// include "caching/start-cache.php";
include "search-hotels.php";

if (mysqli_num_rows($getHotelQuery)) {

    $pageHeading = getPageHeadingFromSlug($conn, $slug);
    $mainPageImage = getPageHeadingImageFromSlug($conn, $slug);
    $original_link = getPageRedirectLinkFromSlug($conn, $slug);
    $img = $mainPageImage ? "images/$mainPageImage" : "https://myairtrip.com/offers/img/bg.jpg";

    $updated_link = getlinkDateModified($original_link, $checkin_date, $checkout_date);
    ?>

    <!DOCTYPE html>
    <html>

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title><?= ucwords($hotelName) ?> - Myairtrip</title>
        <meta name="description" content="">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="icon" href="https://myairtrip.com/offers/img/trip-favicon.jpg" />
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css?v=<?= time() ?>"
            rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH"
            crossorigin="anonymous">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
        <link rel="stylesheet" href="https://myairtrip.com/offers/css/style.css?v=<?= time() ?>">
        <link rel="preload" href="<?= $img ?>" as="image">
        <!-- Google tag (gtag.js) -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=AW-16805336308"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag() { dataLayer.push(arguments); }
            gtag('js', new Date());

            gtag('config', 'AW-16805336308');
        </script>
        <!-- Event snippet for Page view conversion page-->
        <script>
            gtag('event', 'conversion', { 'send_to': 'AW-16805011757/1HQPCNis4_EZEK3CoM0-' });
        </script>
        <style>
           
            @media only screen and (min-width: 768px) {
                .m-banr {
                    background-image: url('<?= $img ?>');
                    background-size: cover;
                    background-repeat: no-repeat;
                }
                .m-l-r-0{
                    margin-left: 0px !important;
                    margin-right: 0px !important;
                    display: block;
                }
            }
            /* .m-banr {
                background-image: url('<?= $img ?>');
                background-size: cover;
                background-repeat: no-repeat;
            } */
        </style>
    </head>

    <body>
        <nav class="navbar navbar-expand-lg">
            <div class="container">
                <a class="navbar-brand text-white" href="https://myairtrip.com/">
                    <h2><strong>Myairtrip.com</strong></h2>
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarText"
                    aria-controls="navbarText" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collaps navbar-collapse" id="navbarTex">
                    <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                        <li class="nav-item">
                            <span class="h6">Top hotels for you</span>
                        </li>
                    </ul>
                    <div class="modal fade" id="exampleModalToggle1" aria-hidden="true"
                        aria-labelledby="exampleModalToggleLabel" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h1 class="modal-title fs-5" id="exampleModalToggleLabel">Select your language</h1>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <!-- <h6>Top languages</h6> -->
                                    <ul class="cur-lstt1">
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <button class="btn btn-primary mbg7" data-bs-target="#exampleModalToggle1"
                        data-bs-toggle="modal">English</button>
                    <div class="modal fade" id="exampleModalToggle" aria-hidden="true"
                        aria-labelledby="exampleModalToggleLabel" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h1 class="modal-title fs-5" id="exampleModalToggleLabel">Select your currency</h1>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <!-- <h6>Top Currencies</h6> -->
                                    <ul class="cur-lstt">
                                        <li><a href="#">US$ <span> US Dollar</span></a></li>
                                        <li><a href="#">US$ <span> US Dollar</span></a></li>
                                        <li><a href="#">US$ <span> US Dollar</span></a></li>
                                        <li><a href="#">US$ <span> US Dollar</span></a></li>
                                        <li><a href="#">US$ <span> US Dollar</span></a></li>
                                        <li><a href="#">US$ <span> US Dollar</span></a></li>
                                        <li><a href="#">US$ <span> US Dollar</span></a></li>
                                        <li><a href="#">US$ <span> US Dollar</span></a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <button class="btn btn-primary mbg7" data-bs-target="#exampleModalToggle"
                        data-bs-toggle="modal">$USD</button>
                </div>
            </div>
        </nav>

        <div class="m-banr">
            <div class="main-container">
                <div class="container">
                    <h2 class="text-black main-heading">
                        <strong><?= $pageHeading ? ucwords($pageHeading) : ucwords($hotelName) ?></strong>
                    </h2><br>

                    <div class="frm-stc" id="SiteSearch">
                        <div class="row">
                            <div class="col-md-11 col-12">
                                <input type="text" class="form-control" id="search" placeholder="<?= ucwords($hotelName) ?>"
                                    aria-label="First name" value="<?= ucwords($hotelName) ?>">
                            </div>
                            <div class="col-md-1 col-12">
                                <a href="<?= $updated_link ?>" onclick="logClick('<?= $updated_link ?>')" target="_blank"
                                    style="text-decoration:none;">
                                    <div>
                                        <img src="/offers/img/close.svg" loading="lazy" id="closeBtn" class="csl"
                                            alt="close">
                                        <img src="/offers/img/search.svg" loading="lazy" class="srt" alt="search">
                                    </div>
                                </a>
                            </div>
                            <div class="col-md-6 col-6 hdmob m-top25">
                                <span class="date-text">Check-in</span>
                                <input type="text" class="form-control date-inpt" id="formGroupExampleInput"
                                    placeholder="Check-in Date">
                            </div>
                            <div class="col-md-6 col-6 wd-eqq hdmob m-top25">
                                <span class="date-text">Check-out</span>
                                <input type="text" class="form-control date-inpt" id="formGroupExampleInput2"
                                    placeholder="Check-out Date">
                            </div>
                            <div class="col-md-12 col-12 mb-3 mt-1 hddesk">
                                <input type="text" class="form-control date-input-mobile" id="formGroupExampleInputMobile"
                                    placeholder="Check-in Date">
                            </div>
                            <div class="col-md-12 col-12">
                                <a href="<?= $updated_link ?>" class="submob74">Search</a>
                            </div>
                        </div>
                    </div>
                    <div style="display: none; <?= $background ?>" class="h-autoo" id="widgetBox">
                        <div id="bookingAffiliateWidget_04b45126-5a31-4a7f-bc34-4cbefeb080d1" style="display: none;">&nbsp;
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="htlss">
            <div class="container">
                <div class="row">
                    <div class="col-md-3 order-1">
                        <div class="prp-tab">
                            <h6>Top attractions</h6>
                            <ul>
                                <?php
                                if (!empty($links) && !empty($attractions)) {
                                    $linksList = explode(',', $links);
                                    $attractionList = explode(',', $attractions);
                                    // echo count($linksList)."links";
                                    // echo count($attractionList)."attraction content";
                                    if (count($linksList) === count($attractionList)) {
                                        foreach ($attractionList as $index => $attraction) {
                                            $link = trim($linksList[$index]);
                                            $attraction = trim($attraction);
                                            echo '<li><a href="' . htmlspecialchars($link) . '" target="_blank" onclick="logClick(`' . $link . '`) " >' . htmlspecialchars($attraction) . '</a></li>';
                                        }
                                    }
                                } else {
                                    echo '<li>No attractions or links available</li>';
                                }
                                ?>
                            </ul>

                            <h6 style="border-top: 1px solid #DAE9FF; margin-top: 20px;">Best time to visit</h6>
                            <ul>
                                <?php
                                $timetovisit = getTimetoVisitContentFromSlug($conn, $slug);
                                if (!empty($timetovisit)) {
                                    $timeList = explode(',', $timetovisit);
                                    foreach ($timeList as $time) {
                                        echo '<li><a>' . trim($time) . '</a></li>';
                                    }
                                } else {
                                    echo '<li>No time to visit information available</li>';
                                }
                                ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-9 order-md-1">
                        <div class="container mmlftpr7">
                            <h2 class="text-black hd-mnnn">Properties </h2>
                            <img src="/offers/img/secure-b.svg" loading="lazy" class="scure" alt="secure">
                            <?php

                            while ($hotelArr = mysqli_fetch_assoc($getHotelQuery)) {
                                // echo "<pre>";
                                // print_r($hotelArr);
                                $rowClass = $isFirstHotel ? 'top-hotel' : '';
                                ?>
                                <div class="<?= $rowClass ?> h-viw "
                                    style="<?= $rowClass ? 'background: #f0f6ff !important;border-color: #a3d7fc !important;' : '' ?>">
                                    <a href="<?= $isFirstHotel ? $hotelArr['tophotellinks'] : $updated_link ?>" onclick="logClick('<?= $isFirstHotel ? $hotelArr['tophotellinks'] : $updated_link ?>')" target="_blank">
                                        <div class="row">
                                            <div class="col-md-3 col-5 wdim7">
                                                <img src="<?= $hotelArr['image_url'] ?>" loading="lazy" class="h-imgg"
                                                    alt="<?= ucwords(htmlspecialchars($hotelArr['hotel_name'])) ?>">
                                                <img src="/offers/img/heart.svg" loading="lazy" class="hrtt" alt="heart">
                                                <p class="mpl ribbon-2">More Photos</p>
                                            </div>
                                            <div class="col-md-9 col-7">
                                                <h3><?= ucwords(htmlspecialchars($hotelArr['hotel_name'])) ?></h3>
                                                <div class="rt-rw">
                                                    <div>
                                                        <p class="tx-sup">
                                                            <span><?= htmlspecialchars($hotelArr['review_number']) ?></span>
                                                            <?= ucwords(htmlspecialchars($hotelArr['rating_comment'])) ?></p>
                                                    </div>
                                                    <div>
                                                        <img src="/offers/img/star.svg" loading="lazy" class="strr" alt="star">
                                                    </div>
                                                </div>
                                                <div class="rt-rwcas">
                                                    <div>
                                                        <?php
                                                        $address = htmlspecialchars($hotelArr['hotel_address'], ENT_QUOTES, 'UTF-8');
                                                        $shortAddress = mb_substr($address, 0, 20, 'UTF-8');
                                                        ?>
                                                        <h5 class="autr"><?= $shortAddress ?><span
                                                                style="font-weight:300 !important;">..</span></h5>
                                                    </div>
                                                </div>
                                                <ul class="lst-sti">
                                                    <li><?= $hotelArr['free_cancellation'] == 1 ? 'Free cancellation' : ($hotelArr['free_cancellation'] == 2 ? 'Best Price Guarantee' : ($hotelArr['free_cancellation'] == 3 ? 'Great location' : '')) ?>
                                                    </li>
                                                    <li><?= $hotelArr['no_pre_payment'] == 1 ? 'No prepayment needed' : ($hotelArr['no_pre_payment'] == 2 ? 'Recently booked' : ($hotelArr['no_pre_payment'] == 3 ? 'Highly rated for cleanliness' : '')) ?>
                                                    </li>
                                                </ul>
                                                <div class="rt-rwc">
                                                    <div>
                                                        <img src="/offers/img/book.png" loading="lazy" class="booki" alt="star">
                                                    </div>
                                                    <div>
                                                        <p class="tx-prcc"><span>Starting from&nbsp;&nbsp;</span>
                                                            $<?= number_format($hotelArr['pricing'], 0) ?></p>
                                                    </div>
                                                </div>
                                                <div class="butt-bxx">
                                                    <p class="but-aval">See availability <img
                                                            src="/offers/img/arrow_forward.svg" loading="lazy" class="arwo"
                                                            alt="arrow"> </p>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                    <div class="mpdvd">
                                        <a href="<?= getlinkDateModified($hotelArr['hotel_location'], $checkin_date, $checkout_date) ?>"
                                            target="_blank" class="txtt-map">Show on map</a>
                                    </div>
                                </div>
                            <?php 
                                $isFirstHotel = false;
                                } 
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="htlss">
            <div class="container" id="lazy-load-trigger">
                <div class="row">
                    <div class="col-md-12 order-md-1">
                        <div class="prp-tab p-3">
                            <div class="notcc-sdv">
                                <img src="img/check.svg" loading="lazy" class="ceck" alt="check">
                                <div>Prices are subject to change; the above suggested prices are estimates only.</div>
                            </div>
                            <div class="notcc-sdv">
                                <img src="img/check.svg" loading="lazy" class="ceck" alt="check">
                                <div>Prices are per room, per night.</div>
                            </div>
                            <div class="notcc-sdv">
                                <img src="img/check.svg" loading="lazy" class="ceck" alt="check">
                                <div>Availability of rooms is dependent on the property owner.</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="htlss mt-6" id="lazy-load-triggerfaqs">
            <div class="container">
                <div class="row m-l-r-0">
                    <div class="pageContentBox text-justify prp-tab p-3" id="lazy-loaded-content" style="margin-left:0px !important;margin-right:0px !important;">
                    </div>
                </div>
            </div>
        </div>
        <div class="htlss">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 order-md-1" id="lazy-load-trigger-faqs">

                    </div>
                </div>
            </div>
        </div>    

        <footer>

            <div class="f-box">
                <div class="container fmarj">
                    <div class="row">
                        <div class="col-md-3">
                            <a class="navbar-brand" href="#">
                                <h2><strong>Myairtrip.com</strong></h2>
                            </a>
                        </div>
                        <div class="col-md-9">
                            <div class="f-lstt">
                                <a href="https://myairtrip.com/about-us/">About us</a>
                                <a href="https://myairtrip.com/contact-us/">Contact Us</a>
                                <a href="https://myairtrip.com/privacy-and-cookie-policy/">Privacy and Cookie Policy</a>
                                <a href="https://myairtrip.com/terms-conditions/">Terms and Conditions</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="container">
                    <p class="cpyrt">© 2024. All Right Reserved.</p>
                </div>
            </div>
        </footer>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
            integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"
            defer></script>
        <script src="https://www.booking.com/affiliate/prelanding_sdk"></script>
    </body>

    </html>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js" defer></script>
    <script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js" defer></script>
    <script type="text/javascript" src="./js/userlog.js"></script>
    <script>
        $(document).ready(function () { $("#closeBtn").click(function () { $(".main-heading").addClass("disp-none"), $(".main-container").addClass("pd-0"), $("#SiteSearch").fadeOut(400, function () { $("#widgetBox").fadeIn(400), $("#bookingAffiliateWidget_04b45126-5a31-4a7f-bc34-4cbefeb080d1").fadeIn(400) }) }); let a = moment(), e = moment().add(7, "days"), t = moment(e).add(2, "days"); $("#formGroupExampleInputMobile").daterangepicker({ autoApply: !0, minDate: a, startDate: e, endDate: t, locale: { format: "ddd D MMM", separator: " - ", applyLabel: "Apply", cancelLabel: "Cancel" } }); let d = moment().add(7, "days"), n = moment(d).add(2, "days"); $("#formGroupExampleInput").daterangepicker({ singleDatePicker: !0, autoApply: !0, minDate: a, startDate: d, locale: { format: "ddd D MMM" } }), $("#formGroupExampleInput2").daterangepicker({ singleDatePicker: !0, autoApply: !0, minDate: n, startDate: n, locale: { format: "ddd D MMM" } }), $("#formGroupExampleInput").on("apply.daterangepicker", function (a, e) { let t = e.startDate, d = moment(t).add(1, "days"); $("#formGroupExampleInput2").daterangepicker({ singleDatePicker: !0, autoApply: !0, minDate: d, startDate: moment(t).add(2, "days"), locale: { format: "ddd D MMM YYYY" } }) }) }), new Booking.AffiliateWidget({ iframeSettings: { selector: "bookingAffiliateWidget_04b45126-5a31-4a7f-bc34-4cbefeb080d1", responsive: !0 }, widgetSettings: {} });
    </script>
    <script>
        $(window).on("scroll", function () {
            if ($(this).scrollTop() > 380) {
                $(".prp-tab").css("margin-top", "10px");
            } else {
                $(".prp-tab").css("margin-top", "40px");
            }
        });

        document.addEventListener("DOMContentLoaded", function () {
            let contentLoaded = false;
            let contentLoadedFAQS = false; 

            const lazyLoadTrigger = document.getElementById("lazy-load-trigger");
            const lazyLoadTriggerFAQS = document.getElementById("lazy-load-triggerfaqs");
            const lazyLoadedContent = document.getElementById("lazy-loaded-content");
            const lazyLoadedContentFAQS = document.getElementById("lazy-load-trigger-faqs");


            const observer = new IntersectionObserver((entries) => {
                if (entries[0].isIntersecting && !contentLoaded) {
                    contentLoaded = true;

                    fetch("loadPageContent.php", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                        },
                        body: new URLSearchParams({
                            slug: "<?= $slug ?>",
                            category: "1",
                            type : 1
                        })
                    })
                        .then((response) => response.text())
                        .then((data) => {
                            lazyLoadedContent.innerHTML = data; 
                        })
                        .catch((error) => {
                            console.error("Error loading content:", error);
                        });
                }
            });
            observer.observe(lazyLoadTrigger);

            const observerNew = new IntersectionObserver((entries) => {
                if (entries[0].isIntersecting && !contentLoadedFAQS) {
                    contentLoadedFAQS = true;
                    fetch("loadPageContent.php", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                        },
                        body: new URLSearchParams({
                            slug: "<?= $slug ?>",
                            type : 2
                        })
                    })
                        .then((response) => response.text())
                        .then((data) => {
                            lazyLoadedContentFAQS.innerHTML = data; 
                        })
                        .catch((error) => {
                            console.error("Error loading content:", error);
                        });
                }
            });
            observerNew.observe(lazyLoadTriggerFAQS);
        });

    </script>

<?php
} else {
    echo "No Data Available Related to <strong>" . $slug . "</strong>";
}

include 'site-modal.php';
// include "caching/end-cache.php"; 
?>