<?php
include "search-hotels.php";
if (mysqli_num_rows($getHotelQuery)) {

    $pageHeading = getPageHeadingFromSlug($conn, $slug);
    $mainPageImage = getPageHeadingImageFromSlug($conn, $slug);
    ?>

    <!DOCTYPE html>
    <!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
    <!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
    <!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
    <!--[if gt IE 8]>      <html class="no-js"> <![endif]-->
    <html>

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title><?= ucwords($hotelName) ?> - Myairtrip</title>
        <meta name="description" content="">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
            integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
        <link rel="stylesheet" href="https://dev.myairtrip.com/css/style.css?v=<?=time()?>">
        <script src="https://www.booking.com/affiliate/prelanding_sdk"></script>
        <style>
            .csl{
                cursor: pointer;
            }
            .m-banr{
                background-image: url(<?=$mainPageImage?"https://admin.myairtrip.com/images/$mainPageImage":"https://dev.myairtrip.com/img/bg.jpg"?>);
                background-size: cover;
                background-repeat: no-repeat;
            }
            .main-container{
                background: #faebd785;
                padding-top: 35px;
            }
        </style>
    </head>

    <body>
        <!--[if lt IE 7]>
                    <p class="browsehappy">You are using an <strong>outdated</strong> browser. Please <a href="#">upgrade your browser</a> to improve your experience.</p>
                <![endif]-->

        <nav class="navbar navbar-expand-lg">
            <div class="container">
                <a class="navbar-brand text-white" href="#">
                    <h2><strong>Myairtrip.com</strong></h2>
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarText"
                    aria-controls="navbarText" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarText">
                    <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                        <li class="nav-item">
                            <a class="nav-link text-white" href="#"><span class="h4">Top hotels for you</span></a>
                        </li>
                    </ul>
                    <div class="modal fade" id="exampleModalToggle1" aria-hidden="true"
                        aria-labelledby="exampleModalToggleLabel" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h1 class="modal-title fs-5" id="exampleModalToggleLabel">Select your language</h1>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <!-- <h6>Top languages</h6> -->
                                    <ul class="cur-lstt1">
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                        <li><a href="#">English <span> UK</span></a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <button class="btn btn-primary mbg7" data-bs-target="#exampleModalToggle1"
                        data-bs-toggle="modal">English</button>
                    <div class="modal fade" id="exampleModalToggle" aria-hidden="true"
                        aria-labelledby="exampleModalToggleLabel" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h1 class="modal-title fs-5" id="exampleModalToggleLabel">Select your currency</h1>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <!-- <h6>Top Currencies</h6> -->
                                    <ul class="cur-lstt">
                                        <li><a href="#">US$ <span> US Dollar</span></a></li>
                                        <li><a href="#">US$ <span> US Dollar</span></a></li>
                                        <li><a href="#">US$ <span> US Dollar</span></a></li>
                                        <li><a href="#">US$ <span> US Dollar</span></a></li>
                                        <li><a href="#">US$ <span> US Dollar</span></a></li>
                                        <li><a href="#">US$ <span> US Dollar</span></a></li>
                                        <li><a href="#">US$ <span> US Dollar</span></a></li>
                                        <li><a href="#">US$ <span> US Dollar</span></a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <button class="btn btn-primary mbg7" data-bs-target="#exampleModalToggle"
                        data-bs-toggle="modal">$USD</button>
                </div>
            </div>
        </nav>

        <div class="m-banr">
            <div class="main-container">
                <div class="container">
                    <h2 class="text-black"><strong><?= $pageHeading ? ucwords($pageHeading) : ucwords($hotelName) ?></strong></h2><br>

                    <div class="frm-stc" id="SiteSearch">
                        <div class="row">
                            <div class="col-md-11 col-9">
                                <input type="text" class="form-control" placeholder="<?= ucwords($hotelName) ?>"
                                    aria-label="First name" value="<?= ucwords($hotelName) ?>">
                            </div>
                            <div class="col-md-1 col-3">
                                <img src="https://dev.myairtrip.com/img/close.svg" id="closeBtn" class="csl" alt="close">
                                <img src="https://dev.myairtrip.com/img/search.svg" class="srt" alt="search">
                            </div>
                            <div class="col-md-6 col-6 mb-3 mt-1 wd-eqq">
                                <input type="date" class="form-control" id="formGroupExampleInputDate" placeholder="Check-in Date">
                            </div>
                            <div class="col-md-6 col-6 mb-3 mt-1 wd-eqq">
                                <input type="date" class="form-control" id="formGroupExampleInputDate2"
                                    placeholder="Check-out Date">
                            </div>
                        </div>
                    </div>
                    <div style="height:160px;display: none;" id="widgetBox">
                        <div id="bookingAffiliateWidget_04b45126-5a31-4a7f-bc34-4cbefeb080d1" style="display: none;">&nbsp;</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="htlss">
            <div class="container">
                <div class="row">
                    <div class="col-md-3 order-1">
                        <div class="prp-tab">
                            <h6>Top attractions</h6>
                            <ul>
                                <li><a href="#">Burj Khalifa</a></li>
                                <li><a href="#">The Dubai Fountain</a></li>
                                <li><a href="#">The Dubai Frame</a></li>
                                <li><a href="#">Dubai Gold Souk</a></li>
                                <li><a href="#">Museum of the Future</a></li>
                                <li><a href="#">Dubai Miracle Garden</a></li>
                                <li><a href="#">Wild Wadi Water Park</a></li>
                                <li><a href="#">Deira Clocktower</a></li>
                                <li><a href="#">Palm Islands</a></li>
                                <li><a href="#">Dubai Creek</a></li>
                            </ul>
                        </div>
                        <div class="prp-tab">
                            <!-- <a href="#" class="but-aval">See availability <img src="https://dev.myairtrip.com/img/arrow_forward.svg" class="arwo" alt="arrow"> </a> -->
                            <h6>Best time to visit</h6>
                            <ul>
                                <li><a href="https://www.booking.com/dealspage.html">Top Deals</a></li>
                                <li><a href="https://www.booking.com/index.en-gb.html">Trending Destinations</a></li>
                                <li><a href="https://www.booking.com/hotel/index.en-gb.html?">Budget Hotels</a></li>
                                <li><a href="https://www.booking.com/hotel/index.en-gb.html?">Beach Resorts</a></li>
                                <li><a href="https://www.booking.com/villas/index.en-gb.html?">Luxury Stays</a></li>
                                <li><a href="https://www.booking.com/booking-home/index.en-gb.html?">Weekend Getaways</a>
                                </li>
                                <li><a href="https://www.booking.com/index.en-gb.html">Family-Friendly Hotels</a></li>
                                <li><a href="https://www.booking.com/index.en-gb.html">Romantic Getaways</a></li>
                                <li><a href="https://www.booking.com/index.en-gb.html">Adventure Trips</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-9 order-md-1">
                        <div class="container mmlftpr7">
                            <h2 class="text-black hd-mnnn">Properties </h2>
                            <img src="https://dev.myairtrip.com/img/secure-b.svg" class="scure" alt="secure">
                            <?php 
                                while($hotelArr = mysqli_fetch_assoc($getHotelQuery)){
                                // echo "<pre>";
                                // print_r($hotelArr);
                            ?>
                                <div class="h-viw">
                                    <a href="<?=$hotelArr['hotel_link']?>">
                                        <div class="row">
                                            <div class="col-md-3 col-12 wdim7">
                                                <img src="<?=$hotelArr['image_url']?>" class="h-imgg" alt="<?=ucwords($hotelArr['hotel_name'])?>">
                                                <img src="https://dev.myairtrip.com/img/heart.svg" class="hrtt" alt="heart">
                                                <p class="mpl ribbon-2">More Photos</p>
                                            </div>
                                            <div class="col-md-9 col-12">
                                                <h3><?=ucwords($hotelArr['hotel_name'])?></h3>
                                                <div class="rt-rw">
                                                    <div>
                                                        <p class="tx-sup"><?=$hotelArr['review_number']?> <?=ucwords($hotelArr['rating_comment'])?></p>
                                                    </div>
                                                    <div>
                                                        <img src="https://dev.myairtrip.com/img/star.svg" class="strr" alt="star">
                                                    </div>
                                                </div>
                                                <div class="rt-rwcas">
                                                    <div>
                                                        <h5 class="autr">Arsenalsgatan 6 </h5>
                                                    </div>
                                                </div>
                                                <ul class="lst-sti">
                                                    <li><?=$hotelArr['free_cancellation'] ? 'Free cancellation' : 'No Free cancellation'?></li>
                                                    <li><?=$hotelArr['no_pre_payment'] ? 'No prepayment' : 'Prepayment Required'?></li>
                                                </ul>
                                                <div class="rt-rwc">
                                                    <div>
                                                        <img src="https://dev.myairtrip.com/img/book.png" class="booki" alt="star">
                                                    </div>
                                                    <div>
                                                        <p class="tx-prcc"><span>Starting from </span> $ <?=$hotelArr['pricing']?></p>
                                                    </div>
                                                </div>
                                                <div class="butt-bxx">
                                                    <p class="but-aval">See availability <img src="https://dev.myairtrip.com/img/arrow_forward.svg"
                                                            class="arwo" alt="arrow"> </p>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                    <div class="mpdvd">
                                        <a href="<?=$hotelArr['hotel_location']?>" class="txtt-map">Show on map</a>
                                    </div>
                                </div>
                            <?php }?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <footer>
            <div class="container">
                <p class="notcc"><img src="https://dev.myairtrip.com/img/check.svg" class="ceck" alt="check"> Prices are subject to change; the above
                    suggested prices are estimates only.<br>
                    <img src="https://dev.myairtrip.com/img/check.svg" class="ceck" alt="check"> Prices are per room, per night.<br>
                    <img src="https://dev.myairtrip.com/img/check.svg" class="ceck" alt="check"> Availability of rooms is dependent on the property
                    owner.
                </p>
            </div>
            <div class="f-box">
                <div class="container fmarj">
                    <div class="row">
                        <div class="col-md-3">
                            <a class="navbar-brand" href="#">
                                <h2><strong>Myairtrip.com</strong></h2>
                            </a>
                        </div>
                        <div class="col-md-9">
                            <div class="f-lstt">
                                <a href="#">Advertisement Disclosure</a>
                                <a href="#">Terms of Use</a>
                                <a href="#">Privacy Policy</a>
                                <a href="#">Cookie Policy</a>
                                <a href="#">Contact Us</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="container">
                    <p class="cpyrt">© 2024. All Right Reserved.</p>
                </div>
            </div>
        </footer>

        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
            integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz"
            crossorigin="anonymous"></script>
    </body>

    </html>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function(){
            $('#closeBtn').click(function(){
                $('#SiteSearch').fadeOut(400, function() {
                    $('#widgetBox').fadeIn(400);
                    $('#bookingAffiliateWidget_04b45126-5a31-4a7f-bc34-4cbefeb080d1').fadeIn(400);
                });
            });
        });


        (function () {
            var BookingAffiliateWidget = new Booking.AffiliateWidget({
            "iframeSettings": {
                "selector": "bookingAffiliateWidget_04b45126-5a31-4a7f-bc34-4cbefeb080d1",
                "responsive": true
            },
            "widgetSettings": {}
            });
        })();

        document.addEventListener("DOMContentLoaded", function() {
    const checkInInput = document.getElementById("formGroupExampleInputDate");
    const checkOutInput = document.getElementById("formGroupExampleInputDate2");

    const today = new Date();
    const year = today.getFullYear();
    const month = String(today.getMonth() + 1).padStart(2, '0');
    const day = String(today.getDate()).padStart(2, '0');
    const minDate = `${year}-${month}-${day}`;

    checkInInput.setAttribute("min", minDate);
    checkOutInput.setAttribute("min", minDate);

    const checkInDate = new Date(today);
    checkInDate.setDate(today.getDate() + 7);
    const defaultCheckIn = `${checkInDate.getFullYear()}-${String(checkInDate.getMonth() + 1).padStart(2, '0')}-${String(checkInDate.getDate()).padStart(2, '0')}`;
    checkInInput.value = defaultCheckIn;

    const checkOutDate = new Date(checkInDate);
    checkOutDate.setDate(checkInDate.getDate() + 2);
    const defaultCheckOut = `${checkOutDate.getFullYear()}-${String(checkOutDate.getMonth() + 1).padStart(2, '0')}-${String(checkOutDate.getDate()).padStart(2, '0')}`;
    checkOutInput.value = defaultCheckOut;

    checkInInput.addEventListener("change", function() {
        const selectedCheckInDate = new Date(checkInInput.value);
        // console.log(selectedCheckInDate);
        // Disable all dates before the selected check-in date
        const formattedCheckInDate = `${selectedCheckInDate.getFullYear()}-${String(selectedCheckInDate.getMonth() + 1).padStart(2, '0')}-${String(selectedCheckInDate.getDate()).padStart(2, '0')}`;
        // console.log(formattedCheckInDate);
        checkOutInput.setAttribute("min", formattedCheckInDate);

        // Automatically adjust the check-out date to be 2 days after check-in
        const checkOutDate = new Date(selectedCheckInDate);
        checkOutDate.setDate(selectedCheckInDate.getDate() + 2);
        const defaultCheckOut = `${checkOutDate.getFullYear()}-${String(checkOutDate.getMonth() + 1).padStart(2, '0')}-${String(checkOutDate.getDate()).padStart(2, '0')}`;
        console.log(defaultCheckOut);
        checkOutInput.value = defaultCheckOut;
    });
});


        const dateInput = document.getElementById('formGroupExampleInputDate');
    dateInput.addEventListener('focus', function() {
        this.setAttribute('placeholder', 'Check-in Date');
    });
    dateInput.addEventListener('blur', function() {
        if (!this.value) {
            this.removeAttribute('placeholder');
        }
    });
    </script>

<?php }else{
    echo "No Data Available Related to <strong>".$slug."</strong>";
} ?>