<?php
/**
 * Debug Options Object
 *
 * @package     TravelpayoutsSettingsFramework
 * @author      Kevin Provance (kprovance)
 * @version     3.5.4
 */

defined( 'ABSPATH' ) || exit;

// Don't duplicate me!
if ( ! class_exists( 'Redux_Travelpayouts_Options_Object', false ) ) {

	/**
	 * Main Redux_Travelpayouts_options_object class
	 *
	 * @since       1.0.0
	 */
	class Redux_Travelpayouts_Options_Object extends Redux_Travelpayouts_Field {

		/**
		 * Redux_Travelpayouts_Options_Object constructor.
		 *
		 * @param array  $field Field array.
		 * @param string $value Value array.
		 * @param object $parent TravelpayoutsSettingsFramework object.
		 *
		 * @throws ReflectionException .
		 */
		public function __construct( $field = array(), $value = '', $parent ) {
			parent::__construct( $field, $value, $parent );

			$this->is_field = $this->parent->extensions['options_object']->is_field;
		}

		/**
		 * Set field defaults.
		 */
		public function set_defaults() {
			$defaults = array(
				'options'          => array(),
				'stylesheet'       => '',
				'output'           => true,
				'enqueue'          => true,
				'enqueue_frontend' => true,
			);

			$this->field = wp_parse_args( $this->field, $defaults );
		}

		/**
		 * Field Render Function.
		 * Takes the vars and outputs the HTML for the field in the settings
		 *
		 * @since       1.0.0
		 * @access      public
		 * @return      void
		 */
		public function render() {
			if ( version_compare( phpversion(), '5.3.0', '>=' ) ) {
				$json = wp_json_encode( $this->parent->options, true );
			} else {
				$json = wp_json_encode( $this->parent->options );
			}

			$defaults = array(
				'full_width' => true,
				'overflow'   => 'inherit',
			);

			$this->field = wp_parse_args( $this->field, $defaults );

			if ( $this->is_field ) {
				$full_width = $this->field['full_width'];
			}

			$do_close = false;

			$id = $this->parent->args['opt_name'] . '-' . $this->field['id'];

			if ( ! $this->is_field || ( $this->is_field && false === $full_width ) ) {
				?>
				<style>#<?php echo esc_html( $id ); ?>{padding: 0;}</style>
				<?php // phpcs:ignore WordPress.CodeAnalysis.EmptyStatement ?>
				<?php echo '</td></tr></table>'; ?>
				<table id="<?php echo esc_attr( $id ); ?>" class="tp-admin-table form-table no-border redux-group-table redux-raw-table" style=" overflow: <?php esc_attr( $this->field['overflow'] ); ?>;">
				<tbody class="tp-admin-table-body"><tr class="tp-admin-table-body-row"><td  class="tp-admin-table-body-cell">
				<?php
				$do_close = true;
			}
			?>
			<fieldset
					id="<?php echo esc_attr( $id ); ?>-fieldset"
					class="tp-admin-table-fieldset redux-field redux-container-<?php echo esc_attr( $this->field['type'] ) . ' ' . esc_attr( $this->field['class'] ); ?>"
					data-id="<?php echo esc_attr( $this->field['id'] ); ?>">

				<h3><?php esc_html_e( 'Options Object', 'redux-framework' ); ?></h3>
				<div id="redux-object-browser"></div>
				<div id="redux-object-json" class="hide"><?php echo( $json ); // phpcs:ignore WordPress.Security.EscapeOutput ?></div>
				<a
					href="#" id="consolePrintObject"
					class="button">
					<?php esc_html_e( 'Show Object in Javascript Console Object', 'redux-framework' ); ?></a>

			</fieldset>
			<?php if ( true === $do_close ) { ?>
				</td></tr></table>
				<table class="tp-admin-table form-table no-border" style="margin-top: 0;">
					<tbody class="tp-admin-table-body">
					<tr class="tp-admin-table-body-row" style="border-bottom: 0;">
						<th></th>
						<td class="tp-admin-table-body-cell">
			<?php } ?>
			<?php
		}

		/**
		 * Enqueue Function.
		 * If this field requires any scripts, or css define this function and register/enqueue the scripts/css
		 *
		 * @since       1.0.0
		 * @access      public
		 * @return      void
		 */
		public function enqueue() {
			if ( $this->parent->args['dev_mode'] ) {
				wp_enqueue_script(
					'redux-extension-options-object-js',
					$this->url . 'redux-options-object' . Redux_Travelpayouts_Functions::is_min() . '.js',
					array( 'jquery', 'redux-js' ),
					Redux_Travelpayouts_Extension_Options_Object::$version,
					true
				);
			}

			wp_enqueue_style(
				'redux-options-object',
				$this->url . 'redux-options-object.css',
				array(),
				Redux_Travelpayouts_Extension_Options_Object::$version,
				'all'
			);
		}
	}
}
