<?php
/*
Plugin Name: Affiliates, OTA, GDS Travel XML API Plugin
Plugin URI: http://www.adivaha.com
Description: GDS &amp; OTA go-LIVE Solution - Amadeus, Travelport (Galileo), Hotelbeds, TBO, Rezlive, Restel and 150+ integrated suppliers. Plug &amp; Play! Have no APIs? No worries, use adivaha&reg; integrated affiliates and GDS bookings APIs and update as you grow!
Author: adivaha&reg; - Travel Tech Company
Version: 2.3
Author URI: http://www.adivaha.com
*/

define('ADIVAHA__PLUGIN_DIR', plugin_dir_path(__FILE__));
//define( 'ADIVAHA__PLUGIN_URL', plugin_dir_url( __FILE__ ) );

// Changed according to my directory
// define( 'ADIVAHA__PLUGIN_URL', "http://localhost/wordpress/wp-content/plugins/adivaha/" ); // default
$site_url = get_site_url();
define('ADIVAHA__PLUGIN_SITE_URL', $site_url); // mine
define('ADIVAHA__PLUGIN_URL', $site_url."/wp-content/plugins/adiaha-hotel/"); // mine

define('DEFAULT_SETTING_URL','http://www.abengines.com/wp-content/themes/adivaha-default-setting-plugin.php');

global $current_user, $user_pid, $user_secret_key, $plugin_version;

require (ABSPATH . WPINC . '/pluggable.php');
if ( !function_exists('wp_get_current_user') ){
	echo 'Function not set';
	function wp_get_current_user() {
		global $current_user;
		get_currentuserinfo();
		return $current_user;
	}
}
$current_user = wp_get_current_user();
$user_id = $current_user->ID;

// if(!function_exists('is_admin')) {
// 	function is_admin() {
// 		if ( isset( $GLOBALS['current_screen'] ) ) {
// 				return $GLOBALS['current_screen']->in_admin();
// 		} elseif ( defined( 'WP_ADMIN' ) ) {
// 				return WP_ADMIN;
// 		}
// 		return false;
// 	}
// }
// $is_admin = is_admin();


// if(is_admin()) {
// 	print_r(is_admin());
// } else {
// 	echo "string";
// }

if ( !function_exists('get_pid') && !function_exists('get_secret_key') && !function_exists('get_plugin_version') ){
	// echo 'Function not set';
	function get_pid() {
		global $user_pid;
		// if ($user_id != "") { // is_admin() commented because it's not working here outsise it's working
			$get_user_pid = get_option('adh_pid', false);
			// $user_pid = $get_user_pid[0];
			return $get_user_pid;
		// }
	}

	function get_secret_key() {
		global $user_secret_key;
		// if ($user_id != "") { // is_admin() commented because it's not working here outsise it's working
			$get_user_secret_key = get_option('adh_secret_key', false);
			// $user_secret_key = $get_user_secret_key[0];
			return $get_user_secret_key;
		// }
	}

	// function get_plugin_version($user_id) {
	// 	global $user_secret_key;
	// 	if ($user_id != "") { // is_admin() commented because it's not working here outsise it's working
	// 		$get_user_secret_key = get_user_meta($user_id,'secret_key');
	// 		$user_secret_key = $get_user_secret_key[0];
	// 		return $user_secret_key;
	// 	}
	// }
}


// $get_user_pid = get_option('adh_pid', false);
// var_dump($get_user_pid);

$user_pid = get_pid($user_id);
$user_secret_key = get_secret_key($user_id);

// echo $user_pid;
// echo "<br>";
// echo $user_secret_key;
// die;

// add_action('init', 'get_pid');
// function get_pid($user_id) {
// 	$get_user_pid = get_user_meta($user_id,'pid');
// 	$pid = $get_user_pid[0];
// 	return $pid;
// }

// 	$get_user_secret_key = get_user_meta($user_id, 'secret_key');
// 	$user_secret_key = $get_user_secret_key[0];

// Add Toolbar Menus
if (!function_exists('adi_add_admin_bar_link_adi')) {
	function adi_add_admin_bar_link_adi()
	{
		global $wp_admin_bar;
		if (!is_super_admin() || !is_admin_bar_showing())
			return;
		$wp_admin_bar->add_menu(array(
			'id' => 'unq_adivaha',
			'title' => __('adivaha&reg; Plugin', 'adi_framework'),
			'href' => admin_url('admin.php?page=unq_adivaha'),
			'meta'   => array(
				'class'    => 'adi-item2',
			),
		));
	}
}
add_action('admin_bar_menu', 'adi_add_admin_bar_link_adi', 26);

add_action('admin_menu', 'adivaha_main_menu');
function adivaha_main_menu()
{
	ob_start();
	global $wpdb;
	global $files;
	global $Plugin_Path;
	$parent_slug = "unq_adivaha";
	add_menu_page("adivaha&reg; Plugin", "adivaha&reg; Plugin", 8, $parent_slug, "adivaha_dashboard_output", ADIVAHA__PLUGIN_URL . "asset/images/icon.png");
	function adivaha_dashboard_output()
	{
		//include(ADIVAHA__PLUGIN_DIR.'apps/dashboard.php');
		include(ADIVAHA__PLUGIN_DIR . 'apps/index.php');
		//insert_data();
	}
}

add_shortcode('adivaha_searchBox', 'searchBox');
add_shortcode('adivaha_searchResults', 'searchResults');
function adivaha_booking_engine()
{
	function searchBox()
	{
		ob_start();
		global $user_pid, $plugin_version;
		echo '<div id="adivaha-wrapper"><script charset="utf-8" type="text/javascript" src="//www.abengines.com/ui/'.$plugin_version.'/'.$user_pid.'/combo/"></script></div>';
		return ob_get_clean();
	}

	function searchResults()
	{
		ob_start();
		global $user_pid, $plugin_version;
		$mid = $_REQUEST['mid'];
		echo "<div id='adivaha-wrapper'><script charset='utf-8' type='text/javascript' src='https://www.abengines.com/ui/".$plugin_version."/".$user_pid."/".$mid."/mt/search-results/'></script></div>";
		return ob_get_clean();
	}
}
add_action('init', 'adivaha_booking_engine');


//register_deactivation_hook(_FILE_ , 'adivha_pro_uninstall_portal' );

function adivha_pro_install_portal()
{
	init_db_myplugin();
}

// Initialize DB Tables
function init_db_myplugin()
{

	// WP Globals
	global $table_prefix, $wpdb;

	// Customer Table
	$customerTable = $table_prefix . 'custom_plugin';
	//$customerTable = 'wp_custom_plugin';
	// Create Customer Table if not exist
	if ($wpdb->get_var("show tables like '$customerTable'") != $customerTable) {

		// Query - Create Table
		$sql = "CREATE TABLE `$customerTable` (";
		$sql .= " `id` int(11) NOT NULL auto_increment, ";
		$sql .= " `pid` varchar(25) NOT NULL, ";
		// $sql .= " `fname` varchar(500) NOT NULL, ";
		// $sql .= " `sname` varchar(500), ";
		// $sql .= " `line1` varchar(500) NOT NULL, ";
		// $sql .= " `line2` varchar(500), ";
		// $sql .= " `line3` varchar(500), ";
		// $sql .= " `city` varchar(150) NOT NULL, ";
		// $sql .= " `state` varchar(150), ";
		// $sql .= " `area` varchar(15), ";
		// $sql .= " `country` varchar(5) NOT NULL, ";
		$sql .= " PRIMARY KEY (`id`) ";
		$sql .= ") ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";

		// Include Upgrade Script
		require_once(ABSPATH . '/wp-admin/includes/upgrade.php');

		// Create Table
		dbDelta($sql);
	}
}

register_activation_hook(__FILE__, 'adivha_pro_install_portal');

// function success_alert($message) {
// 	echo '<div class="updated notice">
//     		<p>'.$message.'</p>
// 		</div>';
// }

// function warning_alert($message) {
// 	echo '<div class="update-nag notice">
//     		<p>'.$message.'</p>
// 		</div>';
// }

// function error_alert($message) {
// 	echo '<div class="error notice">
//     		<p>'.$message.'</p>
// 		</div>';
// }

function verifyUser($pid, $secret_key)
{
  $data = array('pid' => $pid, 'secret_key' => $secret_key);
  $url = DEFAULT_SETTING_URL."?action=verifyUser";
  $send = json_encode($data);
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLINFO_HEADER_OUT, true);
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_POSTFIELDS, $send);
  $result = curl_exec($ch);
  curl_close($ch);
  return $result;
}
function getDetails($user_secret_key)
{
  $data = array('secret_key' => $user_secret_key);
  $url = DEFAULT_SETTING_URL."?action=getDetails";
  $send = json_encode($data);
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLINFO_HEADER_OUT, true);
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_POSTFIELDS, $send);
  $result = curl_exec($ch);
  curl_close($ch);
  return $result;
}
if($user_secret_key != "") {
	$content = getDetails($user_secret_key);
	$details = json_decode($content);
	$twc_content = json_decode($details->twc->content);
	foreach ($twc_content->common as $key => $value) {
		if ($key == 'combined_search_box_version') {
			$plugin_version = $value;
		}
	}
}
function settingUpdate($data)
{
  $url = DEFAULT_SETTING_URL."?action=settingUpdate";
  $send = json_encode($data);
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLINFO_HEADER_OUT, true);
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_POSTFIELDS, $send);
  $result = curl_exec($ch);
  curl_close($ch);
  return $result;
}
function chatboatSettingUpdate($data)
{
  $url = DEFAULT_SETTING_URL."?action=chatboatSettingUpdate";
  $send = json_encode($data);
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLINFO_HEADER_OUT, true);
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_POSTFIELDS, $send);
  $result = curl_exec($ch);
  curl_close($ch);
  return $result;
}
function pluginVersionUpdate($data)
{
  $url = DEFAULT_SETTING_URL."?action=pluginVersionUpdate";
  $send = json_encode($data);
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLINFO_HEADER_OUT, true);
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_POSTFIELDS, $send);
  $result = curl_exec($ch);
  curl_close($ch);
  return $result;
}

if(is_admin()) {	
	add_action('wp_ajax_deleteUser', 'deleteUser');
	add_action('wp_ajax_nopriv_deleteUser', 'deleteUser');
	function deleteUser() {
		global $wpdb, $user_pid, $user_secret_key, $user_id;

		$user_pid = $_REQUEST['pid'];
		$user_secret_key = $_REQUEST['secret_key'];

		$flag = 0;
	    if($user_pid != "" && $user_secret_key !="") {
			$delete_one = delete_option('adh_pid');
			$delete_two = delete_option('adh_secret_key');

			// $delete_one = delete_user_meta($user_id, 'pid', $user_pid);
			// $delete_two = delete_user_meta($user_id, 'secret_key', $user_secret_key);
			if($delete_one && $delete_two) {
				$flag = 1;
			} else {
				$flag = 0;
			}
		}
		echo $flag;
		die;
	}

	add_action('wp_ajax_addUser', 'addUser');
	add_action('wp_ajax_nopriv_addUser', 'addUser');
	function addUser() {
		global $wpdb, $user_id;

		$user_pid = $_REQUEST['pid'];
		$user_secret_key = $_REQUEST['secret_key'];

		$flag = 0;
	    if($user_pid != "" && $user_secret_key !="") {
			$verify = verifyUser($user_pid, $user_secret_key);
			if ($verify == 1) {
				$add_one = add_option('adh_pid', $user_pid, 'yes');
				$add_two = add_option('adh_secret_key', $user_secret_key, 'yes');

				// $add_one = add_user_meta($user_id, 'pid', $user_pid);
				// $add_two = add_user_meta($user_id, 'secret_key', $user_secret_key);
				if ($add_one && $add_two) {
					$flag = 1;
				} else {
					$flag = 0;
				}
			} else {
				$flag = 0;
			}
		}
		echo $flag;
		die;
	}

	add_action('wp_ajax_update_setting', 'update_setting');
	add_action('wp_ajax_nopriv_update_setting', 'update_setting');
	function update_setting() {
		global $wpdb, $user_pid, $user_secret_key, $user_id;

		$flag = 0;

		$customer_banner_image_one = $_REQUEST['customer_banner_image_one'];
		$customer_banner_image_two = $_REQUEST['customer_banner_image_two'];
		$customer_banner_image_array = array();

		$content = getDetails($user_secret_key);
		$details = json_decode($content);
		$theme_content = json_decode($details->customer->theme_content);
		foreach ($theme_content->step1 as $key => $value) {
		  if ($key == 'banner_path1') {
			$customer_banner_image_array[$key] = $customer_banner_image_one;
		  } elseif ($key == 'banner_path2') {
			$customer_banner_image_array[$key] = $customer_banner_image_two;
		  } else {
			$customer_banner_image_array[$key] = $value;
		  }
		}
		$step1 = array("step1" => $customer_banner_image_array);
		$theme_content_update = json_decode(json_encode($step1));
		$_REQUEST['theme_content'] = $theme_content_update;
	
		$restData_update = array();
		$twc_content = json_decode($details->twc->content);
		$search_result_modules = json_decode(json_encode($details->search_result_modules), true);
		if($twc_content->restData != "") {
		  foreach($twc_content->restData as $key => $value) {
			if(in_array($key,$search_result_modules,true)) {
			  $restData_update[$key] = $_REQUEST['search_result_url'];
			} else {
			  $restData_update[$key] = $value;
			}
		  }
		}

		$twc_content = array("common"=> $twc_content->common,"restData" => $restData_update);
		$content = json_decode(json_encode($twc_content));
		$_REQUEST['content'] = $content;

		$updated = settingUpdate($_REQUEST);
		if ($updated) {
			$flag = 1;
		} else {
			$flag = 0;
		}
		echo $flag;
		die;
	}

	add_action('wp_ajax_update_chatboat', 'update_chatboat');
	add_action('wp_ajax_nopriv_update_chatboat', 'update_chatboat');
	function update_chatboat() {
		global $wpdb, $user_pid, $user_secret_key, $user_id;

		$flag = 0;
		if ($_REQUEST['active_chat_menu'] != "") {
		  $active_chat = array();
		  foreach ($_REQUEST['active_chat_menu'] as $key => $value) {
			$active_chat[] = $value;
		  }
		  $active_chat_menu = json_encode($active_chat);
		  $_REQUEST['active_chat_menu'] = $active_chat_menu;
		}
		$updated = chatboatSettingUpdate($_REQUEST);
		if ($updated) {
			$flag = 1;
		} else {
			$flag = 0;
		}
		echo $flag;
		die;
	}

	add_action('wp_ajax_update_plugin', 'update_plugin');
	add_action('wp_ajax_nopriv_update_plugin', 'update_plugin');
	function update_plugin() {
		global $wpdb, $user_pid, $user_secret_key, $user_id;

		$flag = 0;

		$combine_sb_version = $_REQUEST['data_id'];
		$combined_sb_version_array = array();

		$content = getDetails($user_secret_key);
		$details = json_decode($content);
		$twc_content = json_decode($details->twc->content);
		foreach ($twc_content->common as $key => $value) {
		  if ($key == 'combined_search_box_version') {
			$combined_sb_version_array[$key] = $combine_sb_version;
		  } else {
			$combined_sb_version_array[$key] = $value;
		  }
		}
		$common = array("common" => $combined_sb_version_array);

		if($twc_content->restData != '') {
			$restData = $twc_content->restData;
			$common["restData"] = $restData;
		}

		$content_update = json_decode(json_encode($common));
		$_REQUEST['content'] = $content_update;

		$updated = pluginVersionUpdate($_REQUEST);
		if ($updated) {
			$flag = 1;
		} else {
			$flag = 0;
		}
		echo $flag;
		die;
	}
}